package lu.tudor.santec.gecamed.formeditor.utils;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.util.Collection;
import java.util.Vector;

public class FocusPolicy extends FocusTraversalPolicy
{
	/* ======================================== */
	// 		MEMBERS
	/* ======================================== */
	
	private Vector<Container> order;
	
	
	
	/* ======================================== */
	// 		CONSTRUCTORS
	/* ======================================== */
	
	public FocusPolicy()
	{
		order = new Vector<Container>();
	}
	
	public FocusPolicy (Collection<Container> container)
	{
		order = new Vector<Container>(container);
	}
	
	
	
	/* ======================================== */
	// 		ADDED METHODS
	/* ======================================== */
	
	public void setOrder (Vector<Container> newOrder)
	{
		this.order = (Vector<Container>) newOrder;
	}
	
	public Vector<Container> getOrder ()
	{
		return order;
	}
	
	public void clearOrder (Collection<Container> newOrder)
	{
		if (newOrder instanceof Vector<?>)
			this.order = (Vector<Container>) newOrder;
		else
		{
			order.clear();
			if (newOrder != null)
				order.addAll(newOrder);
		}
	}
	
	public void clearOrder ()
	{
		clearOrder(null);
	}
	
	public void addContainer (Container aContainer)
	{
		order.add(aContainer);
	}
	
	public void addContainer (int position, Container aContainer)
	{
		order.add(position, aContainer);
	}
	
	
	
	/* ======================================== */
	// 		OVERRIDDEN METHODS
	/* ======================================== */
	
	@Override
	public Component getLastComponent(Container aContainer)
	{
		return order.lastElement();
	}
	
	@Override
	public Component getFirstComponent(Container aContainer)
	{
		return order.firstElement();
	}
	
	@Override
	public Component getDefaultComponent(Container aContainer)
	{
		return order.firstElement();
	}
	
	@Override
	public Component getComponentBefore(Container aContainer,
			Component aComponent)
	{
		int i = order.indexOf(aContainer);
		if (i > 0)
			return order.get(i-1);
		else
			return order.firstElement();
	}
	
	@Override
	public Component getComponentAfter(Container aContainer,
			Component aComponent)
	{
		int i = order.indexOf(aContainer);
		if (i < order.size() - 1)
			return order.get(i+1);
		else
			return order.lastElement();
	}
}
