package lu.tudor.santec.gecamed.formeditor.utils;

import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class EventRedirector implements MouseListener, KeyListener
{
	private Component target;
	
	public EventRedirector (Component redirectTarget)
	{
		this.target = redirectTarget;
	}

	
	/* ---------------------------------------- */
	// 		KEY EVENTS
	/* ---------------------------------------- */
	
	public void keyTyped(KeyEvent e)
	{
		e.setSource(target);
		
		KeyListener[] listener = target.getKeyListeners();
		for (KeyListener l : listener)
			l.keyTyped(e);
	}

	public void keyPressed(KeyEvent e)
	{
		e.setSource(target);
		
		KeyListener[] listener = target.getKeyListeners();
		for (KeyListener l : listener)
			l.keyPressed(e);
	}

	public void keyReleased(KeyEvent e)
	{
		e.setSource(target);
		
		KeyListener[] listener = target.getKeyListeners();
		for (KeyListener l : listener)
			l.keyReleased(e);
	}
	
	
	/* ---------------------------------------- */
	// 		MOUSE EVENTS
	/* ---------------------------------------- */
	
	public void mouseClicked(MouseEvent e)
	{
		e.setSource(target);
		
		MouseListener[] listener = target.getMouseListeners();
		for (MouseListener l : listener)
		{
			l.mouseClicked(e);
		}
	}

	public void mousePressed(MouseEvent e)
	{
		e.setSource(target);
		
		MouseListener[] listener = target.getMouseListeners();
		for (MouseListener l : listener)
		{
			l.mousePressed(e);
		}
	}

	public void mouseReleased(MouseEvent e)
	{
		e.setSource(target);
		
		MouseListener[] listener = target.getMouseListeners();
		for (MouseListener l : listener)
		{
			l.mouseReleased(e);
		}
	}

	public void mouseEntered(MouseEvent e)
	{
		e.setSource(target);
		
		MouseListener[] listener = target.getMouseListeners();
		for (MouseListener l : listener)
		{
			l.mouseEntered(e);
		}
	}

	public void mouseExited(MouseEvent e)
	{
		e.setSource(target);
		
		MouseListener[] listener = target.getMouseListeners();
		for (MouseListener l : listener)
		{
			l.mouseExited(e);
		}
	}
}
