-- add the incident entry type for forms
insert into patient.incident_entry_types (name,mime_type) 
values (E'form',E'text/plain');

-- add the default iReport template
insert into core.template_type (value,sequence_number,template_file_path) 
values (E'form_template',10,E'/lu/tudor/santec/gecamed/formeditor/gui/templates/FormPrintTemplate.jrxml');

-- roles and permissions
insert into usermanagement.permission (name, description) 
values (E'Form-EditorModule.viewEditor',E'User is allowed to see the form editor module');

insert into usermanagement.role (name, description) 
values (E'Form-EditorModule.formEditorAdmin',E'User is allowed to see the form editor module');

-- add permissions to role
insert into usermanagement.rel_role_permission (role_id,permission_id) 
values ((select id from usermanagement.role 
			where name=E'Form-EditorModule.formEditorAdmin'),
		(select id from usermanagement.permission 
			where name=E'Form-EditorModule.viewEditor'));

insert into usermanagement.rel_role_permission (role_id,permission_id) 
values ((select id from usermanagement.role 
			where name=E'PatientModule.admin'),
		(select id from usermanagement.permission 
			where name=E'Form-EditorModule.viewEditor'));



-- add 2 default templates

INSERT INTO formeditor.form_template
(name, version, description, subform_only, xml)
VALUES
(E'IMC', E'1.0', E'The Body Mass Index of a patient can be calculated in this form.', FALSE,
E'<?xml version="1.0" encoding="UTF-8"?>
<form info="Form template of GECAMed 1.2.01 - This file is a template to create forms for GECAMed (GEstion de CAbinet Medicaux)." name="IMC" version="1.1" subFormOnly="false">
  <description>The Body Mass Index of a patient can be calculated in this form.</description>
  <layout>
    <colFormat>0px,fill:5px:none,fill:113px:none,fill:20px:none,fill:100px:none,fill:20px:none,fill:100px:none,fill:20px:none,fill:100px:none,fill:25px:none,fill:125px:none,fill:31px:none,fill:292px:none</colFormat>
    <rowFormat>0px,fill:45px:none,fill:25px:none,fill:25px:none,fill:15px:none,fill:400px:none,fill:25px:none,fill:300px:none</rowFormat>
    <backgroundImg />
  </layout>
  <component xCoord="9" yCoord="3" xSize="1" ySize="1" key="Label_4" value="IMC :" storeInDB="false" showInHistory="false" historyIndex="0.0" labelPosition="none" labelText="">
    <type>lu.tudor.santec.gecamed.formeditor.gui.component.EditableLabel</type>
    <structure />
    <border>false,0,0,0,255</border>
    <background>false,238,238,238,255</background>
    <fontStyle>b</fontStyle>
    <fontSize>12</fontSize>
    <fontFamily>Dialog</fontFamily>
    <fontColor>true,0,0,0,255</fontColor>
    <hAlign>default</hAlign>
    <vAlign>default</vAlign>
  </component>
  <component xCoord="3" yCoord="2" xSize="10" ySize="1" key="headline" value="Indice de Masse Corporelle" storeInDB="false" showInHistory="false" historyIndex="0.0" labelPosition="none" labelText="">
    <type>lu.tudor.santec.gecamed.formeditor.gui.component.EditableLabel</type>
    <structure />
    <border>false,102,102,255,255</border>
    <background>false,255,255,255,255</background>
    <fontStyle>b</fontStyle>
    <fontSize>36</fontSize>
    <fontFamily>Arial</fontFamily>
    <fontColor>true,102,102,255,255</fontColor>
    <hAlign>center</hAlign>
    <vAlign>default</vAlign>
  </component>
  <component xCoord="3" yCoord="4" xSize="1" ySize="1" key="measuringDate" value="TODAY" storeInDB="true" showInHistory="false" historyIndex="0.0" labelPosition="none" labelText="">
    <type>lu.tudor.santec.gecamed.formeditor.gui.component.EditableDateChooser</type>
    <structure />
    <border>false,0,0,0,255</border>
    <background>false,238,238,238,255</background>
    <fontStyle />
    <fontSize>12</fontSize>
    <fontFamily>Dialog</fontFamily>
    <fontColor>true,0,0,0,255</fontColor>
    <hAlign>default</hAlign>
    <vAlign>default</vAlign>
  </component>
  <component xCoord="7" yCoord="3" xSize="1" ySize="1" key="Label_3" value="Poids [kg] :" storeInDB="false" showInHistory="false" historyIndex="0.0" labelPosition="none" labelText="">
    <type>lu.tudor.santec.gecamed.formeditor.gui.component.EditableLabel</type>
    <structure />
    <border>false,0,0,0,255</border>
    <background>false,238,238,238,255</background>
    <fontStyle>b</fontStyle>
    <fontSize>12</fontSize>
    <fontFamily>Dialog</fontFamily>
    <fontColor>true,0,0,0,255</fontColor>
    <hAlign>default</hAlign>
    <vAlign>default</vAlign>
  </component>
  <component xCoord="3" yCoord="3" xSize="1" ySize="1" key="label_1" value="Date de mesure :" storeInDB="false" showInHistory="false" historyIndex="0.0" labelPosition="none" labelText="">
    <type>lu.tudor.santec.gecamed.formeditor.gui.component.EditableLabel</type>
    <structure />
    <border>false,0,0,0,255</border>
    <background>false,238,238,238,255</background>
    <fontStyle>b</fontStyle>
    <fontSize>12</fontSize>
    <fontFamily>Dialog</fontFamily>
    <fontColor>true,0,0,0,255</fontColor>
    <hAlign>default</hAlign>
    <vAlign>default</vAlign>
  </component>
  <component xCoord="9" yCoord="4" xSize="1" ySize="1" key="lblBmi" value="" storeInDB="true" showInHistory="true" historyIndex="3.0" labelPosition="none" labelText="IMC :">
    <type>lu.tudor.santec.gecamed.formeditor.gui.component.EditableLabel</type>
    <structure />
    <border>false,0,0,102,255</border>
    <background>true,255,102,102,255</background>
    <fontStyle>bi</fontStyle>
    <fontSize>16</fontSize>
    <fontFamily>Arial</fontFamily>
    <fontColor>true,255,255,255,255</fontColor>
    <hAlign>default</hAlign>
    <vAlign>default</vAlign>
  </component>
  <component xCoord="3" yCoord="6" xSize="9" ySize="1" key="chart_bmi" value="" storeInDB="false" showInHistory="false" historyIndex="3.0" labelPosition="none" labelText="">
    <type>lu.tudor.santec.gecamed.formeditor.gui.component.EditableChart</type>
    <script eventTypeId="13">
      <scriptCode>manipulateChart(event.getSource());</scriptCode>
    </script>
    <structure>#&#xD;
#Fri Mar 16 13:42:05 CET 2012&#xD;
chart.type=1&#xD;
chart.series.referencingComponents=NULL;NULL;NULL;NULL;NULL;NULL;NULL;NULL;NULL;NULL;NULL;NULL;NULL;NULL;NULL;NULL;NULL;NULL;NULL;NULL;measuringDate-lblBmi;&#xD;
chart.yAxis.label=IMC [kg/m²]&#xD;
chart.yAxis.ticksVisible=true&#xD;
chart.border.color=-16777216&#xD;
chart.xAxis.size=14.0&#xD;
chart.title.text=IMC selon l&apos;Âge&#xD;
chart.series.staticData=2,00;14,5035 \\n2,08;14,4688 \\n2,17;14,4346 \\n2,25;14,4008 \\n2,33;14,3675 \\n2,42;14,3348 \\n2,50;14,3026 \\n2,58;14,2709 \\n2,67;14,2399 \\n2,75;14,2095 \\n2,83;14,1797 \\n2,92;14,1506 \\n3,00;14,1222 \\n3,08;14,0945 \\n3,17;14,0676 \\n3,25;14,0413 \\n3,33;14,0158 \\n3,42;13,9911 \\n3,50;13,9671 \\n3,58;13,9438 \\n3,67;13,9213 \\n3,75;13,8996 \\n3,83;13,8786 \\n3,92;13,8583 \\n4,00;13,8388 \\n4,08;13,8199 \\n4,17;13,8018 \\n4,25;13,7844 \\n4,33;13,7676 \\n4,42;13,7515 \\n4,50;13,7361 \\n4,58;13,7212 \\n4,67;13,7070 \\n4,75;13,6934 \\n4,83;13,6804 \\n4,92;13,6679 \\n5,00;13,6560 \\n5,08;13,6446 \\n5,17;13,6338 \\n5,25;13,6235 \\n5,33;13,6138 \\n5,42;13,6046 \\n5,50;13,5958 \\n5,58;13,5876 \\n5,67;13,5800 \\n5,75;13,5728 \\n5,83;13,5661 \\n5,92;13,5600 \\n6,00;13,5544 \\n6,08;13,5492 \\n6,17;13,5447 \\n6,25;13,5406 \\n6,33;13,5371 \\n6,42;13,5341 \\n6,50;13,5317 \\n6,58;13,5298 \\n6,67;13,5285 \\n6,75;13,5277 \\n6,83;13,5275 \\n6,92;13,5278 \\n7,00;13,5287 \\n7,08;13,5302 \\n7,17;13,5323 \\n7,25;13,5350 \\n7,33;13,5383 \\n7,42;13,5421 \\n7,50;13,5466 \\n7,58;13,5516 \\n7,67;13,5573 \\n7,75;13,5636 \\n7,83;13,5704 \\n7,92;13,5779 \\n8,00;13,5860 \\n8,08;13,5948 \\n8,17;13,6041 \\n8,25;13,6141 \\n8,33;13,6247 \\n8,42;13,6359 \\n8,50;13,6477 \\n8,58;13,6602 \\n8,67;13,6733 \\n8,75;13,6870 \\n8,83;13,7013 \\n8,92;13,7162 \\n9,00;13,7318 \\n9,08;13,7480 \\n9,17;13,7648 \\n9,25;13,7823 \\n9,33;13,8003 \\n9,42;13,8190 \\n9,50;13,8383 \\n9,58;13,8582 \\n9,67;13,8787 \\n9,75;13,8998 \\n9,83;13,9215 \\n9,92;13,9438 \\n10,00;13,9667 \\n10,08;13,9902 \\n10,17;14,0143 \\n10,25;14,0390 \\n10,33;14,0643 \\n10,42;14,0901 \\n10,50;14,1165 \\n10,58;14,1435 \\n10,67;14,1711 \\n10,75;14,1992 \\n10,83;14,2278 \\n10,92;14,2570 \\n11,00;14,2868 \\n11,08;14,3171 \\n11,17;14,3479 \\n11,25;14,3792 \\n11,33;14,4111 \\n11,42;14,4435 \\n11,50;14,4764 \\n11,58;14,5098 \\n11,67;14,5437 \\n11,75;14,5780 \\n11,83;14,6129 \\n11,92;14,6482 \\n12,00;14,6840 \\n12,08;14,7202 \\n12,17;14,7569 \\n12,25;14,7941 \\n12,33;14,8316 \\n12,42;14,8696 \\n12,50;14,9080 \\n12,58;14,9469 \\n12,67;14,9861 \\n12,75;15,0257 \\n12,83;15,0657 \\n12,92;15,1061 \\n13,00;15,1468 \\n13,08;15,1879 \\n13,17;15,2294 \\n13,25;15,2712 \\n13,33;15,3133 \\n13,42;15,3557 \\n13,50;15,3984 \\n13,58;15,4415 \\n13,67;15,4848 \\n13,75;15,5284 \\n13,83;15,5723 \\n13,92;15,6164 \\n14,00;15,6608 \\n14,08;15,7054 \\n14,17;15,7502 \\n14,25;15,7952 \\n14,33;15,8405 \\n14,42;15,8859 \\n14,50;15,9316 \\n14,58;15,9773 \\n14,67;16,0233 \\n14,75;16,0694 \\n14,83;16,1156 \\n14,92;16,1620 \\n15,00;16,2084 \\n15,08;16,2550 \\n15,17;16,3017 \\n15,25;16,3484 \\n15,33;16,3952 \\n15,42;16,4420 \\n15,50;16,4889 \\n15,58;16,5358 \\n15,67;16,5828 \\n15,75;16,6297 \\n15,83;16,6766 \\n15,92;16,7235 \\n16,00;16,7704 \\n16,08;16,8172 \\n16,17;16,8640 \\n16,25;16,9106 \\n16,33;16,9572 \\n16,42;17,0038 \\n16,50;17,0501 \\n16,58;17,0964 \\n16,67;17,1426 \\n16,75;17,1885 \\n16,83;17,2344 \\n16,92;17,2800 \\n17,00;17,3255 \\n17,08;17,3707 \\n17,17;17,4158 \\n17,25;17,4606 \\n17,33;17,5052 \\n17,42;17,5495 \\n17,50;17,5936 \\n17,58;17,6373 \\n17,67;17,6808 \\n17,75;17,7240 \\n17,83;17,7668 \\n17,92;17,8093 \\n18,00;17,8515 \\n18,08;17,8933 \\n18,17;17,9347 \\n18,25;17,9757 \\n18,33;18,0163 \\n18,42;18,0565 \\n18,50;18,0963 \\n18,58;18,1356 \\n18,67;18,1744 \\n18,75;18,2127 \\n18,83;18,2505 \\n18,92;18,2878 \\n19,00;18,3246 \\n19,08;18,3608 \\n19,17;18,3964 \\n19,25;18,4315 \\n19,33;18,4659 \\n19,42;18,4997 \\n19,50;18,5329 \\n19,58;18,5654 \\n19,67;18,5972 \\n19,75;18,6283 \\n19,83;18,6586 \\n19,92;18,6882 \\n\\n\#\\n2,00;14,7193 \\n2,08;14,6836 \\n2,17;14,6484 \\n2,25;14,6138 \\n2,33;14,5797 \\n2,42;14,5461 \\n2,50;14,5132 \\n2,58;14,4808 \\n2,67;14,4491 \\n2,75;14,4180 \\n2,83;14,3875 \\n2,92;14,3577 \\n3,00;14,3285 \\n3,08;14,3000 \\n3,17;14,2722 \\n3,25;14,2451 \\n3,33;14,2187 \\n3,42;14,1930 \\n3,50;14,1680 \\n3,58;14,1437 \\n3,67;14,1201 \\n3,75;14,0972 \\n3,83;14,0751 \\n3,92;14,0537 \\n4,00;14,0330 \\n4,08;14,0130 \\n4,17;13,9937 \\n4,25;13,9751 \\n4,33;13,9572 \\n4,42;13,9400 \\n4,50;13,9235 \\n4,58;13,9077 \\n4,67;13,8926 \\n4,75;13,8781 \\n4,83;13,8643 \\n4,92;13,8511 \\n5,00;13,8385 \\n5,08;13,8266 \\n5,17;13,8154 \\n5,25;13,8047 \\n5,33;13,7947 \\n5,42;13,7853 \\n5,50;13,7765 \\n5,58;13,7682 \\n5,67;13,7606 \\n5,75;13,7536 \\n5,83;13,7472 \\n5,92;13,7414 \\n6,00;13,7362 \\n6,08;13,7316 \\n6,17;13,7276 \\n6,25;13,7242 \\n6,33;13,7215 \\n6,42;13,7193 \\n6,50;13,7177 \\n6,58;13,7167 \\n6,67;13,7164 \\n6,75;13,7166 \\n6,83;13,7175 \\n6,92;13,7190 \\n7,00;13,7211 \\n7,08;13,7239 \\n7,17;13,7272 \\n7,25;13,7312 \\n7,33;13,7359 \\n7,42;13,7411 \\n7,50;13,7470 \\n7,58;13,7536 \\n7,67;13,7607 \\n7,75;13,7685 \\n7,83;13,7770 \\n7,92;13,7860 \\n8,00;13,7957 \\n8,08;13,8061 \\n8,17;13,8171 \\n8,25;13,8287 \\n8,33;13,8410 \\n8,42;13,8539 \\n8,50;13,8675 \\n8,58;13,8817 \\n8,67;13,8965 \\n8,75;13,9119 \\n8,83;13,9280 \\n8,92;13,9448 \\n9,00;13,9621 \\n9,08;13,9801 \\n9,17;13,9987 \\n9,25;14,0179 \\n9,33;14,0378 \\n9,42;14,0583 \\n9,50;14,0794 \\n9,58;14,1011 \\n9,67;14,1234 \\n9,75;14,1463 \\n9,83;14,1698 \\n9,92;14,1939 \\n10,00;14,2187 \\n10,08;14,2440 \\n10,17;14,2699 \\n10,25;14,2963 \\n10,33;14,3234 \\n10,42;14,3510 \\n10,50;14,3792 \\n10,58;14,4080 \\n10,67;14,4373 \\n10,75;14,4671 \\n10,83;14,4976 \\n10,92;14,5285 \\n11,00;14,5600 \\n11,08;14,5920 \\n11,17;14,6246 \\n11,25;14,6576 \\n11,33;14,6912 \\n11,42;14,7253 \\n11,50;14,7599 \\n11,58;14,7950 \\n11,67;14,8305 \\n11,75;14,8666 \\n11,83;14,9031 \\n11,92;14,9400 \\n12,00;14,9774 \\n12,08;15,0153 \\n12,17;15,0536 \\n12,25;15,0924 \\n12,33;15,1315 \\n12,42;15,1711 \\n12,50;15,2111 \\n12,58;15,2515 \\n12,67;15,2923 \\n12,75;15,3335 \\n12,83;15,3750 \\n12,92;15,4169 \\n13,00;15,4592 \\n13,08;15,5018 \\n13,17;15,5447 \\n13,25;15,5880 \\n13,33;15,6316 \\n13,42;15,6755 \\n13,50;15,7197 \\n13,58;15,7642 \\n13,67;15,8090 \\n13,75;15,8540 \\n13,83;15,8993 \\n13,92;15,9449 \\n14,00;15,9907 \\n14,08;16,0367 \\n14,17;16,0829 \\n14,25;16,1293 \\n14,33;16,1760 \\n14,42;16,2228 \\n14,50;16,2698 \\n14,58;16,3170 \\n14,67;16,3643 \\n14,75;16,4117 \\n14,83;16,4593 \\n14,92;16,5070 \\n15,00;16,5548 \\n15,08;16,6027 \\n15,17;16,6507 \\n15,25;16,6988 \\n15,33;16,7469 \\n15,42;16,7950 \\n15,50;16,8432 \\n15,58;16,8915 \\n15,67;16,9397 \\n15,75;16,9879 \\n15,83;17,0361 \\n15,92;17,0843 \\n16,00;17,1325 \\n16,08;17,1806 \\n16,17;17,2287 \\n16,25;17,2766 \\n16,33;17,3245 \\n16,42;17,3723 \\n16,50;17,4200 \\n16,58;17,4675 \\n16,67;17,5149 \\n16,75;17,5621 \\n16,83;17,6092 \\n16,92;17,6561 \\n17,00;17,7028 \\n17,08;17,7494 \\n17,17;17,7956 \\n17,25;17,8417 \\n17,33;17,8875 \\n17,42;17,9331 \\n17,50;17,9783 \\n17,58;18,0233 \\n17,67;18,0680 \\n17,75;18,1124 \\n17,83;18,1564 \\n17,92;18,2001 \\n18,00;18,2435 \\n18,08;18,2865 \\n18,17;18,3290 \\n18,25;18,3712 \\n18,33;18,4130 \\n18,42;18,4543 \\n18,50;18,4952 \\n18,58;18,5356 \\n18,67;18,5756 \\n18,75;18,6150 \\n18,83;18,6539 \\n18,92;18,6923 \\n19,00;18,7302 \\n19,08;18,7675 \\n19,17;18,8042 \\n19,25;18,8403 \\n19,33;18,8758 \\n19,42;18,9107 \\n19,50;18,9449 \\n19,58;18,9784 \\n19,67;19,0113 \\n19,75;19,0434 \\n19,83;19,0748 \\n19,92;19,1055 \\n\\n\#\\n2,00;15,0712 \\n2,08;15,0334 \\n2,17;14,9962 \\n2,25;14,9597 \\n2,33;14,9238 \\n2,42;14,8887 \\n2,50;14,8541 \\n2,58;14,8203 \\n2,67;14,7871 \\n2,75;14,7545 \\n2,83;14,7226 \\n2,92;14,6914 \\n3,00;14,6609 \\n3,08;14,6310 \\n3,17;14,6017 \\n3,25;14,5732 \\n3,33;14,5453 \\n3,42;14,5180 \\n3,50;14,4915 \\n3,58;14,4657 \\n3,67;14,4405 \\n3,75;14,4160 \\n3,83;14,3923 \\n3,92;14,3693 \\n4,00;14,3470 \\n4,08;14,3254 \\n4,17;14,3045 \\n4,25;14,2844 \\n4,33;14,2651 \\n4,42;14,2465 \\n4,50;14,2287 \\n4,58;14,2116 \\n4,67;14,1953 \\n4,75;14,1798 \\n4,83;14,1650 \\n4,92;14,1510 \\n5,00;14,1378 \\n5,08;14,1253 \\n5,17;14,1136 \\n5,25;14,1027 \\n5,33;14,0925 \\n5,42;14,0831 \\n5,50;14,0744 \\n5,58;14,0664 \\n5,67;14,0592 \\n5,75;14,0527 \\n5,83;14,0470 \\n5,92;14,0420 \\n6,00;14,0377 \\n6,08;14,0342 \\n6,17;14,0313 \\n6,25;14,0292 \\n6,33;14,0278 \\n6,42;14,0271 \\n6,50;14,0272 \\n6,58;14,0279 \\n6,67;14,0294 \\n6,75;14,0315 \\n6,83;14,0344 \\n6,92;14,0379 \\n7,00;14,0422 \\n7,08;14,0471 \\n7,17;14,0528 \\n7,25;14,0591 \\n7,33;14,0661 \\n7,42;14,0739 \\n7,50;14,0823 \\n7,58;14,0914 \\n7,67;14,1012 \\n7,75;14,1116 \\n7,83;14,1228 \\n7,92;14,1346 \\n8,00;14,1471 \\n8,08;14,1603 \\n8,17;14,1742 \\n8,25;14,1887 \\n8,33;14,2039 \\n8,42;14,2197 \\n8,50;14,2362 \\n8,58;14,2534 \\n8,67;14,2712 \\n8,75;14,2897 \\n8,83;14,3088 \\n8,92;14,3286 \\n9,00;14,3490 \\n9,08;14,3701 \\n9,17;14,3918 \\n9,25;14,4141 \\n9,33;14,4370 \\n9,42;14,4606 \\n9,50;14,4848 \\n9,58;14,5096 \\n9,67;14,5350 \\n9,75;14,5610 \\n9,83;14,5876 \\n9,92;14,6148 \\n10,00;14,6426 \\n10,08;14,6710 \\n10,17;14,6999 \\n10,25;14,7295 \\n10,33;14,7596 \\n10,42;14,7903 \\n10,50;14,8215 \\n10,58;14,8533 \\n10,67;14,8856 \\n10,75;14,9184 \\n10,83;14,9518 \\n10,92;14,9858 \\n11,00;15,0202 \\n11,08;15,0552 \\n11,17;15,0907 \\n11,25;15,1266 \\n11,33;15,1631 \\n11,42;15,2001 \\n11,50;15,2375 \\n11,58;15,2754 \\n11,67;15,3138 \\n11,75;15,3527 \\n11,83;15,3919 \\n11,92;15,4317 \\n12,00;15,4719 \\n12,08;15,5125 \\n12,17;15,5535 \\n12,25;15,5949 \\n12,33;15,6368 \\n12,42;15,6790 \\n12,50;15,7217 \\n12,58;15,7647 \\n12,67;15,8081 \\n12,75;15,8518 \\n12,83;15,8960 \\n12,92;15,9404 \\n13,00;15,9852 \\n13,08;16,0303 \\n13,17;16,0758 \\n13,25;16,1215 \\n13,33;16,1676 \\n13,42;16,2139 \\n13,50;16,2605 \\n13,58;16,3074 \\n13,67;16,3546 \\n13,75;16,4020 \\n13,83;16,4497 \\n13,92;16,4976 \\n14,00;16,5457 \\n14,08;16,5940 \\n14,17;16,6425 \\n14,25;16,6913 \\n14,33;16,7402 \\n14,42;16,7892 \\n14,50;16,8385 \\n14,58;16,8879 \\n14,67;16,9374 \\n14,75;16,9871 \\n14,83;17,0368 \\n14,92;17,0867 \\n15,00;17,1367 \\n15,08;17,1868 \\n15,17;17,2369 \\n15,25;17,2871 \\n15,33;17,3373 \\n15,42;17,3876 \\n15,50;17,4379 \\n15,58;17,4883 \\n15,67;17,5386 \\n15,75;17,5889 \\n15,83;17,6392 \\n15,92;17,6895 \\n16,00;17,7397 \\n16,08;17,7899 \\n16,17;17,8400 \\n16,25;17,8900 \\n16,33;17,9400 \\n16,42;17,9898 \\n16,50;18,0395 \\n16,58;18,0890 \\n16,67;18,1385 \\n16,75;18,1877 \\n16,83;18,2368 \\n16,92;18,2857 \\n17,00;18,3344 \\n17,08;18,3829 \\n17,17;18,4312 \\n17,25;18,4792 \\n17,33;18,5270 \\n17,42;18,5745 \\n17,50;18,6218 \\n17,58;18,6687 \\n17,67;18,7154 \\n17,75;18,7617 \\n17,83;18,8077 \\n17,92;18,8533 \\n18,00;18,8985 \\n18,08;18,9434 \\n18,17;18,9879 \\n18,25;19,0320 \\n18,33;19,0756 \\n18,42;19,1188 \\n18,50;19,1616 \\n18,58;19,2039 \\n18,67;19,2457 \\n18,75;19,2870 \\n18,83;19,3277 \\n18,92;19,3680 \\n19,00;19,4077 \\n19,08;19,4468 \\n19,17;19,4853 \\n19,25;19,5233 \\n19,33;19,5606 \\n19,42;19,5973 \\n19,50;19,6333 \\n19,58;19,6687 \\n19,67;19,7033 \\n19,75;19,7373 \\n19,83;19,7706 \\n19,92;19,8031 \\n\\n\#\\n2,00;15,7196 \\n2,08;15,6763 \\n2,17;15,6340 \\n2,25;15,5927 \\n2,33;15,5523 \\n2,42;15,5128 \\n2,50;15,4741 \\n2,58;15,4364 \\n2,67;15,3995 \\n2,75;15,3635 \\n2,83;15,3282 \\n2,92;15,2938 \\n3,00;15,2602 \\n3,08;15,2273 \\n3,17;15,1952 \\n3,25;15,1639 \\n3,33;15,1334 \\n3,42;15,1036 \\n3,50;15,0746 \\n3,58;15,0463 \\n3,67;15,0189 \\n3,75;14,9922 \\n3,83;14,9663 \\n3,92;14,9412 \\n4,00;14,9169 \\n4,08;14,8935 \\n4,17;14,8709 \\n4,25;14,8492 \\n4,33;14,8284 \\n4,42;14,8084 \\n4,50;14,7894 \\n4,58;14,7713 \\n4,67;14,7541 \\n4,75;14,7379 \\n4,83;14,7227 \\n4,92;14,7084 \\n5,00;14,6950 \\n5,08;14,6827 \\n5,17;14,6713 \\n5,25;14,6609 \\n5,33;14,6515 \\n5,42;14,6431 \\n5,50;14,6357 \\n5,58;14,6292 \\n5,67;14,6237 \\n5,75;14,6191 \\n5,83;14,6155 \\n5,92;14,6129 \\n6,00;14,6112 \\n6,08;14,6104 \\n6,17;14,6106 \\n6,25;14,6116 \\n6,33;14,6136 \\n6,42;14,6165 \\n6,50;14,6202 \\n6,58;14,6248 \\n6,67;14,6303 \\n6,75;14,6367 \\n6,83;14,6439 \\n6,92;14,6519 \\n7,00;14,6608 \\n7,08;14,6705 \\n7,17;14,6811 \\n7,25;14,6924 \\n7,33;14,7046 \\n7,42;14,7175 \\n7,50;14,7312 \\n7,58;14,7457 \\n7,67;14,7610 \\n7,75;14,7770 \\n7,83;14,7938 \\n7,92;14,8114 \\n8,00;14,8296 \\n8,08;14,8487 \\n8,17;14,8684 \\n8,25;14,8889 \\n8,33;14,9101 \\n8,42;14,9319 \\n8,50;14,9545 \\n8,58;14,9778 \\n8,67;15,0018 \\n8,75;15,0264 \\n8,83;15,0517 \\n8,92;15,0777 \\n9,00;15,1043 \\n9,08;15,1316 \\n9,17;15,1595 \\n9,25;15,1881 \\n9,33;15,2173 \\n9,42;15,2471 \\n9,50;15,2775 \\n9,58;15,3086 \\n9,67;15,3402 \\n9,75;15,3725 \\n9,83;15,4053 \\n9,92;15,4387 \\n10,00;15,4727 \\n10,08;15,5073 \\n10,17;15,5424 \\n10,25;15,5780 \\n10,33;15,6142 \\n10,42;15,6510 \\n10,50;15,6883 \\n10,58;15,7261 \\n10,67;15,7644 \\n10,75;15,8032 \\n10,83;15,8425 \\n10,92;15,8824 \\n11,00;15,9227 \\n11,08;15,9635 \\n11,17;16,0047 \\n11,25;16,0465 \\n11,33;16,0886 \\n11,42;16,1313 \\n11,50;16,1743 \\n11,58;16,2178 \\n11,67;16,2618 \\n11,75;16,3061 \\n11,83;16,3509 \\n11,92;16,3960 \\n12,00;16,4416 \\n12,08;16,4875 \\n12,17;16,5338 \\n12,25;16,5805 \\n12,33;16,6275 \\n12,42;16,6749 \\n12,50;16,7227 \\n12,58;16,7707 \\n12,67;16,8191 \\n12,75;16,8679 \\n12,83;16,9169 \\n12,92;16,9662 \\n13,00;17,0158 \\n13,08;17,0657 \\n13,17;17,1159 \\n13,25;17,1664 \\n13,33;17,2171 \\n13,42;17,2680 \\n13,50;17,3192 \\n13,58;17,3706 \\n13,67;17,4223 \\n13,75;17,4741 \\n13,83;17,5262 \\n13,92;17,5784 \\n14,00;17,6309 \\n14,08;17,6835 \\n14,17;17,7362 \\n14,25;17,7892 \\n14,33;17,8422 \\n14,42;17,8955 \\n14,50;17,9488 \\n14,58;18,0023 \\n14,67;18,0558 \\n14,75;18,1095 \\n14,83;18,1632 \\n14,92;18,2170 \\n15,00;18,2709 \\n15,08;18,3249 \\n15,17;18,3789 \\n15,25;18,4329 \\n15,33;18,4870 \\n15,42;18,5410 \\n15,50;18,5951 \\n15,58;18,6492 \\n15,67;18,7032 \\n15,75;18,7572 \\n15,83;18,8112 \\n15,92;18,8651 \\n16,00;18,9190 \\n16,08;18,9728 \\n16,17;19,0265 \\n16,25;19,0801 \\n16,33;19,1336 \\n16,42;19,1870 \\n16,50;19,2402 \\n16,58;19,2934 \\n16,67;19,3463 \\n16,75;19,3991 \\n16,83;19,4517 \\n16,92;19,5041 \\n17,00;19,5563 \\n17,08;19,6083 \\n17,17;19,6600 \\n17,25;19,7115 \\n17,33;19,7628 \\n17,42;19,8138 \\n17,50;19,8644 \\n17,58;19,9148 \\n17,67;19,9649 \\n17,75;20,0147 \\n17,83;20,0641 \\n17,92;20,1132 \\n18,00;20,1619 \\n18,08;20,2102 \\n18,17;20,2582 \\n18,25;20,3057 \\n18,33;20,3528 \\n18,42;20,3995 \\n18,50;20,4457 \\n18,58;20,4915 \\n18,67;20,5367 \\n18,75;20,5815 \\n18,83;20,6258 \\n18,92;20,6696 \\n19,00;20,7128 \\n19,08;20,7555 \\n19,17;20,7977 \\n19,25;20,8392 \\n19,33;20,8802 \\n19,42;20,9206 \\n19,50;20,9603 \\n19,58;20,9995 \\n19,67;21,0379 \\n19,75;21,0758 \\n19,83;21,1130 \\n19,92;21,1495 \\n\\n\#\\n2,00;16,5478 \\n2,08;16,4944 \\n2,17;16,4426 \\n2,25;16,3922 \\n2,33;16,3433 \\n2,42;16,2958 \\n2,50;16,2497 \\n2,58;16,2050 \\n2,67;16,1615 \\n2,75;16,1193 \\n2,83;16,0784 \\n2,92;16,0388 \\n3,00;16,0003 \\n3,08;15,9630 \\n3,17;15,9270 \\n3,25;15,8920 \\n3,33;15,8582 \\n3,42;15,8256 \\n3,50;15,7941 \\n3,58;15,7636 \\n3,67;15,7343 \\n3,75;15,7061 \\n3,83;15,6790 \\n3,92;15,6531 \\n4,00;15,6282 \\n4,08;15,6044 \\n4,17;15,5818 \\n4,25;15,5603 \\n4,33;15,5399 \\n4,42;15,5206 \\n4,50;15,5026 \\n4,58;15,4857 \\n4,67;15,4700 \\n4,75;15,4555 \\n4,83;15,4421 \\n4,92;15,4300 \\n5,00;15,4191 \\n5,08;15,4095 \\n5,17;15,4010 \\n5,25;15,3938 \\n5,33;15,3878 \\n5,42;15,3831 \\n5,50;15,3795 \\n5,58;15,3772 \\n5,67;15,3761 \\n5,75;15,3762 \\n5,83;15,3775 \\n5,92;15,3799 \\n6,00;15,3835 \\n6,08;15,3883 \\n6,17;15,3942 \\n6,25;15,4013 \\n6,33;15,4094 \\n6,42;15,4187 \\n6,50;15,4290 \\n6,58;15,4404 \\n6,67;15,4529 \\n6,75;15,4664 \\n6,83;15,4809 \\n6,92;15,4964 \\n7,00;15,5129 \\n7,08;15,5303 \\n7,17;15,5488 \\n7,25;15,5681 \\n7,33;15,5884 \\n7,42;15,6096 \\n7,50;15,6317 \\n7,58;15,6547 \\n7,67;15,6785 \\n7,75;15,7032 \\n7,83;15,7288 \\n7,92;15,7551 \\n8,00;15,7823 \\n8,08;15,8103 \\n8,17;15,8390 \\n8,25;15,8686 \\n8,33;15,8989 \\n8,42;15,9299 \\n8,50;15,9617 \\n8,58;15,9942 \\n8,67;16,0274 \\n8,75;16,0613 \\n8,83;16,0959 \\n8,92;16,1312 \\n9,00;16,1671 \\n9,08;16,2037 \\n9,17;16,2409 \\n9,25;16,2788 \\n9,33;16,3173 \\n9,42;16,3564 \\n9,50;16,3961 \\n9,58;16,4363 \\n9,67;16,4772 \\n9,75;16,5186 \\n9,83;16,5606 \\n9,92;16,6031 \\n10,00;16,6461 \\n10,08;16,6897 \\n10,17;16,7338 \\n10,25;16,7784 \\n10,33;16,8235 \\n10,42;16,8691 \\n10,50;16,9151 \\n10,58;16,9616 \\n10,67;17,0086 \\n10,75;17,0560 \\n10,83;17,1039 \\n10,92;17,1522 \\n11,00;17,2009 \\n11,08;17,2500 \\n11,17;17,2995 \\n11,25;17,3494 \\n11,33;17,3997 \\n11,42;17,4504 \\n11,50;17,5014 \\n11,58;17,5528 \\n11,67;17,6045 \\n11,75;17,6565 \\n11,83;17,7089 \\n11,92;17,7616 \\n12,00;17,8146 \\n12,08;17,8679 \\n12,17;17,9216 \\n12,25;17,9754 \\n12,33;18,0296 \\n12,42;18,0840 \\n12,50;18,1387 \\n12,58;18,1937 \\n12,67;18,2488 \\n12,75;18,3043 \\n12,83;18,3599 \\n12,92;18,4157 \\n13,00;18,4718 \\n13,08;18,5281 \\n13,17;18,5845 \\n13,25;18,6411 \\n13,33;18,6979 \\n13,42;18,7549 \\n13,50;18,8120 \\n13,58;18,8693 \\n13,67;18,9267 \\n13,75;18,9842 \\n13,83;19,0419 \\n13,92;19,0997 \\n14,00;19,1576 \\n14,08;19,2156 \\n14,17;19,2737 \\n14,25;19,3318 \\n14,33;19,3901 \\n14,42;19,4484 \\n14,50;19,5067 \\n14,58;19,5651 \\n14,67;19,6236 \\n14,75;19,6821 \\n14,83;19,7406 \\n14,92;19,7991 \\n15,00;19,8577 \\n15,08;19,9162 \\n15,17;19,9747 \\n15,25;20,0332 \\n15,33;20,0917 \\n15,42;20,1502 \\n15,50;20,2086 \\n15,58;20,2669 \\n15,67;20,3252 \\n15,75;20,3835 \\n15,83;20,4416 \\n15,92;20,4997 \\n16,00;20,5576 \\n16,08;20,6155 \\n16,17;20,6733 \\n16,25;20,7309 \\n16,33;20,7884 \\n16,42;20,8457 \\n16,50;20,9029 \\n16,58;20,9600 \\n16,67;21,0169 \\n16,75;21,0736 \\n16,83;21,1301 \\n16,92;21,1864 \\n17,00;21,2425 \\n17,08;21,2984 \\n17,17;21,3540 \\n17,25;21,4094 \\n17,33;21,4646 \\n17,42;21,5195 \\n17,50;21,5742 \\n17,58;21,6285 \\n17,67;21,6826 \\n17,75;21,7364 \\n17,83;21,7899 \\n17,92;21,8430 \\n18,00;21,8959 \\n18,08;21,9484 \\n18,17;22,0005 \\n18,25;22,0523 \\n18,33;22,1037 \\n18,42;22,1548 \\n18,50;22,2054 \\n18,58;22,2557 \\n18,67;22,3055 \\n18,75;22,3550 \\n18,83;22,4040 \\n18,92;22,4526 \\n19,00;22,5007 \\n19,08;22,5484 \\n19,17;22,5957 \\n19,25;22,6424 \\n19,33;22,6887 \\n19,42;22,7346 \\n19,50;22,7799 \\n19,58;22,8247 \\n19,67;22,8691 \\n19,75;22,9129 \\n19,83;22,9563 \\n19,92;22,9991 \\n\\n\#\\n2,00;17,5213 \\n2,08;17,4514 \\n2,17;17,3838 \\n2,25;17,3187 \\n2,33;17,2559 \\n2,42;17,1955 \\n2,50;17,1373 \\n2,58;17,0813 \\n2,67;17,0275 \\n2,75;16,9759 \\n2,83;16,9265 \\n2,92;16,8791 \\n3,00;16,8338 \\n3,08;16,7905 \\n3,17;16,7492 \\n3,25;16,7099 \\n3,33;16,6725 \\n3,42;16,6370 \\n3,50;16,6034 \\n3,58;16,5717 \\n3,67;16,5418 \\n3,75;16,5136 \\n3,83;16,4873 \\n3,92;16,4626 \\n4,00;16,4397 \\n4,08;16,4185 \\n4,17;16,3989 \\n4,25;16,3810 \\n4,33;16,3647 \\n4,42;16,3500 \\n4,50;16,3369 \\n4,58;16,3254 \\n4,67;16,3155 \\n4,75;16,3072 \\n4,83;16,3004 \\n4,92;16,2952 \\n5,00;16,2915 \\n5,08;16,2893 \\n5,17;16,2887 \\n5,25;16,2895 \\n5,33;16,2919 \\n5,42;16,2958 \\n5,50;16,3011 \\n5,58;16,3079 \\n5,67;16,3162 \\n5,75;16,3259 \\n5,83;16,3370 \\n5,92;16,3496 \\n6,00;16,3635 \\n6,08;16,3787 \\n6,17;16,3954 \\n6,25;16,4133 \\n6,33;16,4326 \\n6,42;16,4531 \\n6,50;16,4750 \\n6,58;16,4980 \\n6,67;16,5223 \\n6,75;16,5478 \\n6,83;16,5744 \\n6,92;16,6022 \\n7,00;16,6311 \\n7,08;16,6611 \\n7,17;16,6923 \\n7,25;16,7244 \\n7,33;16,7576 \\n7,42;16,7919 \\n7,50;16,8271 \\n7,58;16,8633 \\n7,67;16,9004 \\n7,75;16,9384 \\n7,83;16,9774 \\n7,92;17,0173 \\n8,00;17,0580 \\n8,08;17,0995 \\n8,17;17,1419 \\n8,25;17,1851 \\n8,33;17,2291 \\n8,42;17,2738 \\n8,50;17,3193 \\n8,58;17,3655 \\n8,67;17,4124 \\n8,75;17,4600 \\n8,83;17,5083 \\n8,92;17,5573 \\n9,00;17,6068 \\n9,08;17,6570 \\n9,17;17,7078 \\n9,25;17,7592 \\n9,33;17,8111 \\n9,42;17,8636 \\n9,50;17,9166 \\n9,58;17,9702 \\n9,67;18,0243 \\n9,75;18,0788 \\n9,83;18,1338 \\n9,92;18,1893 \\n10,00;18,2452 \\n10,08;18,3016 \\n10,17;18,3583 \\n10,25;18,4155 \\n10,33;18,4731 \\n10,42;18,5310 \\n10,50;18,5893 \\n10,58;18,6479 \\n10,67;18,7069 \\n10,75;18,7662 \\n10,83;18,8258 \\n10,92;18,8857 \\n11,00;18,9459 \\n11,08;19,0063 \\n11,17;19,0671 \\n11,25;19,1280 \\n11,33;19,1892 \\n11,42;19,2507 \\n11,50;19,3123 \\n11,58;19,3742 \\n11,67;19,4362 \\n11,75;19,4985 \\n11,83;19,5609 \\n11,92;19,6234 \\n12,00;19,6861 \\n12,08;19,7490 \\n12,17;19,8120 \\n12,25;19,8751 \\n12,33;19,9384 \\n12,42;20,0017 \\n12,50;20,0651 \\n12,58;20,1287 \\n12,67;20,1923 \\n12,75;20,2559 \\n12,83;20,3197 \\n12,92;20,3835 \\n13,00;20,4473 \\n13,08;20,5112 \\n13,17;20,5751 \\n13,25;20,6390 \\n13,33;20,7030 \\n13,42;20,7669 \\n13,50;20,8309 \\n13,58;20,8949 \\n13,67;20,9588 \\n13,75;21,0227 \\n13,83;21,0866 \\n13,92;21,1505 \\n14,00;21,2143 \\n14,08;21,2781 \\n14,17;21,3419 \\n14,25;21,4055 \\n14,33;21,4692 \\n14,42;21,5327 \\n14,50;21,5962 \\n14,58;21,6596 \\n14,67;21,7229 \\n14,75;21,7862 \\n14,83;21,8493 \\n14,92;21,9124 \\n15,00;21,9753 \\n15,08;22,0382 \\n15,17;22,1009 \\n15,25;22,1635 \\n15,33;22,2260 \\n15,42;22,2884 \\n15,50;22,3506 \\n15,58;22,4127 \\n15,67;22,4747 \\n15,75;22,5365 \\n15,83;22,5982 \\n15,92;22,6598 \\n16,00;22,7211 \\n16,08;22,7824 \\n16,17;22,8435 \\n16,25;22,9044 \\n16,33;22,9651 \\n16,42;23,0257 \\n16,50;23,0861 \\n16,58;23,1464 \\n16,67;23,2064 \\n16,75;23,2663 \\n16,83;23,3260 \\n16,92;23,3856 \\n17,00;23,4449 \\n17,08;23,5040 \\n17,17;23,5630 \\n17,25;23,6218 \\n17,33;23,6803 \\n17,42;23,7387 \\n17,50;23,7969 \\n17,58;23,8548 \\n17,67;23,9126 \\n17,75;23,9702 \\n17,83;24,0275 \\n17,92;24,0847 \\n18,00;24,1417 \\n18,08;24,1984 \\n18,17;24,2550 \\n18,25;24,3113 \\n18,33;24,3674 \\n18,42;24,4233 \\n18,50;24,4791 \\n18,58;24,5346 \\n18,67;24,5899 \\n18,75;24,6450 \\n18,83;24,6999 \\n18,92;24,7547 \\n19,00;24,8092 \\n19,08;24,8635 \\n19,17;24,9177 \\n19,25;24,9716 \\n19,33;25,0254 \\n19,42;25,0790 \\n19,50;25,1325 \\n19,58;25,1857 \\n19,67;25,2388 \\n19,75;25,2918 \\n19,83;25,3446 \\n19,92;25,3972 \\n\\n\#\\n2,00;18,1195 \\n2,08;18,0367 \\n2,17;17,9570 \\n2,25;17,8805 \\n2,33;17,8070 \\n2,42;17,7367 \\n2,50;17,6693 \\n2,58;17,6049 \\n2,67;17,5435 \\n2,75;17,4850 \\n2,83;17,4293 \\n2,92;17,3764 \\n3,00;17,3263 \\n3,08;17,2789 \\n3,17;17,2342 \\n3,25;17,1921 \\n3,33;17,1527 \\n3,42;17,1158 \\n3,50;17,0813 \\n3,58;17,0494 \\n3,67;17,0199 \\n3,75;16,9927 \\n3,83;16,9679 \\n3,92;16,9453 \\n4,00;16,9250 \\n4,08;16,9069 \\n4,17;16,8909 \\n4,25;16,8770 \\n4,33;16,8652 \\n4,42;16,8554 \\n4,50;16,8476 \\n4,58;16,8418 \\n4,67;16,8378 \\n4,75;16,8358 \\n4,83;16,8356 \\n4,92;16,8373 \\n5,00;16,8408 \\n5,08;16,8460 \\n5,17;16,8530 \\n5,25;16,8617 \\n5,33;16,8722 \\n5,42;16,8843 \\n5,50;16,8981 \\n5,58;16,9135 \\n5,67;16,9305 \\n5,75;16,9491 \\n5,83;16,9693 \\n5,92;16,9910 \\n6,00;17,0142 \\n6,08;17,0389 \\n6,17;17,0650 \\n6,25;17,0927 \\n6,33;17,1217 \\n6,42;17,1521 \\n6,50;17,1838 \\n6,58;17,2169 \\n6,67;17,2513 \\n6,75;17,2869 \\n6,83;17,3238 \\n6,92;17,3619 \\n7,00;17,4012 \\n7,08;17,4417 \\n7,17;17,4833 \\n7,25;17,5260 \\n7,33;17,5698 \\n7,42;17,6146 \\n7,50;17,6605 \\n7,58;17,7074 \\n7,67;17,7552 \\n7,75;17,8040 \\n7,83;17,8537 \\n7,92;17,9043 \\n8,00;17,9558 \\n8,08;18,0081 \\n8,17;18,0612 \\n8,25;18,1151 \\n8,33;18,1698 \\n8,42;18,2253 \\n8,50;18,2814 \\n8,58;18,3383 \\n8,67;18,3958 \\n8,75;18,4540 \\n8,83;18,5128 \\n8,92;18,5722 \\n9,00;18,6322 \\n9,08;18,6928 \\n9,17;18,7539 \\n9,25;18,8155 \\n9,33;18,8777 \\n9,42;18,9403 \\n9,50;19,0034 \\n9,58;19,0669 \\n9,67;19,1308 \\n9,75;19,1952 \\n9,83;19,2599 \\n9,92;19,3250 \\n10,00;19,3904 \\n10,08;19,4562 \\n10,17;19,5223 \\n10,25;19,5886 \\n10,33;19,6553 \\n10,42;19,7222 \\n10,50;19,7894 \\n10,58;19,8568 \\n10,67;19,9244 \\n10,75;19,9922 \\n10,83;20,0602 \\n10,92;20,1284 \\n11,00;20,1967 \\n11,08;20,2651 \\n11,17;20,3337 \\n11,25;20,4024 \\n11,33;20,4712 \\n11,42;20,5401 \\n11,50;20,6091 \\n11,58;20,6781 \\n11,67;20,7472 \\n11,75;20,8163 \\n11,83;20,8855 \\n11,92;20,9547 \\n12,00;21,0239 \\n12,08;21,0930 \\n12,17;21,1622 \\n12,25;21,2313 \\n12,33;21,3004 \\n12,42;21,3695 \\n12,50;21,4385 \\n12,58;21,5075 \\n12,67;21,5764 \\n12,75;21,6452 \\n12,83;21,7139 \\n12,92;21,7825 \\n13,00;21,8510 \\n13,08;21,9195 \\n13,17;21,9878 \\n13,25;22,0560 \\n13,33;22,1240 \\n13,42;22,1919 \\n13,50;22,2597 \\n13,58;22,3274 \\n13,67;22,3949 \\n13,75;22,4622 \\n13,83;22,5294 \\n13,92;22,5964 \\n14,00;22,6633 \\n14,08;22,7299 \\n14,17;22,7964 \\n14,25;22,8628 \\n14,33;22,9289 \\n14,42;22,9948 \\n14,50;23,0606 \\n14,58;23,1262 \\n14,67;23,1916 \\n14,75;23,2568 \\n14,83;23,3218 \\n14,92;23,3866 \\n15,00;23,4512 \\n15,08;23,5156 \\n15,17;23,5798 \\n15,25;23,6438 \\n15,33;23,7076 \\n15,42;23,7712 \\n15,50;23,8346 \\n15,58;23,8978 \\n15,67;23,9608 \\n15,75;24,0236 \\n15,83;24,0862 \\n15,92;24,1486 \\n16,00;24,2109 \\n16,08;24,2729 \\n16,17;24,3348 \\n16,25;24,3964 \\n16,33;24,4579 \\n16,42;24,5192 \\n16,50;24,5803 \\n16,58;24,6413 \\n16,67;24,7021 \\n16,75;24,7627 \\n16,83;24,8232 \\n16,92;24,8835 \\n17,00;24,9436 \\n17,08;25,0036 \\n17,17;25,0635 \\n17,25;25,1232 \\n17,33;25,1829 \\n17,42;25,2423 \\n17,50;25,3017 \\n17,58;25,3610 \\n17,67;25,4202 \\n17,75;25,4792 \\n17,83;25,5382 \\n17,92;25,5972 \\n18,00;25,6560 \\n18,08;25,7148 \\n18,17;25,7735 \\n18,25;25,8323 \\n18,33;25,8909 \\n18,42;25,9496 \\n18,50;26,0082 \\n18,58;26,0669 \\n18,67;26,1255 \\n18,75;26,1842 \\n18,83;26,2429 \\n18,92;26,3017 \\n19,00;26,3605 \\n19,08;26,4194 \\n19,17;26,4784 \\n19,25;26,5375 \\n19,33;26,5967 \\n19,42;26,6561 \\n19,50;26,7156 \\n19,58;26,7752 \\n19,67;26,8351 \\n19,75;26,8951 \\n19,83;26,9553 \\n19,92;27,0158 \\n\\n\#\\n2,00;18,5611 \\n2,08;18,4673 \\n2,17;18,3774 \\n2,25;18,2913 \\n2,33;18,2089 \\n2,42;18,1303 \\n2,50;18,0554 \\n2,58;17,9841 \\n2,67;17,9164 \\n2,75;17,8522 \\n2,83;17,7914 \\n2,92;17,7341 \\n3,00;17,6802 \\n3,08;17,6296 \\n3,17;17,5823 \\n3,25;17,5382 \\n3,33;17,4973 \\n3,42;17,4594 \\n3,50;17,4246 \\n3,58;17,3928 \\n3,67;17,3639 \\n3,75;17,3380 \\n3,83;17,3148 \\n3,92;17,2943 \\n4,00;17,2766 \\n4,08;17,2615 \\n4,17;17,2490 \\n4,25;17,2390 \\n4,33;17,2315 \\n4,42;17,2263 \\n4,50;17,2235 \\n4,58;17,2231 \\n4,67;17,2248 \\n4,75;17,2288 \\n4,83;17,2349 \\n4,92;17,2432 \\n5,00;17,2534 \\n5,08;17,2657 \\n5,17;17,2800 \\n5,25;17,2962 \\n5,33;17,3144 \\n5,42;17,3344 \\n5,50;17,3562 \\n5,58;17,3798 \\n5,67;17,4051 \\n5,75;17,4322 \\n5,83;17,4609 \\n5,92;17,4913 \\n6,00;17,5234 \\n6,08;17,5570 \\n6,17;17,5921 \\n6,25;17,6288 \\n6,33;17,6670 \\n6,42;17,7066 \\n6,50;17,7476 \\n6,58;17,7900 \\n6,67;17,8338 \\n6,75;17,8789 \\n6,83;17,9253 \\n6,92;17,9730 \\n7,00;18,0218 \\n7,08;18,0719 \\n7,17;18,1231 \\n7,25;18,1755 \\n7,33;18,2289 \\n7,42;18,2834 \\n7,50;18,3390 \\n7,58;18,3955 \\n7,67;18,4531 \\n7,75;18,5115 \\n7,83;18,5709 \\n7,92;18,6311 \\n8,00;18,6923 \\n8,08;18,7542 \\n8,17;18,8169 \\n8,25;18,8804 \\n8,33;18,9446 \\n8,42;19,0095 \\n8,50;19,0751 \\n8,58;19,1414 \\n8,67;19,2083 \\n8,75;19,2757 \\n8,83;19,3438 \\n8,92;19,4124 \\n9,00;19,4815 \\n9,08;19,5511 \\n9,17;19,6212 \\n9,25;19,6917 \\n9,33;19,7627 \\n9,42;19,8340 \\n9,50;19,9057 \\n9,58;19,9778 \\n9,67;20,0502 \\n9,75;20,1229 \\n9,83;20,1959 \\n9,92;20,2692 \\n10,00;20,3427 \\n10,08;20,4164 \\n10,17;20,4904 \\n10,25;20,5645 \\n10,33;20,6388 \\n10,42;20,7132 \\n10,50;20,7878 \\n10,58;20,8624 \\n10,67;20,9372 \\n10,75;21,0120 \\n10,83;21,0869 \\n10,92;21,1618 \\n11,00;21,2368 \\n11,08;21,3118 \\n11,17;21,3867 \\n11,25;21,4616 \\n11,33;21,5366 \\n11,42;21,6114 \\n11,50;21,6862 \\n11,58;21,7609 \\n11,67;21,8355 \\n11,75;21,9101 \\n11,83;21,9845 \\n11,92;22,0588 \\n12,00;22,1329 \\n12,08;22,2069 \\n12,17;22,2807 \\n12,25;22,3544 \\n12,33;22,4279 \\n12,42;22,5012 \\n12,50;22,5743 \\n12,58;22,6472 \\n12,67;22,7199 \\n12,75;22,7924 \\n12,83;22,8646 \\n12,92;22,9367 \\n13,00;23,0084 \\n13,08;23,0799 \\n13,17;23,1512 \\n13,25;23,2222 \\n13,33;23,2930 \\n13,42;23,3634 \\n13,50;23,4336 \\n13,58;23,5035 \\n13,67;23,5732 \\n13,75;23,6425 \\n13,83;23,7116 \\n13,92;23,7804 \\n14,00;23,8489 \\n14,08;23,9171 \\n14,17;23,9850 \\n14,25;24,0526 \\n14,33;24,1199 \\n14,42;24,1869 \\n14,50;24,2536 \\n14,58;24,3200 \\n14,67;24,3862 \\n14,75;24,4520 \\n14,83;24,5175 \\n14,92;24,5828 \\n15,00;24,6478 \\n15,08;24,7125 \\n15,17;24,7769 \\n15,25;24,8410 \\n15,33;24,9049 \\n15,42;24,9685 \\n15,50;25,0318 \\n15,58;25,0949 \\n15,67;25,1577 \\n15,75;25,2203 \\n15,83;25,2827 \\n15,92;25,3448 \\n16,00;25,4067 \\n16,08;25,4684 \\n16,17;25,5298 \\n16,25;25,5911 \\n16,33;25,6522 \\n16,42;25,7131 \\n16,50;25,7738 \\n16,58;25,8344 \\n16,67;25,8948 \\n16,75;25,9550 \\n16,83;26,0152 \\n16,92;26,0752 \\n17,00;26,1351 \\n17,08;26,1950 \\n17,17;26,2547 \\n17,25;26,3144 \\n17,33;26,3741 \\n17,42;26,4337 \\n17,50;26,4933 \\n17,58;26,5528 \\n17,67;26,6124 \\n17,75;26,6720 \\n17,83;26,7317 \\n17,92;26,7914 \\n18,00;26,8512 \\n18,08;26,9111 \\n18,17;26,9711 \\n18,25;27,0312 \\n18,33;27,0915 \\n18,42;27,1519 \\n18,50;27,2126 \\n18,58;27,2734 \\n18,67;27,3345 \\n18,75;27,3959 \\n18,83;27,4575 \\n18,92;27,5194 \\n19,00;27,5816 \\n19,08;27,6441 \\n19,17;27,7071 \\n19,25;27,7704 \\n19,33;27,8341 \\n19,42;27,8983 \\n19,50;27,9629 \\n19,58;28,0280 \\n19,67;28,0936 \\n19,75;28,1598 \\n19,83;28,2265 \\n19,92;28,2938 \\n\\n\#\\n2,00;19,2789 \\n2,08;19,1647 \\n2,17;19,0557 \\n2,25;18,9519 \\n2,33;18,8532 \\n2,42;18,7595 \\n2,50;18,6708 \\n2,58;18,5869 \\n2,67;18,5079 \\n2,75;18,4336 \\n2,83;18,3640 \\n2,92;18,2990 \\n3,00;18,2384 \\n3,08;18,1823 \\n3,17;18,1306 \\n3,25;18,0831 \\n3,33;18,0399 \\n3,42;18,0007 \\n3,50;17,9657 \\n3,58;17,9346 \\n3,67;17,9074 \\n3,75;17,8841 \\n3,83;17,8644 \\n3,92;17,8485 \\n4,00;17,8361 \\n4,08;17,8273 \\n4,17;17,8219 \\n4,25;17,8198 \\n4,33;17,8210 \\n4,42;17,8254 \\n4,50;17,8329 \\n4,58;17,8435 \\n4,67;17,8570 \\n4,75;17,8734 \\n4,83;17,8925 \\n4,92;17,9144 \\n5,00;17,9389 \\n5,08;17,9660 \\n5,17;17,9956 \\n5,25;18,0276 \\n5,33;18,0620 \\n5,42;18,0987 \\n5,50;18,1376 \\n5,58;18,1786 \\n5,67;18,2218 \\n5,75;18,2670 \\n5,83;18,3142 \\n5,92;18,3633 \\n6,00;18,4142 \\n6,08;18,4670 \\n6,17;18,5215 \\n6,25;18,5777 \\n6,33;18,6356 \\n6,42;18,6951 \\n6,50;18,7562 \\n6,58;18,8187 \\n6,67;18,8827 \\n6,75;18,9481 \\n6,83;19,0149 \\n6,92;19,0830 \\n7,00;19,1524 \\n7,08;19,2229 \\n7,17;19,2947 \\n7,25;19,3676 \\n7,33;19,4416 \\n7,42;19,5167 \\n7,50;19,5927 \\n7,58;19,6697 \\n7,67;19,7477 \\n7,75;19,8265 \\n7,83;19,9062 \\n7,92;19,9867 \\n8,00;20,0679 \\n8,08;20,1499 \\n8,17;20,2326 \\n8,25;20,3159 \\n8,33;20,3998 \\n8,42;20,4843 \\n8,50;20,5693 \\n8,58;20,6549 \\n8,67;20,7409 \\n8,75;20,8273 \\n8,83;20,9142 \\n8,92;21,0014 \\n9,00;21,0889 \\n9,08;21,1768 \\n9,17;21,2649 \\n9,25;21,3532 \\n9,33;21,4418 \\n9,42;21,5305 \\n9,50;21,6194 \\n9,58;21,7084 \\n9,67;21,7975 \\n9,75;21,8866 \\n9,83;21,9758 \\n9,92;22,0649 \\n10,00;22,1541 \\n10,08;22,2432 \\n10,17;22,3322 \\n10,25;22,4212 \\n10,33;22,5100 \\n10,42;22,5987 \\n10,50;22,6872 \\n10,58;22,7755 \\n10,67;22,8636 \\n10,75;22,9515 \\n10,83;23,0391 \\n10,92;23,1265 \\n11,00;23,2136 \\n11,08;23,3004 \\n11,17;23,3868 \\n11,25;23,4729 \\n11,33;23,5586 \\n11,42;23,6440 \\n11,50;23,7290 \\n11,58;23,8135 \\n11,67;23,8977 \\n11,75;23,9814 \\n11,83;24,0647 \\n11,92;24,1475 \\n12,00;24,2298 \\n12,08;24,3117 \\n12,17;24,3931 \\n12,25;24,4740 \\n12,33;24,5543 \\n12,42;24,6342 \\n12,50;24,7135 \\n12,58;24,7923 \\n12,67;24,8706 \\n12,75;24,9483 \\n12,83;25,0255 \\n12,92;25,1021 \\n13,00;25,1781 \\n13,08;25,2536 \\n13,17;25,3285 \\n13,25;25,4029 \\n13,33;25,4767 \\n13,42;25,5499 \\n13,50;25,6226 \\n13,58;25,6946 \\n13,67;25,7662 \\n13,75;25,8371 \\n13,83;25,9075 \\n13,92;25,9773 \\n14,00;26,0466 \\n14,08;26,1153 \\n14,17;26,1835 \\n14,25;26,2512 \\n14,33;26,3183 \\n14,42;26,3849 \\n14,50;26,4509 \\n14,58;26,5165 \\n14,67;26,5815 \\n14,75;26,6461 \\n14,83;26,7101 \\n14,92;26,7737 \\n15,00;26,8369 \\n15,08;26,8996 \\n15,17;26,9618 \\n15,25;27,0237 \\n15,33;27,0851 \\n15,42;27,1462 \\n15,50;27,2068 \\n15,58;27,2671 \\n15,67;27,3271 \\n15,75;27,3867 \\n15,83;27,4461 \\n15,92;27,5051 \\n16,00;27,5639 \\n16,08;27,6225 \\n16,17;27,6808 \\n16,25;27,7389 \\n16,33;27,7968 \\n16,42;27,8546 \\n16,50;27,9123 \\n16,58;27,9698 \\n16,67;28,0272 \\n16,75;28,0846 \\n16,83;28,1420 \\n16,92;28,1994 \\n17,00;28,2568 \\n17,08;28,3142 \\n17,17;28,3717 \\n17,25;28,4294 \\n17,33;28,4872 \\n17,42;28,5451 \\n17,50;28,6033 \\n17,58;28,6617 \\n17,67;28,7204 \\n17,75;28,7794 \\n17,83;28,8388 \\n17,92;28,8985 \\n18,00;28,9586 \\n18,08;29,0192 \\n18,17;29,0803 \\n18,25;29,1419 \\n18,33;29,2041 \\n18,42;29,2669 \\n18,50;29,3303 \\n18,58;29,3944 \\n18,67;29,4593 \\n18,75;29,5249 \\n18,83;29,5913 \\n18,92;29,6586 \\n19,00;29,7267 \\n19,08;29,7959 \\n19,17;29,8659 \\n19,25;29,9371 \\n19,33;30,0093 \\n19,42;30,0826 \\n19,50;30,1571 \\n19,58;30,2328 \\n19,67;30,3097 \\n19,75;30,3880 \\n19,83;30,4676 \\n19,92;30,5486 \\n\\n\#\\n2,00;19,7919 \\n2,08;19,6610 \\n2,17;19,5366 \\n2,25;19,4185 \\n2,33;19,3067 \\n2,42;19,2010 \\n2,50;19,1013 \\n2,58;19,0076 \\n2,67;18,9197 \\n2,75;18,8376 \\n2,83;18,7611 \\n2,92;18,6901 \\n3,00;18,6245 \\n3,08;18,5642 \\n3,17;18,5092 \\n3,25;18,4594 \\n3,33;18,4146 \\n3,42;18,3747 \\n3,50;18,3397 \\n3,58;18,3095 \\n3,67;18,2839 \\n3,75;18,2630 \\n3,83;18,2466 \\n3,92;18,2346 \\n4,00;18,2269 \\n4,08;18,2235 \\n4,17;18,2243 \\n4,25;18,2292 \\n4,33;18,2380 \\n4,42;18,2507 \\n4,50;18,2672 \\n4,58;18,2875 \\n4,67;18,3114 \\n4,75;18,3388 \\n4,83;18,3696 \\n4,92;18,4037 \\n5,00;18,4411 \\n5,08;18,4817 \\n5,17;18,5252 \\n5,25;18,5718 \\n5,33;18,6212 \\n5,42;18,6734 \\n5,50;18,7282 \\n5,58;18,7857 \\n5,67;18,8456 \\n5,75;18,9080 \\n5,83;18,9727 \\n5,92;19,0397 \\n6,00;19,1088 \\n6,08;19,1801 \\n6,17;19,2533 \\n6,25;19,3285 \\n6,33;19,4055 \\n6,42;19,4843 \\n6,50;19,5649 \\n6,58;19,6471 \\n6,67;19,7309 \\n6,75;19,8162 \\n6,83;19,9029 \\n6,92;19,9911 \\n7,00;20,0805 \\n7,08;20,1712 \\n7,17;20,2631 \\n7,25;20,3562 \\n7,33;20,4503 \\n7,42;20,5454 \\n7,50;20,6416 \\n7,58;20,7386 \\n7,67;20,8364 \\n7,75;20,9351 \\n7,83;21,0345 \\n7,92;21,1346 \\n8,00;21,2353 \\n8,08;21,3367 \\n8,17;21,4385 \\n8,25;21,5409 \\n8,33;21,6437 \\n8,42;21,7469 \\n8,50;21,8504 \\n8,58;21,9543 \\n8,67;22,0584 \\n8,75;22,1628 \\n8,83;22,2673 \\n8,92;22,3719 \\n9,00;22,4767 \\n9,08;22,5814 \\n9,17;22,6863 \\n9,25;22,7910 \\n9,33;22,8957 \\n9,42;23,0004 \\n9,50;23,1048 \\n9,58;23,2092 \\n9,67;23,3133 \\n9,75;23,4171 \\n9,83;23,5207 \\n9,92;23,6240 \\n10,00;23,7270 \\n10,08;23,8296 \\n10,17;23,9318 \\n10,25;24,0335 \\n10,33;24,1349 \\n10,42;24,2357 \\n10,50;24,3361 \\n10,58;24,4359 \\n10,67;24,5352 \\n10,75;24,6339 \\n10,83;24,7320 \\n10,92;24,8295 \\n11,00;24,9263 \\n11,08;25,0225 \\n11,17;25,1180 \\n11,25;25,2128 \\n11,33;25,3069 \\n11,42;25,4003 \\n11,50;25,4929 \\n11,58;25,5848 \\n11,67;25,6759 \\n11,75;25,7662 \\n11,83;25,8557 \\n11,92;25,9445 \\n12,00;26,0323 \\n12,08;26,1194 \\n12,17;26,2056 \\n12,25;26,2910 \\n12,33;26,3755 \\n12,42;26,4592 \\n12,50;26,5420 \\n12,58;26,6239 \\n12,67;26,7050 \\n12,75;26,7852 \\n12,83;26,8645 \\n12,92;26,9430 \\n13,00;27,0205 \\n13,08;27,0972 \\n13,17;27,1731 \\n13,25;27,2480 \\n13,33;27,3221 \\n13,42;27,3953 \\n13,50;27,4677 \\n13,58;27,5392 \\n13,67;27,6099 \\n13,75;27,6798 \\n13,83;27,7488 \\n13,92;27,8170 \\n14,00;27,8844 \\n14,08;27,9510 \\n14,17;28,0169 \\n14,25;28,0819 \\n14,33;28,1462 \\n14,42;28,2098 \\n14,50;28,2727 \\n14,58;28,3348 \\n14,67;28,3963 \\n14,75;28,4571 \\n14,83;28,5173 \\n14,92;28,5768 \\n15,00;28,6358 \\n15,08;28,6941 \\n15,17;28,7519 \\n15,25;28,8092 \\n15,33;28,8659 \\n15,42;28,9222 \\n15,50;28,9780 \\n15,58;29,0334 \\n15,67;29,0884 \\n15,75;29,1430 \\n15,83;29,1973 \\n15,92;29,2512 \\n16,00;29,3049 \\n16,08;29,3584 \\n16,17;29,4116 \\n16,25;29,4647 \\n16,33;29,5177 \\n16,42;29,5705 \\n16,50;29,6233 \\n16,58;29,6761 \\n16,67;29,7288 \\n16,75;29,7817 \\n16,83;29,8346 \\n16,92;29,8877 \\n17,00;29,9410 \\n17,08;29,9945 \\n17,17;30,0482 \\n17,25;30,1023 \\n17,33;30,1568 \\n17,42;30,2116 \\n17,50;30,2670 \\n17,58;30,3228 \\n17,67;30,3792 \\n17,75;30,4362 \\n17,83;30,4939 \\n17,92;30,5523 \\n18,00;30,6114 \\n18,08;30,6714 \\n18,17;30,7322 \\n18,25;30,7940 \\n18,33;30,8568 \\n18,42;30,9206 \\n18,50;30,9855 \\n18,58;31,0516 \\n18,67;31,1189 \\n18,75;31,1875 \\n18,83;31,2574 \\n18,92;31,3287 \\n19,00;31,4015 \\n19,08;31,4759 \\n19,17;31,5518 \\n19,25;31,6294 \\n19,33;31,7087 \\n19,42;31,7898 \\n19,50;31,8728 \\n19,58;31,9576 \\n19,67;32,0445 \\n19,75;32,1335 \\n19,83;32,2246 \\n19,92;32,3179 \\n\\n\#\\n2,00;14,1323\\n2,08;14,1024\\n2,17;14,0730\\n2,25;14,0440\\n2,33;14,0154\\n2,42;13,9872\\n2,50;13,9595\\n2,58;13,9322\\n2,67;13,9054\\n2,75;13,8789\\n2,83;13,8530\\n2,92;13,8274\\n3,00;13,8023\\n3,08;13,7776\\n3,17;13,7534\\n3,25;13,7296\\n3,33;13,7063\\n3,42;13,6834\\n3,50;13,6610\\n3,58;13,6391\\n3,67;13,6176\\n3,75;13,5965\\n3,83;13,5760\\n3,92;13,5559\\n4,00;13,5364\\n4,08;13,5173\\n4,17;13,4987\\n4,25;13,4806\\n4,33;13,4631\\n4,42;13,4461\\n4,50;13,4296\\n4,58;13,4137\\n4,67;13,3983\\n4,75;13,3835\\n4,83;13,3693\\n4,92;13,3556\\n5,00;13,3425\\n5,08;13,3300\\n5,17;13,3181\\n5,25;13,3069\\n5,33;13,2962\\n5,42;13,2861\\n5,50;13,2767\\n5,58;13,2679\\n5,67;13,2597\\n5,75;13,2522\\n5,83;13,2453\\n5,92;13,2390\\n6,00;13,2334\\n6,08;13,2285\\n6,17;13,2242\\n6,25;13,2206\\n6,33;13,2177\\n6,42;13,2154\\n6,50;13,2138\\n6,58;13,2128\\n6,67;13,2125\\n6,75;13,2129\\n6,83;13,2140\\n6,92;13,2157\\n7,00;13,2182\\n7,08;13,2213\\n7,17;13,2250\\n7,25;13,2295\\n7,33;13,2346\\n7,42;13,2404\\n7,50;13,2468\\n7,58;13,2540\\n7,67;13,2618\\n7,75;13,2702\\n7,83;13,2794\\n7,92;13,2892\\n8,00;13,2997\\n8,08;13,3108\\n8,17;13,3226\\n8,25;13,3350\\n8,33;13,3481\\n8,42;13,3618\\n8,50;13,3762\\n8,58;13,3913\\n8,67;13,4069\\n8,75;13,4232\\n8,83;13,4402\\n8,92;13,4577\\n9,00;13,4759\\n9,08;13,4947\\n9,17;13,5141\\n9,25;13,5341\\n9,33;13,5547\\n9,42;13,5760\\n9,50;13,5978\\n9,58;13,6202\\n9,67;13,6431\\n9,75;13,6667\\n9,83;13,6908\\n9,92;13,7155\\n10,00;13,7407\\n10,08;13,7665\\n10,17;13,7929\\n10,25;13,8197\\n10,33;13,8471\\n10,42;13,8751\\n10,50;13,9035\\n10,58;13,9324\\n10,67;13,9619\\n10,75;13,9918\\n10,83;14,0222\\n10,92;14,0531\\n11,00;14,0845\\n11,08;14,1163\\n11,17;14,1486\\n11,25;14,1813\\n11,33;14,2145\\n11,42;14,2480\\n11,50;14,2820\\n11,58;14,3164\\n11,67;14,3512\\n11,75;14,3864\\n11,83;14,4220\\n11,92;14,4579\\n12,00;14,4942\\n12,08;14,5308\\n12,17;14,5677\\n12,25;14,6050\\n12,33;14,6426\\n12,42;14,6805\\n12,50;14,7187\\n12,58;14,7572\\n12,67;14,7959\\n12,75;14,8349\\n12,83;14,8742\\n12,92;14,9136\\n13,00;14,9533\\n13,08;14,9933\\n13,17;15,0334\\n13,25;15,0737\\n13,33;15,1141\\n13,42;15,1547\\n13,50;15,1955\\n13,58;15,2364\\n13,67;15,2774\\n13,75;15,3185\\n13,83;15,3597\\n13,92;15,4010\\n14,00;15,4424\\n14,08;15,4837\\n14,17;15,5252\\n14,25;15,5666\\n14,33;15,6081\\n14,42;15,6495\\n14,50;15,6909\\n14,58;15,7323\\n14,67;15,7736\\n14,75;15,8148\\n14,83;15,8559\\n14,92;15,8969\\n15,00;15,9379\\n15,08;15,9786\\n15,17;16,0192\\n15,25;16,0597\\n15,33;16,0999\\n15,42;16,1399\\n15,50;16,1797\\n15,58;16,2193\\n15,67;16,2586\\n15,75;16,2976\\n15,83;16,3363\\n15,92;16,3747\\n16,00;16,4128\\n16,08;16,4505\\n16,17;16,4878\\n16,25;16,5247\\n16,33;16,5612\\n16,42;16,5973\\n16,50;16,6330\\n16,58;16,6681\\n16,67;16,7028\\n16,75;16,7369\\n16,83;16,7705\\n16,92;16,8036\\n17,00;16,8360\\n17,08;16,8679\\n17,17;16,8991\\n17,25;16,9298\\n17,33;16,9597\\n17,42;16,9889\\n17,50;17,0175\\n17,58;17,0453\\n17,67;17,0724\\n17,75;17,0986\\n17,83;17,1241\\n17,92;17,1488\\n18,00;17,1726\\n18,08;17,1955\\n18,17;17,2176\\n18,25;17,2387\\n18,33;17,2589\\n18,42;17,2782\\n18,50;17,2964\\n18,58;17,3137\\n18,67;17,3299\\n18,75;17,3450\\n18,83;17,3591\\n18,92;17,3720\\n19,00;17,3838\\n19,08;17,3945\\n19,17;17,4040\\n19,25;17,4123\\n19,33;17,4193\\n19,42;17,4251\\n19,50;17,4296\\n19,58;17,4328\\n19,67;17,4346\\n19,75;17,4352\\n19,83;17,4343\\n19,92;17,4320\\n\\n\#\\n2,00;14,3802\\n2,08;14,3453\\n2,17;14,3110\\n2,25;14,2773\\n2,33;14,2442\\n2,42;14,2117\\n2,50;14,1799\\n2,58;14,1487\\n2,67;14,1181\\n2,75;14,0882\\n2,83;14,0589\\n2,92;14,0302\\n3,00;14,0021\\n3,08;13,9747\\n3,17;13,9479\\n3,25;13,9217\\n3,33;13,8961\\n3,42;13,8712\\n3,50;13,8470\\n3,58;13,8233\\n3,67;13,8003\\n3,75;13,7780\\n3,83;13,7562\\n3,92;13,7352\\n4,00;13,7147\\n4,08;13,6949\\n4,17;13,6758\\n4,25;13,6573\\n4,33;13,6395\\n4,42;13,6223\\n4,50;13,6058\\n4,58;13,5900\\n4,67;13,5748\\n4,75;13,5603\\n4,83;13,5465\\n4,92;13,5334\\n5,00;13,5209\\n5,08;13,5091\\n5,17;13,4981\\n5,25;13,4877\\n5,33;13,4780\\n5,42;13,4690\\n5,50;13,4608\\n5,58;13,4532\\n5,67;13,4463\\n5,75;13,4401\\n5,83;13,4347\\n5,92;13,4299\\n6,00;13,4259\\n6,08;13,4225\\n6,17;13,4199\\n6,25;13,4180\\n6,33;13,4168\\n6,42;13,4163\\n6,50;13,4165\\n6,58;13,4175\\n6,67;13,4191\\n6,75;13,4215\\n6,83;13,4245\\n6,92;13,4283\\n7,00;13,4328\\n7,08;13,4379\\n7,17;13,4438\\n7,25;13,4504\\n7,33;13,4576\\n7,42;13,4656\\n7,50;13,4743\\n7,58;13,4836\\n7,67;13,4936\\n7,75;13,5043\\n7,83;13,5157\\n7,92;13,5278\\n8,00;13,5405\\n8,08;13,5539\\n8,17;13,5680\\n8,25;13,5827\\n8,33;13,5981\\n8,42;13,6141\\n8,50;13,6308\\n8,58;13,6481\\n8,67;13,6660\\n8,75;13,6846\\n8,83;13,7038\\n8,92;13,7237\\n9,00;13,7441\\n9,08;13,7652\\n9,17;13,7868\\n9,25;13,8091\\n9,33;13,8320\\n9,42;13,8554\\n9,50;13,8794\\n9,58;13,9040\\n9,67;13,9292\\n9,75;13,9549\\n9,83;13,9812\\n9,92;14,0080\\n10,00;14,0354\\n10,08;14,0632\\n10,17;14,0917\\n10,25;14,1206\\n10,33;14,1500\\n10,42;14,1800\\n10,50;14,2104\\n10,58;14,2413\\n10,67;14,2727\\n10,75;14,3046\\n10,83;14,3369\\n10,92;14,3697\\n11,00;14,4029\\n11,08;14,4366\\n11,17;14,4706\\n11,25;14,5051\\n11,33;14,5400\\n11,42;14,5753\\n11,50;14,6110\\n11,58;14,6470\\n11,67;14,6835\\n11,75;14,7202\\n11,83;14,7574\\n11,92;14,7948\\n12,00;14,8326\\n12,08;14,8707\\n12,17;14,9091\\n12,25;14,9478\\n12,33;14,9868\\n12,42;15,0261\\n12,50;15,0656\\n12,58;15,1054\\n12,67;15,1454\\n12,75;15,1856\\n12,83;15,2260\\n12,92;15,2667\\n13,00;15,3075\\n13,08;15,3485\\n13,17;15,3897\\n13,25;15,4310\\n13,33;15,4724\\n13,42;15,5140\\n13,50;15,5557\\n13,58;15,5975\\n13,67;15,6394\\n13,75;15,6814\\n13,83;15,7234\\n13,92;15,7654\\n14,00;15,8075\\n14,08;15,8496\\n14,17;15,8917\\n14,25;15,9338\\n14,33;15,9759\\n14,42;16,0179\\n14,50;16,0599\\n14,58;16,1018\\n14,67;16,1436\\n14,75;16,1854\\n14,83;16,2270\\n14,92;16,2684\\n15,00;16,3097\\n15,08;16,3509\\n15,17;16,3919\\n15,25;16,4326\\n15,33;16,4732\\n15,42;16,5135\\n15,50;16,5536\\n15,58;16,5934\\n15,67;16,6329\\n15,75;16,6722\\n15,83;16,7111\\n15,92;16,7496\\n16,00;16,7879\\n16,08;16,8257\\n16,17;16,8632\\n16,25;16,9003\\n16,33;16,9369\\n16,42;16,9731\\n16,50;17,0088\\n16,58;17,0440\\n16,67;17,0788\\n16,75;17,1130\\n16,83;17,1467\\n16,92;17,1798\\n17,00;17,2123\\n17,08;17,2443\\n17,17;17,2756\\n17,25;17,3063\\n17,33;17,3363\\n17,42;17,3656\\n17,50;17,3943\\n17,58;17,4222\\n17,67;17,4494\\n17,75;17,4758\\n17,83;17,5014\\n17,92;17,5262\\n18,00;17,5502\\n18,08;17,5733\\n18,17;17,5955\\n18,25;17,6169\\n18,33;17,6373\\n18,42;17,6568\\n18,50;17,6754\\n18,58;17,6929\\n18,67;17,7095\\n18,75;17,7250\\n18,83;17,7395\\n18,92;17,7529\\n19,00;17,7652\\n19,08;17,7763\\n19,17;17,7864\\n19,25;17,7952\\n19,33;17,8029\\n19,42;17,8093\\n19,50;17,8146\\n19,58;17,8185\\n19,67;17,8212\\n19,75;17,8226\\n19,83;17,8226\\n19,92;17,8213\\n\\n\#\\n2,00;14,7796\\n2,08;14,7369\\n2,17;14,6952\\n2,25;14,6543\\n2,33;14,6143\\n2,42;14,5753\\n2,50;14,5372\\n2,58;14,5000\\n2,67;14,4638\\n2,75;14,4285\\n2,83;14,3941\\n2,92;14,3606\\n3,00;14,3281\\n3,08;14,2964\\n3,17;14,2658\\n3,25;14,2360\\n3,33;14,2071\\n3,42;14,1792\\n3,50;14,1522\\n3,58;14,1261\\n3,67;14,1008\\n3,75;14,0765\\n3,83;14,0531\\n3,92;14,0306\\n4,00;14,0090\\n4,08;13,9882\\n4,17;13,9683\\n4,25;13,9493\\n4,33;13,9312\\n4,42;13,9140\\n4,50;13,8976\\n4,58;13,8821\\n4,67;13,8674\\n4,75;13,8536\\n4,83;13,8406\\n4,92;13,8285\\n5,00;13,8173\\n5,08;13,8068\\n5,17;13,7973\\n5,25;13,7885\\n5,33;13,7806\\n5,42;13,7735\\n5,50;13,7673\\n5,58;13,7619\\n5,67;13,7572\\n5,75;13,7535\\n5,83;13,7505\\n5,92;13,7483\\n6,00;13,7469\\n6,08;13,7464\\n6,17;13,7466\\n6,25;13,7476\\n6,33;13,7495\\n6,42;13,7521\\n6,50;13,7554\\n6,58;13,7596\\n6,67;13,7645\\n6,75;13,7702\\n6,83;13,7767\\n6,92;13,7839\\n7,00;13,7919\\n7,08;13,8006\\n7,17;13,8101\\n7,25;13,8203\\n7,33;13,8312\\n7,42;13,8429\\n7,50;13,8553\\n7,58;13,8684\\n7,67;13,8822\\n7,75;13,8967\\n7,83;13,9119\\n7,92;13,9279\\n8,00;13,9444\\n8,08;13,9617\\n8,17;13,9797\\n8,25;13,9983\\n8,33;14,0176\\n8,42;14,0375\\n8,50;14,0581\\n8,58;14,0793\\n8,67;14,1012\\n8,75;14,1236\\n8,83;14,1467\\n8,92;14,1705\\n9,00;14,1948\\n9,08;14,2197\\n9,17;14,2452\\n9,25;14,2713\\n9,33;14,2980\\n9,42;14,3252\\n9,50;14,3530\\n9,58;14,3813\\n9,67;14,4102\\n9,75;14,4396\\n9,83;14,4696\\n9,92;14,5000\\n10,00;14,5310\\n10,08;14,5625\\n10,17;14,5944\\n10,25;14,6269\\n10,33;14,6598\\n10,42;14,6932\\n10,50;14,7270\\n10,58;14,7613\\n10,67;14,7960\\n10,75;14,8312\\n10,83;14,8668\\n10,92;14,9028\\n11,00;14,9391\\n11,08;14,9759\\n11,17;15,0130\\n11,25;15,0506\\n11,33;15,0884\\n11,42;15,1267\\n11,50;15,1652\\n11,58;15,2041\\n11,67;15,2433\\n11,75;15,2828\\n11,83;15,3226\\n11,92;15,3627\\n12,00;15,4031\\n12,08;15,4437\\n12,17;15,4846\\n12,25;15,5257\\n12,33;15,5671\\n12,42;15,6087\\n12,50;15,6504\\n12,58;15,6924\\n12,67;15,7346\\n12,75;15,7769\\n12,83;15,8194\\n12,92;15,8620\\n13,00;15,9048\\n13,08;15,9476\\n13,17;15,9906\\n13,25;16,0337\\n13,33;16,0769\\n13,42;16,1201\\n13,50;16,1634\\n13,58;16,2068\\n13,67;16,2502\\n13,75;16,2936\\n13,83;16,3370\\n13,92;16,3804\\n14,00;16,4238\\n14,08;16,4671\\n14,17;16,5104\\n14,25;16,5537\\n14,33;16,5968\\n14,42;16,6399\\n14,50;16,6829\\n14,58;16,7257\\n14,67;16,7684\\n14,75;16,8110\\n14,83;16,8534\\n14,92;16,8956\\n15,00;16,9377\\n15,08;16,9795\\n15,17;17,0211\\n15,25;17,0625\\n15,33;17,1036\\n15,42;17,1445\\n15,50;17,1851\\n15,58;17,2253\\n15,67;17,2653\\n15,75;17,3049\\n15,83;17,3442\\n15,92;17,3832\\n16,00;17,4217\\n16,08;17,4599\\n16,17;17,4976\\n16,25;17,5349\\n16,33;17,5718\\n16,42;17,6082\\n16,50;17,6441\\n16,58;17,6796\\n16,67;17,7145\\n16,75;17,7489\\n16,83;17,7828\\n16,92;17,8161\\n17,00;17,8488\\n17,08;17,8809\\n17,17;17,9124\\n17,25;17,9432\\n17,33;17,9734\\n17,42;18,0030\\n17,50;18,0318\\n17,58;18,0600\\n17,67;18,0874\\n17,75;18,1140\\n17,83;18,1399\\n17,92;18,1651\\n18,00;18,1894\\n18,08;18,2129\\n18,17;18,2355\\n18,25;18,2573\\n18,33;18,2782\\n18,42;18,2983\\n18,50;18,3174\\n18,58;18,3355\\n18,67;18,3527\\n18,75;18,3690\\n18,83;18,3842\\n18,92;18,3984\\n19,00;18,4116\\n19,08;18,4237\\n19,17;18,4348\\n19,25;18,4447\\n19,33;18,4535\\n19,42;18,4612\\n19,50;18,4677\\n19,58;18,4731\\n19,67;18,4772\\n19,75;18,4801\\n19,83;18,4818\\n19,92;18,4822\\n\\n\#\\n2,00;15,4998\\n2,08;15,4442\\n2,17;15,3901\\n2,25;15,3375\\n2,33;15,2864\\n2,42;15,2367\\n2,50;15,1885\\n2,58;15,1417\\n2,67;15,0964\\n2,75;15,0525\\n2,83;15,0101\\n2,92;14,9691\\n3,00;14,9295\\n3,08;14,8914\\n3,17;14,8546\\n3,25;14,8193\\n3,33;14,7854\\n3,42;14,7529\\n3,50;14,7218\\n3,58;14,6920\\n3,67;14,6637\\n3,75;14,6366\\n3,83;14,6109\\n3,92;14,5865\\n4,00;14,5634\\n4,08;14,5417\\n4,17;14,5212\\n4,25;14,5019\\n4,33;14,4840\\n4,42;14,4672\\n4,50;14,4517\\n4,58;14,4374\\n4,67;14,4243\\n4,75;14,4123\\n4,83;14,4016\\n4,92;14,3919\\n5,00;14,3835\\n5,08;14,3761\\n5,17;14,3698\\n5,25;14,3647\\n5,33;14,3606\\n5,42;14,3576\\n5,50;14,3557\\n5,58;14,3548\\n5,67;14,3549\\n5,75;14,3561\\n5,83;14,3582\\n5,92;14,3614\\n6,00;14,3655\\n6,08;14,3706\\n6,17;14,3767\\n6,25;14,3837\\n6,33;14,3917\\n6,42;14,4006\\n6,50;14,4103\\n6,58;14,4210\\n6,67;14,4326\\n6,75;14,4451\\n6,83;14,4584\\n6,92;14,4726\\n7,00;14,4876\\n7,08;14,5035\\n7,17;14,5202\\n7,25;14,5377\\n7,33;14,5560\\n7,42;14,5751\\n7,50;14,5950\\n7,58;14,6157\\n7,67;14,6371\\n7,75;14,6592\\n7,83;14,6821\\n7,92;14,7057\\n8,00;14,7301\\n8,08;14,7551\\n8,17;14,7808\\n8,25;14,8072\\n8,33;14,8343\\n8,42;14,8620\\n8,50;14,8904\\n8,58;14,9195\\n8,67;14,9491\\n8,75;14,9794\\n8,83;15,0103\\n8,92;15,0417\\n9,00;15,0738\\n9,08;15,1064\\n9,17;15,1396\\n9,25;15,1733\\n9,33;15,2076\\n9,42;15,2424\\n9,50;15,2777\\n9,58;15,3136\\n9,67;15,3499\\n9,75;15,3867\\n9,83;15,4240\\n9,92;15,4617\\n10,00;15,4999\\n10,08;15,5386\\n10,17;15,5776\\n10,25;15,6171\\n10,33;15,6570\\n10,42;15,6972\\n10,50;15,7379\\n10,58;15,7789\\n10,67;15,8203\\n10,75;15,8620\\n10,83;15,9041\\n10,92;15,9465\\n11,00;15,9892\\n11,08;16,0322\\n11,17;16,0755\\n11,25;16,1191\\n11,33;16,1629\\n11,42;16,2070\\n11,50;16,2513\\n11,58;16,2959\\n11,67;16,3407\\n11,75;16,3857\\n11,83;16,4309\\n11,92;16,4762\\n12,00;16,5218\\n12,08;16,5675\\n12,17;16,6134\\n12,25;16,6593\\n12,33;16,7055\\n12,42;16,7517\\n12,50;16,7980\\n12,58;16,8444\\n12,67;16,8909\\n12,75;16,9375\\n12,83;16,9841\\n12,92;17,0307\\n13,00;17,0774\\n13,08;17,1241\\n13,17;17,1708\\n13,25;17,2174\\n13,33;17,2641\\n13,42;17,3107\\n13,50;17,3573\\n13,58;17,4038\\n13,67;17,4503\\n13,75;17,4966\\n13,83;17,5429\\n13,92;17,5891\\n14,00;17,6351\\n14,08;17,6810\\n14,17;17,7268\\n14,25;17,7724\\n14,33;17,8178\\n14,42;17,8630\\n14,50;17,9081\\n14,58;17,9529\\n14,67;17,9976\\n14,75;18,0420\\n14,83;18,0861\\n14,92;18,1300\\n15,00;18,1736\\n15,08;18,2169\\n15,17;18,2600\\n15,25;18,3027\\n15,33;18,3451\\n15,42;18,3872\\n15,50;18,4289\\n15,58;18,4703\\n15,67;18,5112\\n15,75;18,5518\\n15,83;18,5920\\n15,92;18,6318\\n16,00;18,6712\\n16,08;18,7101\\n16,17;18,7486\\n16,25;18,7866\\n16,33;18,8242\\n16,42;18,8612\\n16,50;18,8978\\n16,58;18,9338\\n16,67;18,9694\\n16,75;19,0043\\n16,83;19,0387\\n16,92;19,0726\\n17,00;19,1059\\n17,08;19,1385\\n17,17;19,1706\\n17,25;19,2020\\n17,33;19,2328\\n17,42;19,2630\\n17,50;19,2925\\n17,58;19,3213\\n17,67;19,3495\\n17,75;19,3769\\n17,83;19,4037\\n17,92;19,4297\\n18,00;19,4549\\n18,08;19,4794\\n18,17;19,5031\\n18,25;19,5261\\n18,33;19,5482\\n18,42;19,5696\\n18,50;19,5901\\n18,58;19,6097\\n18,67;19,6286\\n18,75;19,6465\\n18,83;19,6636\\n18,92;19,6797\\n19,00;19,6950\\n19,08;19,7093\\n19,17;19,7227\\n19,25;19,7352\\n19,33;19,7466\\n19,42;19,7571\\n19,50;19,7666\\n19,58;19,7750\\n19,67;19,7825\\n19,75;19,7889\\n19,83;19,7942\\n19,92;19,7985\\n\\n\#\\n2,00;16,3880\\n2,08;16,3190\\n2,17;16,2521\\n2,25;16,1873\\n2,33;16,1248\\n2,42;16,0643\\n2,50;16,0059\\n2,58;15,9497\\n2,67;15,8955\\n2,75;15,8434\\n2,83;15,7933\\n2,92;15,7453\\n3,00;15,6992\\n3,08;15,6552\\n3,17;15,6132\\n3,25;15,5732\\n3,33;15,5351\\n3,42;15,4989\\n3,50;15,4647\\n3,58;15,4324\\n3,67;15,4019\\n3,75;15,3734\\n3,83;15,3466\\n3,92;15,3217\\n4,00;15,2985\\n4,08;15,2772\\n4,17;15,2576\\n4,25;15,2397\\n4,33;15,2235\\n4,42;15,2089\\n4,50;15,1961\\n4,58;15,1848\\n4,67;15,1751\\n4,75;15,1670\\n4,83;15,1605\\n4,92;15,1554\\n5,00;15,1519\\n5,08;15,1498\\n5,17;15,1492\\n5,25;15,1499\\n5,33;15,1521\\n5,42;15,1557\\n5,50;15,1606\\n5,58;15,1668\\n5,67;15,1743\\n5,75;15,1831\\n5,83;15,1931\\n5,92;15,2044\\n6,00;15,2169\\n6,08;15,2306\\n6,17;15,2454\\n6,25;15,2614\\n6,33;15,2785\\n6,42;15,2968\\n6,50;15,3161\\n6,58;15,3364\\n6,67;15,3579\\n6,75;15,3803\\n6,83;15,4037\\n6,92;15,4282\\n7,00;15,4536\\n7,08;15,4799\\n7,17;15,5072\\n7,25;15,5354\\n7,33;15,5644\\n7,42;15,5944\\n7,50;15,6252\\n7,58;15,6568\\n7,67;15,6893\\n7,75;15,7226\\n7,83;15,7566\\n7,92;15,7914\\n8,00;15,8270\\n8,08;15,8633\\n8,17;15,9003\\n8,25;15,9380\\n8,33;15,9764\\n8,42;16,0155\\n8,50;16,0552\\n8,58;16,0955\\n8,67;16,1365\\n8,75;16,1780\\n8,83;16,2201\\n8,92;16,2628\\n9,00;16,3061\\n9,08;16,3499\\n9,17;16,3942\\n9,25;16,4390\\n9,33;16,4843\\n9,42;16,5300\\n9,50;16,5763\\n9,58;16,6229\\n9,67;16,6700\\n9,75;16,7175\\n9,83;16,7654\\n9,92;16,8137\\n10,00;16,8623\\n10,08;16,9113\\n10,17;16,9606\\n10,25;17,0103\\n10,33;17,0602\\n10,42;17,1105\\n10,50;17,1610\\n10,58;17,2117\\n10,67;17,2628\\n10,75;17,3140\\n10,83;17,3655\\n10,92;17,4172\\n11,00;17,4691\\n11,08;17,5211\\n11,17;17,5733\\n11,25;17,6257\\n11,33;17,6782\\n11,42;17,7308\\n11,50;17,7836\\n11,58;17,8364\\n11,67;17,8893\\n11,75;17,9423\\n11,83;17,9953\\n11,92;18,0484\\n12,00;18,1015\\n12,08;18,1546\\n12,17;18,2077\\n12,25;18,2609\\n12,33;18,3139\\n12,42;18,3670\\n12,50;18,4200\\n12,58;18,4730\\n12,67;18,5259\\n12,75;18,5787\\n12,83;18,6314\\n12,92;18,6840\\n13,00;18,7364\\n13,08;18,7888\\n13,17;18,8410\\n13,25;18,8930\\n13,33;18,9449\\n13,42;18,9966\\n13,50;19,0481\\n13,58;19,0994\\n13,67;19,1505\\n13,75;19,2014\\n13,83;19,2520\\n13,92;19,3024\\n14,00;19,3526\\n14,08;19,4024\\n14,17;19,4520\\n14,25;19,5014\\n14,33;19,5504\\n14,42;19,5991\\n14,50;19,6475\\n14,58;19,6955\\n14,67;19,7432\\n14,75;19,7906\\n14,83;19,8376\\n14,92;19,8843\\n15,00;19,9306\\n15,08;19,9765\\n15,17;20,0220\\n15,25;20,0670\\n15,33;20,1117\\n15,42;20,1560\\n15,50;20,1998\\n15,58;20,2432\\n15,67;20,2861\\n15,75;20,3286\\n15,83;20,3706\\n15,92;20,4122\\n16,00;20,4533\\n16,08;20,4938\\n16,17;20,5339\\n16,25;20,5735\\n16,33;20,6126\\n16,42;20,6511\\n16,50;20,6891\\n16,58;20,7266\\n16,67;20,7636\\n16,75;20,7999\\n16,83;20,8358\\n16,92;20,8711\\n17,00;20,9058\\n17,08;20,9399\\n17,17;20,9734\\n17,25;21,0064\\n17,33;21,0387\\n17,42;21,0705\\n17,50;21,1016\\n17,58;21,1322\\n17,67;21,1621\\n17,75;21,1913\\n17,83;21,2200\\n17,92;21,2480\\n18,00;21,2753\\n18,08;21,3020\\n18,17;21,3281\\n18,25;21,3534\\n18,33;21,3781\\n18,42;21,4021\\n18,50;21,4255\\n18,58;21,4481\\n18,67;21,4701\\n18,75;21,4913\\n18,83;21,5119\\n18,92;21,5317\\n19,00;21,5508\\n19,08;21,5692\\n19,17;21,5869\\n19,25;21,6038\\n19,33;21,6200\\n19,42;21,6354\\n19,50;21,6501\\n19,58;21,6640\\n19,67;21,6771\\n19,75;21,6895\\n19,83;21,7011\\n19,92;21,7119\\n\\n\#\\n2,00;17,3858\\n2,08;17,3048\\n2,17;17,2269\\n2,25;17,1520\\n2,33;17,0801\\n2,42;17,0111\\n2,50;16,9450\\n2,58;16,8817\\n2,67;16,8212\\n2,75;16,7636\\n2,83;16,7086\\n2,92;16,6564\\n3,00;16,6069\\n3,08;16,5600\\n3,17;16,5157\\n3,25;16,4740\\n3,33;16,4349\\n3,42;16,3982\\n3,50;16,3641\\n3,58;16,3324\\n3,67;16,3032\\n3,75;16,2764\\n3,83;16,2519\\n3,92;16,2297\\n4,00;16,2099\\n4,08;16,1923\\n4,17;16,1769\\n4,25;16,1638\\n4,33;16,1528\\n4,42;16,1439\\n4,50;16,1371\\n4,58;16,1324\\n4,67;16,1297\\n4,75;16,1290\\n4,83;16,1302\\n4,92;16,1334\\n5,00;16,1384\\n5,08;16,1453\\n5,17;16,1540\\n5,25;16,1645\\n5,33;16,1767\\n5,42;16,1906\\n5,50;16,2061\\n5,58;16,2233\\n5,67;16,2421\\n5,75;16,2625\\n5,83;16,2844\\n5,92;16,3078\\n6,00;16,3327\\n6,08;16,3591\\n6,17;16,3868\\n6,25;16,4159\\n6,33;16,4463\\n6,42;16,4781\\n6,50;16,5111\\n6,58;16,5454\\n6,67;16,5809\\n6,75;16,6176\\n6,83;16,6555\\n6,92;16,6945\\n7,00;16,7346\\n7,08;16,7758\\n7,17;16,8180\\n7,25;16,8613\\n7,33;16,9055\\n7,42;16,9507\\n7,50;16,9969\\n7,58;17,0440\\n7,67;17,0919\\n7,75;17,1407\\n7,83;17,1904\\n7,92;17,2408\\n8,00;17,2921\\n8,08;17,3441\\n8,17;17,3968\\n8,25;17,4502\\n8,33;17,5043\\n8,42;17,5591\\n8,50;17,6145\\n8,58;17,6706\\n8,67;17,7272\\n8,75;17,7844\\n8,83;17,8421\\n8,92;17,9004\\n9,00;17,9591\\n9,08;18,0183\\n9,17;18,0780\\n9,25;18,1381\\n9,33;18,1987\\n9,42;18,2596\\n9,50;18,3209\\n9,58;18,3825\\n9,67;18,4445\\n9,75;18,5067\\n9,83;18,5693\\n9,92;18,6321\\n10,00;18,6952\\n10,08;18,7585\\n10,17;18,8220\\n10,25;18,8857\\n10,33;18,9496\\n10,42;19,0136\\n10,50;19,0778\\n10,58;19,1421\\n10,67;19,2064\\n10,75;19,2709\\n10,83;19,3354\\n10,92;19,4000\\n11,00;19,4646\\n11,08;19,5292\\n11,17;19,5939\\n11,25;19,6585\\n11,33;19,7230\\n11,42;19,7875\\n11,50;19,8520\\n11,58;19,9164\\n11,67;19,9806\\n11,75;20,0448\\n11,83;20,1088\\n11,92;20,1727\\n12,00;20,2365\\n12,08;20,3001\\n12,17;20,3635\\n12,25;20,4267\\n12,33;20,4897\\n12,42;20,5524\\n12,50;20,6150\\n12,58;20,6773\\n12,67;20,7393\\n12,75;20,8011\\n12,83;20,8626\\n12,92;20,9238\\n13,00;20,9847\\n13,08;21,0453\\n13,17;21,1056\\n13,25;21,1655\\n13,33;21,2251\\n13,42;21,2843\\n13,50;21,3432\\n13,58;21,4017\\n13,67;21,4598\\n13,75;21,5175\\n13,83;21,5748\\n13,92;21,6317\\n14,00;21,6882\\n14,08;21,7443\\n14,17;21,7999\\n14,25;21,8551\\n14,33;21,9098\\n14,42;21,9641\\n14,50;22,0179\\n14,58;22,0713\\n14,67;22,1242\\n14,75;22,1766\\n14,83;22,2285\\n14,92;22,2800\\n15,00;22,3309\\n15,08;22,3813\\n15,17;22,4313\\n15,25;22,4807\\n15,33;22,5296\\n15,42;22,5780\\n15,50;22,6259\\n15,58;22,6733\\n15,67;22,7201\\n15,75;22,7664\\n15,83;22,8122\\n15,92;22,8575\\n16,00;22,9022\\n16,08;22,9464\\n16,17;22,9900\\n16,25;23,0331\\n16,33;23,0757\\n16,42;23,1177\\n16,50;23,1592\\n16,58;23,2002\\n16,67;23,2406\\n16,75;23,2805\\n16,83;23,3199\\n16,92;23,3587\\n17,00;23,3970\\n17,08;23,4347\\n17,17;23,4719\\n17,25;23,5086\\n17,33;23,5448\\n17,42;23,5804\\n17,50;23,6156\\n17,58;23,6502\\n17,67;23,6843\\n17,75;23,7179\\n17,83;23,7510\\n17,92;23,7836\\n18,00;23,8156\\n18,08;23,8472\\n18,17;23,8783\\n18,25;23,9090\\n18,33;23,9391\\n18,42;23,9688\\n18,50;23,9980\\n18,58;24,0268\\n18,67;24,0550\\n18,75;24,0829\\n18,83;24,1103\\n18,92;24,1372\\n19,00;24,1638\\n19,08;24,1899\\n19,17;24,2156\\n19,25;24,2408\\n19,33;24,2657\\n19,42;24,2902\\n19,50;24,3143\\n19,58;24,3380\\n19,67;24,3613\\n19,75;24,3843\\n19,83;24,4069\\n19,92;24,4291\\n\\n\#\\n2,00;17,9737\\n2,08;17,8875\\n2,17;17,8049\\n2,25;17,7259\\n2,33;17,6504\\n2,42;17,5783\\n2,50;17,5096\\n2,58;17,4443\\n2,67;17,3824\\n2,75;17,3236\\n2,83;17,2680\\n2,92;17,2156\\n3,00;17,1663\\n3,08;17,1201\\n3,17;17,0769\\n3,25;17,0366\\n3,33;16,9992\\n3,42;16,9648\\n3,50;16,9331\\n3,58;16,9043\\n3,67;16,8782\\n3,75;16,8548\\n3,83;16,8341\\n3,92;16,8161\\n4,00;16,8006\\n4,08;16,7876\\n4,17;16,7772\\n4,25;16,7693\\n4,33;16,7637\\n4,42;16,7606\\n4,50;16,7598\\n4,58;16,7613\\n4,67;16,7651\\n4,75;16,7711\\n4,83;16,7793\\n4,92;16,7896\\n5,00;16,8020\\n5,08;16,8164\\n5,17;16,8329\\n5,25;16,8514\\n5,33;16,8718\\n5,42;16,8941\\n5,50;16,9182\\n5,58;16,9441\\n5,67;16,9719\\n5,75;17,0013\\n5,83;17,0325\\n5,92;17,0653\\n6,00;17,0997\\n6,08;17,1358\\n6,17;17,1733\\n6,25;17,2124\\n6,33;17,2529\\n6,42;17,2949\\n6,50;17,3382\\n6,58;17,3829\\n6,67;17,4289\\n6,75;17,4763\\n6,83;17,5248\\n6,92;17,5746\\n7,00;17,6256\\n7,08;17,6777\\n7,17;17,7309\\n7,25;17,7852\\n7,33;17,8406\\n7,42;17,8969\\n7,50;17,9543\\n7,58;18,0126\\n7,67;18,0718\\n7,75;18,1319\\n7,83;18,1928\\n7,92;18,2546\\n8,00;18,3172\\n8,08;18,3805\\n8,17;18,4446\\n8,25;18,5094\\n8,33;18,5748\\n8,42;18,6409\\n8,50;18,7076\\n8,58;18,7749\\n8,67;18,8428\\n8,75;18,9112\\n8,83;18,9801\\n8,92;19,0495\\n9,00;19,1194\\n9,08;19,1897\\n9,17;19,2603\\n9,25;19,3314\\n9,33;19,4028\\n9,42;19,4746\\n9,50;19,5466\\n9,58;19,6190\\n9,67;19,6915\\n9,75;19,7644\\n9,83;19,8374\\n9,92;19,9106\\n10,00;19,9840\\n10,08;20,0575\\n10,17;20,1312\\n10,25;20,2049\\n10,33;20,2788\\n10,42;20,3526\\n10,50;20,4266\\n10,58;20,5005\\n10,67;20,5745\\n10,75;20,6484\\n10,83;20,7223\\n10,92;20,7961\\n11,00;20,8698\\n11,08;20,9435\\n11,17;21,0170\\n11,25;21,0904\\n11,33;21,1637\\n11,42;21,2368\\n11,50;21,3097\\n11,58;21,3825\\n11,67;21,4550\\n11,75;21,5273\\n11,83;21,5993\\n11,92;21,6711\\n12,00;21,7426\\n12,08;21,8139\\n12,17;21,8848\\n12,25;21,9554\\n12,33;22,0257\\n12,42;22,0957\\n12,50;22,1653\\n12,58;22,2346\\n12,67;22,3035\\n12,75;22,3720\\n12,83;22,4401\\n12,92;22,5078\\n13,00;22,5751\\n13,08;22,6419\\n13,17;22,7084\\n13,25;22,7743\\n13,33;22,8399\\n13,42;22,9049\\n13,50;22,9695\\n13,58;23,0337\\n13,67;23,0973\\n13,75;23,1605\\n13,83;23,2231\\n13,92;23,2853\\n14,00;23,3469\\n14,08;23,4080\\n14,17;23,4686\\n14,25;23,5287\\n14,33;23,5882\\n14,42;23,6472\\n14,50;23,7057\\n14,58;23,7636\\n14,67;23,8210\\n14,75;23,8778\\n14,83;23,9341\\n14,92;23,9899\\n15,00;24,0450\\n15,08;24,0996\\n15,17;24,1537\\n15,25;24,2072\\n15,33;24,2602\\n15,42;24,3125\\n15,50;24,3644\\n15,58;24,4156\\n15,67;24,4664\\n15,75;24,5165\\n15,83;24,5661\\n15,92;24,6152\\n16,00;24,6637\\n16,08;24,7117\\n16,17;24,7591\\n16,25;24,8060\\n16,33;24,8524\\n16,42;24,8982\\n16,50;24,9436\\n16,58;24,9884\\n16,67;25,0326\\n16,75;25,0764\\n16,83;25,1197\\n16,92;25,1625\\n17,00;25,2048\\n17,08;25,2467\\n17,17;25,2880\\n17,25;25,3289\\n17,33;25,3694\\n17,42;25,4094\\n17,50;25,4490\\n17,58;25,4881\\n17,67;25,5268\\n17,75;25,5652\\n17,83;25,6031\\n17,92;25,6407\\n18,00;25,6779\\n18,08;25,7147\\n18,17;25,7512\\n18,25;25,7873\\n18,33;25,8232\\n18,42;25,8587\\n18,50;25,8939\\n18,58;25,9289\\n18,67;25,9636\\n18,75;25,9980\\n18,83;26,0322\\n18,92;26,0662\\n19,00;26,0999\\n19,08;26,1335\\n19,17;26,1669\\n19,25;26,2002\\n19,33;26,2333\\n19,42;26,2662\\n19,50;26,2991\\n19,58;26,3319\\n19,67;26,3646\\n19,75;26,3972\\n19,83;26,4298\\n19,92;26,4624\\n\\n\#\\n2,00;18,3953\\n2,08;18,3061\\n2,17;18,2210\\n2,25;18,1400\\n2,33;18,0629\\n2,42;17,9896\\n2,50;17,9202\\n2,58;17,8545\\n2,67;17,7925\\n2,75;17,7342\\n2,83;17,6794\\n2,92;17,6281\\n3,00;17,5802\\n3,08;17,5357\\n3,17;17,4946\\n3,25;17,4567\\n3,33;17,4220\\n3,42;17,3905\\n3,50;17,3621\\n3,58;17,3368\\n3,67;17,3144\\n3,75;17,2950\\n3,83;17,2786\\n3,92;17,2650\\n4,00;17,2542\\n4,08;17,2461\\n4,17;17,2408\\n4,25;17,2382\\n4,33;17,2381\\n4,42;17,2407\\n4,50;17,2457\\n4,58;17,2533\\n4,67;17,2632\\n4,75;17,2756\\n4,83;17,2903\\n4,92;17,3073\\n5,00;17,3266\\n5,08;17,3480\\n5,17;17,3717\\n5,25;17,3974\\n5,33;17,4252\\n5,42;17,4550\\n5,50;17,4868\\n5,58;17,5206\\n5,67;17,5562\\n5,75;17,5937\\n5,83;17,6330\\n5,92;17,6740\\n6,00;17,7168\\n6,08;17,7612\\n6,17;17,8073\\n6,25;17,8550\\n6,33;17,9042\\n6,42;17,9549\\n6,50;18,0071\\n6,58;18,0607\\n6,67;18,1157\\n6,75;18,1720\\n6,83;18,2297\\n6,92;18,2886\\n7,00;18,3487\\n7,08;18,4101\\n7,17;18,4726\\n7,25;18,5361\\n7,33;18,6008\\n7,42;18,6665\\n7,50;18,7333\\n7,58;18,8009\\n7,67;18,8695\\n7,75;18,9391\\n7,83;19,0094\\n7,92;19,0806\\n8,00;19,1526\\n8,08;19,2254\\n8,17;19,2988\\n8,25;19,3730\\n8,33;19,4478\\n8,42;19,5233\\n8,50;19,5993\\n8,58;19,6760\\n8,67;19,7531\\n8,75;19,8308\\n8,83;19,9089\\n8,92;19,9875\\n9,00;20,0665\\n9,08;20,1458\\n9,17;20,2256\\n9,25;20,3056\\n9,33;20,3860\\n9,42;20,4667\\n9,50;20,5475\\n9,58;20,6287\\n9,67;20,7100\\n9,75;20,7915\\n9,83;20,8731\\n9,92;20,9548\\n10,00;21,0367\\n10,08;21,1186\\n10,17;21,2006\\n10,25;21,2826\\n10,33;21,3646\\n10,42;21,4466\\n10,50;21,5285\\n10,58;21,6104\\n10,67;21,6922\\n10,75;21,7740\\n10,83;21,8555\\n10,92;21,9370\\n11,00;22,0183\\n11,08;22,0994\\n11,17;22,1803\\n11,25;22,2610\\n11,33;22,3415\\n11,42;22,4217\\n11,50;22,5017\\n11,58;22,5813\\n11,67;22,6607\\n11,75;22,7398\\n11,83;22,8185\\n11,92;22,8969\\n12,00;22,9749\\n12,08;23,0526\\n12,17;23,1299\\n12,25;23,2068\\n12,33;23,2832\\n12,42;23,3593\\n12,50;23,4349\\n12,58;23,5101\\n12,67;23,5848\\n12,75;23,6591\\n12,83;23,7328\\n12,92;23,8061\\n13,00;23,8790\\n13,08;23,9513\\n13,17;24,0231\\n13,25;24,0943\\n13,33;24,1651\\n13,42;24,2353\\n13,50;24,3050\\n13,58;24,3741\\n13,67;24,4427\\n13,75;24,5107\\n13,83;24,5782\\n13,92;24,6451\\n14,00;24,7114\\n14,08;24,7772\\n14,17;24,8423\\n14,25;24,9069\\n14,33;24,9710\\n14,42;25,0344\\n14,50;25,0972\\n14,58;25,1595\\n14,67;25,2212\\n14,75;25,2823\\n14,83;25,3428\\n14,92;25,4027\\n15,00;25,4620\\n15,08;25,5208\\n15,17;25,5790\\n15,25;25,6366\\n15,33;25,6936\\n15,42;25,7500\\n15,50;25,8059\\n15,58;25,8612\\n15,67;25,9159\\n15,75;25,9701\\n15,83;26,0238\\n15,92;26,0769\\n16,00;26,1295\\n16,08;26,1815\\n16,17;26,2330\\n16,25;26,2840\\n16,33;26,3345\\n16,42;26,3845\\n16,50;26,4340\\n16,58;26,4830\\n16,67;26,5315\\n16,75;26,5796\\n16,83;26,6273\\n16,92;26,6745\\n17,00;26,7212\\n17,08;26,7676\\n17,17;26,8136\\n17,25;26,8592\\n17,33;26,9044\\n17,42;26,9492\\n17,50;26,9937\\n17,58;27,0379\\n17,67;27,0817\\n17,75;27,1253\\n17,83;27,1686\\n17,92;27,2116\\n18,00;27,2543\\n18,08;27,2969\\n18,17;27,3392\\n18,25;27,3813\\n18,33;27,4233\\n18,42;27,4651\\n18,50;27,5067\\n18,58;27,5483\\n18,67;27,5897\\n18,75;27,6311\\n18,83;27,6724\\n18,92;27,7137\\n19,00;27,7550\\n19,08;27,7963\\n19,17;27,8377\\n19,25;27,8791\\n19,33;27,9206\\n19,42;27,9622\\n19,50;28,0040\\n19,58;28,0459\\n19,67;28,0880\\n19,75;28,1303\\n19,83;28,1729\\n19,92;28,2157\\n\\n\#\\n2,00;19,0582\\n2,08;18,9659\\n2,17;18,8785\\n2,25;18,7959\\n2,33;18,7180\\n2,42;18,6447\\n2,50;18,5760\\n2,58;18,5117\\n2,67;18,4519\\n2,75;18,3963\\n2,83;18,3450\\n2,92;18,2978\\n3,00;18,2548\\n3,08;18,2157\\n3,17;18,1805\\n3,25;18,1492\\n3,33;18,1217\\n3,42;18,0978\\n3,50;18,0776\\n3,58;18,0609\\n3,67;18,0478\\n3,75;18,0380\\n3,83;18,0316\\n3,92;18,0284\\n4,00;18,0285\\n4,08;18,0317\\n4,17;18,0380\\n4,25;18,0474\\n4,33;18,0597\\n4,42;18,0749\\n4,50;18,0929\\n4,58;18,1137\\n4,67;18,1372\\n4,75;18,1634\\n4,83;18,1922\\n4,92;18,2235\\n5,00;18,2574\\n5,08;18,2936\\n5,17;18,3323\\n5,25;18,3733\\n5,33;18,4165\\n5,42;18,4620\\n5,50;18,5096\\n5,58;18,5593\\n5,67;18,6111\\n5,75;18,6649\\n5,83;18,7206\\n5,92;18,7783\\n6,00;18,8378\\n6,08;18,8991\\n6,17;18,9621\\n6,25;19,0269\\n6,33;19,0932\\n6,42;19,1612\\n6,50;19,2308\\n6,58;19,3018\\n6,67;19,3743\\n6,75;19,4482\\n6,83;19,5235\\n6,92;19,6001\\n7,00;19,6779\\n7,08;19,7570\\n7,17;19,8373\\n7,25;19,9187\\n7,33;20,0012\\n7,42;20,0847\\n7,50;20,1692\\n7,58;20,2547\\n7,67;20,3412\\n7,75;20,4285\\n7,83;20,5166\\n7,92;20,6055\\n8,00;20,6953\\n8,08;20,7857\\n8,17;20,8768\\n8,25;20,9685\\n8,33;21,0609\\n8,42;21,1538\\n8,50;21,2473\\n8,58;21,3412\\n8,67;21,4356\\n8,75;21,5305\\n8,83;21,6257\\n8,92;21,7213\\n9,00;21,8173\\n9,08;21,9135\\n9,17;22,0100\\n9,25;22,1067\\n9,33;22,2036\\n9,42;22,3007\\n9,50;22,3979\\n9,58;22,4952\\n9,67;22,5926\\n9,75;22,6901\\n9,83;22,7876\\n9,92;22,8851\\n10,00;22,9826\\n10,08;23,0800\\n10,17;23,1773\\n10,25;23,2746\\n10,33;23,3717\\n10,42;23,4687\\n10,50;23,5655\\n10,58;23,6621\\n10,67;23,7584\\n10,75;23,8546\\n10,83;23,9505\\n10,92;24,0461\\n11,00;24,1414\\n11,08;24,2364\\n11,17;24,3311\\n11,25;24,4254\\n11,33;24,5193\\n11,42;24,6129\\n11,50;24,7060\\n11,58;24,7988\\n11,67;24,8911\\n11,75;24,9829\\n11,83;25,0743\\n11,92;25,1652\\n12,00;25,2556\\n12,08;25,3456\\n12,17;25,4350\\n12,25;25,5239\\n12,33;25,6122\\n12,42;25,7000\\n12,50;25,7873\\n12,58;25,8740\\n12,67;25,9601\\n12,75;26,0457\\n12,83;26,1307\\n12,92;26,2150\\n13,00;26,2988\\n13,08;26,3820\\n13,17;26,4645\\n13,25;26,5465\\n13,33;26,6278\\n13,42;26,7085\\n13,50;26,7886\\n13,58;26,8681\\n13,67;26,9469\\n13,75;27,0251\\n13,83;27,1027\\n13,92;27,1797\\n14,00;27,2560\\n14,08;27,3317\\n14,17;27,4067\\n14,25;27,4812\\n14,33;27,5550\\n14,42;27,6282\\n14,50;27,7008\\n14,58;27,7728\\n14,67;27,8441\\n14,75;27,9149\\n14,83;27,9851\\n14,92;28,0547\\n15,00;28,1237\\n15,08;28,1921\\n15,17;28,2600\\n15,25;28,3273\\n15,33;28,3941\\n15,42;28,4603\\n15,50;28,5260\\n15,58;28,5912\\n15,67;28,6559\\n15,75;28,7201\\n15,83;28,7838\\n15,92;28,8470\\n16,00;28,9098\\n16,08;28,9722\\n16,17;29,0341\\n16,25;29,0956\\n16,33;29,1567\\n16,42;29,2174\\n16,50;29,2778\\n16,58;29,3378\\n16,67;29,3975\\n16,75;29,4569\\n16,83;29,5161\\n16,92;29,5749\\n17,00;29,6335\\n17,08;29,6919\\n17,17;29,7500\\n17,25;29,8080\\n17,33;29,8658\\n17,42;29,9235\\n17,50;29,9811\\n17,58;30,0386\\n17,67;30,0960\\n17,75;30,1534\\n17,83;30,2107\\n17,92;30,2681\\n18,00;30,3255\\n18,08;30,3830\\n18,17;30,4406\\n18,25;30,4984\\n18,33;30,5562\\n18,42;30,6143\\n18,50;30,6726\\n18,58;30,7311\\n18,67;30,7900\\n18,75;30,8491\\n18,83;30,9086\\n18,92;30,9685\\n19,00;31,0288\\n19,08;31,0896\\n19,17;31,1508\\n19,25;31,2126\\n19,33;31,2750\\n19,42;31,3379\\n19,50;31,4015\\n19,58;31,4658\\n19,67;31,5309\\n19,75;31,5966\\n19,83;31,6632\\n19,92;31,7307\\n\\n\#\\n2,00;19,5153\\n2,08;19,4220\\n2,17;19,3341\\n2,25;19,2516\\n2,33;19,1745\\n2,42;19,1026\\n2,50;19,0358\\n2,58;18,9741\\n2,67;18,9173\\n2,75;18,8655\\n2,83;18,8184\\n2,92;18,7761\\n3,00;18,7384\\n3,08;18,7052\\n3,17;18,6765\\n3,25;18,6521\\n3,33;18,6320\\n3,42;18,6161\\n3,50;18,6042\\n3,58;18,5964\\n3,67;18,5925\\n3,75;18,5925\\n3,83;18,5961\\n3,92;18,6035\\n4,00;18,6144\\n4,08;18,6288\\n4,17;18,6467\\n4,25;18,6679\\n4,33;18,6923\\n4,42;18,7199\\n4,50;18,7506\\n4,58;18,7844\\n4,67;18,8211\\n4,75;18,8607\\n4,83;18,9032\\n4,92;18,9483\\n5,00;18,9962\\n5,08;19,0466\\n5,17;19,0996\\n5,25;19,1550\\n5,33;19,2129\\n5,42;19,2731\\n5,50;19,3355\\n5,58;19,4002\\n5,67;19,4670\\n5,75;19,5359\\n5,83;19,6069\\n5,92;19,6798\\n6,00;19,7546\\n6,08;19,8313\\n6,17;19,9098\\n6,25;19,9900\\n6,33;20,0718\\n6,42;20,1553\\n6,50;20,2404\\n6,58;20,3270\\n6,67;20,4150\\n6,75;20,5045\\n6,83;20,5953\\n6,92;20,6874\\n7,00;20,7807\\n7,08;20,8753\\n7,17;20,9710\\n7,25;21,0679\\n7,33;21,1657\\n7,42;21,2646\\n7,50;21,3645\\n7,58;21,4652\\n7,67;21,5669\\n7,75;21,6693\\n7,83;21,7726\\n7,92;21,8766\\n8,00;21,9813\\n8,08;22,0866\\n8,17;22,1925\\n8,25;22,2991\\n8,33;22,4061\\n8,42;22,5137\\n8,50;22,6217\\n8,58;22,7301\\n8,67;22,8389\\n8,75;22,9480\\n8,83;23,0575\\n8,92;23,1672\\n9,00;23,2771\\n9,08;23,3873\\n9,17;23,4976\\n9,25;23,6081\\n9,33;23,7186\\n9,42;23,8293\\n9,50;23,9400\\n9,58;24,0507\\n9,67;24,1613\\n9,75;24,2720\\n9,83;24,3825\\n9,92;24,4930\\n10,00;24,6033\\n10,08;24,7135\\n10,17;24,8235\\n10,25;24,9333\\n10,33;25,0429\\n10,42;25,1522\\n10,50;25,2613\\n10,58;25,3700\\n10,67;25,4785\\n10,75;25,5866\\n10,83;25,6943\\n10,92;25,8017\\n11,00;25,9087\\n11,08;26,0152\\n11,17;26,1214\\n11,25;26,2271\\n11,33;26,3323\\n11,42;26,4371\\n11,50;26,5414\\n11,58;26,6451\\n11,67;26,7484\\n11,75;26,8511\\n11,83;26,9533\\n11,92;27,0549\\n12,00;27,1560\\n12,08;27,2565\\n12,17;27,3564\\n12,25;27,4557\\n12,33;27,5544\\n12,42;27,6525\\n12,50;27,7500\\n12,58;27,8469\\n12,67;27,9431\\n12,75;28,0388\\n12,83;28,1338\\n12,92;28,2281\\n13,00;28,3219\\n13,08;28,4149\\n13,17;28,5074\\n13,25;28,5992\\n13,33;28,6904\\n13,42;28,7809\\n13,50;28,8708\\n13,58;28,9600\\n13,67;29,0486\\n13,75;29,1366\\n13,83;29,2240\\n13,92;29,3107\\n14,00;29,3969\\n14,08;29,4824\\n14,17;29,5673\\n14,25;29,6516\\n14,33;29,7353\\n14,42;29,8185\\n14,50;29,9011\\n14,58;29,9831\\n14,67;30,0646\\n14,75;30,1455\\n14,83;30,2259\\n14,92;30,3058\\n15,00;30,3852\\n15,08;30,4641\\n15,17;30,5426\\n15,25;30,6205\\n15,33;30,6981\\n15,42;30,7752\\n15,50;30,8519\\n15,58;30,9282\\n15,67;31,0042\\n15,75;31,0798\\n15,83;31,1550\\n15,92;31,2300\\n16,00;31,3046\\n16,08;31,3790\\n16,17;31,4531\\n16,25;31,5270\\n16,33;31,6007\\n16,42;31,6743\\n16,50;31,7476\\n16,58;31,8209\\n16,67;31,8940\\n16,75;31,9671\\n16,83;32,0401\\n16,92;32,1130\\n17,00;32,1860\\n17,08;32,2590\\n17,17;32,3321\\n17,25;32,4053\\n17,33;32,4786\\n17,42;32,5520\\n17,50;32,6257\\n17,58;32,6995\\n17,67;32,7736\\n17,75;32,8480\\n17,83;32,9227\\n17,92;32,9978\\n18,00;33,0732\\n18,08;33,1491\\n18,17;33,2255\\n18,25;33,3023\\n18,33;33,3797\\n18,42;33,4577\\n18,50;33,5362\\n18,58;33,6155\\n18,67;33,6954\\n18,75;33,7761\\n18,83;33,8576\\n18,92;33,9398\\n19,00;34,0230\\n19,08;34,1071\\n19,17;34,1921\\n19,25;34,2781\\n19,33;34,3652\\n19,42;34,4534\\n19,50;34,5427\\n19,58;34,6333\\n19,67;34,7250\\n19,75;34,8181\\n19,83;34,9125\\n19,92;35,0083\\n\\n\#\\nnull\\n\#\\n&#xD;
chart.marker.alpha=0.8&#xD;
chart.yAxis.weight=2.0&#xD;
chart.yAxis.tickLabelsVisible=true&#xD;
chart.xAxis.tickLabelsVisible=true&#xD;
chart.xAxis.color=-16751053&#xD;
chart.showLegend=false&#xD;
chart.title.weight=2.0&#xD;
chart.yAxis.size=14.0&#xD;
chart.series.paint=-65536;-52480;-26368;-16711936;-16738048;-16711936;-39424;-52480;-52480;-65485;-65536;-52480;-39424;-16724992;-16738048;-16724992;-26368;-52429;-52480;-65536;-16777216;&#xD;
chart.title.color=-16777216&#xD;
chart.series.sinceWhen=null;null;null;null;null;null;null;null;null;null;null;null;null;null;null;null;null;null;null;null;null;&#xD;
chart.series.names=3rd_b;5th_b;10th_b;25th_b;50th_b;75th_b;85th_b;90th_b;95th_b;97th_b;3rd_g;5th_g;10th_g;25th_g;50th_g;75th_g;85th_g;90th;95th;97th;BMI;&#xD;
chart.plot.outline.color=-13408513&#xD;
chart.marker.range=0.800000011920929&#xD;
chart.xAxis.label=Âge [Année]&#xD;
chart.xAxis.ticksVisible=true&#xD;
chart.xAxis.weight=2.0&#xD;
chart.background.color=-1&#xD;
chart.xAxis.autoRange=true&#xD;
chart.yAxis.color=-16751053&#xD;
chart.plot.background.color=-3355393&#xD;
chart.title.size=20.0&#xD;
chart.series.shape=0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;1;&#xD;
chart.plot.orientation=0&#xD;
chart.marker.color=-8355712&#xD;
chart.visible=false&#xD;
chart.series.limit=0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;&#xD;
chart.antiAlias=true</structure>
    <border>false,0,0,0,255</border>
    <background>false,238,238,238,255</background>
    <fontStyle />
    <fontSize>12</fontSize>
    <fontFamily>Dialog</fontFamily>
    <fontColor>true,0,0,0,255</fontColor>
    <hAlign>default</hAlign>
    <vAlign>default</vAlign>
  </component>
  <component xCoord="3" yCoord="8" xSize="7" ySize="1" key="chart_weight" value="" storeInDB="false" showInHistory="false" historyIndex="0.0" labelPosition="none" labelText="">
    <type>lu.tudor.santec.gecamed.formeditor.gui.component.EditableChart</type>
    <script eventTypeId="13">
      <scriptCode>manipulateChart(event.getSource());</scriptCode>
    </script>
    <structure>#&#xD;
#Fri Mar 16 13:42:05 CET 2012&#xD;
chart.yAxis.label=Weight [kg]&#xD;
chart.xAxis.autoRange=true&#xD;
chart.title.posture=0.2&#xD;
chart.series.referencingComponents=NULL;NULL;NULL;NULL;NULL;NULL;NULL;NULL;NULL;NULL;NULL;NULL;NULL;NULL;NULL;NULL;NULL;NULL;measuringDate-tfWeight;&#xD;
chart.marker.range=0.800000011920929&#xD;
chart.xAxis.ticksVisible=true&#xD;
chart.border.color=-16777216&#xD;
chart.series.staticData=0;2.355450986\\n0,08;2.799548641\\n0,17;3.614688072\\n0,25;4.34234145\\n0,33;4.992897896\\n0,42;5.575169066\\n0,5;6.096775274\\n0,58;6.564430346\\n0,67;6.984123338\\n0,75;7.361236116\\n0,83;7.700624405\\n0,92;8.006677447\\n1;8.283364855\\n1,08;8.534275028\\n1,17;8.762648582\\n1,25;8.971407287\\n1,33;9.163180317\\n1,42;9.340328068\\n1,5;9.504964014\\n1,58;9.658974787\\n1,67;9.804039109\\n1,75;9.941644878\\n1,83;10.07310549\\n1,92;10.19957488\\n2;10.32206165\\n2,08;10.4414422\\n2,17;10.55847309\\n2,25;10.67380261\\n2,33;10.78798157\\n2,42;10.90147346\\n2,5;11.01466395\\n2,58;11.12786972\\n2,67;11.24134752\\n2,75;11.3552982\\n2,83;11.46987889\\n2,92;11.58520959\\n3;11.70137143\\n3,08;11.81842214\\n3,17;11.93639129\\n3,25;12.05529277\\n3,33;12.17512305\\n3,42;12.29587074\\n3,5;12.41751102\\n3,58;12.54001161\\n3,67;12.66334091\\n3,75;12.78746137\\n3,83;12.91233523\\n3,92;13.03792328\\n4;13.16419231\\n4,08;13.29110715\\n4,17;13.41863676\\n4,25;13.54675344\\n4,33;13.67543322\\n4,42;13.8046561\\n4,5;13.93440617\\n4,58;14.06467165\\n4,67;14.19544485\\n4,75;14.3267205\\n4,83;14.45850147\\n4,92;14.59079005\\n5;14.7235931\\n5,08;14.85692044\\n5,17;14.99078448\\n5,25;15.12519986\\n5,33;15.26018306\\n5,42;15.39575201\\n5,5;15.53192567\\n5,58;15.66872366\\n5,67;15.80616582\\n5,75;15.94427185\\n5,83;16.08306098\\n5,92;16.22255158\\n6;16.36275897\\n6,08;16.50370229\\n6,17;16.64539409\\n6,25;16.78784656\\n6,33;16.93106986\\n6,42;17.07507197\\n6,5;17.21985864\\n6,58;17.36543339\\n6,67;17.51179749\\n6,75;17.65894807\\n6,83;17.80688538\\n6,92;17.95560314\\n7;18.10509471\\n7,08;18.25535252\\n7,17;18.4063661\\n7,25;18.55812709\\n7,33;18.71062426\\n7,42;18.86384686\\n7,5;19.01778428\\n7,58;19.17242647\\n7,67;19.32776424\\n7,75;19.48378967\\n7,83;19.64049642\\n7,92;19.79787788\\n8;19.95593574\\n8,08;20.1146687\\n8,17;20.27408001\\n8,25;20.43417606\\n8,33;20.59496663\\n8,42;20.75646502\\n8,5;20.91868832\\n8,58;21.08165758\\n8,67;21.24539741\\n8,75;21.40993987\\n8,83;21.57531575\\n8,92;21.74156399\\n9;21.90872739\\n9,08;22.07685313\\n9,17;22.24599293\\n9,25;22.41620302\\n9,33;22.58754414\\n9,42;22.76008145\\n9,5;22.93388449\\n9,58;23.10902476\\n9,67;23.28558367\\n9,75;23.46364195\\n9,83;23.6432856\\n9,92;23.8246044\\n10;24.00769173\\n10,08;24.19264433\\n10,17;24.37956211\\n10,25;24.5685479\\n10,33;24.75970717\\n10,42;24.95314776\\n10,5;25.14897956\\n10,58;25.3473142\\n10,67;25.54826471\\n10,75;25.75194512\\n10,83;25.95847011\\n10,92;26.16795559\\n11;26.38051177\\n11,08;26.59626062\\n11,17;26.81530934\\n11,25;27.03777112\\n11,33;27.26375553\\n11,42;27.49336962\\n11,5;27.72671746\\n11,58;27.96389959\\n11,67;28.20501252\\n11,75;28.4501482\\n11,83;28.69939347\\n11,92;28.95282957\\n12;29.21053153\\n12,08;29.47256769\\n12,17;29.73899917\\n12,25;30.00987927\\n12,33;30.28525305\\n12,42;30.56515671\\n12,5;30.84961718\\n12,58;31.13865154\\n12,67;31.43226571\\n12,75;31.73045808\\n12,83;32.03321196\\n12,92;32.34050069\\n13;32.6522856\\n13,08;32.96851571\\n13,17;33.28912731\\n13,25;33.61404373\\n13,33;33.94317499\\n13,42;34.27641756\\n13,5;34.61365176\\n13,58;34.95474943\\n13,67;35.29956396\\n13,75;35.64793577\\n13,83;35.99969112\\n13,92;36.354642\\n14;36.71258626\\n14,08;37.07330766\\n14,17;37.43657601\\n14,25;37.80214741\\n14,33;38.16976444\\n14,42;38.53915657\\n14,5;38.91004046\\n14,58;39.28212045\\n14,67;39.65508906\\n14,75;40.02862762\\n14,83;40.40240687\\n14,92;40.77608405\\n15;41.14932239\\n15,08;41.52175462\\n15,17;41.89302144\\n15,25;42.26275389\\n15,33;42.63057829\\n15,42;42.99611758\\n15,5;43.3589927\\n15,58;43.71882106\\n15,67;44.07523324\\n15,75;44.42784452\\n15,83;44.77628678\\n15,92;45.1202019\\n16;45.45922209\\n16,08;45.79300591\\n16,17;46.12121938\\n16,25;46.4435428\\n16,33;46.75967279\\n16,42;47.06932426\\n16,5;47.37223239\\n16,58;47.66815456\\n16,67;47.9568721\\n16,75;48.23819204\\n16,83;48.5119486\\n16,92;48.77800463\\n17;49.03625275\\n17,08;49.28661635\\n17,17;49.52905029\\n17,25;49.76354136\\n17,33;49.99010333\\n17,42;50.2087994\\n17,5;50.41970456\\n17,58;50.62293176\\n17,67;50.81862346\\n17,75;51.00695001\\n17,83;51.18810764\\n17,92;51.36231608\\n18;51.52981582\\n18,08;51.69086489\\n18,17;51.8457352\\n18,25;51.99471665\\n18,33;52.13808124\\n18,42;52.27611902\\n18,5;52.4091082\\n18,58;52.53731392\\n18,67;52.66097508\\n18,75;52.78032448\\n18,83;52.89553346\\n18,92;53.00673755\\n19;53.11401756\\n19,08;53.21738885\\n19,17;53.31678976\\n19,25;53.41206904\\n19,33;53.50297229\\n19,42;53.58912711\\n19,5;53.67002691\\n19,58;53.74501298\\n19,67;53.8132547\\n19,75;53.87372737\\n19,83;53.92518731\\n19,92;53.96613658\\n20;53.99481762\\n\\n\#\\n0;2.52690402\\n0,08;2.964655655\\n0,17;3.774848862\\n0,25;4.503255345\\n0,33;5.157411653\\n0,42;5.744751566\\n0,5;6.272175299\\n0,58;6.745992665\\n0,67;7.171952393\\n0,75;7.555286752\\n0,83;7.90075516\\n0,92;8.212683538\\n1;8.494999555\\n1,08;8.751264252\\n1,17;8.984701111\\n1,25;9.198222429\\n1,33;9.394453831\\n1,42;9.575756968\\n1,5;9.744250626\\n1,58;9.901830339\\n1,67;10.05018686\\n1,75;10.19082308\\n1,83;10.32507004\\n1,92;10.45410181\\n2;10.57894925\\n2,08;10.70051298\\n2,17;10.81957536\\n2,25;10.93681171\\n2,33;11.05280067\\n2,42;11.168034\\n2,5;11.28292555\\n2,58;11.3978197\\n2,67;11.51299966\\n2,75;11.62869248\\n2,83;11.74507892\\n2,92;11.86229971\\n3;11.98045644\\n3,08;12.09962308\\n3,17;12.21984466\\n3,25;12.34114672\\n3,33;12.46353554\\n3,42;12.5870056\\n3,5;12.71153714\\n3,58;12.83710098\\n3,67;12.96366474\\n3,75;13.09118938\\n3,83;13.21963362\\n3,92;13.34895376\\n4;13.47910915\\n4,08;13.61005739\\n4,17;13.74175874\\n4,25;13.87417598\\n4,33;14.0072749\\n4,42;14.14102471\\n4,5;14.27539832\\n4,58;14.41037252\\n4,67;14.54592801\\n4,75;14.68204842\\n4,83;14.81872422\\n4,92;14.95594682\\n5;15.09371211\\n5,08;15.23201937\\n5,17;15.37087094\\n5,25;15.51027205\\n5,33;15.65023042\\n5,42;15.79075599\\n5,5;15.93186059\\n5,58;16.07355758\\n5,67;16.21586154\\n5,75;16.35878793\\n5,83;16.50235277\\n5,92;16.64657235\\n6;16.79146158\\n6,08;16.93703875\\n6,17;17.08331814\\n6,25;17.23031439\\n6,33;17.37804118\\n6,42;17.52651109\\n6,5;17.6757355\\n6,58;17.82572453\\n6,67;17.97648696\\n6,75;18.12802886\\n6,83;18.28035866\\n6,92;18.4334803\\n7;18.58739757\\n7,08;18.74211363\\n7,17;18.89762965\\n7,25;19.05394835\\n7,33;19.21107044\\n7,42;19.36899699\\n7,5;19.52772926\\n7,58;19.68726895\\n7,67;19.84761848\\n7,75;20.00878127\\n7,83;20.17076208\\n7,92;20.33356558\\n8;20.49720276\\n8,08;20.66168259\\n8,17;20.82701772\\n8,25;20.9932234\\n8,33;21.16031766\\n8,42;21.32832161\\n8,5;21.49725951\\n8,58;21.66715902\\n8,67;21.83805093\\n8,75;22.00997207\\n8,83;22.18295884\\n8,92;22.35705429\\n9;22.53230492\\n9,08;22.70876108\\n9,17;22.8864771\\n9,25;23.06551129\\n9,33;23.24592593\\n9,42;23.42778723\\n9,5;23.61116524\\n9,58;23.79613202\\n9,67;23.98276774\\n9,75;24.17115246\\n9,83;24.36137073\\n9,92;24.55351042\\n10;24.74766249\\n10,08;24.94392079\\n10,17;25.14238189\\n10,25;25.34314479\\n10,33;25.54631065\\n10,42;25.75198256\\n10,5;25.96026515\\n10,58;26.17126436\\n10,67;26.38508699\\n10,75;26.60184044\\n10,83;26.82163224\\n10,92;27.0445704\\n11;27.27075818\\n11,08;27.50030694\\n11,17;27.73331628\\n11,25;27.96988937\\n11,33;28.21012567\\n11,42;28.45412164\\n11,5;28.70197022\\n11,58;28.95376036\\n11,67;29.20957645\\n11,75;29.46949781\\n11,83;29.73359819\\n11,92;30.00194519\\n12;30.27459974\\n12,08;30.55161562\\n12,17;30.83303885\\n12,25;31.11890724\\n12,33;31.40924987\\n12,42;31.70408654\\n12,5;32.00342738\\n12,58;32.30727227\\n12,67;32.61560983\\n12,75;32.92841993\\n12,83;33.24566815\\n12,92;33.56730937\\n13;33.8932863\\n13,08;34.22352911\\n13,17;34.5579552\\n13,25;34.8964689\\n13,33;35.23896126\\n13,42;35.58530989\\n13,5;35.9353771\\n13,58;36.28901539\\n13,67;36.64606043\\n13,75;37.00633501\\n13,83;37.36964826\\n13,92;37.73579576\\n14;38.10455963\\n14,08;38.47570882\\n14,17;38.84899932\\n14,25;39.22417451\\n14,33;39.60096552\\n14,42;39.97909172\\n14,5;40.35826115\\n14,58;40.73817116\\n14,67;41.118509\\n14,75;41.49895256\\n14,83;41.8791711\\n14,92;42.25882349\\n15;42.63757221\\n15,08;43.01505816\\n15,17;43.39092788\\n15,25;43.76482163\\n15,33;44.13637714\\n15,42;44.50523096\\n15,5;44.87101979\\n15,58;45.23337973\\n15,67;45.59195858\\n15,75;45.94639581\\n15,83;46.29634576\\n15,92;46.64147321\\n16;46.98143987\\n16,08;47.31593016\\n16,17;47.64463827\\n16,25;47.96727332\\n16,33;48.2835611\\n16,42;48.59324591\\n16,5;48.89609218\\n16,58;49.1918862\\n16,67;49.4804377\\n16,75;49.76158125\\n16,83;50.03517772\\n16,92;50.30111539\\n17;50.55931105\\n17,08;50.8097108\\n17,17;51.05229071\\n17,25;51.28705716\\n17,33;51.51404335\\n17,42;51.73332523\\n17,5;51.94499451\\n17,58;52.14917717\\n17,67;52.34602709\\n17,75;52.53572455\\n17,83;52.71847428\\n17,92;52.89450319\\n18;53.06405769\\n18,08;53.22740059\\n18,17;53.38480749\\n18,25;53.53656883\\n18,33;53.68296205\\n18,42;53.82427723\\n18,5;53.96079321\\n18,58;54.09277512\\n18,67;54.22046291\\n18,75;54.34408388\\n18,83;54.46381004\\n18,92;54.57977424\\n19;54.69205355\\n19,08;54.80065842\\n19,17;54.90552089\\n19,25;55.00648181\\n19,33;55.10327703\\n19,42;55.19552245\\n19,5;55.28269761\\n19,58;55.36412796\\n19,67;55.43896526\\n19,75;55.50616614\\n19,83;55.56446839\\n19,92;55.61235958\\n20;55.64806673\\n\\n\#\\n0;2.773801848\\n0,08;3.209510017\\n0,17;4.020561446\\n0,25;4.754479354\\n0,33;5.416802856\\n0,42;6.01371624\\n0,5;6.551379244\\n0,58;7.035656404\\n0,67;7.472021438\\n0,75;7.865532922\\n0,83;8.220839211\\n0,92;8.542195484\\n1;8.833485623\\n1,08;9.098245709\\n1,17;9.339687673\\n1,25;9.560722369\\n1,33;9.763981751\\n1,42;9.951839998\\n1,5;10.12643352\\n1,58;10.28967982\\n1,67;10.44329524\\n1,75;10.58881155\\n1,83;10.72759156\\n1,92;10.86084353\\n2;10.98963476\\n2,08;11.11490406\\n2,17;11.23747341\\n2,25;11.35805876\\n2,33;11.47727994\\n2,42;11.59566994\\n2,5;11.7136834\\n2,58;11.83170451\\n2,67;11.95005435\\n2,75;12.06899744\\n2,83;12.18874828\\n2,92;12.30947723\\n3;12.43131521\\n3,08;12.55435953\\n3,17;12.67867752\\n3,25;12.80431149\\n3,33;12.93128204\\n3,42;13.05959214\\n3,5;13.18922941\\n3,58;13.32016918\\n3,67;13.45237788\\n3,75;13.5858142\\n3,83;13.72043155\\n3,92;13.85617947\\n4;13.99300607\\n4,08;14.13085804\\n4,17;14.26968247\\n4,25;14.40942768\\n4,33;14.55004391\\n4,42;14.69148397\\n4,5;14.83370375\\n4,58;14.97666256\\n4,67;15.12032345\\n4,75;15.26465308\\n4,83;15.40962296\\n4,92;15.55520788\\n5;15.70138696\\n5,08;15.8481433\\n5,17;15.9954639\\n5,25;16.14333947\\n5,33;16.29176433\\n5,42;16.44073615\\n5,5;16.59025577\\n5,58;16.74032694\\n5,67;16.8909561\\n5,75;17.04215212\\n5,83;17.19392605\\n5,92;17.34629087\\n6;17.49926081\\n6,08;17.65285271\\n6,17;17.80708353\\n6,25;17.96197153\\n6,33;18.11753578\\n6,42;18.2737959\\n6,5;18.43077195\\n6,58;18.58848423\\n6,67;18.74695318\\n6,75;18.90619877\\n6,83;19.06624222\\n6,92;19.22710346\\n7;19.38880264\\n7,08;19.55135989\\n7,17;19.71479476\\n7,25;19.87912757\\n7,33;20.044378\\n7,42;20.21056603\\n7,5;20.37771189\\n7,58;20.54583618\\n7,67;20.71496001\\n7,75;20.88510518\\n7,83;21.05629437\\n7,92;21.22855059\\n8;21.40189997\\n8,08;21.57636833\\n8,17;21.75198362\\n8,25;21.92877558\\n8,33;22.10677591\\n8,42;22.28601843\\n8,5;22.46653924\\n8,58;22.64837687\\n8,67;22.83157226\\n8,75;23.01617007\\n8,83;23.20221593\\n8,92;23.38975956\\n9;23.57885344\\n9,08;23.769553\\n9,17;23.96191672\\n9,25;24.15600612\\n9,33;24.35188577\\n9,42;24.54962324\\n9,5;24.74928911\\n9,58;24.95095592\\n9,67;25.15470129\\n9,75;25.36060368\\n9,83;25.56874466\\n9,92;25.77920825\\n10;25.99208072\\n10,08;26.20745042\\n10,17;26.42540754\\n10,25;26.64604388\\n10,33;26.86945259\\n10,42;27.09572788\\n10,5;27.32496472\\n10,58;27.55725852\\n10,67;27.79270478\\n10,75;28.03139872\\n10,83;28.27343489\\n10,92;28.51890714\\n11;28.76790586\\n11,08;29.02052392\\n11,17;29.27684696\\n11,25;29.53696045\\n11,33;29.80094595\\n11,42;30.06888124\\n11,5;30.34083979\\n11,58;30.61689027\\n11,67;30.89709604\\n11,75;31.18151463\\n11,83;31.47019723\\n11,92;31.76318818\\n12;32.06052445\\n12,08;32.36223514\\n12,17;32.66834099\\n12,25;32.97885387\\n12,33;33.29377635\\n12,42;33.61310119\\n12,5;33.93681092\\n12,58;34.26487746\\n12,67;34.59726137\\n12,75;34.9339128\\n12,83;35.27476898\\n12,92;35.61975555\\n13;35.96878581\\n13,08;36.32176053\\n13,17;36.67856768\\n13,25;37.03908232\\n13,33;37.40316649\\n13,42;37.7706691\\n13,5;38.14142532\\n13,58;38.51525867\\n13,67;38.89197851\\n13,75;39.27138168\\n13,83;39.65325233\\n13,92;40.03736224\\n14;40.42347105\\n14,08;40.81132672\\n14,17;41.20066588\\n14,25;41.5912144\\n14,33;41.98268787\\n14,42;42.37479226\\n14,5;42.76722456\\n14,58;43.15967355\\n14,67;43.55182054\\n14,75;43.94334028\\n14,83;44.33390178\\n14,92;44.72316843\\n15;45.1108035\\n15,08;45.49646217\\n15,17;45.87980164\\n15,25;46.26047782\\n15,33;46.63814737\\n15,42;47.01246901\\n15,5;47.3831047\\n15,58;47.74972019\\n15,67;48.11199053\\n15,75;48.46959303\\n15,83;48.82221709\\n15,92;49.16956302\\n16;49.51133821\\n16,08;49.84726703\\n16,17;50.17708708\\n16,25;50.5005518\\n16,33;50.81743186\\n16,42;51.12751661\\n16,5;51.43061537\\n16,58;51.72655874\\n16,67;52.01519982\\n16,75;52.29641539\\n16,83;52.57010692\\n16,92;52.83620153\\n17;53.09465275\\n17,08;53.34544121\\n17,17;53.58857507\\n17,25;53.82409032\\n17,33;54.05204939\\n17,42;54.27254708\\n17,5;54.48570012\\n17,58;54.69165364\\n17,67;54.89057819\\n17,75;55.08266832\\n17,83;55.26814081\\n17,92;55.44723255\\n18;55.62019799\\n18,08;55.78730622\\n18,17;55.94883747\\n18,25;56.10508206\\n18,33;56.25632509\\n18,42;56.402856\\n18,5;56.54495425\\n18,58;56.68288493\\n18,67;56.81689002\\n18,75;56.94718918\\n18,83;57.073957\\n18,92;57.19732448\\n19;57.31736613\\n19,08;57.43408908\\n19,17;57.54742113\\n19,25;57.6571979\\n19,33;57.7631489\\n19,42;57.86488244\\n19,5;57.96186944\\n19,58;58.05342591\\n19,67;58.13869414\\n19,75;58.2166225\\n19,83;58.28594368\\n19,92;58.34514946\\n20;58.39247268\\n\\n\#\\n0;3.150611082\\n0,08;3.597395573\\n0,17;4.428872952\\n0,25;5.183377547\\n0,33;5.866806254\\n0,42;6.484969167\\n0,5;7.043626918\\n0,58;7.548345716\\n0,67;8.004398775\\n0,75;8.416718775\\n0,83;8.789881892\\n0,92;9.128109523\\n1;9.43527941\\n1,08;9.714941801\\n1,17;9.970337596\\n1,25;10.20441778\\n1,33;10.41986276\\n1,42;10.61910138\\n1,5;10.80432929\\n1,58;10.97752662\\n1,67;11.14047457\\n1,75;11.2947714\\n1,83;11.44184727\\n1,92;11.58297823\\n2;11.7192993\\n2,08;11.85181666\\n2,17;11.98141892\\n2,25;12.10888759\\n2,33;12.23490671\\n2,42;12.36007175\\n2,5;12.48489772\\n2,58;12.60982671\\n2,67;12.73523417\\n2,75;12.86143776\\n2,83;12.98869962\\n2,92;13.11723187\\n3;13.24720657\\n3,08;13.37875374\\n3,17;13.51197197\\n3,25;13.64692711\\n3,33;13.78365965\\n3,42;13.92218431\\n3,5;14.06249859\\n3,58;14.2045836\\n3,67;14.34840318\\n3,75;14.49391163\\n3,83;14.64105343\\n3,92;14.78976688\\n4;14.93998212\\n4,08;15.0916281\\n4,17;15.24463077\\n4,25;15.39891519\\n4,33;15.55440665\\n4,42;15.71103166\\n4,5;15.86871877\\n4,58;16.0273993\\n4,67;16.18700795\\n4,75;16.34748412\\n4,83;16.50876909\\n4,92;16.670811\\n5;16.83356209\\n5,08;16.99697963\\n5,17;17.16102601\\n5,25;17.32566884\\n5,33;17.49088098\\n5,42;17.65664052\\n5,5;17.82293074\\n5,58;17.98974005\\n5,67;18.15706188\\n5,75;18.32489457\\n5,83;18.49324122\\n5,92;18.66210955\\n6;18.83151262\\n6,08;19.00146515\\n6,17;19.17198834\\n6,25;19.34310643\\n6,33;19.51484724\\n6,42;19.68724198\\n6,5;19.86032494\\n6,58;20.03413327\\n6,67;20.20870673\\n6,75;20.38408835\\n6,83;20.56032091\\n6,92;20.73745116\\n7;20.9155269\\n7,08;21.09459707\\n7,17;21.2747126\\n7,25;21.45592408\\n7,33;21.63828396\\n7,42;21.82184504\\n7,5;22.00666068\\n7,58;22.19278461\\n7,67;22.38027095\\n7,75;22.56917407\\n7,83;22.75954858\\n7,92;22.95145019\\n8;23.14493249\\n8,08;23.34005152\\n8,17;23.53686295\\n8,25;23.73542282\\n8,33;23.93578761\\n8,42;24.13801431\\n8,5;24.34216053\\n8,58;24.54828458\\n8,67;24.7564457\\n8,75;24.96670281\\n8,83;25.17911785\\n8,92;25.39375238\\n9;25.61066925\\n9,08;25.82993243\\n9,17;26.05160708\\n9,25;26.27575951\\n9,33;26.50245719\\n9,42;26.73176876\\n9,5;26.96376399\\n9,58;27.19851432\\n9,67;27.43609072\\n9,75;27.67656629\\n9,83;27.92001453\\n9,92;28.16650963\\n10;28.41612623\\n10,08;28.66893932\\n10,17;28.92502395\\n10,25;29.18445509\\n10,33;29.44730733\\n10,42;29.7136546\\n10,5;29.98356997\\n10,58;30.25712523\\n10,67;30.53439065\\n10,75;30.8154346\\n10,83;31.1003232\\n10,92;31.38911963\\n11;31.6818858\\n11,08;31.97867622\\n11,17;32.27954601\\n11,25;32.58454356\\n11,33;32.89371309\\n11,42;33.20709368\\n11,5;33.52471882\\n11,58;33.84661596\\n11,67;34.17280606\\n11,75;34.50330312\\n11,83;34.83811379\\n11,92;35.17723687\\n12;35.52066292\\n12,08;35.8683738\\n12,17;36.22034231\\n12,25;36.57653175\\n12,33;36.9368956\\n12,42;37.3013771\\n12,5;37.669909\\n12,58;38.04241318\\n12,67;38.4188008\\n12,75;38.79897039\\n12,83;39.18281045\\n12,92;39.57019714\\n13;39.96099475\\n13,08;40.35505561\\n13,17;40.75222006\\n13,25;41.15231646\\n13,33;41.55516124\\n13,42;41.96055897\\n13,5;42.36830371\\n13,58;42.77817554\\n13,67;43.1899454\\n13,75;43.6033728\\n13,83;44.01820683\\n13,92;44.43418656\\n14;44.8510416\\n14,08;45.26849262\\n14,17;45.68625203\\n14,25;46.10402466\\n14,33;46.5215085\\n14,42;46.93839552\\n14,5;47.35437254\\n14,58;47.76912213\\n14,67;48.18232356\\n14,75;48.59365384\\n14,83;49.00278873\\n14,92;49.40940563\\n15;49.81317566\\n15,08;50.21378283\\n15,17;50.61090716\\n15,25;51.0042348\\n15,33;51.39345743\\n15,42;51.77827341\\n15,5;52.15838887\\n15,58;52.53352018\\n15,67;52.90338872\\n15,75;53.26773454\\n15,83;53.62630488\\n15,92;53.97885832\\n16;54.32517625\\n16,08;54.66504759\\n16,17;54.9982797\\n16,25;55.32469696\\n16,33;55.64414166\\n16,42;55.95647478\\n16,5;56.26157681\\n16,58;56.55934839\\n16,67;56.8497111\\n16,75;57.13260799\\n16,83;57.40800416\\n16,92;57.67588728\\n17;57.93626794\\n17,08;58.18918\\n17,17;58.43468077\\n17,25;58.67285105\\n17,33;58.90379742\\n17,42;59.1276417\\n17,5;59.3445374\\n17,58;59.55465678\\n17,67;59.75819326\\n17,75;59.95536025\\n17,83;60.1463897\\n17,92;60.33153027\\n18;60.51104512\\n18,08;60.68520928\\n18,17;60.85430662\\n18,25;61.0186237\\n18,33;61.17845532\\n18,42;61.33408787\\n18,5;61.48580086\\n18,58;61.63385984\\n18,67;61.77851223\\n18,75;61.91996953\\n18,83;62.05841733\\n18,92;62.19399335\\n19;62.32678127\\n19,08;62.45680021\\n19,17;62.58399337\\n19,25;62.70821568\\n19,33;62.8292204\\n19,42;62.94664487\\n19,5;63.0599953\\n19,58;63.16863065\\n19,67;63.27174585\\n19,75;63.36835431\\n19,83;63.45727001\\n19,92;63.53709257\\n20;63.6061772\\n\\n\#\\n0;3.530203168\\n0,08;4.003106424\\n0,17;4.879525083\\n0,25;5.672888765\\n0,33;6.391391982\\n0,42;7.041836432\\n0,5;7.630425182\\n0,58;8.162951035\\n0,67;8.644832479\\n0,75;9.081119817\\n0,83;9.476500305\\n0,92;9.835307701\\n1;10.16153567\\n1,08;10.45885399\\n1,17;10.7306256\\n1,25;10.97992482\\n1,33;11.20955529\\n1,42;11.4220677\\n1,5;11.61977698\\n1,58;11.80477902\\n1,67;11.9789663\\n1,75;12.14404334\\n1,83;12.30154103\\n1,92;12.45283028\\n2;12.59913494\\n2,08;12.74154396\\n2,17;12.88102276\\n2,25;13.01842382\\n2,33;13.1544966\\n2,42;13.28989667\\n2,5;13.42519408\\n2,58;13.56088113\\n2,67;13.69737858\\n2,75;13.83504622\\n2,83;13.97418299\\n2,92;14.1150324\\n3;14.25779618\\n3,08;14.40262749\\n3,17;14.54964614\\n3,25;14.69893326\\n3,33;14.85054151\\n3,42;15.00449143\\n3,5;15.16078454\\n3,58;15.31940246\\n3,67;15.48030313\\n3,75;15.64343309\\n3,83;15.80872535\\n3,92;15.97610456\\n4;16.14548194\\n4,08;16.31676727\\n4,17;16.4898646\\n4,25;16.66467529\\n4,33;16.84109948\\n4,42;17.01903746\\n4,5;17.1983908\\n4,58;17.37906341\\n4,67;17.56096245\\n4,75;17.74400082\\n4,83;17.92809121\\n4,92;18.11315625\\n5;18.29912286\\n5,08;18.48592413\\n5,17;18.67349965\\n5,25;18.86179576\\n5,33;19.05076579\\n5,42;19.24037019\\n5,5;19.43057662\\n5,58;19.62136007\\n5,67;19.8127028\\n5,75;20.0045944\\n5,83;20.19703171\\n5,92;20.39001872\\n6;20.58356862\\n6,08;20.77769565\\n6,17;20.97242631\\n6,25;21.16779192\\n6,33;21.36383013\\n6,42;21.56058467\\n6,5;21.75810506\\n6,58;21.95644627\\n6,67;22.15566842\\n6,75;22.35583862\\n6,83;22.55702268\\n6,92;22.75929558\\n7;22.9627344\\n7,08;23.16741888\\n7,17;23.37343341\\n7,25;23.58086145\\n7,33;23.78979096\\n7,42;24.00031064\\n7,5;24.21251028\\n7,58;24.42648043\\n7,67;24.642312\\n7,75;24.86009596\\n7,83;25.07992303\\n7,92;25.30188584\\n8;25.52606977\\n8,08;25.75256528\\n8,17;25.9814599\\n8,25;26.2128399\\n8,33;26.44679027\\n8,42;26.68339457\\n8,5;26.92273494\\n8,58;27.16489199\\n8,67;27.40994539\\n8,75;27.65796978\\n8,83;27.90904433\\n8,92;28.16324264\\n9;28.42063744\\n9,08;28.68130005\\n9,17;28.94530029\\n9,25;29.21270645\\n9,33;29.48358527\\n9,42;29.75800198\\n9,5;30.03602021\\n9,58;30.31770417\\n9,67;30.60311107\\n9,75;30.89230072\\n9,83;31.18532984\\n9,92;31.48225315\\n10;31.78312329\\n10,08;32.08799062\\n10,17;32.39690313\\n10,25;32.7099062\\n10,33;33.02704244\\n10,42;33.34835148\\n10,5;33.67386973\\n10,58;34.00363017\\n10,67;34.33766207\\n10,75;34.67599076\\n10,83;35.01863732\\n10,92;35.36561737\\n11;35.71694723\\n11,08;36.07262569\\n11,17;36.43265996\\n11,25;36.79704392\\n11,33;37.1657671\\n11,42;37.53881268\\n11,5;37.91615721\\n11,58;38.2977703\\n11,67;38.6836143\\n11,75;39.07364401\\n11,83;39.46780643\\n11,92;39.86604044\\n12;40.26827652\\n12,08;40.67443658\\n12,17;41.08443363\\n12,25;41.49817164\\n12,33;41.91554528\\n12,42;42.33643978\\n12,5;42.76073078\\n12,58;43.18828419\\n12,67;43.61895703\\n12,75;44.0525931\\n12,83;44.48903027\\n12,92;44.92809483\\n13;45.36960315\\n13,08;45.81336172\\n13,17;46.25916729\\n13,25;46.70680701\\n13,33;47.15605863\\n13,42;47.60669074\\n13,5;48.05846572\\n13,58;48.51113138\\n13,67;48.96443224\\n13,75;49.41810374\\n13,83;49.87187409\\n13,92;50.32546478\\n14;50.77859121\\n14,08;51.23096332\\n14,17;51.68228625\\n14,25;52.13226113\\n14,33;52.58058583\\n14,42;53.02695588\\n14,5;53.47106525\\n14,58;53.91260737\\n14,67;54.35127608\\n14,75;54.78676659\\n14,83;55.21877657\\n14,92;55.64701131\\n15;56.07116407\\n15,08;56.49095862\\n15,17;56.90610886\\n15,25;57.31634059\\n15,33;57.72138846\\n15,42;58.12099696\\n15,5;58.51492143\\n15,58;58.90293208\\n15,67;59.28479948\\n15,75;59.66032626\\n15,83;60.02931704\\n15,92;60.39158721\\n16;60.74698785\\n16,08;61.09536847\\n16,17;61.43660077\\n16,25;61.77057372\\n16,33;62.09719399\\n16,42;62.41638628\\n16,5;62.72809362\\n16,58;63.03227756\\n16,67;63.32891841\\n16,75;63.61801537\\n16,83;63.89958662\\n16,92;64.17366943\\n17;64.44032016\\n17,08;64.69961427\\n17,17;64.95164625\\n17,25;65.1965295\\n17,33;65.43440186\\n17,42;65.66540015\\n17,5;65.88970117\\n17,58;66.10749114\\n17,67;66.31897311\\n17,75;66.52436618\\n17,83;66.72390443\\n17,92;66.91783563\\n18;67.10641956\\n18,08;67.28992603\\n18,17;67.46863255\\n18,25;67.64281378\\n18,33;67.8127675\\n18,42;67.97877331\\n18,5;68.14111022\\n18,58;68.30004741\\n18,67;68.4558454\\n18,75;68.60872174\\n18,83;68.75889263\\n18,92;68.90653028\\n19;69.05176427\\n19,08;69.19467288\\n19,17;69.33527376\\n19,25;69.47351373\\n19,33;69.60925782\\n19,42;69.74227758\\n19,5;69.87223885\\n19,58;69.99868896\\n19,67;70.12104381\\n19,75;70.23857482\\n19,83;70.35039626\\n19,92;70.45546105\\n20;70.55252127\\n\\n\#\\n0;3.879076559\\n0,08;4.387422565\\n0,17;5.327327567\\n0,25;6.175598158\\n0,33;6.942217106\\n0,42;7.635323002\\n0,5;8.262032991\\n0,58;8.828786159\\n0,67;9.34149038\\n0,75;9.805593364\\n0,83;10.22612395\\n0,92;10.60772151\\n1;10.9546603\\n1,08;11.27087147\\n1,17;11.55996332\\n1,25;11.82524099\\n1,33;12.06972515\\n1,42;12.29616991\\n1,5;12.50708008\\n1,58;12.70472779\\n1,67;12.89116805\\n1,75;13.06825426\\n1,83;13.23765258\\n1,92;13.40085582\\n2;13.55919667\\n2,08;13.71386029\\n2,17;13.86589625\\n2,25;14.0162298\\n2,33;14.1656725\\n2,42;14.31493214\\n2,5;14.46462206\\n2,58;14.61526973\\n2,67;14.76732387\\n2,75;14.9211657\\n2,83;15.07711012\\n2,92;15.23541179\\n3;15.3962791\\n3,08;15.5598683\\n3,17;15.72629889\\n3,25;15.89564892\\n3,33;16.06796532\\n3,42;16.24326063\\n3,5;16.4215262\\n3,58;16.60273167\\n3,67;16.78682117\\n3,75;16.97372594\\n3,83;17.16336229\\n3,92;17.3556371\\n4;17.55044259\\n4,08;17.74766896\\n4,17;17.94720007\\n4,25;18.14891672\\n4,33;18.35269841\\n4,42;18.55842485\\n4,5;18.76597736\\n4,58;18.9752401\\n4,67;19.18610119\\n4,75;19.39845556\\n4,83;19.61219848\\n4,92;19.82723683\\n5;20.04348292\\n5,08;20.26085668\\n5,17;20.47928605\\n5,25;20.69870731\\n5,33;20.9190654\\n5,42;21.14031403\\n5,5;21.36241588\\n5,58;21.58534268\\n5,67;21.80907518\\n5,75;22.03360322\\n5,83;22.25892561\\n5,92;22.48505007\\n6;22.71199557\\n6,08;22.93978291\\n6,17;23.16844769\\n6,25;23.39803173\\n6,33;23.62858485\\n6,42;23.86016456\\n6,5;24.09283575\\n6,58;24.32667035\\n6,67;24.56174697\\n6,75;24.79815314\\n6,83;25.03597537\\n6,92;25.27531174\\n7;25.51626345\\n7,08;25.75893543\\n7,17;26.00343881\\n7,25;26.24988395\\n7,33;26.49838713\\n7,42;26.74906587\\n7,5;27.00203925\\n7,58;27.25742737\\n7,67;27.51535075\\n7,75;27.77592982\\n7,83;28.03928438\\n7,92;28.30553622\\n8;28.57479705\\n8,08;28.84718437\\n8,17;29.12281085\\n8,25;29.40178631\\n8,33;29.68421748\\n8,42;29.97020767\\n8,5;30.25985653\\n8,58;30.5532598\\n8,67;30.85050986\\n8,75;31.15169009\\n8,83;31.45688766\\n8,92;31.76617973\\n9;32.07963965\\n9,08;32.39733625\\n9,17;32.71933351\\n9,25;33.04569055\\n9,33;33.37646157\\n9,42;33.7116958\\n9,5;34.05143747\\n9,58;34.39572894\\n9,67;34.74459982\\n9,75;35.09808092\\n9,83;35.45619608\\n9,92;35.81896391\\n10;36.18639776\\n10,08;36.55850564\\n10,17;36.9352902\\n10,25;37.31674867\\n10,33;37.70287276\\n10,42;38.09364865\\n10,5;38.48905687\\n10,58;38.88907228\\n10,67;39.29366396\\n10,75;39.70279517\\n10,83;40.11642323\\n10,92;40.53449819\\n11;40.95697152\\n11,08;41.38377162\\n11,17;41.81483955\\n11,25;42.25009969\\n11,33;42.68947235\\n11,42;43.13287143\\n11,5;43.58020437\\n11,58;44.03137211\\n11,67;44.48626901\\n11,75;44.94478284\\n11,83;45.40679475\\n11,92;45.8721792\\n12;46.34080401\\n12,08;46.81253029\\n12,17;47.28721249\\n12,25;47.76469837\\n12,33;48.24482905\\n12,42;48.72743903\\n12,5;49.21235624\\n12,58;49.6994021\\n12,67;50.1883928\\n12,75;50.67913392\\n12,83;51.17142989\\n12,92;51.66507694\\n13;52.15986523\\n13,08;52.65557906\\n13,17;53.15199704\\n13,25;53.64889226\\n13,33;54.14603254\\n13,42;54.64318067\\n13,5;55.14009784\\n13,58;55.63653354\\n13,67;56.13223889\\n13,75;56.62695959\\n13,83;57.12043787\\n13,92;57.61241293\\n14;58.10262135\\n14,08;58.59079757\\n14,17;59.07667438\\n14,25;59.55998349\\n14,33;60.04045606\\n14,42;60.51782332\\n14,5;60.99181722\\n14,58;61.4621711\\n14,67;61.92862037\\n14,75;62.3909033\\n14,83;62.84876169\\n14,92;63.30194659\\n15;63.75019486\\n15,08;64.19327833\\n15,17;64.63095632\\n15,25;65.06300059\\n15,33;65.48919135\\n15,42;65.90931806\\n15,5;66.32318017\\n15,58;66.73059164\\n15,67;67.13136309\\n15,75;67.52533948\\n15,83;67.91236375\\n15,92;68.29228717\\n16;68.66499835\\n16,08;69.03037911\\n16,17;69.38833214\\n16,25;69.73877506\\n16,33;70.08164061\\n16,42;70.41687682\\n16,5;70.74444713\\n16,58;71.06433046\\n16,67;71.3765212\\n16,75;71.68102918\\n16,83;71.97787966\\n16,92;72.26711325\\n17;72.54878582\\n17,08;72.82296841\\n17,17;73.08974718\\n17,25;73.34922324\\n17,33;73.60151968\\n17,42;73.84675041\\n17,5;74.08507097\\n17,58;74.31664141\\n17,67;74.54163604\\n17,75;74.76024322\\n17,83;74.97266503\\n17,92;75.17911684\\n18;75.37982657\\n18,08;75.57503388\\n18,17;75.76498909\\n18,25;75.94994171\\n18,33;76.13017744\\n18,42;76.30596623\\n18,5;76.47758936\\n18,58;76.64533092\\n18,67;76.80948323\\n18,75;76.97030781\\n18,83;77.12809294\\n18,92;77.28310484\\n19;77.43559533\\n19,08;77.58579719\\n19,17;77.73391919\\n19,25;77.88014066\\n19,33;78.02460556\\n19,42;78.16741625\\n19,5;78.30862691\\n19,58;78.44823694\\n19,67;78.58618425\\n19,75;78.72233893\\n19,83;78.85649725\\n19,92;78.98838596\\n20;79.11762417\\n\\n\#\\n0;4.17249339\\n0,08;4.718161283\\n0,17;5.728152752\\n0,25;6.638979132\\n0,33;7.460702368\\n0,42;8.202193202\\n0,5;8.871384112\\n0,58;9.47546616\\n0,67;10.02101374\\n0,75;10.51406421\\n0,83;10.96017225\\n0,92;11.36445045\\n1;11.73160184\\n1,08;12.06594792\\n1,17;12.37145331\\n1,25;12.65174864\\n1,33;12.91015164\\n1,42;13.14968707\\n1,5;13.37310558\\n1,58;13.58290165\\n1,67;13.78133058\\n1,75;13.9704249\\n1,83;14.15200982\\n1,92;14.3277181\\n2;14.49900418\\n2,08;14.6671577\\n2,17;14.83331632\\n2,25;14.99847794\\n2,33;15.16351231\\n2,42;15.32917196\\n2,5;15.49610261\\n2,58;15.66485286\\n2,67;15.83588309\\n2,75;16.00957526\\n2,83;16.18623907\\n2,92;16.36611917\\n3;16.54940494\\n3,08;16.73623287\\n3,17;16.92669619\\n3,25;17.12084685\\n3,33;17.31870281\\n3,42;17.52024974\\n3,5;17.72544898\\n3,58;17.93423997\\n3,67;18.14654091\\n3,75;18.36225594\\n3,83;18.58127627\\n3,92;18.80348418\\n4;19.02875229\\n4,08;19.25695041\\n4,17;19.48794495\\n4,25;19.72160147\\n4,33;19.95778649\\n4,42;20.19636905\\n4,5;20.43722215\\n4,58;20.68022399\\n4,67;20.92525904\\n4,75;21.17221993\\n4,83;21.42100482\\n4,92;21.67152294\\n5;21.92369204\\n5,08;22.17743954\\n5,17;22.43270288\\n5,25;22.6894297\\n5,33;22.94757799\\n5,42;23.20711615\\n5,5;23.46802293\\n5,58;23.73028735\\n5,67;23.99390857\\n5,75;24.25889565\\n5,83;24.52526733\\n5,92;24.79305175\\n6;25.06228739\\n6,08;25.33301794\\n6,17;25.60529875\\n6,25;25.87919213\\n6,33;26.15476795\\n6,42;26.43210324\\n6,5;26.71128177\\n6,58;26.99239357\\n6,67;27.27553447\\n6,75;27.56080718\\n6,83;27.84831538\\n6,92;28.13817063\\n7;28.43048732\\n7,08;28.72538282\\n7,17;29.02297867\\n7,25;29.32339625\\n7,33;29.62676053\\n7,42;29.93319702\\n7,5;30.24283177\\n7,58;30.55579074\\n7,67;30.87219924\\n7,75;31.19218135\\n7,83;31.51585929\\n7,92;31.8433549\\n8;32.17478161\\n8,08;32.51025437\\n8,17;32.84988252\\n8,25;33.19377093\\n8,33;33.54201944\\n8,42;33.8947225\\n8,5;34.25196875\\n8,58;34.61384061\\n8,67;34.98041447\\n8,75;35.35175676\\n8,83;35.72793225\\n8,92;36.10899472\\n9;36.49499102\\n9,08;36.8859604\\n9,17;37.28193426\\n9,25;37.68293608\\n9,33;38.08898133\\n9,42;38.50007744\\n9,5;38.9162238\\n9,58;39.33741401\\n9,67;39.76362815\\n9,75;40.19484291\\n9,83;40.63102576\\n9,92;41.07213642\\n10;41.51812687\\n10,08;41.96894158\\n10,17;42.42451755\\n10,25;42.88478457\\n10,33;43.34966531\\n10,42;43.81907554\\n10,5;44.29292431\\n10,58;44.77111415\\n10,67;45.2535413\\n10,75;45.74009589\\n10,83;46.23066219\\n10,92;46.72511793\\n11;47.22334049\\n11,08;47.72519072\\n11,17;48.23053714\\n11,25;48.73923662\\n11,33;49.25114312\\n11,42;49.76610635\\n11,5;50.28397203\\n11,58;50.80458216\\n11,67;51.32777521\\n11,75;51.85338637\\n11,83;52.38124777\\n11,92;52.91118868\\n12;53.44303574\\n12,08;53.97661318\\n12,17;54.51174297\\n12,25;55.04824506\\n12,33;55.58593751\\n12,42;56.1246367\\n12,5;56.66415748\\n12,58;57.20431332\\n12,67;57.74491716\\n12,75;58.2857783\\n12,83;58.82670813\\n12,92;59.36751587\\n13;59.90801\\n13,08;60.44799828\\n13,17;60.98728788\\n13,25;61.52568545\\n13,33;62.06299719\\n13,42;62.59902894\\n13,5;63.13358794\\n13,58;63.66647721\\n13,67;64.19750276\\n13,75;64.72646954\\n13,83;65.25318239\\n13,92;65.77744608\\n14;66.29906539\\n14,08;66.81784516\\n14,17;67.33359031\\n14,25;67.846106\\n14,33;68.35519765\\n14,42;68.86067105\\n14,5;69.36233252\\n14,58;69.85998897\\n14,67;70.35344811\\n14,75;70.8425186\\n14,83;71.32701026\\n14,92;71.80673678\\n15;72.2815034\\n15,08;72.75113236\\n15,17;73.21543801\\n15,25;73.6742397\\n15,33;74.12735965\\n15,42;74.57462329\\n15,5;75.01585966\\n15,58;75.45090384\\n15,67;75.87958721\\n15,75;76.30175821\\n15,83;76.71726244\\n15,92;77.12594864\\n16;77.5276843\\n16,08;77.92233231\\n16,17;78.30976593\\n16,25;78.68986591\\n16,33;79.0625209\\n16,42;79.42762779\\n16,5;79.78509216\\n16,58;80.13482859\\n16,67;80.47676112\\n16,75;80.81082354\\n16,83;81.1369598\\n16,92;81.45512442\\n17;81.76528289\\n17,08;82.06741212\\n17,17;82.3615009\\n17,25;82.64755047\\n17,33;82.92557908\\n17,42;83.19560496\\n17,5;83.45767612\\n17,58;83.71184998\\n17,67;83.95819995\\n17,75;84.19681638\\n17,83;84.42780754\\n17,92;84.6513007\\n18;84.86744322\\n18,08;85.07640364\\n18,17;85.27837286\\n18,25;85.47355853\\n18,33;85.66221241\\n18,42;85.84459728\\n18,5;86.02100855\\n18,58;86.1917714\\n18,67;86.35724712\\n18,75;86.51781277\\n18,83;86.6739\\n18,92;86.82596904\\n19;86.97451776\\n19,08;87.12008338\\n19,17;87.26324432\\n19,25;87.40462203\\n19,33;87.54488282\\n19,42;87.6847398\\n19,5;87.82495478\\n19,58;87.96634036\\n19,67;88.10976202\\n19,75;88.25614046\\n19,83;88.40645399\\n19,92;88.56174643\\n20;88.72311137\\n\\n\#\\nage [years];95th\\n0;4.34029274\\n0,08;4.910130108\\n0,17;5.967101615\\n0,25;6.921119162\\n0,33;7.781401145\\n0,42;8.556813353\\n0,5;9.255614546\\n0,58;9.885435743\\n0,67;10.45331433\\n0,75;10.96573632\\n0,83;11.42867623\\n0,92;11.84763282\\n1;12.2276612\\n1,08;12.57340193\\n1,17;12.88910809\\n1,25;13.17867019\\n1,33;13.44563963\\n1,42;13.6932508\\n1,5;13.92444193\\n1,58;14.14187481\\n1,67;14.34795358\\n1,75;14.54484233\\n1,83;14.73448194\\n1,92;14.91860604\\n2;15.09875606\\n2,08;15.27629562\\n2,17;15.45242405\\n2,25;15.62818936\\n2,33;15.80450043\\n2,42;15.98213866\\n2,5;16.16176896\\n2,58;16.34395025\\n2,67;16.52914562\\n2,75;16.71773017\\n2,83;16.91000204\\n2,92;17.10619066\\n3;17.30646132\\n3,08;17.51092666\\n3,17;17.7196494\\n3,25;17.93265202\\n3,33;18.14992024\\n3,42;18.37141087\\n3,5;18.59705318\\n3,58;18.8267549\\n3,67;19.06040859\\n3,75;19.29789203\\n3,83;19.53907323\\n3,92;19.78381251\\n4;20.03196776\\n4,08;20.28339348\\n4,17;20.53794512\\n4,25;20.79548054\\n4,33;21.05586181\\n4,42;21.31895671\\n4,5;21.58464011\\n4,58;21.85279508\\n4,67;22.12331387\\n4,75;22.3960982\\n4,83;22.67106204\\n4,92;22.94812899\\n5;23.22723469\\n5,08;23.50832656\\n5,17;23.79136391\\n5,25;24.07631802\\n5,33;24.36317198\\n5,42;24.65192058\\n5,5;24.94257\\n5,58;25.23513755\\n5,67;25.52965118\\n5,75;25.82614911\\n5,83;26.12467926\\n5,92;26.42529873\\n6;26.72807261\\n6,08;27.03307565\\n6,17;27.34038832\\n6,25;27.6500983\\n6,33;27.96229925\\n6,42;28.27709021\\n6,5;28.59457486\\n6,58;28.91486092\\n6,67;29.23805946\\n6,75;29.56428369\\n6,83;29.89365038\\n6,92;30.2262764\\n7;30.56227989\\n7,08;30.90177938\\n7,17;31.24489263\\n7,25;31.59173734\\n7,33;31.94242919\\n7,42;32.29708214\\n7,5;32.65580771\\n7,58;33.01871449\\n7,67;33.38590769\\n7,75;33.75748861\\n7,83;34.13355425\\n7,92;34.51419632\\n8;34.89950266\\n8,08;35.28955426\\n8,17;35.68442647\\n8,25;36.08418823\\n8,33;36.48890176\\n8,42;36.89862215\\n8,5;37.31339712\\n8,58;37.73326669\\n8,67;38.15826287\\n8,75;38.5884101\\n8,83;39.02372343\\n8,92;39.46421007\\n9;39.90986854\\n9,08;40.36068858\\n9,17;40.81665117\\n9,25;41.27772848\\n9,33;41.74388392\\n9,42;42.21507216\\n9,5;42.69123922\\n9,58;43.17232241\\n9,67;43.65825106\\n9,75;44.14894598\\n9,83;44.64432008\\n9,92;45.1442785\\n10;45.64871885\\n10,08;46.15753154\\n10,17;46.67060006\\n10,25;47.18780128\\n10,33;47.70900582\\n10,42;48.23407839\\n10,5;48.76287816\\n10,58;49.29525914\\n10,67;49.83107058\\n10,75;50.37015732\\n10,83;50.91236024\\n10,92;51.45751679\\n11;52.00546039\\n11,08;52.55602363\\n11,17;53.10903452\\n11,25;53.66432034\\n11,33;54.22170647\\n11,42;54.7810171\\n11,5;55.34207557\\n11,58;55.90470472\\n11,67;56.46872726\\n11,75;57.03396609\\n11,83;57.6002446\\n11,92;58.167387\\n12;58.73521857\\n12,08;59.30356596\\n12,17;59.87225739\\n12,25;60.44112289\\n12,33;61.00999451\\n12,42;61.5787065\\n12,5;62.14709543\\n12,58;62.71500036\\n12,67;63.28226272\\n12,75;63.84872734\\n12,83;64.41424088\\n12,92;64.97865313\\n13;65.54181664\\n13,08;66.1035867\\n13,17;66.66382131\\n13,25;67.22238111\\n13,33;67.77912926\\n13,42;68.33393136\\n13,5;68.88665453\\n13,58;69.43716965\\n13,67;69.98534819\\n13,75;70.53106367\\n13,83;71.07419108\\n13,92;71.6146066\\n14;72.15218736\\n14,08;72.68681109\\n14,17;73.21835588\\n14,25;73.7466998\\n14,33;74.27172061\\n14,42;74.79329538\\n14,5;75.31130018\\n14,58;75.82560968\\n14,67;76.33609688\\n14,75;76.84263269\\n14,83;77.34508562\\n14,92;77.84332029\\n15;78.33720309\\n15,08;78.82658994\\n15,17;79.31133801\\n15,25;79.79129954\\n15,33;80.26632286\\n15,42;80.73625224\\n15,5;81.20092786\\n15,58;81.66018503\\n15,67;82.11385795\\n15,75;82.56177239\\n15,83;83.00375329\\n15,92;83.43962339\\n16;83.8691966\\n16,08;84.29228904\\n16,17;84.70871297\\n16,25;85.1182789\\n16,33;85.52079616\\n16,42;85.91607365\\n16,5;86.30392061\\n16,58;86.68414749\\n16,67;87.0565669\\n16,75;87.42099463\\n16,83;87.77725073\\n16,92;88.12516072\\n17;88.46455683\\n17,08;88.79527942\\n17,17;89.11717836\\n17,25;89.43011463\\n17,33;89.73396054\\n17,42;90.02860798\\n17,5;90.31395969\\n17,58;90.58993909\\n17,67;90.85649043\\n17,75;91.11358115\\n17,83;91.36120451\\n17,92;91.59938232\\n18;91.82816795\\n18,08;92.04764958\\n18,17;92.25795363\\n18,25;92.4592488\\n18,33;92.65174946\\n18,42;92.83571985\\n18,5;93.0114792\\n18,58;93.17940638\\n18,67;93.33994398\\n18,75;93.49360895\\n18,83;93.64099003\\n18,92;93.7827601\\n19;93.91968135\\n19,08;94.05261232\\n19,17;94.18251529\\n19,25;94.31046411\\n19,33;94.43765234\\n19,42;94.56540179\\n19,5;94.69517136\\n19,58;94.82856611\\n19,67;94.96734651\\n19,75;95.11343784\\n19,83;95.26893942\\n19,92;95.43613181\\n20;95.61749303\\n\\n\#\\n0;4.446488308\\n0,08;5.032624982\\n0,17;6.121929103\\n0,25;7.106250132\\n0,33;7.993878049\\n0,42;8.793443663\\n0,5;9.51330656\\n0,58;10.16135019\\n0,67;10.74492376\\n0,75;11.27083843\\n0,83;11.74538465\\n0,92;12.17435729\\n1;12.56308347\\n1,08;12.91645043\\n1,17;13.23893338\\n1,25;13.53462171\\n1,33;13.80724431\\n1,42;14.0601935\\n1,5;14.29654774\\n1,58;14.51909298\\n1,67;14.73034312\\n1,75;14.93255878\\n1,83;15.12776542\\n1,92;15.31777023\\n2;15.50417803\\n2,08;15.68840631\\n2,17;15.87169941\\n2,25;16.05514188\\n2,33;16.23967114\\n2,42;16.42608957\\n2,5;16.61507584\\n2,58;16.80719583\\n2,67;17.00291386\\n2,75;17.2025984\\n2,83;17.40653734\\n2,92;17.61494698\\n3;17.8279717\\n3,08;18.04570363\\n3,17;18.26817893\\n3,25;18.49539445\\n3,33;18.72730763\\n3,42;18.96385009\\n3,5;19.20492292\\n3,58;19.45040584\\n3,67;19.70016918\\n3,75;19.95406774\\n3,83;20.21194963\\n3,92;20.47365655\\n4;20.73903469\\n4,08;21.00792648\\n4,17;21.28017953\\n4,25;21.55564717\\n4,33;21.83419011\\n4,42;22.11567799\\n4,5;22.39999059\\n4,58;22.68701888\\n4,67;22.97666583\\n4,75;23.26884512\\n4,83;23.56348925\\n4,92;23.86053886\\n5;24.15995003\\n5,08;24.46169255\\n5,17;24.76574995\\n5,25;25.07211926\\n5,33;25.38081076\\n5,42;25.69184758\\n5,5;26.00526525\\n5,58;26.32111112\\n5,67;26.63944376\\n5,75;26.96033222\\n5,83;27.28385531\\n5,92;27.6101008\\n6;27.93916194\\n6,08;28.27114631\\n6,17;28.60616106\\n6,25;28.94432077\\n6,33;29.2857444\\n6,42;29.63055429\\n6,5;29.97887524\\n6,58;30.33083356\\n6,67;30.68655618\\n6,75;31.04616685\\n6,83;31.40979543\\n6,92;31.77756321\\n7;32.14959054\\n7,08;32.52599493\\n7,17;32.90688716\\n7,25;33.29237745\\n7,33;33.68256717\\n7,42;34.07755271\\n7,5;34.47742403\\n7,58;34.88226421\\n7,67;35.2921491\\n7,75;35.707147\\n7,83;36.12731836\\n7,92;36.55271218\\n8;36.98337837\\n8,08;37.41934991\\n8,17;37.86065382\\n8,25;38.30730842\\n8,33;38.75932329\\n8,42;39.21669915\\n8,5;39.67942783\\n8,58;40.14749235\\n8,67;40.62086606\\n8,75;41.09951874\\n8,83;41.58340237\\n8,92;42.07246636\\n9;42.56665066\\n9,08;43.06588662\\n9,17;43.57009739\\n9,25;44.07919809\\n9,33;44.59309597\\n9,42;45.11169064\\n9,5;45.63487433\\n9,58;46.16252884\\n9,67;46.69453697\\n9,75;47.23076853\\n9,83;47.77108893\\n9,92;48.31535768\\n10;48.86342877\\n10,08;49.41515104\\n10,17;49.97036852\\n10,25;50.52892088\\n10,33;51.09064381\\n10,42;51.65536941\\n10,5;52.22292668\\n10,58;52.79314187\\n10,67;53.36583897\\n10,75;53.94084012\\n10,83;54.51796605\\n10,92;55.09703793\\n11;55.67786843\\n11,08;56.26028801\\n11,17;56.84410756\\n11,25;57.42914961\\n11,33;58.01523548\\n11,42;58.60218796\\n11,5;59.18983178\\n11,58;59.77799389\\n11,67;60.36650388\\n11,75;60.95519425\\n11,83;61.54390076\\n11,92;62.13246268\\n12;62.72072311\\n12,08;63.30852916\\n12,17;63.89573222\\n12,25;64.48218816\\n12,33;65.06775743\\n12,42;65.65230527\\n12,5;66.23570179\\n12,58;66.81782206\\n12,67;67.39854494\\n12,75;67.97775861\\n12,83;68.5553511\\n12,92;69.13121752\\n13;69.70525793\\n13,08;70.27737718\\n13,17;70.8474848\\n13,25;71.41549477\\n13,33;71.98132532\\n13,42;72.54489869\\n13,5;73.10613746\\n13,58;73.66497514\\n13,67;74.22134215\\n13,75;74.77517319\\n13,83;75.32640513\\n13,92;75.87497649\\n14;76.42082697\\n14,08;76.96389688\\n14,17;77.50412655\\n14,25;78.04145573\\n14,33;78.57582294\\n14,42;79.10716478\\n14,5;79.63541524\\n14,58;80.16050495\\n14,67;80.68236046\\n14,75;81.20090348\\n14,83;81.71605007\\n14,92;82.22770492\\n15;82.73578555\\n15,08;83.24017154\\n15,17;83.74075385\\n15,25;84.23740907\\n15,33;84.73000377\\n15,42;85.21839391\\n15,5;85.70242429\\n15,58;86.18192445\\n15,67;86.65672655\\n15,75;87.12662858\\n15,83;87.59143077\\n15,92;88.05092631\\n16;88.50487158\\n16,08;88.95303286\\n16,17;89.39515827\\n16,25;89.83098491\\n16,33;90.26023965\\n16,42;90.68264001\\n16,5;91.09789536\\n16,58;91.50570814\\n16,67;91.90577541\\n16,75;92.29779046\\n16,83;92.6814447\\n16,92;93.05642962\\n17;93.42243904\\n17,08;93.77917145\\n17,17;94.12633257\\n17,25;94.46363806\\n17,33;94.79080897\\n17,42;95.10760779\\n17,5;95.41378755\\n17,58;95.70913474\\n17,67;95.99346235\\n17,75;96.26661385\\n17,83;96.52846743\\n17,92;96.77894046\\n18;97.01799447\\n18,08;97.24564034\\n18,17;97.46194398\\n18,25;97.66704065\\n18,33;97.8611107\\n18,42;98.04442516\\n18,5;98.21733128\\n18,58;98.38026471\\n18,67;98.53374986\\n18,75;98.67844376\\n18,83;98.8150862\\n18,92;98.94455298\\n19;99.06785516\\n19,08;99.18615007\\n19,17;99.30075287\\n19,25;99.41314881\\n19,33;99.5250061\\n19,42;99.63818945\\n19,5;99.75477412\\n19,58;99.87706036\\n19,67;100.0075883\\n19,75;100.1491529\\n19,83;100.3048189\\n19,92;100.477926\\n20;100.6721384\\n\\n\#\\n0;2.414111983\\n0,08;2.756916984\\n0,17;3.402293298\\n0,25;3.997805608\\n0,33;4.54738333\\n0,42;5.054538727\\n0,5;5.522500226\\n0,58;5.954272494\\n0,67;6.352668277\\n0,75;6.720327734\\n0,83;7.059731719\\n0,92;7.373211901\\n1;7.662959063\\n1,08;7.93103031\\n1,17;8.179355552\\n1,25;8.409743555\\n1,33;8.62388725\\n1,42;8.82336957\\n1,5;9.00966812\\n1,58;9.184160166\\n1,67;9.348127323\\n1,75;9.502760074\\n1,83;9.649162144\\n1,92;9.788354721\\n2;9.921280547\\n2,08;10.04880788\\n2,17;10.17173432\\n2,25;10.29079033\\n2,33;10.40664383\\n2,42;10.51990171\\n2,5;10.63111516\\n2,58;10.74078194\\n2,67;10.84934933\\n2,75;10.95721927\\n2,83;11.0647471\\n2,92;11.17224778\\n3;11.27999893\\n3,08;11.38824099\\n3,17;11.49718137\\n3,25;11.60699649\\n3,33;11.71783343\\n3,42;11.82981465\\n3,5;11.94303682\\n3,58;12.05757491\\n3,67;12.17348363\\n3,75;12.29079939\\n3,83;12.40954207\\n3,92;12.52971675\\n4;12.65131534\\n4,08;12.77431816\\n4,17;12.89869431\\n4,25;13.0244072\\n4,33;13.15141009\\n4,42;13.279651\\n4,5;13.40907302\\n4,58;13.53961547\\n4,67;13.67121491\\n4,75;13.80380614\\n4,83;13.9373231\\n4,92;14.07169977\\n5;14.20687088\\n5,08;14.34277271\\n5,17;14.47934293\\n5,25;14.61652406\\n5,33;14.75426001\\n5,42;14.89249907\\n5,5;15.03119376\\n5,58;15.17030121\\n5,67;15.30978338\\n5,75;15.4496077\\n5,83;15.5897467\\n5,92;15.73017845\\n6;15.87088741\\n6,08;16.01186303\\n6,17;16.15310112\\n6,25;16.29460329\\n6,33;16.43637669\\n6,42;16.57843458\\n6,5;16.72079656\\n6,58;16.86348713\\n6,67;17.00653572\\n6,75;17.14997871\\n6,83;17.2938564\\n6,92;17.43821437\\n7;17.58310295\\n7,08;17.72857693\\n7,17;17.87469542\\n7,25;18.02152302\\n7,33;18.16912246\\n7,42;18.31756871\\n7,5;18.46693089\\n7,58;18.61728653\\n7,67;18.76871394\\n7,75;18.92129383\\n7,83;19.07510898\\n7,92;19.23024402\\n8;19.38678267\\n8,08;19.54481057\\n8,17;19.70441527\\n8,25;19.86568272\\n8,33;20.02869944\\n8,42;20.19355165\\n8,5;20.36032458\\n8,58;20.52910239\\n8,67;20.6999678\\n8,75;20.8730018\\n8,83;21.04828336\\n8,92;21.22588911\\n9;21.40589307\\n9,08;21.58836636\\n9,17;21.77337689\\n9,25;21.96098914\\n9,33;22.15126389\\n9,42;22.34425792\\n9,5;22.54002382\\n9,58;22.73860975\\n9,67;22.94005917\\n9,75;23.14441069\\n9,83;23.35169781\\n9,92;23.56194878\\n10;23.77518637\\n10,08;23.99142774\\n10,17;24.21068424\\n10,25;24.43296131\\n10,33;24.65825833\\n10,42;24.88656847\\n10,5;25.11787864\\n10,58;25.35216934\\n10,67;25.58941249\\n10,75;25.82958069\\n10,83;26.0726318\\n10,92;26.31852113\\n11;26.56719327\\n11,08;26.81859231\\n11,17;27.0726516\\n11,25;27.3292989\\n11,33;27.5884554\\n11,42;27.85003573\\n11,5;28.11394809\\n11,58;28.38009427\\n11,67;28.64837137\\n11,75;28.91866389\\n11,83;29.1908599\\n11,92;29.46483511\\n12;29.74046108\\n12,08;30.01760377\\n12,17;30.29612378\\n12,25;30.57587654\\n12,33;30.85671255\\n12,42;31.13847695\\n12,5;31.42101289\\n12,58;31.70415418\\n12,67;31.98773757\\n12,75;32.27158972\\n12,83;32.55553716\\n12,92;32.83940314\\n13;33.12300797\\n13,08;33.40616909\\n13,17;33.68870064\\n13,25;33.97041915\\n13,33;34.25113618\\n13,42;34.5306634\\n13,5;34.80881186\\n13,58;35.08539244\\n13,67;35.36021624\\n13,75;35.63309497\\n13,83;35.90384139\\n13,92;36.17226975\\n14;36.43819618\\n14,08;36.70143915\\n14,17;36.96181994\\n14,25;37.21916305\\n14,33;37.47329665\\n14,42;37.72405025\\n14,5;37.97126574\\n14,58;38.2147829\\n14,67;38.45444923\\n14,75;38.69011819\\n14,83;38.92164966\\n14,92;39.14891037\\n15;39.37177435\\n15,08;39.59012338\\n15,17;39.80384736\\n15,25;40.01284477\\n15,33;40.21702302\\n15,42;40.41629881\\n15,5;40.61059851\\n15,58;40.79985847\\n15,67;40.98402528\\n15,75;41.16305606\\n15,83;41.33691866\\n15,92;41.50559186\\n16;41.66906547\\n16,08;41.82734048\\n16,17;41.98042905\\n16,25;42.12835452\\n16,33;42.27115134\\n16,42;42.40886495\\n16,5;42.54155162\\n16,58;42.66927817\\n16,67;42.79212167\\n16,75;42.91016914\\n16,83;43.02351704\\n16,92;43.13227083\\n17;43.23654442\\n17,08;43.33645956\\n17,17;43.43214518\\n17,25;43.52373663\\n17,33;43.61137495\\n17,42;43.69520604\\n17,5;43.77537971\\n17,58;43.85204883\\n17,67;43.9253721\\n17,75;43.99549743\\n17,83;44.06258481\\n17,92;44.12678882\\n18;44.18826162\\n18,08;44.24715174\\n18,17;44.30360275\\n18,25;44.35775192\\n18,33;44.40972877\\n18,42;44.45965358\\n18,5;44.50763581\\n18,58;44.5537724\\n18,67;44.598146\\n18,75;44.64082307\\n18,83;44.68185184\\n18,92;44.72126019\\n19;44.75905693\\n19,08;44.79521204\\n19,17;44.82968627\\n19,25;44.86239882\\n19,33;44.89323794\\n19,42;44.92205384\\n19,5;44.94865678\\n19,58;44.97281279\\n19,67;44.99423978\\n19,75;45.01260329\\n19,83;45.02751676\\n19,92;45.03852094\\n20;45.04509979\\n\\n\#\\n0;2.54790518\\n0,08;2.894442278\\n0,17;3.547610305\\n0,25;4.150638506\\n0,33;4.70712251\\n0,42;5.220487543\\n0,5;5.693974176\\n0,58;6.130641295\\n0,67;6.533372908\\n0,75;6.904885578\\n0,83;7.247735767\\n0,92;7.564326904\\n1;7.856916169\\n1,08;8.127621012\\n1,17;8.378425424\\n1,25;8.611186014\\n1,33;8.827637666\\n1,42;9.029399482\\n1,5;9.217979979\\n1,58;9.394782429\\n1,67;9.561109949\\n1,75;9.718170424\\n1,83;9.867081272\\n1,92;10.00887405\\n2;10.14449891\\n2,08;10.27482891\\n2,17;10.40066415\\n2,25;10.52273569\\n2,33;10.64171007\\n2,42;10.7581918\\n2,5;10.8727282\\n2,58;10.98581228\\n2,67;11.09788597\\n2,75;11.2093447\\n2,83;11.32053778\\n2,92;11.43177357\\n3;11.54332263\\n3,08;11.65541879\\n3,17;11.76826286\\n3,25;11.88202491\\n3,33;11.99684628\\n3,42;12.11284345\\n3,5;12.23010816\\n3,58;12.34871076\\n3,67;12.46870194\\n3,75;12.59011469\\n3,83;12.71296607\\n3,92;12.837259\\n4;12.96298387\\n4,08;13.09012012\\n4,17;13.21863694\\n4,25;13.34849756\\n4,33;13.47965651\\n4,42;13.61206342\\n4,5;13.74566354\\n4,58;13.88039891\\n4,67;14.0162093\\n4,75;14.15303322\\n4,83;14.29080875\\n4,92;14.42947441\\n5;14.56896986\\n5,08;14.70923661\\n5,17;14.85021811\\n5,25;14.9918623\\n5,33;15.13411929\\n5,42;15.27694359\\n5,5;15.42029408\\n5,58;15.56413437\\n5,67;15.70843301\\n5,75;15.85316397\\n5,83;15.99830645\\n5,92;16.1438452\\n6;16.28977109\\n6,08;16.43608019\\n6,17;16.58277468\\n6,25;16.72986243\\n6,33;16.87735682\\n6,42;17.02527707\\n6,5;17.17364841\\n6,58;17.32250091\\n6,67;17.47186953\\n6,75;17.62179544\\n6,83;17.77232382\\n6,92;17.92350474\\n7;18.07539265\\n7,08;18.2280462\\n7,17;18.38152794\\n7,25;18.53590513\\n7,33;18.69124428\\n7,42;18.84762137\\n7,5;19.00510849\\n7,58;19.16378421\\n7,67;19.32372789\\n7,75;19.48502077\\n7,83;19.64774563\\n7,92;19.8119865\\n8;19.9778266\\n8,08;20.14535023\\n8,17;20.31464276\\n8,25;20.48578791\\n8,33;20.65886924\\n8,42;20.83396942\\n8,5;21.01116968\\n8,58;21.19054959\\n8,67;21.37218677\\n8,75;21.55615653\\n8,83;21.74253164\\n8,92;21.93138197\\n9;22.12277423\\n9,08;22.31677169\\n9,17;22.51343388\\n9,25;22.71281638\\n9,33;22.91497052\\n9,42;23.11994316\\n9,5;23.32777646\\n9,58;23.53850764\\n9,67;23.7521688\\n9,75;23.96878672\\n9,83;24.18838263\\n9,92;24.4109721\\n10;24.63656488\\n10,08;24.86516468\\n10,17;25.09676913\\n10,25;25.33136962\\n10,33;25.56895119\\n10,42;25.80949245\\n10,5;26.05296553\\n10,58;26.29933598\\n10,67;26.5485612\\n10,75;26.80059725\\n10,83;27.05538753\\n10,92;27.31287184\\n11;27.57298031\\n11,08;27.83564104\\n11,17;28.10077256\\n11,25;28.3682877\\n11,33;28.63809288\\n11,42;28.91008824\\n11,5;29.18416775\\n11,58;29.46021931\\n11,67;29.73812611\\n11,75;30.01776074\\n11,83;30.29899746\\n11,92;30.58170029\\n12;30.86572924\\n12,08;31.15093935\\n12,17;31.43718091\\n12,25;31.72429973\\n12,33;32.01213742\\n12,42;32.30053116\\n12,5;32.58931625\\n12,58;32.87832086\\n12,67;33.16737518\\n12,75;33.45630184\\n12,83;33.74492348\\n12,92;34.03306041\\n13;34.3205311\\n13,08;34.60715224\\n13,17;34.89273857\\n13,25;35.17710718\\n13,33;35.46007223\\n13,42;35.74144871\\n13,5;36.0210521\\n13,58;36.29869877\\n13,67;36.57420636\\n13,75;36.84739419\\n13,83;37.11808367\\n13,92;37.38609874\\n14;37.65126622\\n14,08;37.91341628\\n14,17;38.17238283\\n14,25;38.42800396\\n14,33;38.68012233\\n14,42;38.92858345\\n14,5;39.17324412\\n14,58;39.41396159\\n14,67;39.65060094\\n14,75;39.8830339\\n14,83;40.11113919\\n14,92;40.33480295\\n15;40.55391906\\n15,08;40.76838955\\n15,17;40.97812493\\n15,25;41.18304453\\n15,33;41.3830768\\n15,42;41.57815964\\n15,5;41.76824065\\n15,58;41.95327736\\n15,67;42.1332375\\n15,75;42.30809914\\n15,83;42.4778509\\n15,92;42.642492\\n16;42.80203238\\n16,08;42.95649273\\n16,17;43.10590449\\n16,25;43.25030973\\n16,33;43.38976112\\n16,42;43.52432169\\n16,5;43.65406467\\n16,58;43.77907316\\n16,67;43.89943983\\n16,75;44.01526649\\n16,83;44.12666366\\n16,92;44.23375003\\n17;44.33665192\\n17,08;44.43550259\\n17,17;44.53044156\\n17,25;44.62161386\\n17,33;44.70916923\\n17,42;44.79326117\\n17,5;44.8740461\\n17,58;44.95168231\\n17,67;45.02633189\\n17,75;45.09814744\\n17,83;45.16728964\\n17,92;45.23391322\\n18;45.29816896\\n18,08;45.36020233\\n18,17;45.42015206\\n18,25;45.47814866\\n18,33;45.53431283\\n18,42;45.58875384\\n18,5;45.64156773\\n18,58;45.69283549\\n18,67;45.74262109\\n18,75;45.79096943\\n18,83;45.83790409\\n18,92;45.88342504\\n19;45.92750914\\n19,08;45.97009344\\n19,17;46.01109826\\n19,25;46.05040055\\n19,33;46.08784264\\n19,42;46.12322421\\n19,5;46.15630107\\n19,58;46.18678082\\n19,67;46.21431895\\n19,75;46.23851477\\n19,83;46.2589107\\n19,92;46.27497563\\n20;46.28611635\\n\\n\#\\n0;2.747222257\\n0,08;3.101767067\\n0,17;3.770157472\\n0,25;4.387041982\\n0,33;4.95592631\\n0,42;5.480295205\\n0,5;5.963510428\\n0,58;6.408775097\\n0,67;6.819122283\\n0,75;7.197413532\\n0,83;7.546341788\\n0,92;7.868436369\\n1;8.166068895\\n1,08;8.441459662\\n1,17;8.696684147\\n1,25;8.933679535\\n1,33;9.154251142\\n1,42;9.360078736\\n1,5;9.55272268\\n1,58;9.733629905\\n1,67;9.904139709\\n1,75;10.06548937\\n1,83;10.21881956\\n1,92;10.3651796\\n2;10.50553251\\n2,08;10.64075987\\n2,17;10.77166654\\n2,25;10.89898512\\n2,33;11.02338047\\n2,42;11.14545358\\n2,5;11.26574591\\n2,58;11.38474303\\n2,67;11.50287836\\n2,75;11.62053698\\n2,83;11.7380584\\n2,92;11.85574032\\n3;11.9738418\\n3,08;12.0925858\\n3,17;12.21216229\\n3,25;12.33273088\\n3,33;12.45442324\\n3,42;12.57734604\\n3,5;12.7015826\\n3,58;12.82719552\\n3,67;12.95422865\\n3,75;13.08270906\\n3,83;13.21264896\\n3,92;13.3440474\\n4;13.47689199\\n4,08;13.61116044\\n4,17;13.74682181\\n4,25;13.88383882\\n4,33;14.02216781\\n4,42;14.16176079\\n4,5;14.30256641\\n4,58;14.44453095\\n4,67;14.58759933\\n4,75;14.731716\\n4,83;14.87682577\\n4,92;15.02287453\\n5;15.16981002\\n5,08;15.31758235\\n5,17;15.46614444\\n5,25;15.61545325\\n5,33;15.76546914\\n5,42;15.91615695\\n5,5;16.06748615\\n5,58;16.21943117\\n5,67;16.37197155\\n5,75;16.52509225\\n5,83;16.67878363\\n5,92;16.83304163\\n6;16.98786798\\n6,08;17.14326985\\n6,17;17.29926017\\n6,25;17.4558574\\n6,33;17.61308542\\n6,42;17.77097356\\n6,5;17.92955656\\n6,58;18.08887399\\n6,67;18.24897012\\n6,75;18.40989435\\n6,83;18.57170012\\n6,92;18.73444512\\n7;18.89819089\\n7,08;19.06300261\\n7,17;19.22894873\\n7,25;19.39610118\\n7,33;19.56453273\\n7,42;19.73432134\\n7,5;19.90554403\\n7,58;20.07828129\\n7,67;20.25261432\\n7,75;20.42862531\\n7,83;20.60639712\\n7,92;20.7860129\\n8;20.96755499\\n8,08;21.15110555\\n8,17;21.33674635\\n8,25;21.52455736\\n8,33;21.71461721\\n8,42;21.90700268\\n8,5;22.10178826\\n8,58;22.29904589\\n8,67;22.49884459\\n8,75;22.7012502\\n8,83;22.90632506\\n8,92;23.1141277\\n9;23.32471257\\n9,08;23.53812979\\n9,17;23.75442484\\n9,25;23.97363834\\n9,33;24.19580583\\n9,42;24.4209575\\n9,5;24.64911804\\n9,58;24.88030638\\n9,67;25.11453557\\n9,75;25.35181259\\n9,83;25.59213818\\n9,92;25.83550673\\n10;26.08190616\\n10,08;26.33131782\\n10,17;26.58371638\\n10,25;26.8390698\\n10,33;27.09733925\\n10,42;27.35847906\\n10,5;27.62243677\\n10,58;27.88915304\\n10,67;28.15856107\\n10,75;28.43058954\\n10,83;28.70515783\\n10,92;28.98217994\\n11;29.26156199\\n11,08;29.5432056\\n11,17;29.82700474\\n11,25;30.11284746\\n11,33;30.4006158\\n11,42;30.69018587\\n11,5;30.98142809\\n11,58;31.27420739\\n11,67;31.56838398\\n11,75;31.8638107\\n11,83;32.16033905\\n11,92;32.45781366\\n12;32.75607548\\n12,08;33.05496144\\n12,17;33.35430482\\n12,25;33.6539355\\n12,33;33.95368036\\n12,42;34.25336333\\n12,5;34.55280676\\n12,58;34.85182934\\n12,67;35.15025041\\n12,75;35.44788577\\n12,83;35.74455149\\n12,92;36.04006296\\n13;36.33423538\\n13,08;36.62688403\\n13,17;36.91782442\\n13,25;37.20687443\\n13,33;37.49385217\\n13,42;37.77857793\\n13,5;38.06087423\\n13,58;38.34056621\\n13,67;38.61748204\\n13,75;38.89145331\\n13,83;39.16231542\\n13,92;39.42990799\\n14;39.69407521\\n14,08;39.95466626\\n14,17;40.21153565\\n14,25;40.4645436\\n14,33;40.71355642\\n14,42;40.95844577\\n14,5;41.19909297\\n14,58;41.4353838\\n14,67;41.66721226\\n14,75;41.89448008\\n14,83;42.11709702\\n14,92;42.33498116\\n15;42.54805916\\n15,08;42.7562665\\n15,17;42.95954776\\n15,25;43.1578568\\n15,33;43.35115698\\n15,42;43.53942133\\n15,5;43.72263271\\n15,58;43.90078396\\n15,67;44.07387796\\n15,75;44.24192774\\n15,83;44.40495652\\n15,92;44.5629977\\n16;44.71609485\\n16,08;44.86430165\\n16,17;45.00768175\\n16,25;45.14630867\\n16,33;45.28026556\\n16,42;45.40964499\\n16,5;45.5345486\\n16,58;45.65508683\\n16,67;45.77137845\\n16,75;45.88355015\\n16,83;45.99173597\\n16,92;46.09607679\\n17;46.19671962\\n17,08;46.29381699\\n17,17;46.38752609\\n17,25;46.47800802\\n17,33;46.56542689\\n17,42;46.64994883\\n17,5;46.73174101\\n17,58;46.81097052\\n17,67;46.88780489\\n17,75;46.96240411\\n17,83;47.03492965\\n17,92;47.10553608\\n18;47.17437139\\n18,08;47.24157543\\n18,17;47.30727836\\n18,25;47.37159889\\n18,33;47.43464251\\n18,42;47.49649958\\n18,5;47.55724333\\n18,58;47.61692775\\n18,67;47.6755854\\n18,75;47.733225\\n18,83;47.78982906\\n18,92;47.84535121\\n19;47.89971542\\n19,08;47.9528045\\n19,17;48.00447244\\n19,25;48.05452712\\n19,33;48.10273611\\n19,42;48.14881709\\n19,5;48.1924379\\n19,58;48.23321202\\n19,67;48.27069475\\n19,75;48.3043794\\n19,83;48.33369518\\n19,92;48.35799667\\n20;48.37656825\\n\\n\#\\n0;3.06486465\\n0,08;3.437628263\\n0,17;4.13899376\\n0,25;4.784820426\\n0,33;5.379141034\\n0,42;5.92588831\\n0,5;6.428828208\\n0,58;6.891533095\\n0,67;7.317373091\\n0,75;7.709516114\\n0,83;8.070932165\\n0,92;8.404399764\\n1;8.712513432\\n1,08;8.997691667\\n1,17;9.262185089\\n1,25;9.508084539\\n1,33;9.737329319\\n1,42;9.951714686\\n1,5;10.15289979\\n1,58;10.34241498\\n1,67;10.52166904\\n1,75;10.69195601\\n1,83;10.85446195\\n1,92;11.01027128\\n2;11.16037297\\n2,08;11.30566645\\n2,17;11.44696728\\n2,25;11.58501268\\n2,33;11.72046615\\n2,42;11.8539236\\n2,5;11.98591692\\n2,58;12.11691911\\n2,67;12.24734867\\n2,75;12.37757256\\n2,83;12.50791249\\n2,92;12.63864672\\n3;12.77001339\\n3,08;12.90221529\\n3,17;13.03542218\\n3,25;13.16977393\\n3,33;13.3053838\\n3,42;13.44233976\\n3,5;13.58070885\\n3,58;13.72053844\\n3,67;13.86185877\\n3,75;14.00468502\\n3,83;14.14901929\\n3,92;14.29485248\\n4;14.44216593\\n4,08;14.59093307\\n4,17;14.74112146\\n4,25;14.89269209\\n4,33;15.04560355\\n4,42;15.19981137\\n4,5;15.35526953\\n4,58;15.51193144\\n4,67;15.66975084\\n4,75;15.82868259\\n4,83;15.9886834\\n4,92;16.14971251\\n5;16.31173224\\n5,08;16.47470852\\n5,17;16.63861163\\n5,25;16.80341543\\n5,33;16.96909934\\n5,42;17.13564756\\n5,5;17.30304956\\n5,58;17.4713002\\n5,67;17.64039992\\n5,75;17.81035463\\n5,83;17.98117606\\n5,92;18.15288153\\n6;18.32549376\\n6,08;18.49904125\\n6,17;18.67355775\\n6,25;18.84908224\\n6,33;19.02565892\\n6,42;19.20333679\\n6,5;19.38216922\\n6,58;19.56221428\\n6,67;19.74353436\\n6,75;19.92619507\\n6,83;20.110266\\n6,92;20.29581981\\n7;20.48293203\\n7,08;20.67168066\\n7,17;20.86214582\\n7,25;21.05440884\\n7,33;21.24855446\\n7,42;21.44466518\\n7,5;21.64282737\\n7,58;21.84312554\\n7,67;22.04564463\\n7,75;22.25046892\\n7,83;22.45768158\\n7,92;22.6673643\\n8;22.87959773\\n8,08;23.09445998\\n8,17;23.31202608\\n8,25;23.53236883\\n8,33;23.75555744\\n8,42;23.98165745\\n8,5;24.21073043\\n8,58;24.44283365\\n8,67;24.67801969\\n8,75;24.9163362\\n8,83;25.15782551\\n8,92;25.40252443\\n9;25.65046392\\n9,08;25.90166889\\n9,17;26.15615792\\n9,25;26.41394306\\n9,33;26.67502964\\n9,42;26.93941607\\n9,5;27.20709368\\n9,58;27.47804659\\n9,67;27.75225159\\n9,75;28.029678\\n9,83;28.31028765\\n9,92;28.59403476\\n10;28.88086594\\n10,08;29.17072015\\n10,17;29.4635287\\n10,25;29.7592153\\n10,33;30.05769609\\n10,42;30.35887971\\n10,5;30.66266737\\n10,58;30.96895298\\n10,67;31.27762411\\n10,75;31.58855853\\n10,83;31.90163028\\n10,92;32.21670522\\n11;32.5336442\\n11,08;32.85229967\\n11,17;33.17251956\\n11,25;33.49414573\\n11,33;33.81701463\\n11,42;34.14095759\\n11,5;34.46580111\\n11,58;34.79136727\\n11,67;35.11747352\\n11,75;35.44393549\\n11,83;35.77056256\\n11,92;36.09716305\\n12;36.4235422\\n12,08;36.7495031\\n12,17;37.07484703\\n12,25;37.39937399\\n12,33;37.72288302\\n12,42;38.04517298\\n12,5;38.36604173\\n12,58;38.68528952\\n12,67;39.0027151\\n12,75;39.31812066\\n12,83;39.63130927\\n12,92;39.94208624\\n13;40.25025974\\n13,08;40.55564134\\n13,17;40.85804669\\n13,25;41.15729406\\n13,33;41.45320759\\n13,42;41.74561603\\n13,5;42.03435353\\n13,58;42.31926009\\n13,67;42.60018191\\n13,75;42.87697183\\n13,83;43.14948969\\n13,92;43.4176027\\n14;43.68118578\\n14,08;43.94012186\\n14,17;44.19430225\\n14,25;44.4436269\\n14,33;44.68800466\\n14,42;44.92735442\\n14,5;45.16160204\\n14,58;45.39068521\\n14,67;45.61455072\\n14,75;45.83315528\\n14,83;46.0464657\\n14,92;46.25445894\\n15;46.45712228\\n15,08;46.65445329\\n15,17;46.84645992\\n15,25;47.03316051\\n15,33;47.21458375\\n15,42;47.39076866\\n15,5;47.56176451\\n15,58;47.72763073\\n15,67;47.8884368\\n15,75;48.04426208\\n15,83;48.19519564\\n15,92;48.34133606\\n16;48.4827912\\n16,08;48.6196779\\n16,17;48.7521217\\n16,25;48.88025651\\n16,33;49.0042242\\n16,42;49.12417422\\n16,5;49.24026312\\n16,58;49.35265405\\n16,67;49.46151622\\n16,75;49.5670243\\n16,83;49.66935776\\n16,92;49.76870017\\n17;49.86523842\\n17,08;49.95916191\\n17,17;50.05066163\\n17,25;50.13992923\\n17,33;50.22715595\\n17,42;50.31253151\\n17,5;50.39624297\\n17,58;50.47847336\\n17,67;50.55939966\\n17,75;50.6391944\\n17,83;50.71801935\\n17,92;50.79602716\\n18;50.87335876\\n18,08;50.95014153\\n18,17;51.02648735\\n18,25;51.10249055\\n18,33;51.17822572\\n18,42;51.25374544\\n18,5;51.32907793\\n18,58;51.40422448\\n18,67;51.47915686\\n18,75;51.55381463\\n18,83;51.62810228\\n18,92;51.70188628\\n19;51.7749921\\n19,08;51.84720202\\n19,17;51.91824859\\n19,25;51.98781418\\n19,33;52.05553129\\n19,42;52.12097097\\n19,5;52.1836449\\n19,58;52.24300075\\n19,67;52.2984187\\n19,75;52.34920805\\n19,83;52.39460282\\n19,92;52.4337619\\n20;52.46576117\\n\\n\#\\n0;3.39918645\\n0,08;3.79752846\\n0,17;4.544776513\\n0,25;5.230584214\\n0,33;5.859960798\\n0,42;6.437587751\\n0,5;6.967850457\\n0,58;7.454854109\\n0,67;7.902436186\\n0,75;8.314178377\\n0,83;8.693418423\\n0,92;9.043261854\\n1;9.366593571\\n1,08;9.666089185\\n1,17;9.944226063\\n1,25;10.20329397\\n1,33;10.4454058\\n1,42;10.67250698\\n1,5;10.88638558\\n1,58;11.08868151\\n1,67;11.28089537\\n1,75;11.46439708\\n1,83;11.64043402\\n1,92;11.81013895\\n2;11.97453748\\n2,08;12.13455528\\n2,17;12.2910249\\n2,25;12.44469258\\n2,33;12.59622335\\n2,42;12.74620911\\n2,5;12.89517218\\n2,58;13.04357164\\n2,67;13.19180874\\n2,75;13.34022934\\n2,83;13.48913319\\n2,92;13.63877446\\n3;13.78936547\\n3,08;13.94108332\\n3,17;14.09407175\\n3,25;14.24844498\\n3,33;14.40429169\\n3,42;14.56167529\\n3,5;14.72064045\\n3,58;14.88121352\\n3,67;15.04340553\\n3,75;15.20721443\\n3,83;15.37262729\\n3,92;15.53962221\\n4;15.70817017\\n4,08;15.87823668\\n4,17;16.04978452\\n4,25;16.2227706\\n4,33;16.39715363\\n4,42;16.57289122\\n4,5;16.74994187\\n4,58;16.92826587\\n4,67;17.10782615\\n4,75;17.28858894\\n4,83;17.47052444\\n4,92;17.65360733\\n5;17.83781722\\n5,08;18.02313904\\n5,17;18.20956418\\n5,25;18.3970876\\n5,33;18.58571243\\n5,42;18.77544728\\n5,5;18.966307\\n5,58;19.15831267\\n5,67;19.35149163\\n5,75;19.54587708\\n5,83;19.74150854\\n5,92;19.93843145\\n6;20.13669623\\n6,08;20.33635961\\n6,17;20.53748298\\n6,25;20.74013277\\n6,33;20.94438028\\n6,42;21.15030093\\n6,5;21.35797332\\n6,58;21.56748045\\n6,67;21.77890902\\n6,75;21.99234686\\n6,83;22.20788541\\n6,92;22.4256177\\n7;22.64563824\\n7,08;22.86804258\\n7,17;23.09292679\\n7,25;23.32038549\\n7,33;23.55051871\\n7,42;23.78341652\\n7,5;24.01917703\\n7,58;24.25789074\\n7,67;24.49964778\\n7,75;24.74453536\\n7,83;24.99263735\\n7,92;25.24403371\\n8;25.49880264\\n8,08;25.7570168\\n8,17;26.01874261\\n8,25;26.28404312\\n8,33;26.55297507\\n8,42;26.82558904\\n8,5;27.1019295\\n8,58;27.38203422\\n8,67;27.66593402\\n8,75;27.9536524\\n8,83;28.24520531\\n8,92;28.54060085\\n9;28.83983907\\n9,08;29.14291171\\n9,17;29.44980208\\n9,25;29.76048479\\n9,33;30.0749257\\n9,42;30.39308176\\n9,5;30.71490093\\n9,58;31.0403221\\n9,67;31.36927506\\n9,75;31.7016805\\n9,83;32.03744999\\n9,92;32.37648607\\n10;32.71868225\\n10,08;33.06392318\\n10,17;33.4120847\\n10,25;33.76303402\\n10,33;34.1166299\\n10,42;34.47272283\\n10,5;34.83115524\\n10,58;35.19176177\\n10,67;35.55437176\\n10,75;35.91879976\\n10,83;36.28486194\\n10,92;36.65236365\\n11;37.02110818\\n11,08;37.39088668\\n11,17;37.76148905\\n11,25;38.1326991\\n11,33;38.50429603\\n11,42;38.87605489\\n11,5;39.24774707\\n11,58;39.61914076\\n11,67;39.98999994\\n11,75;40.36009244\\n11,83;40.72917544\\n11,92;41.09701099\\n12;41.46335907\\n12,08;41.82797963\\n12,17;42.19063313\\n12,25;42.55108107\\n12,33;42.90908653\\n12,42;43.2644155\\n12,5;43.61683402\\n12,58;43.9661169\\n12,67;44.31203579\\n12,75;44.65437319\\n12,83;44.99291356\\n12,92;45.32744704\\n13;45.65777013\\n13,08;45.98368656\\n13,17;46.30500858\\n13,25;46.62155183\\n13,33;46.93314404\\n13,42;47.23962058\\n13,5;47.54082604\\n13,58;47.83661466\\n13,67;48.12685082\\n13,75;48.41140938\\n13,83;48.69017613\\n13,92;48.9630481\\n14;49.22993391\\n14,08;49.49075409\\n14,17;49.74544132\\n14,25;49.99394068\\n14,33;50.23620985\\n14,42;50.47222213\\n14,5;50.70195581\\n14,58;50.92540942\\n14,67;51.14259229\\n14,75;51.3535268\\n14,83;51.55824831\\n14,92;51.75680513\\n15;51.94925841\\n15,08;52.13568193\\n15,17;52.31616197\\n15,25;52.49079703\\n15,33;52.65969757\\n15,42;52.82298572\\n15,5;52.9807949\\n15,58;53.13326946\\n15,67;53.28056425\\n15,75;53.42284417\\n15,83;53.5602837\\n15,92;53.69306637\\n16;53.82138422\\n16,08;53.94543725\\n16,17;54.06543278\\n16,25;54.18158486\\n16,33;54.29411356\\n16,42;54.40324431\\n16,5;54.50920717\\n16,58;54.61223603\\n16,67;54.71256787\\n16,75;54.81044184\\n16,83;54.90609842\\n16,92;54.99977846\\n17;55.09172217\\n17,08;55.18216811\\n17,17;55.271352\\n17,25;55.35950558\\n17,33;55.44685531\\n17,42;55.53362107\\n17,5;55.62001464\\n17,58;55.70623826\\n17,67;55.79247939\\n17,75;55.87892356\\n17,83;55.96573022\\n17,92;56.05304601\\n18;56.14099882\\n18,08;56.22969564\\n18,17;56.3192203\\n18,25;56.40963105\\n18,33;56.50095811\\n18,42;56.59320107\\n18,5;56.68632619\\n18,58;56.78026364\\n18,67;56.87490465\\n18,75;56.97009856\\n18,83;57.06564989\\n18,92;57.16131528\\n19;57.25679821\\n19,08;57.35175792\\n19,17;57.44578172\\n19,25;57.53840429\\n19,33;57.62910094\\n19,42;57.7172758\\n19,5;57.80226553\\n19,58;57.88333502\\n19,67;57.95967458\\n19,75;58.0303973\\n19,83;58.09453209\\n19,92;58.15103575\\n20;58.1987714\\n\\n\#\\n0;3.717519384\\n0,08;4.145593668\\n0,17;4.946765504\\n0,25;5.680083196\\n0,33;6.351511983\\n0,42;6.966523789\\n0,5;7.53018045\\n0,58;8.047178246\\n0,67;8.52187726\\n0,75;8.958324062\\n0,83;9.360270982\\n0,92;9.7311934\\n1;10.07430572\\n1,08;10.39257636\\n1,17;10.68874201\\n1,25;10.96532105\\n1,33;11.2246268\\n1,42;11.46877937\\n1,5;11.69971783\\n1,58;11.91921144\\n1,67;12.1288704\\n1,75;12.3301562\\n1,83;12.52439148\\n1,92;12.71276942\\n2;12.89636272\\n2,08;13.07613212\\n2,17;13.25293458\\n2,25;13.42753123\\n2,33;13.60059358\\n2,42;13.77271274\\n2,5;13.94440383\\n2,58;14.11611337\\n2,67;14.28822545\\n2,75;14.46106492\\n2,83;14.6349076\\n2,92;14.80998135\\n3;14.98647034\\n3,08;15.16452247\\n3,17;15.34425164\\n3,25;15.52574208\\n3,33;15.7090529\\n3,42;15.89421842\\n3,5;16.08125551\\n3,58;16.27016402\\n3,67;16.4609302\\n3,75;16.65352914\\n3,83;16.84792719\\n3,92;17.04408407\\n4;17.24195488\\n4,08;17.44149184\\n4,17;17.64264736\\n4,25;17.84537017\\n4,33;18.04961414\\n4,42;18.25533469\\n4,5;18.46249096\\n4,58;18.67104666\\n4,67;18.88097086\\n4,75;19.09223862\\n4,83;19.30483153\\n4,92;19.51873814\\n5;19.73395429\\n5,08;19.95048336\\n5,17;20.16833747\\n5,25;20.38753372\\n5,33;20.60809964\\n5,42;20.83006969\\n5,5;21.05348599\\n5,58;21.27839816\\n5,67;21.50486316\\n5,75;21.7329446\\n5,83;21.96271325\\n5,92;22.19424627\\n6;22.42762598\\n6,08;22.66294138\\n6,17;22.90028597\\n6,25;23.13975807\\n6,33;23.38146064\\n6,42;23.62550009\\n6,5;23.87198507\\n6,58;24.12102802\\n6,67;24.37274421\\n6,75;24.62724833\\n6,83;24.88465774\\n6,92;25.14508981\\n7;25.40866182\\n7,08;25.67549032\\n7,17;25.94569055\\n7,25;26.21937378\\n7,33;26.49665657\\n7,42;26.77764034\\n7,5;27.06243533\\n7,58;27.35113996\\n7,67;27.64385046\\n7,75;27.94065757\\n7,83;28.24164611\\n7,92;28.54689431\\n8;28.85647669\\n8,08;29.17045929\\n8,17;29.4888987\\n8,25;29.8118461\\n8,33;30.13934341\\n8,42;30.47142364\\n8,5;30.80811106\\n8,58;31.14942058\\n8,67;31.49535747\\n8,75;31.8459171\\n8,83;32.20108468\\n8,92;32.56083507\\n9;32.92513255\\n9,08;33.29393074\\n9,17;33.66717239\\n9,25;34.04478937\\n9,33;34.42670255\\n9,42;34.8128218\\n9,5;35.20304599\\n9,58;35.59726302\\n9,67;35.99534989\\n9,75;36.3971728\\n9,83;36.80258726\\n9,92;37.21143829\\n10;37.62356058\\n10,08;38.03877869\\n10,17;38.45690737\\n10,25;38.87775177\\n10,33;39.30110778\\n10,42;39.72676238\\n10,5;40.15449395\\n10,58;40.58407272\\n10,67;41.01526401\\n10,75;41.44781609\\n10,83;41.88148136\\n10,92;42.31600037\\n11;42.75111318\\n11,08;43.18654635\\n11,17;43.62202704\\n11,25;44.05727678\\n11,33;44.49201341\\n11,42;44.92595166\\n11,5;45.35880379\\n11,58;45.79028017\\n11,67;46.22008796\\n11,75;46.64794172\\n11,83;47.07354407\\n11,92;47.4966064\\n12;47.91683947\\n12,08;48.33395608\\n12,17;48.74767177\\n12,25;49.15770541\\n12,33;49.56377988\\n12,42;49.96562365\\n12,5;50.36296721\\n12,58;50.75555403\\n12,67;51.14312509\\n12,75;51.52543729\\n12,83;51.90225139\\n12,92;52.273337\\n13;52.63847339\\n13,08;52.99745045\\n13,17;53.35007037\\n13,25;53.69614073\\n13,33;54.03548596\\n13,42;54.36794129\\n13,5;54.69335479\\n13,58;55.01158787\\n13,67;55.32251577\\n13,75;55.62602801\\n13,83;55.9220288\\n13,92;56.21043748\\n14;56.49118881\\n14,08;56.76423337\\n14,17;57.02953776\\n14,25;57.2870849\\n14,33;57.53687418\\n14,42;57.77892568\\n14,5;58.01326503\\n14,58;58.23994486\\n14,67;58.45903143\\n14,75;58.67060766\\n14,83;58.87477302\\n14,92;59.07164337\\n15;59.26135066\\n15,08;59.44404265\\n15,17;59.61988254\\n15,25;59.78904852\\n15,33;59.95173329\\n15,42;60.10814351\\n15,5;60.25849917\\n15,58;60.40303292\\n15,67;60.54198938\\n15,75;60.67562433\\n15,83;60.80420388\\n15,92;60.92800363\\n16;61.04730771\\n16,08;61.16240788\\n16,17;61.27360245\\n16,25;61.38119533\\n16,33;61.48549489\\n16,42;61.58681291\\n16,5;61.68546339\\n16,58;61.7817614\\n16,67;61.87602186\\n16,75;61.96855832\\n16,83;62.05968162\\n16,92;62.14969862\\n17;62.23891075\\n17,08;62.32761268\\n17,17;62.41609075\\n17,25;62.50462147\\n17,33;62.59346994\\n17,42;62.68288814\\n17,5;62.77311319\\n17,58;62.86436555\\n17,67;62.95684135\\n17,75;63.05073398\\n17,83;63.14619584\\n17,92;63.24336091\\n18;63.34233618\\n18,08;63.44319934\\n18,17;63.54599643\\n18,25;63.65073939\\n18,33;63.75740358\\n18,42;63.86592525\\n18,5;63.97619897\\n18,58;64.08807505\\n18,67;64.20135697\\n18,75;64.31579883\\n18,83;64.43110284\\n18,92;64.54691678\\n19;64.66282755\\n19,08;64.77837954\\n19,17;64.89303137\\n19,25;65.00619161\\n19,33;65.11720439\\n19,42;65.22534243\\n19,5;65.32980994\\n19,58;65.42973979\\n19,67;65.52419173\\n19,75;65.61215061\\n19,83;65.69251821\\n19,92;65.76413346\\n20;65.8257417\\n\\n\#\\n0;3.992572231\\n0,08;4.450125603\\n0,17;5.305632496\\n0,25;6.08764077\\n0,33;6.802769825\\n0,42;7.45711879\\n0,5;8.056331004\\n0,58;8.605635546\\n0,67;9.109878097\\n0,75;9.573546299\\n0,83;10.00079194\\n0,92;10.3954511\\n1;10.76106284\\n1,08;11.10088678\\n1,17;11.4179197\\n1,25;11.7149113\\n1,33;11.99437938\\n1,42;12.258624\\n1,5;12.50974133\\n1,58;12.74963667\\n1,67;12.98003694\\n1,75;13.20250263\\n1,83;13.41843913\\n1,92;13.62910755\\n2;13.8356351\\n2,08;14.03902484\\n2,17;14.24016506\\n2,25;14.43983825\\n2,33;14.63872906\\n2,42;14.83743315\\n2,5;15.03646393\\n2,58;15.23626013\\n2,67;15.43719269\\n2,75;15.63957012\\n2,83;15.8436466\\n2,92;16.04962601\\n3;16.25766706\\n3,08;16.46788956\\n3,17;16.68037834\\n3,25;16.89518784\\n3,33;17.11234657\\n3,42;17.33185956\\n3,5;17.55371382\\n3,58;17.77788046\\n3,67;18.00431807\\n3,75;18.23297548\\n3,83;18.46379435\\n3,92;18.69671155\\n4;18.9316613\\n4,08;19.16857713\\n4,17;19.40739437\\n4,25;19.64804889\\n4,33;19.8904825\\n4,42;20.13464164\\n4,5;20.38047905\\n4,58;20.62795467\\n4,67;20.87703643\\n4,75;21.12770084\\n4,83;21.37993353\\n4,92;21.63372961\\n5;21.88909396\\n5,08;22.14604136\\n5,17;22.40459718\\n5,25;22.66479513\\n5,33;22.92668027\\n5,42;23.19030686\\n5,5;23.45573857\\n5,58;23.72304816\\n5,67;23.99231712\\n5,75;24.263635\\n5,83;24.53709941\\n5,92;24.8128152\\n6;25.09089343\\n6,08;25.3714519\\n6,17;25.65461346\\n6,25;25.94050589\\n6,33;26.22926131\\n6,42;26.52101516\\n6,5;26.815905\\n6,58;27.11407112\\n6,67;27.41565556\\n6,75;27.72079958\\n6,83;28.02964533\\n6,92;28.3423338\\n7;28.65900443\\n7,08;28.97979428\\n7,17;29.30483741\\n7,25;29.63426278\\n7,33;29.96819988\\n7,42;30.30676532\\n7,5;30.65007797\\n7,58;30.99824532\\n7,67;31.3513695\\n7,75;31.70954484\\n7,83;32.07285742\\n7,92;32.44138436\\n8;32.81519554\\n8,08;33.19435025\\n8,17;33.5788965\\n8,25;33.9688734\\n8,33;34.3643086\\n8,42;34.76521834\\n8,5;35.17160751\\n8,58;35.58346914\\n8,67;36.00078421\\n8,75;36.42352136\\n8,83;36.85163675\\n8,92;37.28507392\\n9;37.72376365\\n9,08;38.16762389\\n9,17;38.61655976\\n9,25;39.0704635\\n9,33;39.52921454\\n9,42;39.99267955\\n9,5;40.46071256\\n9,58;40.9331551\\n9,67;41.40983639\\n9,75;41.89057352\\n9,83;42.37517172\\n9,92;42.86342465\\n10;43.35511467\\n10,08;43.85001322\\n10,17;44.34788119\\n10,25;44.84846931\\n10,33;45.35151857\\n10,42;45.8567607\\n10,5;46.36391866\\n10,58;46.87270712\\n10,67;47.38283479\\n10,75;47.89399722\\n10,83;48.40589011\\n10,92;48.91819978\\n11;49.43061053\\n11,08;49.94279684\\n11,17;50.45443246\\n11,25;50.96518685\\n11,33;51.47472671\\n11,42;51.98271665\\n11,5;52.48881992\\n11,58;52.99269914\\n11,67;53.49401569\\n11,75;53.99243685\\n11,83;54.48762378\\n11,92;54.97924502\\n12;55.4669708\\n12,08;55.9504751\\n12,17;56.42943635\\n12,25;56.90353811\\n12,33;57.37246984\\n12,42;57.83592807\\n12,5;58.29361488\\n12,58;58.74524431\\n12,67;59.19053344\\n12,75;59.62921442\\n12,83;60.06102656\\n12,92;60.48572025\\n13;60.90305741\\n13,08;61.31281247\\n13,17;61.71477365\\n13,25;62.10873877\\n13,33;62.49452276\\n13,42;62.87195405\\n13,5;63.24087599\\n13,58;63.60114743\\n13,67;63.95264314\\n13,75;64.29525433\\n13,83;64.62888901\\n13,92;64.95347244\\n14;65.26894746\\n14,08;65.57527484\\n14,17;65.87243353\\n14,25;66.16042095\\n14,33;66.43925318\\n14,42;66.70896797\\n14,5;66.96961412\\n14,58;67.22126661\\n14,67;67.46401722\\n14,75;67.69797665\\n14,83;67.92327441\\n14,92;68.14005866\\n15;68.34849595\\n15,08;68.5487709\\n15,17;68.74108582\\n15,25;68.92566027\\n15,33;69.10273048\\n15,42;69.27254876\\n15,5;69.43538282\\n15,58;69.59151495\\n15,67;69.74124122\\n15,75;69.8848705\\n15,83;70.0227235\\n15,92;70.15513163\\n16;70.28243588\\n16,08;70.40498554\\n16,17;70.52313696\\n16,25;70.63725215\\n16,33;70.74769732\\n16,42;70.85484146\\n16,5;70.95905471\\n16,58;71.06070688\\n16,67;71.16016568\\n16,75;71.25779513\\n16,83;71.35395381\\n16,92;71.44899305\\n17;71.54325519\\n17,08;71.63707172\\n17,17;71.73076142\\n17,25;71.82462845\\n17,33;71.91896047\\n17,42;72.01402668\\n17,5;72.11007585\\n17,58;72.20733438\\n17,67;72.3059993\\n17,75;72.40625667\\n17,83;72.50824833\\n17,92;72.61209121\\n18;72.71786996\\n18,08;72.82563495\\n18,17;72.93540037\\n18,25;73.04714239\\n18,33;73.16079731\\n18,42;73.27625982\\n18,5;73.39338138\\n18,58;73.51196857\\n18,67;73.63178167\\n18,75;73.75253327\\n18,83;73.87388701\\n18,92;73.99545642\\n19;74.11679995\\n19,08;74.23743894\\n19,17;74.35682105\\n19,25;74.47435424\\n19,33;74.58938617\\n19,42;74.70121281\\n19,5;74.80907365\\n19,58;74.91215216\\n19,67;75.00957518\\n19,75;75.10041216\\n19,83;75.18366937\\n19,92;75.25830602\\n20;75.32321054\\n\\n\#\\nage [years];95th\\n0;4.152636594\\n0,08;4.628836382\\n0,17;5.51916925\\n0,25;6.332837055\\n0,33;7.076722522\\n0,42;7.757233948\\n0,5;8.380329759\\n0,58;8.951543685\\n0,67;9.476008728\\n0,75;9.958479736\\n0,83;10.40335475\\n0,92;10.81469528\\n1;11.19624565\\n1,08;11.5514514\\n1,17;11.88347697\\n1,25;12.19522253\\n1,33;12.48934\\n1,42;12.76824867\\n1,5;13.03414978\\n1,58;13.28904061\\n1,67;13.53472797\\n1,75;13.77284102\\n1,83;14.00484351\\n1,92;14.23204547\\n2;14.45561433\\n2,08;14.67658549\\n2,17;14.89587242\\n2,25;15.1142761\\n2,33;15.33249457\\n2,42;15.55113065\\n2,5;15.770701\\n2,58;15.99164336\\n2,67;16.21432377\\n2,75;16.43904429\\n2,83;16.66604785\\n2,92;16.89552564\\n3;17.12762297\\n3,08;17.3624437\\n3,17;17.60005585\\n3,25;17.84049621\\n3,33;18.08377443\\n3,42;18.329878\\n3,5;18.57877485\\n3,58;18.83041754\\n3,67;19.08474635\\n3,75;19.34169227\\n3,83;19.60117968\\n3,92;19.86312888\\n4;20.12745836\\n4,08;20.3940868\\n4,17;20.66293462\\n4,25;20.93392691\\n4,33;21.20699305\\n4,42;21.48206912\\n4,5;21.75909881\\n4,58;22.0380343\\n4,67;22.31883709\\n4,75;22.60147865\\n4,83;22.88594093\\n4,92;23.17221677\\n5;23.46031012\\n5,08;23.75023626\\n5,17;24.04202158\\n5,25;24.33570429\\n5,33;24.63133325\\n5,42;24.92896835\\n5,5;25.22868007\\n5,58;25.5305491\\n5,67;25.83466581\\n5,75;26.14112991\\n5,83;26.45004964\\n5,92;26.76154129\\n6;27.07572865\\n6,08;27.39274198\\n6,17;27.71271759\\n6,25;28.03579694\\n6,33;28.36212579\\n6,42;28.69185351\\n6,5;29.02513239\\n6,58;29.36211644\\n6,67;29.70296069\\n6,75;30.04782073\\n6,83;30.39685131\\n6,92;30.75020585\\n7;31.10803553\\n7,08;31.47048848\\n7,17;31.83770901\\n7,25;32.2098371\\n7,33;32.58700628\\n7,42;32.96934568\\n7,5;33.35697585\\n7,58;33.75001097\\n7,67;34.14855665\\n7,75;34.55270981\\n7,83;34.96255799\\n7,92;35.37817885\\n8;35.79963916\\n8,08;36.2269949\\n8,17;36.66029091\\n8,25;37.09955982\\n8,33;37.54482215\\n8,42;37.99608589\\n8,5;38.45334608\\n8,58;38.91658465\\n8,67;39.38577014\\n8,75;39.86085756\\n8,83;40.3417882\\n8,92;40.82848957\\n9;41.32087531\\n9,08;41.8188452\\n9,17;42.32228515\\n9,25;42.83106725\\n9,33;43.34504991\\n9,42;43.86407795\\n9,5;44.38798278\\n9,58;44.91658265\\n9,67;45.44968284\\n9,75;45.98707597\\n9,83;46.52854232\\n9,92;47.07385017\\n10;47.62275619\\n10,08;48.17500585\\n10,17;48.73033386\\n10,25;49.28846466\\n10,33;49.84911291\\n10,42;50.41198402\\n10,5;50.9767747\\n10,58;51.54317357\\n10,67;52.11086123\\n10,75;52.67951305\\n10,83;53.2487963\\n10,92;53.81837358\\n11;54.38790173\\n11,08;54.95703466\\n11,17;55.52542195\\n11,25;56.0927106\\n11,33;56.65854557\\n11,42;57.22257051\\n11,5;57.78442851\\n11,58;58.34376285\\n11,67;58.90021802\\n11,75;59.45343918\\n11,83;60.00307549\\n11,92;60.5487783\\n12;61.09020319\\n12,08;61.62701045\\n12,17;62.15886584\\n12,25;62.68544133\\n12,33;63.20641583\\n12,42;63.72147556\\n12,5;64.2303163\\n12,58;64.73264089\\n12,67;65.22816347\\n12,75;65.7166078\\n12,83;66.19770861\\n12,92;66.67121259\\n13;67.13687835\\n13,08;67.59447719\\n13,17;68.04379345\\n13,25;68.4846261\\n13,33;68.91678763\\n13,42;69.34010551\\n13,5;69.75442235\\n13,58;70.15959636\\n13,67;70.55550168\\n13,75;70.94202872\\n13,83;71.31908448\\n13,92;71.68659282\\n14;72.04449469\\n14,08;72.39274832\\n14,17;72.73132942\\n14,25;73.06023127\\n14,33;73.37946482\\n14,42;73.68905842\\n14,5;73.98905915\\n14,58;74.27953085\\n14,67;74.5605553\\n14,75;74.83223179\\n14,83;75.09467698\\n14,92;75.34802466\\n15;75.5924255\\n15,08;75.82804673\\n15,17;76.05507182\\n15,25;76.27369999\\n15,33;76.48414576\\n15,42;76.68663841\\n15,5;76.88142138\\n15,58;77.06875157\\n15,67;77.24889863\\n15,75;77.42214413\\n15,83;77.58878071\\n15,92;77.74911109\\n16;77.90344707\\n16,08;78.05210841\\n16,17;78.19542171\\n16,25;78.33371911\\n16,33;78.46733702\\n16,42;78.59661472\\n16,5;78.72189292\\n16,58;78.84351231\\n16,67;78.96181194\\n16,75;79.07712765\\n16,83;79.18979044\\n16,92;79.30012477\\n17;79.40844685\\n17,08;79.51506292\\n17,17;79.62026752\\n17,25;79.72434173\\n17,33;79.82755144\\n17,42;79.9301456\\n17,5;80.03235456\\n17,58;80.13438837\\n17,67;80.23643485\\n17,75;80.33865934\\n17,83;80.44120111\\n17,92;80.54417335\\n18;80.64766146\\n18,08;80.75172168\\n18,17;80.85638\\n18,25;80.96163098\\n18,33;81.06743678\\n18,42;81.17372627\\n18,5;81.28039424\\n18,58;81.38730069\\n18,67;81.49427023\\n18,75;81.60109165\\n18,83;81.70751748\\n18,92;81.8132637\\n19;81.91800816\\n19,08;82.02139464\\n19,17;82.12302792\\n19,25;82.22248225\\n19,33;82.3192791\\n19,42;82.41291688\\n19,5;82.50285304\\n19,58;82.58850833\\n19,67;82.66926695\\n19,75;82.74447678\\n19,83;82.81344962\\n19,92;82.87546122\\n20;82.92975179\\n\\n\#\\n0;4.254922004\\n0,08;4.743581789\\n0,17;5.657379108\\n0,25;6.492574414\\n0,33;7.256165568\\n0,42;7.954730061\\n0,5;8.59441348\\n0,58;9.180938407\\n0,67;9.719620693\\n0,75;10.2153883\\n0,83;10.67280092\\n0,92;11.0960696\\n1;11.48907597\\n1,08;11.85539095\\n1,17;12.19829279\\n1,25;12.52078451\\n1,33;12.82561033\\n1,42;13.11527219\\n1,5;13.39204468\\n1,58;13.65798985\\n1,67;13.91497124\\n1,75;14.1646673\\n1,83;14.40858419\\n1,92;14.64806798\\n2;14.88431632\\n2,08;15.11838945\\n2,17;15.35122084\\n2,25;15.58362686\\n2,33;15.8163176\\n2,42;16.0499034\\n2,5;16.28490586\\n2,58;16.52176469\\n2,67;16.76084508\\n2,75;17.00244749\\n2,83;17.24680927\\n2,92;17.49411514\\n3;17.74450372\\n3,08;17.9980699\\n3,17;18.25487219\\n3,25;18.51493707\\n3,33;18.77826268\\n3,42;19.04482627\\n3,5;19.31458378\\n3,58;19.58747608\\n3,67;19.86343169\\n3,75;20.14236985\\n3,83;20.42420335\\n3,92;20.70884106\\n4;20.99619028\\n4,08;21.28615884\\n4,17;21.57865549\\n4,25;21.8735972\\n4,33;22.17090276\\n4,42;22.47049907\\n4,5;22.7723211\\n4,58;23.07631287\\n4,67;23.3824283\\n4,75;23.69063187\\n4,83;24.00089913\\n4,92;24.31321719\\n5;24.62758492\\n5,08;24.94401317\\n5,17;25.26252369\\n5,25;25.5831532\\n5,33;25.90594748\\n5,42;26.23096473\\n5,5;26.55827443\\n5,58;26.88795694\\n5,67;27.2201029\\n5,75;27.55481321\\n5,83;27.89219758\\n5,92;28.2323743\\n6;28.57547042\\n6,08;28.92161906\\n6,17;29.27096042\\n6,25;29.62364011\\n6,33;29.97980811\\n6,42;30.33961853\\n6,5;30.70322948\\n6,58;31.07080008\\n6,67;31.44248988\\n6,75;31.81846107\\n6,83;32.19887352\\n6,92;32.58388611\\n7;32.97365535\\n7,08;33.3683346\\n7,17;33.76807319\\n7,25;34.17301785\\n7,33;34.5833014\\n7,42;34.99906317\\n7,5;35.42042208\\n7,58;35.84749737\\n7,67;36.28039703\\n7,75;36.71922013\\n7,83;37.16405609\\n7,92;37.61498429\\n8;38.07206991\\n8,08;38.53536809\\n8,17;39.00492396\\n8,25;39.48076746\\n8,33;39.96291669\\n8,42;40.45137672\\n8,5;40.94613881\\n8,58;41.44718044\\n8,67;41.95446506\\n8,75;42.46794195\\n8,83;42.98754609\\n8,92;43.51319807\\n9;44.04480409\\n9,08;44.58225593\\n9,17;45.12543098\\n9,25;45.67419242\\n9,33;46.22838923\\n9,42;46.78785646\\n9,5;47.3524154\\n9,58;47.92187383\\n9,67;48.49602631\\n9,75;49.07465451\\n9,83;49.65752758\\n9,92;50.24440253\\n10;50.83502464\\n10,08;51.42912799\\n10,17;52.02643587\\n10,25;52.62666135\\n10,33;53.22950783\\n10,42;53.8346696\\n10,5;54.44183245\\n10,58;55.0506743\\n10,67;55.66086287\\n10,75;56.27206944\\n10,83;56.88394797\\n10,92;57.49615297\\n11;58.10832895\\n11,08;58.72012509\\n11,17;59.33118206\\n11,25;59.94113978\\n11,33;60.54963673\\n11,42;61.15631078\\n11,5;61.76079992\\n11,58;62.36274309\\n11,67;62.96178288\\n11,75;63.55755646\\n11,83;64.14971608\\n11,92;64.73791012\\n12;65.32179369\\n12,08;65.90102746\\n12,17;66.47527837\\n12,25;67.04422046\\n12,33;67.60753554\\n12,42;68.16491273\\n12,5;68.7160548\\n12,58;69.26066574\\n12,67;69.7984699\\n12,75;70.32919455\\n12,83;70.85258197\\n12,92;71.36838696\\n13;71.87637634\\n13,08;72.37632936\\n13,17;72.86803693\\n13,25;73.35131006\\n13,33;73.82596855\\n13,42;74.2918484\\n13,5;74.74880046\\n13,58;75.19669066\\n13,67;75.63540025\\n13,75;76.0648259\\n13,83;76.48487978\\n13,92;76.8954897\\n14;77.29659902\\n14,08;77.68816668\\n14,17;78.0701671\\n14,25;78.44259001\\n14,33;78.80544037\\n14,42;79.15873364\\n14,5;79.5025122\\n14,58;79.83682168\\n14,67;80.16172522\\n14,75;80.47729968\\n14,83;80.78363524\\n14,92;81.08083497\\n15;81.36901438\\n15,08;81.64830091\\n15,17;81.91883344\\n15,25;82.18076174\\n15,33;82.43424593\\n15,42;82.67945587\\n15,5;82.91657062\\n15,58;83.1457778\\n15,67;83.36727297\\n15,75;83.581259\\n15,83;83.78794544\\n15,92;83.98754779\\n16;84.18028693\\n16,08;84.36638832\\n16,17;84.54608137\\n16,25;84.71959869\\n16,33;84.88717537\\n16,42;85.04904822\\n16,5;85.205455\\n16,58;85.35663368\\n16,67;85.50282159\\n16,75;85.64425466\\n16,83;85.78116658\\n16,92;85.91378798\\n17;86.04234557\\n17,08;86.16706131\\n17,17;86.28815157\\n17,25;86.40582627\\n17,33;86.52028803\\n17,42;86.63173131\\n17,5;86.74034162\\n17,58;86.84629466\\n17,67;86.9497625\\n17,75;87.05088422\\n17,83;87.14980899\\n17,92;87.24666536\\n18;87.34156823\\n18,08;87.43461808\\n18,17;87.52590032\\n18,25;87.61548453\\n18,33;87.70342388\\n18,42;87.78975439\\n18,5;87.87449436\\n18,58;87.95764367\\n18,67;88.03918325\\n18,75;88.11907438\\n18,83;88.19725823\\n18,92;88.27365525\\n19;88.34816753\\n19,08;88.42066003\\n19,17;88.49100174\\n19,25;88.55903385\\n19,33;88.62454872\\n19,42;88.68734305\\n19,5;88.74718402\\n19,58;88.80381758\\n19,67;88.85696942\\n19,75;88.90634626\\n19,83;88.95164479\\n19,92;88.99252982\\n20;89.02866893\\n\\n\#\\nnull\\n\#\\n&#xD;
chart.xAxis.tickLabelsVisible=true&#xD;
chart.visible=false&#xD;
chart.plot.orientation=0&#xD;
chart.marker.color=-8355712&#xD;
chart.title.color=-16777216&#xD;
chart.series.names=3rd_b;5th_b;10th_b;25th_b;50th_b;75th_b;90th_b;95th_b;97th_b;3rd_g;5th_g;10th_g;25th_g;50th_g;75th_g;90th_g;95th_g;97th_g;weight;&#xD;
chart.yAxis.color=-16750900&#xD;
chart.xAxis.label=Age [Année]&#xD;
chart.series.paint=-65536;-52480;-26368;-16711936;-16738048;-16711936;-26368;-52480;-65536;-65536;-52480;-39424;-16711936;-16738048;-16711936;-26368;-52480;-65536;-16777216;&#xD;
chart.type=1&#xD;
chart.yAxis.ticksVisible=true&#xD;
chart.yAxis.tickLabelsVisible=true&#xD;
chart.antiAlias=true&#xD;
chart.background.color=-1&#xD;
chart.series.limit=0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;&#xD;
chart.title.text=Poids selon Âge&#xD;
chart.title.size=18.0&#xD;
chart.series.sinceWhen=null;null;null;null;null;null;null;null;null;null;null;null;null;null;null;null;null;null;null;&#xD;
chart.xAxis.color=-16750900&#xD;
chart.plot.outline.color=-16777216&#xD;
chart.marker.alpha=0.8&#xD;
chart.showLegend=false&#xD;
chart.plot.background.color=-3355393&#xD;
chart.series.shape=0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;1;</structure>
    <border>false,0,0,0,255</border>
    <background>false,238,238,238,255</background>
    <fontStyle />
    <fontSize>12</fontSize>
    <fontFamily>Dialog</fontFamily>
    <fontColor>true,0,0,0,255</fontColor>
    <hAlign>default</hAlign>
    <vAlign>default</vAlign>
  </component>
  <component xCoord="5" yCoord="4" xSize="1" ySize="1" key="tfHeight" value="0" storeInDB="true" showInHistory="true" historyIndex="0.0" labelPosition="none" labelText="Taille [cm] :">
    <type>lu.tudor.santec.gecamed.formeditor.gui.component.EditableNumericTextField</type>
    <script eventTypeId="13">
      <scriptCode>getBMI();</scriptCode>
    </script>
    <structure />
    <border>false,0,0,0,255</border>
    <background>true,255,255,255,255</background>
    <fontStyle>b</fontStyle>
    <fontSize>12</fontSize>
    <fontFamily>Dialog</fontFamily>
    <fontColor>true,0,0,0,255</fontColor>
    <hAlign>default</hAlign>
    <vAlign>default</vAlign>
  </component>
  <component xCoord="5" yCoord="3" xSize="1" ySize="1" key="Label_2" value="Taille [cm] :" storeInDB="false" showInHistory="false" historyIndex="0.0" labelPosition="none" labelText="">
    <type>lu.tudor.santec.gecamed.formeditor.gui.component.EditableLabel</type>
    <structure />
    <border>false,0,0,0,255</border>
    <background>false,238,238,238,255</background>
    <fontStyle>b</fontStyle>
    <fontSize>12</fontSize>
    <fontFamily>Dialog</fontFamily>
    <fontColor>true,0,0,0,255</fontColor>
    <hAlign>default</hAlign>
    <vAlign>default</vAlign>
  </component>
  <component xCoord="11" yCoord="8" xSize="3" ySize="1" key="chart_height" value="" storeInDB="false" showInHistory="false" historyIndex="0.0" labelPosition="none" labelText="">
    <type>lu.tudor.santec.gecamed.formeditor.gui.component.EditableChart</type>
    <script eventTypeId="13">
      <scriptCode>manipulateChart(event.getSource());</scriptCode>
    </script>
    <structure>#&#xD;
#Fri Mar 16 13:42:05 CET 2012&#xD;
chart.yAxis.label=Taille [cm]&#xD;
chart.xAxis.autoRange=true&#xD;
chart.title.posture=0.2&#xD;
chart.series.referencingComponents=NULL;NULL;NULL;NULL;NULL;NULL;NULL;NULL;NULL;NULL;NULL;NULL;NULL;NULL;NULL;NULL;NULL;NULL;NULL;NULL;NULL;NULL;NULL;NULL;NULL;NULL;NULL;NULL;NULL;NULL;NULL;NULL;NULL;NULL;NULL;NULL;measuringDate-tfHeight;&#xD;
chart.marker.range=0.800000011920929&#xD;
chart.xAxis.ticksVisible=true&#xD;
chart.border.color=-16777216&#xD;
chart.series.staticData=0;45.00612553\\n0,08;48.04973769\\n0,17;52.26116691\\n0,25;55.32153252\\n0,33;57.78649885\\n0,42;59.88038198\\n0,5;61.71780444\\n0,58;63.36584892\\n0,67;64.86744574\\n0,75;66.25187348\\n0,83;67.54007513\\n0,92;68.7475992\\n1;69.88633417\\n1,08;70.96559835\\n1,17;71.99284334\\n1,25;72.97413192\\n1,33;73.91447032\\n1,42;74.81804561\\n1,5;75.68839929\\n1,58;76.52855656\\n1,67;77.3411245\\n1,75;78.12836755\\n1,83;78.8922666\\n1,92;79.63456346\\n2;80.35680765\\n2,08;81.06037074\\n2,17;81.8052937\\n2,25;82.5341574\\n2,33;83.24845648\\n2,42;83.94944982\\n2,5;84.63819399\\n2,58;85.31558277\\n2,67;85.98238019\\n2,75;86.63925011\\n2,83;87.28678276\\n2,92;87.92551862\\n3;88.55596799\\n\\n\#\\n0;45.63915075\\n0,08;48.6209095\\n0,17;52.781234\\n0,25;55.82492468\\n0,33;58.28692327\\n0,42;60.38480884\\n0,5;62.23030651\\n0,58;63.889034\\n0,67;65.40309649\\n0,75;66.80126999\\n0,83;68.10417305\\n0,92;69.32713403\\n1;70.48188777\\n1,08;71.57764016\\n1,17;72.62175913\\n1,25;73.6202435\\n1,33;74.57804959\\n1,42;75.49932478\\n1,5;76.38757841\\n1,58;77.2458093\\n1,67;78.07660252\\n1,75;78.88220395\\n1,83;79.66457861\\n1,92;80.42545568\\n2;81.16637022\\n2,08;81.88868489\\n2,17;82.63445202\\n2,25;83.36406112\\n2,33;84.07898582\\n2,42;84.78045262\\n2,5;85.46948449\\n2,58;86.1469433\\n2,67;86.81356554\\n2,75;87.46999332\\n2,83;88.11680155\\n2,92;88.75452162\\n3;89.38366128\\n\\n\#\\n0;46.60925664\\n0,08;49.506962\\n0,17;53.59708281\\n0,25;56.61840131\\n0,33;59.07746094\\n0,42;61.18237422\\n0,5;63.04073288\\n0,58;64.71604295\\n0,67;66.24921112\\n0,75;67.66827946\\n0,83;68.99339048\\n0,92;70.23954867\\n1;71.41826211\\n1,08;72.53857067\\n1,17;73.60771866\\n1,25;74.63161045\\n1,33;75.61512873\\n1,42;76.56236246\\n1,5;77.4767739\\n1,58;78.36132336\\n1,67;79.21856401\\n1,75;80.05071504\\n1,83;80.85971886\\n1,92;81.64728665\\n2;82.41493357\\n2,08;83.16400989\\n2,17;83.91387064\\n2,25;84.64716151\\n2,33;85.36534433\\n2,42;86.06961974\\n2,5;86.76098331\\n2,58;87.44027154\\n2,67;88.10820085\\n2,75;88.76540055\\n2,83;89.41244073\\n2,92;90.04985581\\n3;90.67816458\\n\\n\#\\n0;48.218174\\n0,08;51.00525369\\n0,17;55.00240616\\n0,25;57.99633728\\n0,33;60.45550522\\n0,42;62.57480445\\n0,5;64.45590909\\n0,58;66.15925026\\n0,67;67.72396873\\n0,75;69.17701631\\n0,83;70.53782479\\n0,92;71.82091411\\n1;73.03745271\\n1,08;74.19623275\\n1,17;75.30431489\\n1,25;76.36746432\\n1,33;77.39045632\\n1,42;78.37729583\\n1,5;79.33137846\\n1,58;80.25561111\\n1,67;81.15250374\\n1,75;82.02424031\\n1,83;82.87273432\\n1,92;83.69967461\\n2;84.50655294\\n2,08;85.29470553\\n2,17;86.05887745\\n2,25;86.8051731\\n2,33;87.53506945\\n2,42;88.24977223\\n2,5;88.95028421\\n2,58;89.63745411\\n2,67;90.3120186\\n2,75;90.97463683\\n2,83;91.62591867\\n2,92;92.26644774\\n3;92.89680119\\n\\n\#\\n0;49.98888408\\n0,08;52.6959753\\n0,17;56.62842855\\n0,25;59.60895343\\n0,33;62.07700027\\n0,42;64.2168641\\n0,5;66.1253149\\n0,58;67.8601799\\n0,67;69.45908458\\n0,75;70.94803912\\n0,83;72.34586111\\n0,92;73.6666541\\n1;74.92129717\\n1,08;76.11837536\\n1,17;77.26479911\\n1,25;78.36622309\\n1,33;79.4273405\\n1,42;80.45209492\\n1,5;81.44383603\\n1,58;82.40543643\\n1,67;83.33938063\\n1,75;84.24783394\\n1,83;85.13269658\\n1,92;85.9956488\\n2;86.8381751\\n2,08;87.66160934\\n2,17;88.45247282\\n2,25;89.22326434\\n2,33;89.97549228\\n2,42;90.71040853\\n2,5;91.42907762\\n2,58;92.13242379\\n2,67;92.82127167\\n2,75;93.49637946\\n2,83;94.15846546\\n2,92;94.80822923\\n3;95.44636981\\n\\n\#\\nage [years];75th\\n0;51.74273158\\n0,08;54.41405653\\n0,17;58.32626315\\n0,25;61.31467574\\n0,33;63.80289207\\n0,42;65.96919935\\n0,5;67.90752029\\n0,58;69.67415303\\n0,67;71.30583396\\n0,75;72.82802797\\n0,83;74.25920575\\n0,92;75.61324507\\n1;76.90087558\\n1,08;78.13058376\\n1,17;79.30921541\\n1,25;80.44238393\\n1,33;81.53475764\\n1,42;82.59026676\\n1,5;83.6122559\\n1,58;84.60359846\\n1,67;85.56678396\\n1,75;86.50398577\\n1,83;87.4171142\\n1,92;88.30786055\\n2;89.1777232\\n2,08;90.02804829\\n2,17;90.85675457\\n2,25;91.6626041\\n2,33;92.44711353\\n2,42;93.21159029\\n2,5;93.95718995\\n2,58;94.68495599\\n2,67;95.39585394\\n2,75;96.09079906\\n2,83;96.77067824\\n2,92;97.43636727\\n3;98.08874542\\n\\n\#\\n0;53.30756232\\n0,08;55.98376034\\n0,17;59.91924919\\n0,25;62.93631975\\n0,33;65.45448755\\n0,42;67.65073205\\n0,5;69.61844727\\n0,58;71.4137019\\n0,67;73.07313903\\n0,75;74.62219816\\n0,83;76.07935957\\n0,92;77.45852984\\n1;78.77047479\\n1,08;80.02372308\\n1,17;81.22516353\\n1,25;82.38045224\\n1,33;83.4942989\\n1,42;84.57067327\\n1,5;85.61295738\\n1,58;86.62405981\\n1,67;87.60650304\\n1,75;88.5624912\\n1,83;89.49396332\\n1,92;90.40263591\\n2;91.29003583\\n2,08;92.15753004\\n2,17;93.02966054\\n2,25;93.87608163\\n2,33;94.69827114\\n2,42;95.49757027\\n2,5;96.27522083\\n2,58;97.03239427\\n2,67;97.77021533\\n2,75;98.48978097\\n2,83;99.19217521\\n2,92;99.8784807\\n3;100.5497877\\n\\n\#\\nage [years];95th\\n0;54.23810497\\n0,08;56.9337518\\n0,17;60.90339687\\n0,25;63.94885006\\n0,33;66.49126189\\n0,42;68.70871502\\n0,5;70.69531881\\n0,58;72.50762781\\n0,67;74.18263173\\n0,75;75.74602764\\n0,83;77.21649287\\n0,92;78.60808958\\n1;79.93170629\\n1,08;81.19597313\\n1,17;82.40786231\\n1,25;83.57309961\\n1,33;84.69645352\\n1,42;85.78194386\\n1,5;86.83299553\\n1,58;87.85255417\\n1,67;88.84317438\\n1,75;89.80708833\\n1,83;90.7462596\\n1,92;91.66242499\\n2;92.55713369\\n2,08;93.43176749\\n2,17;94.33406648\\n2,25;95.20884914\\n2,33;96.05754106\\n2,42;96.88148848\\n2,5;97.68197981\\n2,58;98.46026663\\n2,67;99.2175791\\n2,75;99.95513792\\n2,83;100.6741635\\n2,92;101.3758831\\n3;102.0615351\\n\\n\#\\n0;54.84011528\\n0,08;57.55495075\\n0,17;61.55532574\\n0,25;64.62419672\\n0,33;67.18521797\\n0,42;69.41794083\\n0,5;71.4173861\\n0,58;73.24070888\\n0,67;74.92531457\\n0,75;76.49719914\\n0,83;77.97526103\\n0,92;79.37373061\\n1;80.7036248\\n1,08;81.97367578\\n1,17;83.19093672\\n1,25;84.36119864\\n1,33;85.48928313\\n1,42;86.57925367\\n1,5;87.63457134\\n1,58;88.65821192\\n1,67;89.65275537\\n1,75;90.62045524\\n1,83;91.56329326\\n1,92;92.48302068\\n2;93.38120251\\n2,08;94.25923029\\n2,17;95.18278047\\n2,25;96.07761711\\n2,33;96.94511823\\n2,42;97.78662531\\n2,5;98.6034532\\n2,58;99.39690538\\n2,67;100.1682833\\n2,75;100.9188932\\n2,83;101.6500508\\n2,92;102.3630853\\n3;103.0593402\\n\\n\#\\nage [years];3rd\\n2,08;80.26037074\\n2,17;81.0052937\\n2,25;81.7341574\\n2,33;82.44845648\\n2,42;83.14944982\\n2,5;83.83819399\\n2,58;84.51558277\\n2,67;85.18238019\\n2,75;85.83925011\\n2,83;86.48678276\\n2,92;87.12551862\\n3;87.75596799\\n3,08;88.37863651\\n3,17;88.93297086\\n3,25;89.47916294\\n3,33;90.01765704\\n3,42;90.54890623\\n3,5;91.07337426\\n3,58;91.59152368\\n3,67;92.10382052\\n3,75;92.6107295\\n3,83;93.11271174\\n3,92;93.61022262\\n4;94.10370972\\n4,08;94.59361093\\n4,17;95.08035263\\n4,25;95.56434805\\n4,33;96.04599748\\n4,42;96.52567713\\n4,5;97.00375833\\n4,58;97.48058355\\n4,67;97.95647862\\n4,75;98.43174768\\n4,83;98.90667254\\n4,92;99.3815118\\n5;99.85650001\\n5,08;100.331847\\n5,17;100.8077371\\n5,25;101.2843288\\n5,33;101.7617545\\n5,42;102.2401199\\n5,5;102.719504\\n5,58;103.1999595\\n5,67;103.6815122\\n5,75;104.164162\\n5,83;104.6478827\\n5,92;105.1326221\\n6;105.6183068\\n6,08;106.1048359\\n6,17;106.592087\\n6,25;107.0799166\\n6,33;107.5681606\\n6,42;108.0566359\\n6,5;108.5451423\\n6,58;109.0334636\\n6,67;109.5213695\\n6,75;110.0086174\\n6,83;110.4949545\\n6,92;110.9801192\\n7;111.4638437\\n7,08;111.9458554\\n7,17;112.4258796\\n7,25;112.9036412\\n7,33;113.3788664\\n7,42;113.8512827\\n7,5;114.3206308\\n7,58;114.7866522\\n7,67;115.2491001\\n7,75;115.7077388\\n7,83;116.1623461\\n7,92;116.6127146\\n8;117.0586529\\n8,08;117.4999879\\n8,17;117.9365657\\n8,25;118.3682526\\n8,33;118.794937\\n8,42;119.2165297\\n8,5;119.6329654\\n8,58;120.0442031\\n8,67;120.450227\\n8,75;120.8510473\\n8,83;121.2467001\\n8,92;121.6372483\\n9;122.0227817\\n9,08;122.4034171\\n9,17;122.7792983\\n9,25;123.1505962\\n9,33;123.5175084\\n9,42;123.8802592\\n9,5;124.2390993\\n9,58;124.5943049\\n9,67;124.9461775\\n9,75;125.2950434\\n9,83;125.6412524\\n9,92;125.9851773\\n10;126.3272131\\n10,08;126.6677753\\n10,17;127.0072991\\n10,25;127.3462381\\n10,33;127.6850624\\n10,42;128.0242572\\n10,5;128.3643208\\n10,58;128.7057627\\n10,67;129.0491015\\n10,75;129.394862\\n10,83;129.7435732\\n10,92;130.095765\\n11;130.4519655\\n11,08;130.8126976\\n11,17;131.1784756\\n11,25;131.5498015\\n11,33;131.9271616\\n11,42;132.311022\\n11,5;132.7018251\\n11,58;133.0999854\\n11,67;133.5058853\\n11,75;133.9198714\\n11,83;134.34225\\n11,92;134.773284\\n12;135.2131887\\n12,08;135.6621289\\n12,17;136.1202156\\n12,25;136.5875035\\n12,33;137.0639883\\n12,42;137.5496052\\n12,5;138.0442266\\n12,58;138.5476617\\n12,67;139.0596548\\n12,75;139.5798855\\n12,83;140.1079685\\n12,92;140.6434536\\n13;141.1858268\\n13,08;141.7345116\\n13,17;142.2888712\\n13,25;142.8482077\\n13,33;143.4117718\\n13,42;143.9787585\\n13,5;144.5483179\\n13,58;145.1195552\\n13,67;145.6915401\\n13,75;146.2633119\\n13,83;146.8338868\\n13,92;147.4022657\\n14;147.9674393\\n14,08;148.5284089\\n14,17;149.0841789\\n14,25;149.6337753\\n14,33;150.1762526\\n14,42;150.7107013\\n14,5;151.2362566\\n14,58;151.7521046\\n14,67;152.2574887\\n14,75;152.7517151\\n14,83;153.2341567\\n14,92;153.7042563\\n15;154.1615288\\n15,08;154.6055622\\n15,17;155.0360175\\n15,25;155.452628\\n15,33;155.8551976\\n15,42;156.243598\\n15,5;156.6177662\\n15,58;156.9777005\\n15,67;157.3234565\\n15,75;157.6551432\\n15,83;157.9729166\\n15,92;158.2769793\\n16;158.5675712\\n16,08;158.8449655\\n16,17;159.1094689\\n16,25;159.3614112\\n16,33;159.6011441\\n16,42;159.8290369\\n16,5;160.0454725\\n16,58;160.2508441\\n16,67;160.4455519\\n16,75;160.6300005\\n16,83;160.8045956\\n16,92;160.9697424\\n17;161.1258433\\n17,08;161.2732955\\n17,17;161.4124903\\n17,25;161.5438112\\n17,33;161.6676329\\n17,42;161.7843202\\n17,5;161.8942273\\n17,58;161.9976976\\n17,67;162.0950624\\n17,75;162.1866414\\n17,83;162.272742\\n17,92;162.3536592\\n18;162.429676\\n18,08;162.501063\\n18,17;162.5680787\\n18,25;162.6309697\\n18,33;162.689971\\n18,42;162.7453061\\n18,5;162.7971876\\n18,58;162.8458172\\n18,67;162.8913862\\n18,75;162.9340759\\n18,83;162.9740581\\n18,92;163.0114951\\n19;163.0465405\\n19,08;163.0793392\\n19,17;163.1100283\\n19,25;163.1387368\\n19,33;163.1655866\\n19,42;163.1906925\\n19,5;163.2141625\\n19,58;163.2360985\\n19,67;163.2565964\\n19,75;163.2757461\\n19,83;163.2936325\\n19,92;163.3103353\\n20;163.3259293\\n\\n\#\\nage [years];5th\\n2,08;81.08868489\\n2,17;81.83445202\\n2,25;82.56406112\\n2,33;83.27898582\\n2,42;83.98045262\\n2,5;84.66948449\\n2,58;85.3469433\\n2,67;86.01356554\\n2,75;86.66999332\\n2,83;87.31680155\\n2,92;87.95452162\\n3;88.58366128\\n3,08;89.20472611\\n3,17;89.77301106\\n3,25;90.33305814\\n3,33;90.88532031\\n3,42;91.43025486\\n3,5;91.96832362\\n3,58;92.4999858\\n3,67;93.02569976\\n3,75;93.54591978\\n3,83;94.06109422\\n3,92;94.57166376\\n4;95.07805975\\n4,08;95.58070273\\n4,17;96.08000091\\n4,25;96.57634888\\n4,33;97.07012724\\n4,42;97.56169654\\n4,5;98.05140652\\n4,58;98.53958366\\n4,67;99.026537\\n4,75;99.51255522\\n4,83;99.99790605\\n4,92;100.4828356\\n5;100.9675675\\n5,08;101.4523027\\n5,17;101.9372185\\n5,25;102.4224687\\n5,33;102.908183\\n5,42;103.3944666\\n5,5;103.8814006\\n5,58;104.3690418\\n5,67;104.8574227\\n5,75;105.3465519\\n5,83;105.8364145\\n5,92;106.3269721\\n6;106.8181654\\n6,08;107.3099116\\n6,17;107.8021076\\n6,25;108.2946307\\n6,33;108.7873391\\n6,42;109.2800738\\n6,5;109.7726591\\n6,58;110.2649049\\n6,67;110.7566073\\n6,75;111.247551\\n6,83;111.7375104\\n6,92;112.2262515\\n7;112.7135338\\n7,08;113.1991118\\n7,17;113.6827373\\n7,25;114.1641607\\n7,33;114.6431334\\n7,42;115.1194078\\n7,5;115.5927447\\n7,58;116.0629074\\n7,67;116.5296686\\n7,75;116.9928104\\n7,83;117.4521263\\n7,92;117.9074226\\n8;118.3585201\\n8,08;118.8052553\\n8,17;119.2474816\\n8,25;119.6850711\\n8,33;120.1179149\\n8,42;120.5459248\\n8,5;120.9690339\\n8,58;121.3871973\\n8,67;121.8003934\\n8,75;122.2086239\\n8,83;122.6119145\\n8,92;123.0103156\\n9;123.4039024\\n9,08;123.7927752\\n9,17;124.1770596\\n9,25;124.5569064\\n9,33;124.9324922\\n9,42;125.3040185\\n9,5;125.6717122\\n9,58;126.035825\\n9,67;126.3966334\\n9,75;126.7544381\\n9,83;127.1095636\\n9,92;127.4623576\\n10;127.8131904\\n10,08;128.1624542\\n10,17;128.5105623\\n10,25;128.857948\\n10,33;129.2050634\\n10,42;129.5523785\\n10,5;129.9003795\\n10,58;130.2495672\\n10,67;130.6004555\\n10,75;130.9535693\\n10,83;131.309442\\n10,92;131.6686134\\n11;132.031627\\n11,08;132.3990267\\n11,17;132.771354\\n11,25;133.1491442\\n11,33;133.5329226\\n11,42;133.9232006\\n11,5;134.3204714\\n11,58;134.7252055\\n11,67;135.1378458\\n11,75;135.5588028\\n11,83;135.9884501\\n11,92;136.4271185\\n12;136.8750919\\n12,08;137.3326017\\n12,17;137.7998222\\n12,25;138.2768661\\n12,33;138.7637799\\n12,42;139.2605402\\n12,5;139.7670498\\n12,58;140.2831346\\n12,67;140.8085414\\n12,75;141.3429356\\n12,83;141.8859002\\n12,92;142.4369354\\n13;142.9954591\\n13,08;143.5608087\\n13,17;144.1322433\\n13,25;144.7089466\\n13,33;145.2900346\\n13,42;145.8745579\\n13,5;146.4615117\\n13,58;147.0498421\\n13,67;147.6384567\\n13,75;148.226234\\n13,83;148.8120346\\n13,92;149.394712\\n14;149.9731226\\n14,08;150.5461431\\n14,17;151.1126739\\n14,25;151.6716544\\n14,33;152.2220718\\n14,42;152.7629701\\n14,5;153.2934582\\n14,58;153.8127163\\n14,67;154.3200013\\n14,75;154.814651\\n14,83;155.2960861\\n14,92;155.7638123\\n15;156.2174196\\n15,08;156.6565818\\n15,17;157.0810539\\n15,25;157.4906696\\n15,33;157.8853369\\n15,42;158.2650343\\n15,5;158.6298055\\n15,58;158.9797544\\n15,67;159.31504\\n15,75;159.6358703\\n15,83;159.9424968\\n15,92;160.2352102\\n16;160.5143338\\n16,08;160.7802183\\n16,17;161.0332391\\n16,25;161.2737894\\n16,33;161.5022772\\n16,42;161.7191211\\n16,5;161.9247473\\n16,58;162.1195857\\n16,67;162.3040676\\n16,75;162.4786229\\n16,83;162.643678\\n16,92;162.7996536\\n17;162.9469636\\n17,08;163.0860132\\n17,17;163.2171976\\n17,25;163.3409016\\n17,33;163.4574984\\n17,42;163.5673489\\n17,5;163.6708019\\n17,58;163.7681929\\n17,67;163.8598446\\n17,75;163.9460665\\n17,83;164.027155\\n17,92;164.1033935\\n18;164.1750527\\n18,08;164.2423904\\n18,17;164.3056523\\n18,25;164.365072\\n18,33;164.4208714\\n18,42;164.473261\\n18,5;164.5224406\\n18,58;164.5685992\\n18,67;164.6119158\\n18,75;164.6525596\\n18,83;164.6906907\\n18,92;164.72646\\n19;164.7600102\\n19,08;164.7914756\\n19,17;164.8209832\\n19,25;164.8486523\\n19,33;164.8745955\\n19,42;164.8989187\\n19,5;164.9217215\\n19,58;164.9430978\\n19,67;164.9631357\\n19,75;164.9819181\\n19,83;164.9995229\\n19,92;165.0160233\\n20;165.031488\\n\\n\#\\nage [years];10th\\n2,08;82.36400989\\n2,17;83.11387064\\n2,25;83.84716151\\n2,33;84.56534433\\n2,42;85.26961974\\n2,5;85.96098331\\n2,58;86.64027154\\n2,67;87.30820085\\n2,75;87.96540055\\n2,83;88.61244073\\n2,92;89.24985581\\n3;89.87816458\\n3,08;90.49788649\\n3,17;91.08607735\\n3,25;91.66588835\\n3,33;92.23778882\\n3,42;92.80224597\\n3,5;93.35972283\\n3,58;93.91067749\\n3,67;94.45556109\\n3,75;94.99481672\\n3,83;95.52887815\\n3,92;96.05816868\\n4;96.58310008\\n4,08;97.1040715\\n4,17;97.62146857\\n4,25;98.13566246\\n4,33;98.64700876\\n4,42;99.15584797\\n4,5;99.66250203\\n4,58;100.1672766\\n4,67;100.6704587\\n4,75;101.1723164\\n4,83;101.6730987\\n4,92;102.1730346\\n5;102.6723326\\n5,08;103.171181\\n5,17;103.6697469\\n5,25;104.1681762\\n5,33;104.6665937\\n5,42;105.1651027\\n5,5;105.6637849\\n5,58;106.1627011\\n5,67;106.6618905\\n5,75;107.1613717\\n5,83;107.6611426\\n5,92;108.1611811\\n6;108.6614449\\n6,08;109.1618735\\n6,17;109.6623876\\n6,25;110.1628906\\n6,33;110.6632694\\n6,42;111.1633949\\n6,5;111.6631239\\n6,58;112.1622995\\n6,67;112.6607528\\n6,75;113.158304\\n6,83;113.654764\\n6,92;114.1499353\\n7;114.6436141\\n7,08;115.1355915\\n7,17;115.625655\\n7,25;116.1135904\\n7,33;116.5991827\\n7,42;117.0822191\\n7,5;117.562488\\n7,58;118.0397834\\n7,67;118.5139049\\n7,75;118.9846594\\n7,83;119.4518627\\n7,92;119.9153408\\n8;120.3749315\\n8,08;120.830485\\n8,17;121.281866\\n8,25;121.7289543\\n8,33;122.1716458\\n8,42;122.6098539\\n8,5;123.04351\\n8,58;123.4725646\\n8,67;123.896988\\n8,75;124.3167709\\n8,83;124.7319249\\n8,92;125.1424835\\n9;125.5485022\\n9,08;125.9500588\\n9,17;126.3472542\\n9,25;126.7402123\\n9,33;127.1290805\\n9,42;127.5140299\\n9,5;127.8952551\\n9,58;128.2729746\\n9,67;128.6474311\\n9,75;129.0188908\\n9,83;129.3876441\\n9,92;129.7540048\\n10;130.1183106\\n10,08;130.4809221\\n10,17;130.8422234\\n10,25;131.2026207\\n10,33;131.5625423\\n10,42;131.9224379\\n10,5;132.2827776\\n10,58;132.6440511\\n10,67;133.0067661\\n10,75;133.3714475\\n10,83;133.738635\\n10,92;134.1088817\\n11;134.4827517\\n11,08;134.8608171\\n11,17;135.2436555\\n11,25;135.6318463\\n11,33;136.0259671\\n11,42;136.4265892\\n11,5;136.8342729\\n11,58;137.2495627\\n11,67;137.6729811\\n11,75;138.1050231\\n11,83;138.5461496\\n11,92;138.9967803\\n12;139.4572873\\n12,08;139.9279871\\n12,17;140.409134\\n12,25;140.9009122\\n12,33;141.403429\\n12,42;141.9167079\\n12,5;142.4406823\\n12,58;142.9751899\\n12,67;143.5199675\\n12,75;144.0746481\\n12,83;144.6387576\\n12,92;145.2117144\\n13;145.7928297\\n13,08;146.3813098\\n13,17;146.9762604\\n13,25;147.576693\\n13,33;148.1815319\\n13,42;148.7896253\\n13,5;149.3997554\\n13,58;150.0106525\\n13,67;150.6210083\\n13,75;151.2294913\\n13,83;151.8347622\\n13,92;152.4354895\\n14;153.0303654\\n14,08;153.6181187\\n14,17;154.1975312\\n14,25;154.7674484\\n14,33;155.3267913\\n14,42;155.874565\\n14,5;156.4098665\\n14,58;156.9318906\\n14,67;157.4399327\\n14,75;157.9333914\\n14,83;158.4117685\\n14,92;158.8746672\\n15;159.3217901\\n15,08;159.7529343\\n15,17;160.1679874\\n15,25;160.5669211\\n15,33;160.9497852\\n15,42;161.3167006\\n15,5;161.6678528\\n15,58;162.0034846\\n15,67;162.3238889\\n15,75;162.6294022\\n15,83;162.9203983\\n15,92;163.1972811\\n16;163.4604795\\n16,08;163.7104424\\n16,17;163.9476322\\n16,25;164.1725219\\n16,33;164.3855897\\n16,42;164.5873165\\n16,5;164.7781818\\n16,58;164.9586613\\n16,67;165.1292244\\n16,75;165.2903324\\n16,83;165.4424364\\n16,92;165.5859761\\n17;165.7213786\\n17,08;165.8490577\\n17,17;165.9694129\\n17,25;166.0828291\\n17,33;166.1896765\\n17,42;166.29031\\n17,5;166.3850695\\n17,58;166.4742799\\n17,67;166.5582511\\n17,75;166.6372787\\n17,83;166.7116437\\n17,92;166.7816133\\n18;166.8474411\\n18,08;166.9093676\\n18,17;166.9676208\\n18,25;167.0224162\\n18,33;167.0739579\\n18,42;167.1224387\\n18,5;167.1680405\\n18,58;167.2109353\\n18,67;167.251285\\n18,75;167.2892424\\n18,83;167.3249515\\n18,92;167.3585477\\n19;167.3901586\\n19,08;167.4199044\\n19,17;167.4478978\\n19,25;167.4742452\\n19,33;167.4990462\\n19,42;167.5223947\\n19,5;167.5443789\\n19,58;167.5650814\\n19,67;167.5845802\\n19,75;167.602948\\n19,83;167.6202536\\n19,92;167.6365611\\n20;167.6519311\\n\\n\#\\nage [years];25th\\n2,08;84.49470553\\n2,17;85.25887745\\n2,25;86.0051731\\n2,33;86.73506945\\n2,42;87.44977223\\n2,5;88.15028421\\n2,58;88.83745411\\n2,67;89.5120186\\n2,75;90.17463683\\n2,83;90.82591867\\n2,92;91.46644774\\n3;92.09680119\\n3,08;92.71755946\\n3,17;93.33440049\\n3,25;93.94268367\\n3,33;94.54291151\\n3,42;95.1355744\\n3,5;95.72114636\\n3,58;96.30009195\\n3,67;96.87286014\\n3,75;97.43988586\\n3,83;98.00158958\\n3,92;98.55837705\\n4;99.11063889\\n4,08;99.65875031\\n4,17;100.2030707\\n4,25;100.7439435\\n4,33;101.281694\\n4,42;101.8166373\\n4,5;102.3490611\\n4,58;102.8792439\\n4,67;103.4074438\\n4,75;103.9339016\\n4,83;104.4588401\\n4,92;104.9824642\\n5;105.5049607\\n5,08;106.026498\\n5,17;106.5472265\\n5,25;107.0672782\\n5,33;107.5867669\\n5,42;108.1057886\\n5,5;108.6244211\\n5,58;109.1427246\\n5,67;109.6607418\\n5,75;110.1784984\\n5,83;110.6960031\\n5,92;111.2132492\\n6;111.7302112\\n6,08;112.2468516\\n6,17;112.7631168\\n6,25;113.2789389\\n6,33;113.7942368\\n6,42;114.3089166\\n6,5;114.8228726\\n6,58;115.335988\\n6,67;115.8481358\\n6,75;116.3591802\\n6,83;116.8689769\\n6,92;117.3773747\\n7;117.8842164\\n7,08;118.3893397\\n7,17;118.8925788\\n7,25;119.3937653\\n7,33;119.8927292\\n7,42;120.3893032\\n7,5;120.8833137\\n7,58;121.3745956\\n7,67;121.8629855\\n7,75;122.3483243\\n7,83;122.8304588\\n7,92;123.3092425\\n8;123.784537\\n8,08;124.2562127\\n8,17;124.7241502\\n8,25;125.1882412\\n8,33;125.6483893\\n8,42;126.1045113\\n8,5;126.5565377\\n8,58;127.0044134\\n8,67;127.4480994\\n8,75;127.8875724\\n8,83;128.3228265\\n8,92;128.7538732\\n9;129.1807426\\n9,08;129.6034839\\n9,17;130.0221657\\n9,25;130.436877\\n9,33;130.8477278\\n9,42;131.2548494\\n9,5;131.6583952\\n9,58;132.0585409\\n9,67;132.4554857\\n9,75;132.8494521\\n9,83;133.2406866\\n9,92;133.6294604\\n10;134.0160697\\n10,08;134.4008357\\n10,17;134.7841054\\n10,25;135.1662516\\n10,33;135.5476732\\n10,42;135.9287948\\n10,5;136.3100669\\n10,58;136.6919657\\n10,67;137.0749922\\n10,75;137.4596717\\n10,83;137.8465525\\n10,92;138.2362048\\n11;138.6292185\\n11,08;139.0262015\\n11,17;139.4277761\\n11,25;139.8345767\\n11,33;140.2472448\\n11,42;140.6664253\\n11,5;141.0927603\\n11,58;141.5268837\\n11,67;141.9694138\\n11,75;142.4209457\\n11,83;142.8820429\\n11,92;143.353228\\n12;143.8349727\\n12,08;144.3276874\\n12,17;144.8317108\\n12,25;145.3472981\\n12,33;145.8746111\\n12,42;146.4137069\\n12,5;146.9645285\\n12,58;147.5268957\\n12,67;148.1004983\\n12,75;148.6848902\\n12,83;149.2794857\\n12,92;149.8835591\\n13;150.4962462\\n13,08;151.1165487\\n13,17;151.7433416\\n13,25;152.3753859\\n13,33;153.0113368\\n13,42;153.6497654\\n13,5;154.2891719\\n13,58;154.9280091\\n13,67;155.5647003\\n13,75;156.1976616\\n13,83;156.8253238\\n13,92;157.4461523\\n14;158.0586697\\n14,08;158.6614636\\n14,17;159.2532157\\n14,25;159.8327068\\n14,33;160.3988301\\n14,42;160.9505985\\n14,5;161.4871507\\n14,58;162.0077536\\n14,67;162.5118031\\n14,75;162.9988222\\n14,83;163.4684575\\n14,92;163.9204738\\n15;164.3547479\\n15,08;164.7712603\\n15,17;165.1700873\\n15,25;165.5513919\\n15,33;165.9154147\\n15,42;166.2624644\\n15,5;166.5929092\\n15,58;166.9071674\\n15,67;167.2056993\\n15,75;167.4889986\\n15,83;167.7575872\\n15,92;168.012004\\n16;168.2528029\\n16,08;168.4805469\\n16,17;168.6957988\\n16,25;168.8991222\\n16,33;169.0910747\\n16,42;169.2722058\\n16,5;169.4430536\\n16,58;169.6041427\\n16,67;169.7559826\\n16,75;169.8990665\\n16,83;170.0338694\\n16,92;170.1608483\\n17;170.280441\\n17,08;170.3930664\\n17,17;170.4991239\\n17,25;170.5989941\\n17,33;170.6930385\\n17,42;170.7816002\\n17,5;170.8650043\\n17,58;170.9435584\\n17,67;171.0175531\\n17,75;171.0872629\\n17,83;171.1529465\\n17,92;171.2148477\\n18;171.2731962\\n18,08;171.3282079\\n18,17;171.3800858\\n18,25;171.4290208\\n18,33;171.4751921\\n18,42;171.5187679\\n18,5;171.5599062\\n18,58;171.598755\\n18,67;171.6354533\\n18,75;171.6701314\\n18,83;171.7029114\\n18,92;171.7339076\\n19;171.7632274\\n19,08;171.7909712\\n19,17;171.8172333\\n19,25;171.8421019\\n19,33;171.8656596\\n19,42;171.8879838\\n19,5;171.9091473\\n19,58;171.9292179\\n19,67;171.9482593\\n19,75;171.9663314\\n19,83;171.9834901\\n19,92;171.9997878\\n20;172.0152737\\n\\n\#\\nage [years];50th\\n2,08;86.86160934\\n2,17;87.65247282\\n2,25;88.42326434\\n2,33;89.17549228\\n2,42;89.91040853\\n2,5;90.62907762\\n2,58;91.33242379\\n2,67;92.02127167\\n2,75;92.69637946\\n2,83;93.35846546\\n2,92;94.00822923\\n3;94.64636981\\n3,08;95.27359106\\n3,17;95.91474929\\n3,25;96.54734328\\n3,33;97.17191309\\n3,42;97.78897727\\n3,5;98.3990283\\n3,58;99.00254338\\n3,67;99.599977\\n3,75;100.191764\\n3,83;100.7783198\\n3,92;101.3600411\\n4;101.9373058\\n4,08;102.5104735\\n4,17;103.0798852\\n4,25;103.645864\\n4,33;104.208713\\n4,42;104.7687256\\n4,5;105.3261638\\n4,58;105.8812823\\n4,67;106.4343146\\n4,75;106.9854769\\n4,83;107.534968\\n4,92;108.0829695\\n5;108.6296457\\n5,08;109.1751441\\n5,17;109.7195954\\n5,25;110.2631136\\n5,33;110.8057967\\n5,42;111.3477265\\n5,5;111.8889694\\n5,58;112.4295761\\n5,67;112.9695827\\n5,75;113.5090108\\n5,83;114.0478678\\n5,92;114.5861486\\n6;115.1238315\\n6,08;115.6608862\\n6,17;116.1972691\\n6,25;116.732925\\n6,33;117.2677879\\n6,42;117.8017819\\n6,5;118.3348215\\n6,58;118.8668123\\n6,67;119.397652\\n6,75;119.9272309\\n6,83;120.455433\\n6,92;120.9821362\\n7;121.5072136\\n7,08;122.0305342\\n7,17;122.5519634\\n7,25;123.0713645\\n7,33;123.588599\\n7,42;124.1035312\\n7,5;124.6160161\\n7,58;125.1259182\\n7,67;125.6331012\\n7,75;126.1374319\\n7,83;126.6387804\\n7,92;127.1370217\\n8;127.6320362\\n8,08;128.1237104\\n8,17;128.6119383\\n8,25;129.096622\\n8,33;129.5776723\\n8,42;130.0550101\\n8,5;130.5285669\\n8,58;130.9982857\\n8,67;131.4641218\\n8,75;131.9260439\\n8,83;132.3840348\\n8,92;132.838092\\n9;133.2882291\\n9,08;133.7344759\\n9,17;134.1768801\\n9,25;134.6155076\\n9,33;135.0504433\\n9,42;135.4817925\\n9,5;135.9096813\\n9,58;136.3342577\\n9,67;136.7556923\\n9,75;137.1741794\\n9,83;137.5899378\\n9,92;138.0032114\\n10;138.4142703\\n10,08;138.8234114\\n10,17;139.2309592\\n10,25;139.6372663\\n10,33;140.042714\\n10,42;140.4477127\\n10,5;140.8527022\\n10,58;141.2581515\\n10,67;141.6645592\\n10,75;142.072452\\n10,83;142.4823852\\n10,92;142.8949403\\n11;143.3107241\\n11,08;143.7303663\\n11,17;144.1545167\\n11,25;144.5838414\\n11,33;145.0190192\\n11,42;145.4607359\\n11,5;145.9096784\\n11,58;146.3665278\\n11,67;146.8319513\\n11,75;147.3065929\\n11,83;147.7910635\\n11,92;148.2859294\\n12;148.7917006\\n12,08;149.3088178\\n12,17;149.8376391\\n12,25;150.3784267\\n12,33;150.9313331\\n12,42;151.4963887\\n12,5;152.0734897\\n12,58;152.6623878\\n12,67;153.2626819\\n12,75;153.8738124\\n12,83;154.495058\\n12,92;155.1255365\\n13;155.7642086\\n13,08;156.4098858\\n13,17;157.0612415\\n13,25;157.7168289\\n13,33;158.3750929\\n13,42;159.034399\\n13,5;159.6930501\\n13,58;160.3493168\\n13,67;161.0014586\\n13,75;161.6477515\\n13,83;162.2865119\\n13,92;162.9161202\\n14;163.535045\\n14,08;164.1418486\\n14,17;164.7352199\\n14,25;165.3139755\\n14,33;165.8770715\\n14,42;166.4236087\\n14,5;166.9528354\\n14,58;167.4641466\\n14,67;167.9570814\\n14,75;168.4313175\\n14,83;168.8866644\\n14,92;169.3230548\\n15;169.7405351\\n15,08;170.139255\\n15,17;170.5194567\\n15,25;170.881464\\n15,33;171.2256717\\n15,42;171.5525345\\n15,5;171.8625576\\n15,58;172.1562865\\n15,67;172.4342983\\n15,75;172.6971935\\n15,83;172.9455898\\n15,92;173.180112\\n16;173.4013896\\n16,08;173.6100518\\n16,17;173.8067179\\n16,25;173.9919998\\n16,33;174.1664951\\n16,42;174.3307855\\n16,5;174.4854344\\n16,58;174.6309856\\n16,67;174.7679617\\n16,75;174.8968634\\n16,83;175.0181691\\n16,92;175.1323345\\n17;175.2397926\\n17,08;175.340954\\n17,17;175.4362071\\n17,25;175.5259191\\n17,33;175.6104358\\n17,42;175.690083\\n17,5;175.7651671\\n17,58;175.8359757\\n17,67;175.9027788\\n17,75;175.9658293\\n17,83;176.0253641\\n17,92;176.081605\\n18;176.1347593\\n18,08;176.1850208\\n18,17;176.2325707\\n18,25;176.2775781\\n18,33;176.3202008\\n18,42;176.3605864\\n18,5;176.3988725\\n18,58;176.4351874\\n18,67;176.469651\\n18,75;176.5023751\\n18,83;176.533464\\n18,92;176.5630153\\n19;176.5911197\\n19,08;176.6178621\\n19,17;176.6433219\\n19,25;176.6675729\\n19,33;176.6906844\\n19,42;176.712721\\n19,5;176.733743\\n19,58;176.753807\\n19,67;176.7729657\\n19,75;176.7912687\\n19,83;176.8087622\\n19,92;176.8254895\\n20;176.8414914\\n\\n\#\\nage [years];75th\\n2,08;89.22804829\\n2,17;90.05675457\\n2,25;90.8626041\\n2,33;91.64711353\\n2,42;92.41159029\\n2,5;93.15718995\\n2,58;93.88495599\\n2,67;94.59585394\\n2,75;95.29079906\\n2,83;95.97067824\\n2,92;96.63636727\\n3;97.28874542\\n3,08;97.92869928\\n3,17;98.58524582\\n3,25;99.23357783\\n3,33;99.87425862\\n3,42;100.5078239\\n3,5;101.1347788\\n3,58;101.7556073\\n3,67;102.370767\\n3,75;102.9806917\\n3,83;103.5857927\\n3,92;104.186459\\n4;104.7830584\\n4,08;105.3759377\\n4,17;105.9654232\\n4,25;106.5518212\\n4,33;107.1354171\\n4,42;107.7164829\\n4,5;108.2952617\\n4,58;108.8719858\\n4,67;109.4468665\\n4,75;110.0200973\\n4,83;110.5918541\\n4,92;111.1622955\\n5;111.731563\\n5,08;112.2997816\\n5,17;112.86706\\n5,25;113.4334909\\n5,33;113.9991516\\n5,42;114.5641044\\n5,5;115.128397\\n5,58;115.6920629\\n5,67;116.2551221\\n5,75;116.8175812\\n5,83;117.3794345\\n5,92;117.9406648\\n6;118.5012409\\n6,08;119.0611237\\n6,17;119.6202624\\n6,25;120.1785968\\n6,33;120.7360574\\n6,42;121.2925663\\n6,5;121.8480376\\n6,58;122.4023786\\n6,67;122.9554895\\n6,75;123.5072652\\n6,83;124.057595\\n6,92;124.6063638\\n7;125.1534527\\n7,08;125.6987395\\n7,17;126.2420996\\n7,25;126.7834065\\n7,33;127.3225327\\n7,42;127.8593529\\n7,5;128.393735\\n7,58;128.9255543\\n7,67;129.4546858\\n7,75;129.9810071\\n7,83;130.504399\\n7,92;131.024746\\n8;131.5419375\\n8,08;132.0558684\\n8,17;132.5664397\\n8,25;133.0735595\\n8,33;133.5771438\\n8,42;134.0771172\\n8,5;134.5734138\\n8,58;135.065978\\n8,67;135.5547656\\n8,75;136.0397444\\n8,83;136.5208952\\n8,92;136.9982129\\n9;137.4717069\\n9,08;137.9414029\\n9,17;138.4073433\\n9,25;138.8695881\\n9,33;139.3282163\\n9,42;139.7833266\\n9,5;140.2350389\\n9,58;140.6834944\\n9,67;141.1288576\\n9,75;141.5713168\\n9,83;142.011085\\n9,92;142.4484014\\n10;142.8835317\\n10,08;143.3167691\\n10,17;143.7484354\\n10,25;144.1788815\\n10,33;144.6084877\\n10,42;145.0376645\\n10,5;145.4668527\\n10,58;145.8965233\\n10,67;146.3271773\\n10,75;146.7593449\\n10,83;147.1935849\\n10,92;147.630483\\n11;148.07065\\n11,08;148.5147188\\n11,17;148.9633421\\n11,25;149.4171874\\n11,33;149.876933\\n11,42;150.3432618\\n11,5;150.8168546\\n11,58;151.2983826\\n11,67;151.7884983\\n11,75;152.2878255\\n11,83;152.7969484\\n11,92;153.3163996\\n12;153.8466466\\n12,08;154.3880792\\n12,17;154.9409947\\n12,25;155.505584\\n12,33;156.0819181\\n12,42;156.6699351\\n12,5;157.2694285\\n12,58;157.8800378\\n12,67;158.5012409\\n12,75;159.1323501\\n12,83;159.7725112\\n12,92;160.4207062\\n13;161.0757603\\n13,08;161.7363527\\n13,17;162.4010311\\n13,25;163.0682321\\n13,33;163.7362982\\n13,42;164.4035075\\n13,5;165.0680948\\n13,58;165.7282823\\n13,67;166.3823042\\n13,75;167.0284338\\n13,83;167.6650085\\n13,92;168.2904522\\n14;168.9032981\\n14,08;169.5021963\\n14,17;170.0859388\\n14,25;170.6534628\\n14,33;171.2038574\\n14,42;171.7363673\\n14,5;172.2503918\\n14,58;172.7454817\\n14,67;173.2213335\\n14,75;173.6777819\\n14,83;174.1147899\\n14,92;174.5324388\\n15;174.9309165\\n15,08;175.310506\\n15,17;175.6715733\\n15,25;176.0145556\\n15,33;176.3399504\\n15,42;176.648304\\n15,5;176.9402021\\n15,58;177.2162598\\n15,67;177.4771134\\n15,75;177.7234122\\n15,83;177.9558135\\n15,92;178.174973\\n16;178.381543\\n16,08;178.5761676\\n16,17;178.7594756\\n16,25;178.9320817\\n16,33;179.0945815\\n16,42;179.2475503\\n16,5;179.3915415\\n16,58;179.5270853\\n16,67;179.6546885\\n16,75;179.7748338\\n16,83;179.8879797\\n16,92;179.9945609\\n17;180.0949883\\n17,08;180.1896498\\n17,17;180.278911\\n17,25;180.3631154\\n17,33;180.4425858\\n17,42;180.5176249\\n17,5;180.5885165\\n17,58;180.6555257\\n17,67;180.7189006\\n17,75;180.7788732\\n17,83;180.8356596\\n17,92;180.8894616\\n18;180.9404676\\n18,08;180.9888527\\n18,17;181.0347806\\n18,25;181.0784033\\n18,33;181.1198626\\n18,42;181.1592906\\n18,5;181.1968103\\n18,58;181.232536\\n18,67;181.2665744\\n18,75;181.2990249\\n18,83;181.3299799\\n18,92;181.3595256\\n19;181.3877426\\n19,08;181.4147056\\n19,17;181.4404846\\n19,25;181.4651449\\n19,33;181.4887473\\n19,42;181.5113488\\n19,5;181.5330026\\n19,58;181.5537583\\n19,67;181.5736625\\n19,75;181.5927588\\n19,83;181.6110879\\n19,92;181.6286882\\n20;181.6455954\\n\\n\#\\nage [years];90th\\n2,08;91.35753004\\n2,17;92.22966054\\n2,25;93.07608163\\n2,33;93.89827114\\n2,42;94.69757027\\n2,5;95.47522083\\n2,58;96.23239427\\n2,67;96.97021533\\n2,75;97.68978097\\n2,83;98.39217521\\n2,92;99.0784807\\n3;99.74978771\\n3,08;100.4071992\\n3,17;101.0690065\\n3,25;101.7233762\\n3,33;102.3708617\\n3,42;103.011988\\n3,5;103.6472524\\n3,58;104.2771267\\n3,67;104.9020571\\n3,75;105.5224653\\n3,83;106.1387493\\n3,92;106.7512837\\n4;107.3604207\\n4,08;107.9664906\\n4,17;108.569802\\n4,25;109.1706428\\n4,33;109.76928\\n4,42;110.3659614\\n4,5;110.9609139\\n4,58;111.5543461\\n4,67;112.1464475\\n4,75;112.7373894\\n4,83;113.327325\\n4,92;113.9163901\\n5;114.5047033\\n5,08;115.0923665\\n5,17;115.6794655\\n5,25;116.2660704\\n5,33;116.8522359\\n5,42;117.4380018\\n5,5;118.0233939\\n5,58;118.6084238\\n5,67;119.1930903\\n5,75;119.777379\\n5,83;120.3612638\\n5,92;120.9447067\\n6;121.5276587\\n6,08;122.1100607\\n6,17;122.6918435\\n6,25;123.272929\\n6,33;123.8532304\\n6,42;124.4326533\\n6,5;125.0110959\\n6,58;125.5884499\\n6,67;126.1646012\\n6,75;126.7394306\\n6,83;127.3128143\\n6,92;127.8846249\\n7;128.4547316\\n7,08;129.0230015\\n7,17;129.5892999\\n7,25;130.153491\\n7,33;130.7154389\\n7,42;131.2750083\\n7,5;131.8320643\\n7,58;132.3864745\\n7,67;132.9381089\\n7,75;133.4868407\\n7,83;134.0325473\\n7,92;134.5751108\\n8;135.1144188\\n8,08;135.6503652\\n8,17;136.1828511\\n8,25;136.7117853\\n8,33;137.2370854\\n8,42;137.7586784\\n8,5;138.2765017\\n8,58;138.7905039\\n8,67;139.3006456\\n8,75;139.8069003\\n8,83;140.3092555\\n8,92;140.8077133\\n9;141.3022916\\n9,08;141.793025\\n9,17;142.2799654\\n9,25;142.7631838\\n9,33;143.2427702\\n9,42;143.7188356\\n9,5;144.1915122\\n9,58;144.6609548\\n9,67;145.1273417\\n9,75;145.5908755\\n9,83;146.0517839\\n9,92;146.510321\\n10;146.9667676\\n10,08;147.421432\\n10,17;147.8746507\\n10,25;148.326789\\n10,33;148.7782409\\n10,42;149.2294296\\n10,5;149.6808068\\n10,58;150.1328531\\n10,67;150.5860767\\n10,75;151.0410123\\n10,83;151.4982199\\n10,92;151.9582822\\n11;152.4218027\\n11,08;152.8894016\\n11,17;153.3617127\\n11,25;153.839378\\n11,33;154.3230425\\n11,42;154.8133474\\n11,5;155.3109233\\n11,58;155.8163811\\n11,67;156.3303034\\n11,75;156.8532337\\n11,83;157.3856659\\n11,92;157.9280318\\n12;158.4806894\\n12,08;159.0439098\\n12,17;159.6178646\\n12,25;160.2026132\\n12,33;160.7980913\\n12,42;161.4041\\n12,5;162.0202967\\n12,58;162.6461885\\n12,67;163.2811271\\n12,75;163.9243081\\n12,83;164.5747721\\n12,92;165.2314109\\n13;165.892976\\n13,08;166.5580917\\n13,17;167.2252714\\n13,25;167.8929368\\n13,33;168.5594402\\n13,42;169.2230883\\n13,5;169.8821678\\n13,58;170.5349712\\n13,67;171.1798224\\n13,75;171.8151013\\n13,83;172.4392666\\n13,92;173.0508762\\n14;173.6486051\\n14,08;174.2312589\\n14,17;174.7977852\\n14,25;175.347281\\n14,33;175.8789961\\n14,42;176.392334\\n14,5;176.8868489\\n14,58;177.3622413\\n14,67;177.8183499\\n14,75;178.2551431\\n14,83;178.6727081\\n14,92;179.0712394\\n15;179.4510272\\n15,08;179.8124447\\n15,17;180.1559363\\n15,25;180.4820061\\n15,33;180.791206\\n15,42;181.0841263\\n15,5;181.3613851\\n15,58;181.6236202\\n15,67;181.871481\\n15,75;182.1056218\\n15,83;182.3266957\\n15,92;182.5353493\\n16;182.7322187\\n16,08;182.9179257\\n16,17;183.093075\\n16,25;183.2582518\\n16,33;183.4140202\\n16,42;183.5609217\\n16,5;183.6994748\\n16,58;183.8301738\\n16,67;183.9534894\\n16,75;184.0698683\\n16,83;184.1797333\\n16,92;184.2834844\\n17;184.3814989\\n17,08;184.4741322\\n17,17;184.5617185\\n17,25;184.644572\\n17,33;184.7229873\\n17,42;184.7972407\\n17,5;184.867591\\n17,58;184.9342803\\n17,67;184.9975349\\n17,75;185.0575666\\n17,83;185.114573\\n17,92;185.1687386\\n18;185.2202359\\n18,08;185.2692255\\n18,17;185.3158575\\n18,25;185.3602719\\n18,33;185.4025992\\n18,42;185.4429613\\n18,5;185.4814718\\n18,58;185.5182368\\n18,67;185.5533551\\n18,75;185.5869193\\n18,83;185.6190155\\n18,92;185.6497244\\n19;185.6791212\\n19,08;185.7072763\\n19,17;185.7342556\\n19,25;185.7601205\\n19,33;185.7849287\\n19,42;185.8087343\\n19,5;185.8315877\\n19,58;185.8535364\\n19,67;185.874625\\n19,75;185.8948951\\n19,83;185.914386\\n19,92;185.9331347\\n20;185.9511757\\n\\n\#\\nage [years];95th\\n2,08;92.63176749\\n2,17;93.53406648\\n2,25;94.40884914\\n2,33;95.25754106\\n2,42;96.08148848\\n2,5;96.88197981\\n2,58;97.66026663\\n2,67;98.4175791\\n2,75;99.15513792\\n2,83;99.87416352\\n2,92;100.5758831\\n3;101.2615351\\n3,08;101.9323762\\n3,17;102.5930445\\n3,25;103.2470198\\n3,33;103.8948257\\n3,42;104.5369608\\n3,5;105.1739016\\n3,58;105.8060983\\n3,67;106.4339786\\n3,75;107.0579468\\n3,83;107.6783842\\n3,92;108.2956497\\n4;108.9100797\\n4,08;109.5219891\\n4,17;110.1316713\\n4,25;110.7393989\\n4,33;111.3454248\\n4,42;111.9499779\\n4,5;112.5532737\\n4,58;113.1555037\\n4,67;113.7568423\\n4,75;114.3574452\\n4,83;114.9574502\\n4,92;115.5569776\\n5;116.1561304\\n5,08;116.7549954\\n5,17;117.3536426\\n5,25;117.9521268\\n5,33;118.5504872\\n5,42;119.1487482\\n5,5;119.7469201\\n5,58;120.3449993\\n5,67;120.9429688\\n5,75;121.540799\\n5,83;122.1384479\\n5,92;122.7358617\\n6;123.3329768\\n6,08;123.9297176\\n6,17;124.5259991\\n6,25;125.1217272\\n6,33;125.7167992\\n6,42;126.3111047\\n6,5;126.9045258\\n6,58;127.4969382\\n6,67;128.0882119\\n6,75;128.6782115\\n6,83;129.2667977\\n6,92;129.8538272\\n7;130.4391542\\n7,08;131.0226304\\n7,17;131.6041067\\n7,25;132.183433\\n7,33;132.7604599\\n7,42;133.335037\\n7,5;133.9070206\\n7,58;134.4762655\\n7,67;135.0426312\\n7,75;135.6059815\\n7,83;136.1661852\\n7,92;136.7231173\\n8;137.2766592\\n8,08;137.8267001\\n8,17;138.3731376\\n8,25;138.9158785\\n8,33;139.4548395\\n8,42;139.9899485\\n8,5;140.5211451\\n8,58;141.0483813\\n8,67;141.5716229\\n8,75;142.0908498\\n8,83;142.6060571\\n8,92;143.1172562\\n9;143.6244753\\n9,08;144.1277605\\n9,17;144.6271767\\n9,25;145.1228083\\n9,33;145.6147602\\n9,42;146.103159\\n9,5;146.5881531\\n9,58;147.0699143\\n9,67;147.5486382\\n9,75;148.0245452\\n9,83;148.4978811\\n9,92;148.9689178\\n10;149.4379538\\n10,08;149.9053151\\n10,17;150.3713549\\n10,25;150.8364543\\n10,33;151.3010223\\n10,42;151.7654951\\n10,5;152.2303363\\n10,58;152.6960355\\n10,67;153.1631074\\n10,75;153.6320904\\n10,83;154.103544\\n10,92;154.5780465\\n11;155.0561919\\n11,08;155.5385858\\n11,17;156.0258407\\n11,25;156.5185711\\n11,33;157.0173867\\n11,42;157.522886\\n11,5;158.0356481\\n11,58;158.5562242\\n11,67;159.085128\\n11,75;159.622826\\n11,83;160.1697263\\n11,92;160.7261679\\n12;161.2924091\\n12,08;161.8686162\\n12,17;162.4548526\\n12,25;163.0510679\\n12,33;163.657089\\n12,42;164.2726114\\n12,5;164.897193\\n12,58;165.5302497\\n12,67;166.1710534\\n12,75;166.8187329\\n12,83;167.4722776\\n12,92;168.1305444\\n13;168.7922681\\n13,08;169.4560742\\n13,17;170.1204959\\n13,25;170.7839909\\n13,33;171.444966\\n13,42;172.1017957\\n13,5;172.7528491\\n13,58;173.3965112\\n13,67;174.0312083\\n13,75;174.6554295\\n13,83;175.2677481\\n13,92;175.8668393\\n14;176.4514947\\n14,08;177.0206409\\n14,17;177.5733406\\n14,25;178.1088034\\n14,33;178.6263873\\n14,42;179.1255987\\n14,5;179.6060885\\n14,58;180.0676464\\n14,67;180.5101936\\n14,75;180.9337725\\n14,83;181.3385364\\n14,92;181.7247376\\n15;182.0927156\\n15,08;182.4428851\\n15,17;182.7757235\\n15,25;183.09176\\n15,33;183.3915648\\n15,42;183.6757386\\n15,5;183.9449038\\n15,58;184.1996965\\n15,67;184.4407585\\n15,75;184.6687321\\n15,83;184.8842531\\n15,92;185.0879485\\n16;185.2804307\\n16,08;185.4622948\\n16,17;185.6341183\\n16,25;185.7964565\\n16,33;185.949843\\n16,42;186.0947883\\n16,5;186.2317794\\n16,58;186.3612801\\n16,67;186.4837302\\n16,75;186.5995468\\n16,83;186.7091242\\n16,92;186.8128348\\n17;186.9110296\\n17,08;187.0040394\\n17,17;187.0921753\\n17,25;187.1757295\\n17,33;187.2549767\\n17,42;187.3301745\\n17,5;187.4015645\\n17,58;187.4693732\\n17,67;187.5338128\\n17,75;187.5950821\\n17,83;187.6533672\\n17,92;187.7088422\\n18;187.7616702\\n18,08;187.8120038\\n18,17;187.8599859\\n18,25;187.9057499\\n18,33;187.9494211\\n18,42;187.9911165\\n18,5;188.0309455\\n18,58;188.0690108\\n18,67;188.1054085\\n18,75;188.1402284\\n18,83;188.1735549\\n18,92;188.2054669\\n19;188.2360386\\n19,08;188.2653392\\n19,17;188.293434\\n19,25;188.3203841\\n19,33;188.3462469\\n19,42;188.3710763\\n19,5;188.394923\\n19,58;188.4178347\\n19,67;188.4398562\\n19,75;188.4610297\\n19,83;188.481395\\n19,92;188.5009894\\n20;188.5198484\\n\\n\#\\nage [years];97th\\n2,08;93.45923029\\n2,17;94.38278047\\n2,25;95.27761711\\n2,33;96.14511823\\n2,42;96.98662531\\n2,5;97.8034532\\n2,58;98.59690538\\n2,67;99.36828331\\n2,75;100.1188932\\n2,83;100.8500508\\n2,92;101.5630853\\n3;102.2593402\\n3,08;102.940182\\n3,17;103.5982668\\n3,25;104.2502776\\n3,33;104.8967054\\n3,42;105.5380208\\n3,5;106.1746779\\n3,58;106.8071048\\n3,67;107.4357106\\n3,75;108.0608826\\n3,83;108.6829866\\n3,92;109.3023669\\n4;109.9193463\\n4,08;110.5342263\\n4,17;111.1472879\\n4,25;111.7587911\\n4,33;112.3689778\\n4,42;112.9780622\\n4,5;113.5862516\\n4,58;114.1937245\\n4,67;114.800644\\n4,75;115.4071549\\n4,83;116.0133837\\n4,92;116.6194398\\n5;117.2254154\\n5,08;117.831386\\n5,17;118.4374113\\n5,25;119.0435349\\n5,33;119.6497853\\n5,42;120.2561762\\n5,5;120.8627069\\n5,58;121.4693629\\n5,67;122.0761162\\n5,75;122.682926\\n5,83;123.2897392\\n5,92;123.8964899\\n6;124.5031042\\n6,08;125.1094938\\n6,17;125.7155618\\n6,25;126.3212019\\n6,33;126.926299\\n6,42;127.5307299\\n6,5;128.134364\\n6,58;128.737064\\n6,67;129.3386866\\n6,75;129.9390834\\n6,83;130.5381015\\n6,92;131.1355844\\n7;131.7313729\\n7,08;132.3253057\\n7,17;132.9172205\\n7,25;133.5069548\\n7,33;134.0943467\\n7,42;134.6792321\\n7,5;135.2614591\\n7,58;135.8408704\\n7,67;136.4173156\\n7,75;136.9906494\\n7,83;137.5607324\\n7,92;138.1274323\\n8;138.6906245\\n8,08;139.2501934\\n8,17;139.8060325\\n8,25;140.3580462\\n8,33;140.9061502\\n8,42;141.4502723\\n8,5;141.9903534\\n8,58;142.5263486\\n8,67;143.0582274\\n8,75;143.5859753\\n8,83;144.109594\\n8,92;144.6291028\\n9;145.1445387\\n9,08;145.6559581\\n9,17;146.1634368\\n9,25;146.6670713\\n9,33;147.1669794\\n9,42;147.6633011\\n9,5;148.1561991\\n9,58;148.6458598\\n9,67;149.132494\\n9,75;149.6163372\\n9,83;150.0976507\\n9,92;150.5767217\\n10;151.0538639\\n10,08;151.5294179\\n10,17;152.0037511\\n10,25;152.4772579\\n10,33;152.9503596\\n10,42;153.4235035\\n10,5;153.8971624\\n10,58;154.3718335\\n10,67;154.8480367\\n10,75;155.3263129\\n10,83;155.8072211\\n10,92;156.2913356\\n11;156.7792423\\n11,08;157.2715342\\n11,17;157.7688063\\n11,25;158.27165\\n11,33;158.7806462\\n11,42;159.2963578\\n11,5;159.8193221\\n11,58;160.3500415\\n11,67;160.8889743\\n11,75;161.4365245\\n11,83;161.993032\\n11,92;162.5587616\\n12;163.133893\\n12,08;163.7185106\\n12,17;164.3125939\\n12,25;164.9160089\\n12,33;165.5285004\\n12,42;166.1496863\\n12,5;166.7790531\\n12,58;167.4159536\\n12,67;168.0596069\\n12,75;168.7091009\\n12,83;169.3633976\\n12,92;170.0213408\\n13;170.6816665\\n13,08;171.3430163\\n13,17;172.0039535\\n13,25;172.662978\\n13,33;173.3185527\\n13,42;173.9691164\\n13,5;174.6131123\\n13,58;175.2490052\\n13,67;175.8753066\\n13,75;176.490594\\n13,83;177.0935299\\n13,92;177.6828795\\n14;178.2575211\\n14,08;178.8164693\\n14,17;179.3588685\\n14,25;179.8840066\\n14,33;180.3913154\\n14,42;180.8803698\\n14,5;181.3508837\\n14,58;181.8027041\\n14,67;182.2358034\\n14,75;182.6502694\\n14,83;183.0462946\\n14,92;183.4241646\\n15;183.7842466\\n15,08;184.1269767\\n15,17;184.4528488\\n15,25;184.7624031\\n15,33;185.0562159\\n15,42;185.3348893\\n15,5;185.5990431\\n15,58;185.8493063\\n15,67;186.0863109\\n15,75;186.3106859\\n15,83;186.5230505\\n15,92;186.7240141\\n16;186.914169\\n16,08;187.0940877\\n16,17;187.2643258\\n16,25;187.4254148\\n16,33;187.5778643\\n16,42;187.7221607\\n16,5;187.8587671\\n16,58;187.9881233\\n16,67;188.1106465\\n16,75;188.2267311\\n16,83;188.3367503\\n16,92;188.4410559\\n17;188.5399798\\n17,08;188.6338345\\n17,17;188.7229142\\n17,25;188.8074955\\n17,33;188.8878386\\n17,42;188.9641878\\n17,5;189.0367727\\n17,58;189.1058089\\n17,67;189.1714988\\n17,75;189.2340323\\n17,83;189.2935878\\n17,92;189.3503326\\n18;189.4044237\\n18,08;189.4560086\\n18,17;189.5052256\\n18,25;189.5522044\\n18,33;189.5970671\\n18,42;189.6399279\\n18,5;189.6808943\\n18,58;189.7200672\\n18,67;189.7575413\\n18,75;189.7934056\\n18,83;189.8277438\\n18,92;189.8606344\\n19;189.8921514\\n19,08;189.9223642\\n19,17;189.9513383\\n19,25;189.9791351\\n19,33;190.0058126\\n19,42;190.0314253\\n19,5;190.0560245\\n19,58;190.0796588\\n19,67;190.1023738\\n19,75;190.1242124\\n19,83;190.1452154\\n19,92;190.1654212\\n20;190.1848658\\n\\n\#\\n0;45.16290983\\n0,08;47.5343839\\n0,17;51.01964\\n0,25;53.69072443\\n0,33;55.92026196\\n0,42;57.86522501\\n0,5;59.60832861\\n0,58;61.19916978\\n0,67;62.67013206\\n0,75;64.04368248\\n0,83;65.33613405\\n0,92;66.55975865\\n1;67.7240539\\n1,08;68.8365432\\n1,17;69.9033028\\n1,25;70.92932142\\n1,33;71.91875303\\n1,42;72.87509898\\n1,5;73.80134232\\n1,58;74.70004853\\n1,67;75.57344266\\n1,75;76.42346895\\n1,83;77.25183786\\n1,92;78.06006336\\n2;78.84949387\\n2,08;79.62133263\\n2,17;80.40197647\\n2,25;81.17554759\\n2,33;81.9356973\\n2,42;82.67746051\\n2,5;83.39711819\\n2,58;84.09206184\\n2,67;84.76065415\\n2,75;85.40209562\\n2,83;86.01630353\\n2,92;86.60378996\\n3;87.16557262\\n\\n\#\\n0;45.63583839\\n0,08;48.0208249\\n0,17;51.53503149\\n0,25;54.23298148\\n0,33;56.48662578\\n0,42;58.4532373\\n0,5;60.21593325\\n0,58;61.82466699\\n0,67;63.31211299\\n0,75;64.70097098\\n0,83;66.0077396\\n0,92;67.24483959\\n1;68.42188876\\n1,08;69.54650838\\n1,17;70.62485507\\n1,25;71.66198409\\n1,33;72.66210489\\n1,42;73.6287655\\n1,5;74.56498844\\n1,58;75.47337286\\n1,67;76.35617266\\n1,75;77.21535696\\n1,83;78.05265781\\n1,92;78.86960798\\n2;79.66757195\\n2,08;80.44776859\\n2,17;81.24225735\\n2,25;82.02666181\\n2,33;82.79539596\\n2,42;83.54410888\\n2,5;84.26956585\\n2,58;84.96952943\\n2,67;85.64263937\\n2,75;86.28829708\\n2,83;86.90655881\\n2,92;87.49803144\\n3;88.06378819\\n\\n\#\\n0;46.38717056\\n0,08;48.78800472\\n0,17;52.33953078\\n0,25;55.07361272\\n0,33;57.36048247\\n0,42;59.3575223\\n0,5;61.14823459\\n0,58;62.78295251\\n0,67;64.2946723\\n0,75;65.70635581\\n0,83;67.03471346\\n0,92;68.29233743\\n1;69.48898529\\n1,08;70.6323931\\n1,17;71.72881264\\n1,25;72.78337866\\n1,33;73.8003676\\n1,42;74.78338431\\n1,5;75.73549992\\n1,58;76.6593554\\n1,67;77.55724085\\n1,75;78.43115695\\n1,83;79.28286338\\n1,92;80.11391724\\n2;80.92570398\\n2,08;81.71946302\\n2,17;82.53540957\\n2,25;83.3369944\\n2,33;84.11968453\\n2,42;84.87997909\\n2,5;85.61531679\\n2,58;86.32398013\\n2,67;87.00500071\\n2,75;87.65806752\\n2,83;88.28343922\\n2,92;88.88186325\\n3;89.4544988\\n\\n\#\\n0;47.70947448\\n0,08;50.12141713\\n0,17;53.71386774\\n0,25;56.49359771\\n0,33;58.82538022\\n0,42;60.86551938\\n0,5;62.69739258\\n0,58;64.37145135\\n0,67;65.92086464\\n0,75;67.3687658\\n0,83;68.73201986\\n0,92;70.02335386\\n1;71.25264177\\n1,08;72.42771996\\n1,17;73.55492682\\n1,25;74.63947222\\n1,33;75.6856981\\n1,42;76.69726669\\n1,5;77.67729966\\n1,58;78.62848273\\n1,67;79.55314579\\n1,75;80.45332508\\n1,83;81.33081218\\n1,92;82.18719293\\n2;83.02387816\\n2,08;83.84213246\\n2,17;84.69430336\\n2,25;85.52592034\\n2,33;86.33389245\\n2,42;87.11588888\\n2,5;87.87028387\\n2,58;88.5960919\\n2,67;89.29290603\\n2,75;89.96083624\\n2,83;90.60044644\\n2,92;91.21270297\\n3;91.79890839\\n\\n\#\\n0;49.28639612\\n0,08;51.68358057\\n0,17;55.28612813\\n0,25;58.09381906\\n0,33;60.45980763\\n0,42;62.53669656\\n0,5;64.40632762\\n0,58;66.11841553\\n0,67;67.70574419\\n0,75;69.19123614\\n0,83;70.59163924\\n0,92;71.91961673\\n1;73.1850104\\n1,08;74.39564379\\n1,17;75.5578544\\n1,25;76.67685871\\n1,33;77.75700986\\n1,42;78.80198406\\n1,5;79.81491852\\n1,58;80.79851532\\n1,67;81.75512092\\n1,75;82.6867881\\n1,83;83.59532461\\n1,92;84.48233206\\n2;85.34923624\\n2,08;86.1973169\\n2,17;87.09026318\\n2,25;87.95714182\\n2,33;88.7960184\\n2,42;89.6055115\\n2,5;90.38476689\\n2,58;91.13341722\\n2,67;91.8515436\\n2,75;92.5396352\\n2,83;93.19854429\\n2,92;93.82945392\\n3;94.43382278\\n\\n\#\\n0;50.99057602\\n0,08;53.33761678\\n0,17;56.90755246\\n0,25;59.71777002\\n0,33;62.10128248\\n0,42;64.20347124\\n0,5;66.10283931\\n0,58;67.84732266\\n0,67;69.46866839\\n0,75;70.9891564\\n0,83;72.42511841\\n0,92;73.7889394\\n1;75.09027076\\n1,08;76.33680358\\n1,17;77.53478229\\n1,25;78.68935763\\n1,33;79.80483633\\n1,42;80.88486219\\n1,5;81.9325501\\n1,58;82.9505873\\n1,67;83.94131098\\n1,75;84.90676875\\n1,83;85.84876629\\n1,92;86.76890547\\n2;87.6686143\\n2,08;88.54917522\\n2,17;89.483435\\n2,25;90.3875095\\n2,33;91.26017565\\n2,42;92.10065173\\n2,5;92.90858598\\n2,58;93.68403041\\n2,67;94.42741325\\n2,75;95.13950841\\n2,83;95.82140026\\n2,92;96.47445723\\n3;97.10028751\\n\\n\#\\n0;52.64705428\\n0,08;54.91147535\\n0,17;58.41025523\\n0,25;61.19969178\\n0,33;63.58457922\\n0,42;65.69997036\\n0,5;67.61954037\\n0,58;69.38863359\\n0,67;71.03747474\\n0,75;72.5873908\\n0,83;74.05408822\\n0,92;75.44952668\\n1;76.78305993\\n1,08;78.06216608\\n1,17;79.29293439\\n1,25;80.480401\\n1,33;81.62878705\\n1,42;82.74167188\\n1,5;83.82212167\\n1,58;84.87278665\\n1,67;85.89597597\\n1,75;86.89371606\\n1,83;87.86779673\\n1,92;88.81980812\\n2;89.75117034\\n2,08;90.66315834\\n2,17;91.63504785\\n2,25;92.57420584\\n2,33;93.47968776\\n2,42;94.35096822\\n2,5;95.18792816\\n2,58;95.99083262\\n2,67;96.76030359\\n2,75;97.49728978\\n2,83;98.20303421\\n2,92;98.87904266\\n3;99.52704954\\n\\n\#\\n0;53.70008709\\n0,08;55.89473554\\n0,17;59.32973811\\n0,25;62.09577757\\n0,33;64.47491479\\n0,42;66.59395216\\n0,5;68.52274397\\n0,58;70.30459957\\n0,67;71.96855522\\n0,75;73.53519665\\n0,83;75.01974455\\n0,92;76.43382785\\n1;77.78656813\\n1,08;79.08527641\\n1,17;80.33591931\\n1,25;81.54344138\\n1,33;82.7119945\\n1,42;83.84510502\\n1,5;84.94579817\\n1,58;86.01669241\\n1,67;87.06007202\\n1,75;88.07794398\\n1,83;89.07208283\\n1,92;90.0440667\\n2;90.99530689\\n2,08;91.92706971\\n2,17;92.92167631\\n2,25;93.88254082\\n2,33;94.80872819\\n2,42;95.69974364\\n2,5;96.55551171\\n2,58;97.37635253\\n2,67;98.16295103\\n2,75;98.91632342\\n2,83;99.63778417\\n2,92;100.328907\\n3;100.991497\\n\\n\#\\n0;54.41073727\\n0,08;56.55076942\\n0,17;59.93512871\\n0,25;62.68142294\\n0,33;65.05417552\\n0,42;67.17389743\\n0,5;69.10755723\\n0,58;70.89693895\\n0,67;72.5701931\\n0,75;74.14735522\\n0,83;75.64328643\\n0,92;77.06937115\\n1;78.43455934\\n1,08;79.74603843\\n1,17;81.00968409\\n1,25;82.2303728\\n1,33;83.41220466\\n1,42;84.55866622\\n1,5;85.67275177\\n1,58;86.75705551\\n1,67;87.81384263\\n1,75;88.84510488\\n1,83;89.85260475\\n1,92;90.83791074\\n2;91.80242687\\n2,08;92.74741225\\n2,17;93.75684975\\n2,25;94.7320912\\n2,33;95.67214661\\n2,42;96.57649339\\n2,5;97.44504712\\n2,58;98.27813528\\n2,67;99.07646264\\n2,75;99.84107435\\n2,83;100.5733217\\n2,92;101.2748164\\n3;101.9474075\\n\\n\#\\n2,08;78.82133263\\n2,17;79.60197647\\n2,25;80.37554759\\n2,33;81.1356973\\n2,42;81.87746051\\n2,5;82.59711819\\n2,58;83.29206184\\n2,67;83.96065415\\n2,75;84.60209562\\n2,83;85.21630353\\n2,92;85.80378996\\n3;86.36557262\\n3,08;86.90307328\\n3,17;87.43482018\\n3,25;87.95945137\\n3,33;88.47849954\\n3,42;88.99330218\\n3,5;89.50502066\\n3,58;90.01465759\\n3,67;90.52307278\\n3,75;91.03099757\\n3,83;91.5390479\\n3,92;92.04773605\\n4;92.55748123\\n4,08;93.06861913\\n4,17;93.58141046\\n4,25;94.09604867\\n4,33;94.61266684\\n4,42;95.13134395\\n4,5;95.65211042\\n4,58;96.17495324\\n4,67;96.69982047\\n4,75;97.2266254\\n4,83;97.75525036\\n4,92;98.28555005\\n5;98.81735475\\n5,08;99.35047319\\n5,17;99.88469514\\n5,25;100.4197939\\n5,33;100.9555286\\n5,42;101.4916463\\n5,5;102.0278838\\n5,58;102.5639698\\n5,67;103.0996264\\n5,75;103.6345709\\n5,83;104.1685175\\n5,92;104.7011761\\n6;105.2322625\\n6,08;105.7614857\\n6,17;106.2885612\\n6,25;106.8132066\\n6,33;107.3351443\\n6,42;107.8541019\\n6,5;108.3698135\\n6,58;108.8820206\\n6,67;109.3904733\\n6,75;109.8949308\\n6,83;110.3951624\\n6,92;110.890948\\n7;111.3820796\\n7,08;111.868361\\n7,17;112.3496093\\n7,25;112.825655\\n7,33;113.2963432\\n7,42;113.7615336\\n7,5;114.2211014\\n7,58;114.674938\\n7,67;115.1229513\\n7,75;115.5650666\\n7,83;116.001227\\n7,92;116.4313942\\n8;116.8555488\\n8,08;117.2736916\\n8,17;117.6858437\\n8,25;118.092048\\n8,33;118.4923693\\n8,42;118.8868959\\n8,5;119.2757403\\n8,58;119.6590402\\n8,67;120.0369603\\n8,75;120.4096928\\n8,83;120.7774598\\n8,92;121.140514\\n9;121.4991408\\n9,08;121.8536605\\n9,17;122.2044292\\n9,25;122.551842\\n9,33;122.8963342\\n9,42;123.2383839\\n9,5;123.5785142\\n9,58;123.9172948\\n9,67;124.2553446\\n9,75;124.5933332\\n9,83;124.9319822\\n9,92;125.2720662\\n10;125.6144133\\n10,08;125.9599043\\n10,17;126.3094709\\n10,25;126.6640931\\n10,33;127.0247941\\n10,42;127.3926332\\n10,5;127.7686986\\n10,58;128.1540923\\n10,67;128.5499184\\n10,75;128.9572634\\n10,83;129.3771753\\n10,92;129.8106385\\n11;130.2585454\\n11,08;130.7216652\\n11,17;131.2006102\\n11,25;131.6958014\\n11,33;132.2074327\\n11,42;132.7354383\\n11,5;133.2794613\\n11,58;133.8388331\\n11,67;134.4125492\\n11,75;134.9992687\\n11,83;135.5973139\\n11,92;136.2046931\\n12;136.8191174\\n12,08;137.4380555\\n12,17;138.0587804\\n12,25;138.6784334\\n12,33;139.2940935\\n12,42;139.902849\\n12,5;140.5018697\\n12,58;141.0884738\\n12,67;141.6601883\\n12,75;142.2147984\\n12,83;142.7503859\\n12,92;143.2653544\\n13;143.7584411\\n13,08;144.2287179\\n13,17;144.6755805\\n13,25;145.0987292\\n13,33;145.4981426\\n13,42;145.8740473\\n13,5;146.2268836\\n13,58;146.5572714\\n13,67;146.8659759\\n13,75;147.1538752\\n13,83;147.4219304\\n13,92;147.6711585\\n14;147.902609\\n14,08;148.1173446\\n14,17;148.3164186\\n14,25;148.5008727\\n14,33;148.6717163\\n14,42;148.8299213\\n14,5;148.976416\\n14,58;149.1120814\\n14,67;149.2377485\\n14,75;149.3541954\\n14,83;149.4621532\\n14,92;149.5622993\\n15;149.6552628\\n15,08;149.7416255\\n15,17;149.8219242\\n15,25;149.8966533\\n15,33;149.9662668\\n15,42;150.0311812\\n15,5;150.0917784\\n15,58;150.1484074\\n15,67;150.2013879\\n15,75;150.2510113\\n15,83;150.2975443\\n15,92;150.3412298\\n16;150.3822898\\n16,08;150.4209266\\n16,17;150.4573249\\n16,25;150.4916531\\n16,33;150.524065\\n16,42;150.5547008\\n16,5;150.5836887\\n16,58;150.6111457\\n16,67;150.6371789\\n16,75;150.661886\\n16,83;150.6853568\\n16,92;150.7076733\\n17;150.7289106\\n17,08;150.749138\\n17,17;150.7684187\\n17,25;150.7868111\\n17,33;150.8043689\\n17,42;150.8211416\\n17,5;150.8371748\\n17,58;150.8525106\\n17,67;150.8671882\\n17,75;150.8812435\\n17,83;150.8947102\\n17,92;150.9076191\\n18;150.9199994\\n18,08;150.9318778\\n18,17;150.9432795\\n18,25;150.9542279\\n18,33;150.9647448\\n18,42;150.9748507\\n18,5;150.9845649\\n18,58;150.9939053\\n18,67;151.0028889\\n18,75;151.0115315\\n18,83;151.0198482\\n18,92;151.0278532\\n19;151.0355596\\n19,08;151.0429803\\n19,17;151.0501271\\n19,25;151.0570114\\n19,33;151.0636438\\n19,42;151.0700346\\n19,5;151.0761934\\n19,58;151.0821295\\n19,67;151.0878515\\n19,75;151.0933679\\n19,83;151.0986866\\n19,92;151.1038152\\n20;151.1087609\\n\\n\#\\n2,08;79.64776859\\n2,17;80.44225735\\n2,25;81.22666181\\n2,33;81.99539596\\n2,42;82.74410888\\n2,5;83.46956585\\n2,58;84.16952943\\n2,67;84.84263937\\n2,75;85.48829708\\n2,83;86.10655881\\n2,92;86.69803144\\n3;87.26378819\\n3,08;87.80528157\\n3,17;88.34236213\\n3,25;88.87255864\\n3,33;89.39733426\\n3,42;89.91797078\\n3,5;90.43558554\\n3,58;90.95114701\\n3,67;91.4654891\\n3,75;91.97932415\\n3,83;92.49325483\\n3,92;93.00778484\\n4;93.52332863\\n4,08;94.04022021\\n4,17;94.55872109\\n4,25;95.07902737\\n4,33;95.60127628\\n4,42;96.12555202\\n4,5;96.65189097\\n4,58;97.18028656\\n4,67;97.7106936\\n4,75;98.24303219\\n4,83;98.77719141\\n4,92;99.31303257\\n5;99.85039229\\n5,08;100.3890853\\n5,17;100.9289069\\n5,25;101.4696357\\n5,33;102.0110354\\n5,42;102.5528574\\n5,5;103.0948423\\n5,58;103.6367221\\n5,67;104.1782217\\n5,75;104.7190606\\n5,83;105.258955\\n5,92;105.797617\\n6;106.3347618\\n6,08;106.8701003\\n6,17;107.4033481\\n6,25;107.9342229\\n6,33;108.4624465\\n6,42;108.987746\\n6,5;109.5098548\\n6,58;110.0285133\\n6,67;110.5434704\\n6,75;111.0544841\\n6,83;111.5613221\\n6,92;112.0637632\\n7;112.5615976\\n7,08;113.054628\\n7,17;113.54267\\n7,25;114.0255532\\n7,33;114.5031216\\n7,42;114.9752341\\n7,5;115.4417656\\n7,58;115.9026074\\n7,67;116.3576679\\n7,75;116.8068731\\n7,83;117.2501678\\n7,92;117.6875155\\n8;118.1188998\\n8,08;118.5443251\\n8,17;118.9638171\\n8,25;119.3774239\\n8,33;119.7852171\\n8,42;120.1872927\\n8,5;120.5837721\\n8,58;120.9748035\\n8,67;121.3605632\\n8,75;121.7412571\\n8,83;122.1171219\\n8,92;122.4884272\\n9;122.8554769\\n9,08;123.2186111\\n9,17;123.5782083\\n9,25;123.9346869\\n9,33;124.2885075\\n9,42;124.6401749\\n9,5;124.9902397\\n9,58;125.3393004\\n9,67;125.6880049\\n9,75;126.0370512\\n9,83;126.3871885\\n9,92;126.7392174\\n10;127.0939883\\n10,08;127.4524005\\n10,17;127.8153983\\n10,25;128.1839668\\n10,33;128.5591249\\n10,42;128.9419168\\n10,5;129.3334014\\n10,58;129.7346372\\n10,67;130.1466666\\n10,75;130.5704957\\n10,83;131.0070717\\n10,92;131.4572565\\n11;131.9217986\\n11,08;132.4013028\\n11,17;132.8961979\\n11,25;133.4067049\\n11,33;133.9328066\\n11,42;134.4742195\\n11,5;135.0303699\\n11,58;135.6003795\\n11,67;136.1830524\\n11,75;136.7768804\\n11,83;137.3800519\\n11,92;137.9904798\\n12;138.6058289\\n12,08;139.2235689\\n12,17;139.8410247\\n12,25;140.4554388\\n12,33;141.064036\\n12,42;141.6640898\\n12,5;142.2529855\\n12,58;142.8282787\\n12,67;143.3877452\\n12,75;143.9294218\\n12,83;144.4516354\\n12,92;144.9530205\\n13;145.4325259\\n13,08;145.8894106\\n13,17;146.3232308\\n13,25;146.7338197\\n13,33;147.1212613\\n13,42;147.4858611\\n13,5;147.8281145\\n13,58;148.148675\\n13,67;148.4483225\\n13,75;148.7279342\\n13,83;148.9884574\\n13,92;149.2308852\\n14;149.4562355\\n14,08;149.6655332\\n14,17;149.8597926\\n14,25;150.0400107\\n14,33;150.2071532\\n14,42;150.3621482\\n14,5;150.5058813\\n14,58;150.6391923\\n14,67;150.7628729\\n14,75;150.877665\\n14,83;150.9842639\\n14,92;151.0833153\\n15;151.1754186\\n15,08;151.2611287\\n15,17;151.3409575\\n15,25;151.415377\\n15,33;151.4848208\\n15,42;151.5496874\\n15,5;151.610342\\n15,58;151.6671193\\n15,67;151.7203255\\n15,75;151.7702407\\n15,83;151.8171212\\n15,92;151.8612008\\n16;151.9026934\\n16,08;151.9417942\\n16,17;151.9786817\\n16,25;152.013519\\n16,33;152.0464549\\n16,42;152.0776257\\n16,5;152.1071558\\n16,58;152.1351593\\n16,67;152.1617405\\n16,75;152.1869949\\n16,83;152.2110102\\n16,92;152.2338667\\n17;152.2556383\\n17,08;152.2763929\\n17,17;152.296193\\n17,25;152.3150959\\n17,33;152.3331548\\n17,42;152.3504187\\n17,5;152.3669327\\n17,58;152.3827387\\n17,67;152.3978755\\n17,75;152.412379\\n17,83;152.4262827\\n17,92;152.4396177\\n18;152.4524128\\n18,08;152.464695\\n18,17;152.4764895\\n18,25;152.4878198\\n18,33;152.498708\\n18,42;152.5091747\\n18,5;152.5192393\\n18,58;152.52892\\n18,67;152.5382338\\n18,75;152.5471971\\n18,83;152.5558248\\n18,92;152.5641315\\n19;152.5721307\\n19,08;152.5798353\\n19,17;152.5872574\\n19,25;152.5944085\\n19,33;152.6012996\\n19,42;152.6079412\\n19,5;152.6143431\\n19,58;152.6205147\\n19,67;152.626465\\n19,75;152.6322026\\n19,83;152.6377356\\n19,92;152.6430718\\n20;152.6482187\\n\\n\#\\n2,08;80.91946302\\n2,17;81.73540957\\n2,25;82.5369944\\n2,33;83.31968453\\n2,42;84.07997909\\n2,5;84.81531679\\n2,58;85.52398013\\n2,67;86.20500071\\n2,75;86.85806752\\n2,83;87.48343922\\n2,92;88.08186325\\n3;88.6544988\\n3,08;89.20284893\\n3,17;89.74875322\\n3,25;90.28810699\\n3,33;90.82227549\\n3,42;91.35246174\\n3,5;91.87972051\\n3,58;92.40497144\\n3,67;92.92901112\\n3,75;93.45252422\\n3,83;93.97609374\\n3,92;94.50021028\\n4;95.02528063\\n4,08;95.55163545\\n4,17;96.07953634\\n4,25;96.60918226\\n4,33;97.14071535\\n4,42;97.67422621\\n4,5;98.20975881\\n4,58;98.74731484\\n4,67;99.28685775\\n4,75;99.82831652\\n4,83;100.371589\\n4,92;100.9165451\\n5;101.4630296\\n5,08;102.0108651\\n5,17;102.5598541\\n5,25;103.1097819\\n5,33;103.6604184\\n5,42;104.2115203\\n5,5;104.762833\\n5,58;105.3140925\\n5,67;105.8650274\\n5,75;106.4153599\\n5,83;106.9648081\\n5,92;107.5130874\\n6;108.0599112\\n6,08;108.6049935\\n6,17;109.148049\\n6,25;109.6887954\\n6,33;110.2269537\\n6,42;110.7622502\\n6,5;111.2944168\\n6,58;111.8231928\\n6,67;112.3483251\\n6,75;112.8695701\\n6,83;113.3866939\\n6,92;113.8994733\\n7;114.407697\\n7,08;114.9111662\\n7,17;115.4096953\\n7,25;115.9031127\\n7,33;116.391262\\n7,42;116.874002\\n7,5;117.351208\\n7,58;117.8227724\\n7,67;118.2886054\\n7,75;118.7486357\\n7,83;119.2028114\\n7,92;119.651101\\n8;120.0934937\\n8,08;120.5300007\\n8,17;120.9606563\\n8,25;121.3855185\\n8,33;121.8046703\\n8,42;122.2182208\\n8,5;122.6263066\\n8,58;123.029093\\n8,67;123.4267753\\n8,75;123.8195805\\n8,83;124.2077692\\n8,92;124.5916364\\n9;124.9715143\\n9,08;125.3477734\\n9,17;125.7208245\\n9,25;126.0911208\\n9,33;126.4591593\\n9,42;126.8254825\\n9,5;127.1906801\\n9,58;127.5553896\\n9,67;127.9202978\\n9,75;128.2861404\\n9,83;128.6537014\\n9,92;129.0238124\\n10;129.3973496\\n10,08;129.7752299\\n10,17;130.1584061\\n10,25;130.5478595\\n10,33;130.9445907\\n10,42;131.3496084\\n10,5;131.7639151\\n10,58;132.1884911\\n10,67;132.6242751\\n10,75;133.072142\\n10,83;133.5328789\\n10,92;134.0071586\\n11;134.4955119\\n11,08;134.9982982\\n11,17;135.5156778\\n11,25;136.0475846\\n11,33;136.5937022\\n11,42;137.1534445\\n11,5;137.7259419\\n11,58;138.3100351\\n11,67;138.9042785\\n11,75;139.5069517\\n11,83;140.1160824\\n11,92;140.7294775\\n12;141.3447662\\n12,08;141.9594471\\n12,17;142.5709442\\n12,25;143.1766639\\n12,33;143.7740547\\n12,42;144.3606631\\n12,5;144.9341866\\n12,58;145.4925187\\n12,67;146.0337866\\n12,75;146.5563788\\n12,83;147.0589626\\n12,92;147.5404925\\n13;148.0002085\\n13,08;148.437627\\n13,17;148.8525242\\n13,25;149.2449147\\n13,33;149.6150259\\n13,42;149.9632704\\n13,5;150.2902174\\n13,58;150.5965645\\n13,67;150.8831097\\n13,75;151.1507267\\n13,83;151.4003414\\n13,92;151.6329115\\n14;151.8494087\\n14,08;152.0508033\\n14,17;152.238053\\n14,25;152.4120911\\n14,33;152.5738202\\n14,42;152.7241057\\n14,5;152.8637721\\n14,58;152.9936001\\n14,67;153.1143251\\n14,75;153.2266371\\n14,83;153.3311804\\n14,92;153.4285552\\n15;153.5193185\\n15,08;153.6039864\\n15,17;153.6830356\\n15,25;153.7569057\\n15,33;153.8260015\\n15,42;153.8906954\\n15,5;153.951329\\n15,58;154.0082162\\n15,67;154.0616446\\n15,75;154.1118775\\n15,83;154.1591564\\n15,92;154.2037023\\n16;154.2457175\\n16,08;154.2853872\\n16,17;154.3228809\\n16,25;154.3583538\\n16,33;154.3919483\\n16,42;154.4237944\\n16,5;154.4540118\\n16,58;154.4827098\\n16,67;154.509989\\n16,75;154.5359417\\n16,83;154.5606528\\n16,92;154.5842002\\n17;154.6066558\\n17,08;154.6280858\\n17,17;154.6485512\\n17,25;154.6681084\\n17,33;154.6868095\\n17,42;154.7047027\\n17,5;154.7218327\\n17,58;154.7382408\\n17,67;154.7539655\\n17,75;154.7690427\\n17,83;154.7835054\\n17,92;154.7973849\\n18;154.81071\\n18,08;154.8235077\\n18,17;154.8358035\\n18,25;154.8476208\\n18,33;154.8589821\\n18,42;154.8699082\\n18,5;154.8804186\\n18,58;154.8905318\\n18,67;154.9002654\\n18,75;154.9096356\\n18,83;154.9186579\\n18,92;154.9273472\\n19;154.9357171\\n19,08;154.9437809\\n19,17;154.9515511\\n19,25;154.9590395\\n19,33;154.9662574\\n19,42;154.9732154\\n19,5;154.9799237\\n19,58;154.9863922\\n19,67;154.9926299\\n19,75;154.9986458\\n19,83;155.0044483\\n19,92;155.0100454\\n20;155.0154449\\n\\n\#\\n2,08;83.04213246\\n2,17;83.89430336\\n2,25;84.72592034\\n2,33;85.53389245\\n2,42;86.31588888\\n2,5;87.07028387\\n2,58;87.7960919\\n2,67;88.49290603\\n2,75;89.16083624\\n2,83;89.80044644\\n2,92;90.41270297\\n3;90.99890839\\n3,08;91.56065781\\n3,17;92.12298263\\n3,25;92.67925322\\n3,33;93.23069622\\n3,42;93.77840211\\n3,5;94.3233355\\n3,58;94.86634477\\n3,67;95.40817129\\n3,75;95.94945793\\n3,83;96.49075704\\n3,92;97.03253788\\n4;97.57519341\\n4,08;98.11904662\\n4,17;98.66435637\\n4,25;99.2113227\\n4,33;99.76009185\\n4,42;100.3107608\\n4,5;100.8633813\\n4,58;101.4179641\\n4,67;101.9744822\\n4,75;102.5328747\\n4,83;103.0930492\\n4,92;103.6548853\\n5;104.2182371\\n5,08;104.7829358\\n5,17;105.348792\\n5,25;105.9155982\\n5,33;106.4831306\\n5,42;107.0511517\\n5,5;107.6194116\\n5,58;108.1876502\\n5,67;108.7555991\\n5,75;109.3229831\\n5,83;109.8895213\\n5,92;110.4549317\\n6;111.0189247\\n6,08;111.5812164\\n6,17;112.1415202\\n6,25;112.6995522\\n6,33;113.2550319\\n6,42;113.8076835\\n6,5;114.3572371\\n6,58;114.9034294\\n6,67;115.4460056\\n6,75;115.9847196\\n6,83;116.5193358\\n6,92;117.0496296\\n7;117.5753884\\n7,08;118.0964128\\n7,17;118.6125173\\n7,25;119.1235313\\n7,33;119.6293\\n7,42;120.1296849\\n7,5;120.6245654\\n7,58;121.113839\\n7,67;121.5974226\\n7,75;122.0752529\\n7,83;122.5472882\\n7,92;123.0135084\\n8;123.4739166\\n8,08;123.92854\\n8,17;124.3774309\\n8,25;124.8206679\\n8,33;125.2583572\\n8,42;125.6906338\\n8,5;126.1176628\\n8,58;126.5396411\\n8,67;126.9567984\\n8,75;127.3693994\\n8,83;127.7777448\\n8,92;128.1821733\\n9;128.5830629\\n9,08;128.9808329\\n9,17;129.3759451\\n9,25;129.7689053\\n9,33;130.1602643\\n9,42;130.5506193\\n9,5;130.9406135\\n9,58;131.330937\\n9,67;131.7223254\\n9,75;132.1155587\\n9,83;132.5114586\\n9,92;132.9108849\\n10;133.3147302\\n10,08;133.7239135\\n10,17;134.1393714\\n10,25;134.5620476\\n10,33;134.9928804\\n10,42;135.4327874\\n10,5;135.8826474\\n10,58;136.3432832\\n10,67;136.8154369\\n10,75;137.299748\\n10,83;137.7967284\\n10,92;138.3067365\\n11;138.8299523\\n11,08;139.3663536\\n11,17;139.9156938\\n11,25;140.4774848\\n11,33;141.0509836\\n11,42;141.6351863\\n11,5;142.228829\\n11,58;142.8303943\\n11,67;143.4381342\\n11,75;144.0500909\\n11,83;144.6641345\\n11,92;145.2779986\\n12;145.8893375\\n12,08;146.4957662\\n12,17;147.0949169\\n12,25;147.6844892\\n12,33;148.2622979\\n12,42;148.8263158\\n12,5;149.3747099\\n12,58;149.9058698\\n12,67;150.4184277\\n12,75;150.9112703\\n12,83;151.3835413\\n12,92;151.8346381\\n13;152.2642007\\n13,08;152.6720956\\n13,17;153.0583966\\n13,25;153.4233611\\n13,33;153.7674066\\n13,42;154.0910856\\n13,5;154.3950608\\n13,58;154.6800825\\n13,67;154.9469659\\n13,75;155.1965718\\n13,83;155.4297888\\n13,92;155.6475179\\n14;155.8506598\\n14,08;156.0401024\\n14,17;156.2167175\\n14,25;156.3813442\\n14,33;156.5347914\\n14,42;156.6778321\\n14,5;156.8112003\\n14,58;156.9355896\\n14,67;157.0516529\\n14,75;157.1600033\\n14,83;157.2612106\\n14,92;157.3558081\\n15;157.4442908\\n15,08;157.5271178\\n15,17;157.6047139\\n15,25;157.6774719\\n15,33;157.7457539\\n15,42;157.809894\\n15,5;157.8701998\\n15,58;157.9269542\\n15,67;157.9804176\\n15,75;158.0308292\\n15,83;158.0784088\\n15,92;158.1233583\\n16;158.1658633\\n16,08;158.2060942\\n16,17;158.2442076\\n16,25;158.2803474\\n16,33;158.3146459\\n16,42;158.3472249\\n16,5;158.3781962\\n16,58;158.407663\\n16,67;158.4357202\\n16,75;158.4624554\\n16,83;158.4879492\\n16,92;158.5122763\\n17;158.5355056\\n17,08;158.5577008\\n17,17;158.578921\\n17,25;158.5992207\\n17,33;158.6186507\\n17,42;158.6372582\\n17,5;158.6550869\\n17,58;158.6721776\\n17,67;158.6885682\\n17,75;158.7042942\\n17,83;158.7193886\\n17,92;158.7338824\\n18;158.7478045\\n18,08;158.7611821\\n18,17;158.7740404\\n18,25;158.7864036\\n18,33;158.798294\\n18,42;158.8097328\\n18,5;158.8207399\\n18,58;158.8313341\\n18,67;158.8415332\\n18,75;158.851354\\n18,83;158.8608124\\n18,92;158.8699234\\n19;158.8787012\\n19,08;158.8871595\\n19,17;158.8953111\\n19,25;158.9031682\\n19,33;158.9107425\\n19,42;158.918045\\n19,5;158.9250863\\n19,58;158.9318765\\n19,67;158.9384252\\n19,75;158.9447416\\n19,83;158.9508345\\n19,92;158.9567122\\n20;158.9623829\\n\\n\#\\nage [years];50th\\n2,08;85.3973169\\n2,17;86.29026318\\n2,25;87.15714182\\n2,33;87.9960184\\n2,42;88.8055115\\n2,5;89.58476689\\n2,58;90.33341722\\n2,67;91.0515436\\n2,75;91.7396352\\n2,83;92.39854429\\n2,92;93.02945392\\n3;93.63382278\\n3,08;94.21335709\\n3,17;94.79643239\\n3,25;95.37391918\\n3,33;95.94692677\\n3,42;96.51644912\\n3,5;97.08337211\\n3,58;97.6484807\\n3,67;98.21246579\\n3,75;98.77593069\\n3,83;99.33939735\\n3,92;99.9033122\\n4;100.4680516\\n4,08;101.033927\\n4,17;101.6011898\\n4,25;102.1700358\\n4,33;102.7406094\\n4,42;103.3130077\\n4,5;103.8872839\\n4,58;104.4634511\\n4,67;105.0414853\\n4,75;105.6213287\\n4,83;106.2028921\\n4,92;106.7860583\\n5;107.3706841\\n5,08;107.9566031\\n5,17;108.5436278\\n5,25;109.1315521\\n5,33;109.7201531\\n5,42;110.3091934\\n5,5;110.8984228\\n5,58;111.4875806\\n5,67;112.0763967\\n5,75;112.6645943\\n5,83;113.2518902\\n5,92;113.8380006\\n6;114.4226317\\n6,08;115.0054978\\n6,17;115.5863089\\n6,25;116.1647782\\n6,33;116.7406221\\n6,42;117.3135622\\n6,5;117.8833259\\n6,58;118.4496481\\n6,67;119.0122722\\n6,75;119.5709513\\n6,83;120.1254495\\n6,92;120.6755427\\n7;121.22102\\n7,08;121.7616844\\n7,17;122.2973542\\n7,25;122.827864\\n7,33;123.3530652\\n7,42;123.8728276\\n7,5;124.38704\\n7,58;124.8956114\\n7,67;125.398472\\n7,75;125.895574\\n7,83;126.3868929\\n7,92;126.8724284\\n8;127.3522056\\n8,08;127.8262759\\n8,17;128.2947187\\n8,25;128.757642\\n8,33;129.2151839\\n8,42;129.6675143\\n8,5;130.1148354\\n8,58;130.5573839\\n8,67;130.995432\\n8,75;131.4292887\\n8,83;131.8593015\\n8,92;132.2858574\\n9;132.7093845\\n9,08;133.1303527\\n9,17;133.5492749\\n9,25;133.9667073\\n9,33;134.3832499\\n9,42;134.7995463\\n9,5;135.2162826\\n9,58;135.634186\\n9,67;136.0540223\\n9,75;136.4765925\\n9,83;136.9027281\\n9,92;137.3332846\\n10;137.7691339\\n10,08;138.2111552\\n10,17;138.6602228\\n10,25;139.1171933\\n10,33;139.5828898\\n10,42;140.0580848\\n10,5;140.5434787\\n10,58;141.0396832\\n10,67;141.5471945\\n10,75;142.0663731\\n10,83;142.59742\\n10,92;143.1403553\\n11;143.6949981\\n11,08;144.2609497\\n11,17;144.8375809\\n11,25;145.4240246\\n11,33;146.0191748\\n11,42;146.621692\\n11,5;147.2300177\\n11,58;147.8423918\\n11,67;148.4568879\\n11,75;149.0714413\\n11,83;149.6838943\\n11,92;150.2920328\\n12;150.8936469\\n12,08;151.4865636\\n12,17;152.0686985\\n12,25;152.6380955\\n12,33;153.1929631\\n12,42;153.7317031\\n12,5;154.2529332\\n12,58;154.755501\\n12,67;155.2384904\\n12,75;155.7012216\\n12,83;156.1432438\\n12,92;156.564323\\n13;156.9644258\\n13,08;157.3436995\\n13,17;157.7024507\\n13,25;158.0411233\\n13,33;158.3602756\\n13,42;158.6605588\\n13,5;158.9426964\\n13,58;159.2074654\\n13,67;159.455679\\n13,75;159.688172\\n13,83;159.9057871\\n13,92;160.1093647\\n14;160.299733\\n14,08;160.4776996\\n14,17;160.6440526\\n14,25;160.7995428\\n14,33;160.9448916\\n14,42;161.0807857\\n14,5;161.2078755\\n14,58;161.3267744\\n14,67;161.4380593\\n14,75;161.5422726\\n14,83;161.639917\\n14,92;161.7314645\\n15;161.8173534\\n15,08;161.8979913\\n15,17;161.9737558\\n15,25;162.0449969\\n15,33;162.1120386\\n15,42;162.17518\\n15,5;162.2346979\\n15,58;162.2908474\\n15,67;162.343864\\n15,75;162.3939652\\n15,83;162.4413513\\n15,92;162.4862071\\n16;162.5287029\\n16,08;162.5689958\\n16,17;162.6072309\\n16,25;162.6435418\\n16,33;162.6780519\\n16,42;162.7108751\\n16,5;162.7421168\\n16,58;162.7718741\\n16,67;162.8002371\\n16,75;162.8272889\\n16,83;162.8531067\\n16,92;162.8777619\\n17;162.9013208\\n17,08;162.9238449\\n17,17;162.9453912\\n17,25;162.9660131\\n17,33;162.9857599\\n17,42;163.0046776\\n17,5;163.0228094\\n17,58;163.0401953\\n17,67;163.0568727\\n17,75;163.0728768\\n17,83;163.0882404\\n17,92;163.1029943\\n18;163.1171673\\n18,08;163.1307866\\n18,17;163.1438776\\n18,25;163.1564644\\n18,33;163.1685697\\n18,42;163.1802146\\n18,5;163.1914194\\n18,58;163.202203\\n18,67;163.2125835\\n18,75;163.2225779\\n18,83;163.2322024\\n18,92;163.2414722\\n19;163.2504019\\n19,08;163.2590052\\n19,17;163.2672954\\n19,25;163.2752848\\n19,33;163.2829854\\n19,42;163.2904086\\n19,5;163.297565\\n19,58;163.304465\\n19,67;163.3111185\\n19,75;163.3175349\\n19,83;163.3237231\\n19,92;163.3296918\\n20;163.3354491\\n\\n\#\\n2,08;87.74917522\\n2,17;88.683435\\n2,25;89.5875095\\n2,33;90.46017565\\n2,42;91.30065173\\n2,5;92.10858598\\n2,58;92.88403041\\n2,67;93.62741325\\n2,75;94.33950841\\n2,83;95.02140026\\n2,92;95.67445723\\n3;96.30028751\\n3,08;96.9007148\\n3,17;97.50723533\\n3,25;98.10854769\\n3,33;98.70568284\\n3,42;99.2995686\\n3,5;99.89103539\\n3,58;100.4808219\\n3,67;101.0695807\\n3,75;101.6578832\\n3,83;102.2462253\\n3,92;102.8350319\\n4;103.4246616\\n4,08;104.0154114\\n4,17;104.6075204\\n4,25;105.2011743\\n4,33;105.7965086\\n4,42;106.3936129\\n4,5;106.9925336\\n4,58;107.5932772\\n4,67;108.1958137\\n4,75;108.8000793\\n4,83;109.405979\\n4,92;110.0133894\\n5;110.6221611\\n5,08;111.2321213\\n5,17;111.8430758\\n5,25;112.4548114\\n5,33;113.0670984\\n5,42;113.6796918\\n5,5;114.2923342\\n5,58;114.9047572\\n5,67;115.5166834\\n5,75;116.1278283\\n5,83;116.7379017\\n5,92;117.3466121\\n6;117.9536599\\n6,08;118.5587525\\n6,17;119.1615941\\n6,25;119.7618926\\n6,33;120.3593603\\n6,42;120.9537147\\n6,5;121.5446807\\n6,58;122.1319914\\n6,67;122.7153896\\n6,75;123.2946291\\n6,83;123.8694758\\n6,92;124.4397092\\n7;125.0051231\\n7,08;125.5655273\\n7,17;126.1207484\\n7,25;126.6706308\\n7,33;127.2150383\\n7,42;127.7538545\\n7,5;128.2869845\\n7,58;128.8143555\\n7,67;129.3359181\\n7,75;129.8516474\\n7,83;130.3615441\\n7,92;130.8656354\\n8;131.3639763\\n8,08;131.8566506\\n8,17;132.3437724\\n8,25;132.8254867\\n8,33;133.3019713\\n8,42;133.7734371\\n8,5;134.2401302\\n8,58;134.7023324\\n8,67;135.1603626\\n8,75;135.6145777\\n8,83;136.0653737\\n8,92;136.5131864\\n9;136.9584917\\n9,08;137.4018066\\n9,17;137.8436884\\n9,25;138.2847346\\n9,33;138.7255822\\n9,42;139.1669053\\n9,5;139.6094137\\n9,58;140.0538485\\n9,67;140.5009788\\n9,75;140.9515953\\n9,83;141.406504\\n9,92;141.8665172\\n10;142.3324443\\n10,08;142.8050794\\n10,17;143.2851879\\n10,25;143.7734919\\n10,33;144.2706527\\n10,42;144.7772534\\n10,5;145.2937779\\n10,58;145.8205935\\n10,67;146.3579283\\n10,75;146.9058529\\n10,83;147.4642617\\n10,92;148.0328573\\n11;148.6111378\\n11,08;149.1983881\\n11,17;149.7936767\\n11,25;150.3958583\\n11,33;151.0035823\\n11,42;151.6153083\\n11,5;152.2293288\\n11,58;152.8437944\\n11,67;153.4567526\\n11,75;154.0661803\\n11,83;154.6700274\\n11,92;155.2662534\\n12;155.8528786\\n12,08;156.4280126\\n12,17;156.9898953\\n12,25;157.5369262\\n12,33;158.0676887\\n12,42;158.5809683\\n12,5;159.0757636\\n12,58;159.5512908\\n12,67;160.006982\\n12,75;160.4424774\\n12,83;160.8576139\\n12,92;161.252409\\n13;161.6270427\\n13,08;161.9818377\\n13,17;162.317239\\n13,25;162.633793\\n13,33;162.9321282\\n13,42;163.2129368\\n13,5;163.476957\\n13,58;163.7249588\\n13,67;163.9577297\\n13,75;164.1760637\\n13,83;164.3807514\\n13,92;164.572572\\n14;164.7522868\\n14,08;164.920633\\n14,17;165.0783248\\n14,25;165.2260411\\n14,33;165.3644316\\n14,42;165.4941133\\n14,5;165.6156697\\n14,58;165.7296508\\n14,67;165.8365737\\n14,75;165.9369248\\n14,83;166.0311556\\n14,92;166.1196904\\n15;166.202924\\n15,08;166.281224\\n15,17;166.3549321\\n15,25;166.4243655\\n15,33;166.4898188\\n15,42;166.5515647\\n15,5;166.6098562\\n15,58;166.6649274\\n15,67;166.7169951\\n15,75;166.7662599\\n15,83;166.8129074\\n15,92;166.8571093\\n16;166.8990246\\n16,08;166.9388003\\n16,17;166.9765723\\n16,25;167.0124668\\n16,33;167.0466004\\n16,42;167.0790811\\n16,5;167.110009\\n16,58;167.1394771\\n16,67;167.1675715\\n16,75;167.1943721\\n16,83;167.2199532\\n16,92;167.244384\\n17;167.2677286\\n17,08;167.2900467\\n17,17;167.3113942\\n17,25;167.3318229\\n17,33;167.3513812\\n17,42;167.3701145\\n17,5;167.388065\\n17,58;167.4052723\\n17,67;167.4217734\\n17,75;167.437603\\n17,83;167.4527938\\n17,92;167.4673763\\n18;167.4813792\\n18,08;167.4948296\\n18,17;167.5077529\\n18,25;167.520173\\n18,33;167.5321128\\n18,42;167.5435933\\n18,5;167.554635\\n18,58;167.5652567\\n18,67;167.5754766\\n18,75;167.5853118\\n18,83;167.5947785\\n18,92;167.6038921\\n19;167.6126671\\n19,08;167.6211174\\n19,17;167.6292563\\n19,25;167.6370963\\n19,33;167.6446494\\n19,42;167.6519269\\n19,5;167.6589397\\n19,58;167.6656981\\n19,67;167.6722121\\n19,75;167.678491\\n19,83;167.684544\\n19,92;167.6903797\\n20;167.6960062\\n\\n\#\\n2,08;89.86315834\\n2,17;90.83504785\\n2,25;91.77420584\\n2,33;92.67968776\\n2,42;93.55096822\\n2,5;94.38792816\\n2,58;95.19083262\\n2,67;95.96030359\\n2,75;96.69728978\\n2,83;97.40303421\\n2,92;98.07904266\\n3;98.72704954\\n3,08;99.34898744\\n3,17;99.97896123\\n3,25;100.6040005\\n3,33;101.2250993\\n3,42;101.8431523\\n3,5;102.4589604\\n3,58;103.0732359\\n3,67;103.6866076\\n3,75;104.2996257\\n3,83;104.9127666\\n3,92;105.5264371\\n4;106.1409795\\n4,08;106.7566748\\n4,17;107.3737475\\n4,25;107.9923687\\n4,33;108.6126601\\n4,42;109.2346972\\n4,5;109.8585126\\n4,58;110.4840992\\n4,67;111.1114131\\n4,75;111.7403765\\n4,83;112.3708801\\n4,92;113.0027865\\n5;113.6359317\\n5,08;114.2701285\\n5,17;114.9051683\\n5,25;115.5408235\\n5,33;116.1768496\\n5,42;116.8129879\\n5,5;117.4489667\\n5,58;118.0845041\\n5,67;118.7193096\\n5,75;119.3530862\\n5,83;119.9855318\\n5,92;120.6163423\\n6;121.2452109\\n6,08;121.8718331\\n6,17;122.4959057\\n6,25;123.1171295\\n6,33;123.7352109\\n6,42;124.3498634\\n6,5;124.9608087\\n6,58;125.5677788\\n6,67;126.1705167\\n6,75;126.7687784\\n6,83;127.3623338\\n6,92;127.9509681\\n7;128.5344832\\n7,08;129.1126986\\n7,17;129.6854529\\n7,25;130.2526047\\n7,33;130.8140342\\n7,42;131.3696436\\n7,5;131.9193587\\n7,58;132.4631302\\n7,67;133.000934\\n7,75;133.5327731\\n7,83;134.0586782\\n7,92;134.5787089\\n8;135.0929548\\n8,08;135.6015364\\n8,17;136.1046066\\n8,25;136.602351\\n8,33;137.0949894\\n8,42;137.5827768\\n8,5;138.0660041\\n8,58;138.5449986\\n8,67;139.0201256\\n8,75;139.4917879\\n8,83;139.9604267\\n8,92;140.4265216\\n9;140.8905903\\n9,08;141.3531879\\n9,17;141.8149059\\n9,25;142.2763706\\n9,33;142.7382405\\n9,42;143.2012034\\n9,5;143.6659721\\n9,58;144.1332799\\n9,67;144.6038739\\n9,75;145.0785079\\n9,83;145.5579335\\n9,92;146.0428902\\n10;146.5340936\\n10,08;147.0322225\\n10,17;147.5379045\\n10,25;148.0517004\\n10,33;148.5740881\\n10,42;149.1054445\\n10,5;149.6460289\\n10,58;150.1959657\\n10,67;150.7552278\\n10,75;151.3236226\\n10,83;151.9007796\\n10,92;152.4861414\\n11;153.0789588\\n11,08;153.6782905\\n11,17;154.2830074\\n11,25;154.8918033\\n11,33;155.5032105\\n11,42;156.1156207\\n11,5;156.7273114\\n11,58;157.336476\\n11,67;157.9412574\\n11,75;158.5397832\\n11,83;159.1302018\\n11,92;159.710717\\n12;160.2796226\\n12,08;160.8353311\\n12,17;161.3763995\\n12,25;161.9015501\\n12,33;162.4096857\\n12,42;162.8998985\\n12,5;163.3714746\\n12,58;163.8238923\\n12,67;164.2568163\\n12,75;164.6700879\\n12,83;165.0637118\\n12,92;165.4378408\\n13;165.7927589\\n13,08;166.1288638\\n13,17;166.4466488\\n13,25;166.7466859\\n13,33;167.0296087\\n13,42;167.2960978\\n13,5;167.5468664\\n13,58;167.7826481\\n13,67;168.0041861\\n13,75;168.2122241\\n13,83;168.4074983\\n13,92;168.5907313\\n14;168.7626268\\n14,08;168.9238654\\n14,17;169.0751026\\n14,25;169.2169651\\n14,33;169.3500504\\n14,42;169.4749261\\n14,5;169.5921291\\n14,58;169.7021662\\n14,67;169.8055142\\n14,75;169.9026209\\n14,83;169.9939056\\n14,92;170.0797608\\n15;170.160553\\n15,08;170.236624\\n15,17;170.3082921\\n15,25;170.3758539\\n15,33;170.4395847\\n15,42;170.4997408\\n15,5;170.5565599\\n15,58;170.6102627\\n15,67;170.6610542\\n15,75;170.7091243\\n15,83;170.7546494\\n15,92;170.7977929\\n16;170.8387064\\n16,08;170.8775306\\n16,17;170.914396\\n16,25;170.9494236\\n16,33;170.9827258\\n16,42;171.014407\\n16,5;171.0445641\\n16,58;171.0732871\\n16,67;171.1006598\\n16,75;171.1267599\\n16,83;171.1516601\\n16,92;171.1754277\\n17;171.1981258\\n17,08;171.2198128\\n17,17;171.2405436\\n17,25;171.2603693\\n17,33;171.2793375\\n17,42;171.2974929\\n17,5;171.3148774\\n17,58;171.33153\\n17,67;171.3474874\\n17,75;171.362784\\n17,83;171.3774521\\n17,92;171.3915221\\n18;171.4050225\\n18,08;171.4179802\\n18,17;171.4304205\\n18,25;171.4423671\\n18,33;171.4538427\\n18,42;171.4648684\\n18,5;171.4754644\\n18,58;171.4856495\\n18,67;171.4954418\\n18,75;171.5048583\\n18,83;171.5139151\\n18,92;171.5226274\\n19;171.5310098\\n19,08;171.5390761\\n19,17;171.5468394\\n19,25;171.5543121\\n19,33;171.561506\\n19,42;171.5684326\\n19,5;171.5751024\\n19,58;171.5815258\\n19,67;171.5877126\\n19,75;171.5936721\\n19,83;171.5994132\\n19,92;171.6049444\\n20;171.6102738\\n\\n\#\\n2,08;91.12706971\\n2,17;92.12167631\\n2,25;93.08254082\\n2,33;94.00872819\\n2,42;94.89974364\\n2,5;95.75551171\\n2,58;96.57635253\\n2,67;97.36295103\\n2,75;98.11632342\\n2,83;98.83778417\\n2,92;99.52890698\\n3;100.191497\\n3,08;100.8275527\\n3,17;101.4726459\\n3,25;102.112939\\n3,33;102.7494191\\n3,42;103.3829734\\n3,5;104.0143944\\n3,58;104.6443859\\n3,67;105.2735676\\n3,75;105.9024803\\n3,83;106.5315907\\n3,92;107.161296\\n4;107.7919282\\n4,08;108.4237579\\n4,17;109.0569988\\n4,25;109.6918111\\n4,33;110.3283052\\n4,42;110.9665451\\n4,5;111.6065515\\n4,58;112.2483051\\n4,67;112.8917498\\n4,75;113.536795\\n4,83;114.1833188\\n4,92;114.8311708\\n5;115.4801741\\n5,08;116.1301284\\n5,17;116.780812\\n5,25;117.4319846\\n5,33;118.0833889\\n5,42;118.7347537\\n5,5;119.3857953\\n5,58;120.03622\\n5,67;120.685726\\n5,75;121.3340057\\n5,83;121.9807474\\n5,92;122.6256361\\n6;123.2683596\\n6,08;123.9086035\\n6,17;124.5460585\\n6,25;125.1804203\\n6,33;125.8113907\\n6,42;126.4386798\\n6,5;127.0620077\\n6,58;127.6811055\\n6,67;128.2957169\\n6,75;128.9056\\n6,83;129.5105281\\n6,92;130.1102914\\n7;130.7046982\\n7,08;131.2935761\\n7,17;131.876773\\n7,25;132.4541587\\n7,33;133.025626\\n7,42;133.5910912\\n7,5;134.150496\\n7,58;134.7038082\\n7,67;135.2510227\\n7,75;135.7921628\\n7,83;136.3272809\\n7,92;136.8564598\\n8;137.3798137\\n8,08;137.8974887\\n8,17;138.4096645\\n8,25;138.9165546\\n8,33;139.4184075\\n8,42;139.9155075\\n8,5;140.4081749\\n8,58;140.8967672\\n8,67;141.3816789\\n8,75;141.8633417\\n8,83;142.3422248\\n8,92;142.818834\\n9;143.2937108\\n9,08;143.7674316\\n9,17;144.2406053\\n9,25;144.7138712\\n9,33;145.1878952\\n9,42;145.6633664\\n9,5;146.1409913\\n9,58;146.6214882\\n9,67;147.1055797\\n9,75;147.5939843\\n9,83;148.0874065\\n9,92;148.586526\\n10;149.0919854\\n10,08;149.6043767\\n10,17;150.1242269\\n10,25;150.6519828\\n10,33;151.1879951\\n10,42;151.7325029\\n10,5;152.2856189\\n10,58;152.8473131\\n10,67;153.4174019\\n10,75;153.9955367\\n10,83;154.581196\\n10,92;155.1736815\\n11;155.7721177\\n11,08;156.3754566\\n11,17;156.9824866\\n11,25;157.591847\\n11,33;158.2020466\\n11,42;158.8114866\\n11,5;159.4184879\\n11,58;160.0213216\\n11,67;160.6182378\\n11,75;161.2075007\\n11,83;161.7874182\\n11,92;162.3563754\\n12;162.9128551\\n12,08;163.4554684\\n12,17;163.9829705\\n12,25;164.4942764\\n12,33;164.9884705\\n12,42;165.4648118\\n12,5;165.9227345\\n12,58;166.3618445\\n12,67;166.7819123\\n12,75;167.1828627\\n12,83;167.5647631\\n12,92;167.9278093\\n13;168.2723104\\n13,08;168.5986736\\n13,17;168.9073892\\n13,25;169.1990151\\n13,33;169.474163\\n13,42;169.7334849\\n13,5;169.9776618\\n13,58;170.207392\\n13,67;170.4233822\\n13,75;170.6263392\\n13,83;170.8169629\\n13,92;170.9959407\\n14;171.1639423\\n14,08;171.3216174\\n14,17;171.469589\\n14,25;171.6084579\\n14,33;171.7387957\\n14,42;171.8611461\\n14,5;171.9760242\\n14,58;172.0839168\\n14,67;172.1852824\\n14,75;172.2805514\\n14,83;172.3701297\\n14,92;172.4543957\\n15;172.5337038\\n15,08;172.6083849\\n15,17;172.6787478\\n15,25;172.7450799\\n15,33;172.8076491\\n15,42;172.8667045\\n15,5;172.9224777\\n15,58;172.9751838\\n15,67;173.025023\\n15,75;173.0721808\\n15,83;173.1168298\\n15,92;173.1591301\\n16;173.1992303\\n16,08;173.2372685\\n16,17;173.2733728\\n16,25;173.3076624\\n16,33;173.3402478\\n16,42;173.3712319\\n16,5;173.4007102\\n16,58;173.4287717\\n16,67;173.455499\\n16,75;173.4809691\\n16,83;173.5052538\\n16,92;173.5284198\\n17;173.5505296\\n17,08;173.5716411\\n17,17;173.5918087\\n17,25;173.6110831\\n17,33;173.6295117\\n17,42;173.6471389\\n17,5;173.6640061\\n17,58;173.6801522\\n17,67;173.6956138\\n17,75;173.710425\\n17,83;173.7246179\\n17,92;173.7382228\\n18;173.751268\\n18,08;173.7637802\\n18,17;173.7757847\\n18,25;173.787305\\n18,33;173.7983636\\n18,42;173.8089816\\n18,5;173.8191789\\n18,58;173.8289744\\n18,67;173.8383858\\n18,75;173.8474302\\n18,83;173.8561235\\n18,92;173.8644808\\n19;173.8725166\\n19,08;173.8802445\\n19,17;173.8876774\\n19,25;173.8948277\\n19,33;173.9017071\\n19,42;173.9083268\\n19,5;173.9146973\\n19,58;173.9208289\\n19,67;173.9267311\\n19,75;173.9324132\\n19,83;173.9378839\\n19,92;173.9431517\\n20;173.9482244\\n\\n\#\\n2,08;91.94741225\\n2,17;92.95684975\\n2,25;93.9320912\\n2,33;94.87214661\\n2,42;95.77649339\\n2,5;96.64504712\\n2,58;97.47813528\\n2,67;98.27646264\\n2,75;99.04107435\\n2,83;99.77332166\\n2,92;100.4748164\\n3;101.1474075\\n3,08;101.7931359\\n3,17;102.448488\\n3,25;103.0991159\\n3,33;103.7460086\\n3,42;104.3900531\\n3,5;105.0320405\\n3,58;105.6726719\\n3,67;106.3125633\\n3,75;106.9522508\\n3,83;107.5921959\\n3,92;108.2327896\\n4;108.8743573\\n4,08;109.5171624\\n4,17;110.1614111\\n4,25;110.8072554\\n4,33;111.4547971\\n4,42;112.1040915\\n4,5;112.7551501\\n4,58;113.4079442\\n4,67;114.0624076\\n4,75;114.7184401\\n4,83;115.3759096\\n4,92;116.0346553\\n5;116.6944901\\n5,08;117.3552032\\n5,17;118.0165629\\n5,25;118.6783183\\n5,33;119.3402023\\n5,42;120.0019338\\n5,5;120.6632194\\n5,58;121.3237564\\n5,67;121.9832342\\n5,75;122.6413368\\n5,83;123.297745\\n5,92;123.9521353\\n6;124.6041916\\n6,08;125.2535916\\n6,17;125.9000218\\n6,25;126.5431735\\n6,33;127.1827453\\n6,42;127.8184451\\n6,5;128.4499914\\n6,58;129.0771148\\n6,67;129.69956\\n6,75;130.3170863\\n6,83;130.9294701\\n6,92;131.5365053\\n7;132.1380052\\n7,08;132.7338033\\n7,17;133.323755\\n7,25;133.9077383\\n7,33;134.4856552\\n7,42;135.0574328\\n7,5;135.6230245\\n7,58;136.1824107\\n7,67;136.7356\\n7,75;137.2826306\\n7,83;137.8235707\\n7,92;138.3585197\\n8;138.8876092\\n8,08;139.411004\\n8,17;139.9289024\\n8,25;140.4415378\\n8,33;140.9491785\\n8,42;141.4521292\\n8,5;141.9507308\\n8,58;142.4453609\\n8,67;142.936434\\n8,75;143.4244013\\n8,83;143.9097502\\n8,92;144.3930034\\n9;144.8747179\\n9,08;145.3554829\\n9,17;145.8359173\\n9,25;146.3166671\\n9,33;146.798401\\n9,42;147.2818057\\n9,5;147.7675803\\n9,58;148.2564292\\n9,67;148.7490543\\n9,75;149.2461456\\n9,83;149.7483713\\n9,92;150.2563656\\n10;150.7707169\\n10,08;151.2919534\\n10,17;151.8205297\\n10,25;152.3568114\\n10,33;152.9010603\\n10,42;153.4534201\\n10,5;154.0139039\\n10,58;154.5823786\\n10,67;155.1585578\\n10,75;155.741993\\n10,83;156.3320686\\n10,92;156.9280012\\n11;157.5288429\\n11,08;158.1334886\\n11,17;158.740688\\n11,25;159.3490618\\n11,33;159.9571223\\n11,42;160.5632969\\n11,5;161.1659545\\n11,58;161.7634371\\n11,67;162.3540831\\n11,75;162.9362629\\n11,83;163.5084028\\n11,92;164.0690181\\n12;164.6167234\\n12,08;165.1502647\\n12,17;165.6685285\\n12,25;166.1705539\\n12,33;166.6555396\\n12,42;167.1228459\\n12,5;167.5719943\\n12,58;168.0026622\\n12,67;168.4146759\\n12,75;168.8080012\\n12,83;169.1827317\\n12,92;169.5390766\\n13;169.8773471\\n13,08;170.1979436\\n13,17;170.5013414\\n13,25;170.7880784\\n13,33;171.0587419\\n13,42;171.3139575\\n13,5;171.5543778\\n13,58;171.780673\\n13,67;171.9935219\\n13,75;172.1936047\\n13,83;172.3815959\\n13,92;172.5581591\\n14;172.7239426\\n14,08;172.8795764\\n14,17;173.0256638\\n14,25;173.1627906\\n14,33;173.2915138\\n14,42;173.4123635\\n14,5;173.5258431\\n14,58;173.6324287\\n14,67;173.7325694\\n14,75;173.8266863\\n14,83;173.9151788\\n14,92;173.9984185\\n15;174.0767538\\n15,08;174.1505102\\n15,17;174.2199918\\n15,25;174.2854819\\n15,33;174.3472447\\n15,42;174.405526\\n15,5;174.4605545\\n15,58;174.5125428\\n15,67;174.5616886\\n15,75;174.6081757\\n15,83;174.6521747\\n15,92;174.6938442\\n16;174.7333314\\n16,08;174.7707732\\n16,17;174.8062967\\n16,25;174.8400201\\n16,33;174.8720532\\n16,42;174.902498\\n16,5;174.9314494\\n16,58;174.9589959\\n16,67;174.9852197\\n16,75;175.0101973\\n16,83;175.034000\\n16,92;175.0566944\\n17;175.0783424\\n17,08;175.099002\\n17,17;175.1187272\\n17,25;175.1375685\\n17,33;175.155573\\n17,42;175.1727851\\n17,5;175.1892459\\n17,58;175.2049944\\n17,67;175.2200667\\n17,75;175.2344971\\n17,83;175.2483174\\n17,92;175.2615577\\n18;175.2742464\\n18,08;175.2864101\\n18,17;175.2980736\\n18,25;175.3092608\\n18,33;175.3199938\\n18,42;175.3302936\\n18,5;175.3401801\\n18,58;175.349672\\n18,67;175.358787\\n18,75;175.367542\\n18,83;175.3759527\\n18,92;175.3840343\\n19;175.391801\\n19,08;175.3992664\\n19,17;175.4064433\\n19,25;175.4133439\\n19,33;175.4199799\\n19,42;175.4263623\\n19,5;175.4325015\\n19,58;175.4384076\\n19,67;175.4440902\\n19,75;175.4495583\\n19,83;175.4548206\\n19,92;175.4598853\\n20;175.4647604\\n\\n\#\\nnull\\n\#\\n&#xD;
chart.xAxis.tickLabelsVisible=true&#xD;
chart.visible=false&#xD;
chart.plot.orientation=0&#xD;
chart.marker.color=-8355712&#xD;
chart.title.color=-16777216&#xD;
chart.series.names=3rd_l_b;5th_l_b;10th_l_b;25th_l_b;50th_l_b;75th_l_b;90th_l_b;95th_l_b;97th_l_b;3rd_s_b;5th_s_b;10th_s_b;25th_s_b;50th_s_b;75th_s_b;90th_s_b;95th_s_b;97th_s_b;3rd_l_g;5th_l_g;10th_l_g;25th_l_g;50th_l_g;75th_l_g;90th_l_g;95th_l_g;97th_l_g;3rd_s_g;5th_s_g;10th_s_g;25th_s_g;50th_s_g;75th_s_g;90th_s_g;95th_s_g;97th_s_g;height;&#xD;
chart.yAxis.color=-16750900&#xD;
chart.xAxis.label=Âge [Année]&#xD;
chart.series.paint=-65536;-52480;-26368;-16711936;-16738048;-16711936;-26368;-52480;-65536;-65536;-52480;-26368;-16711936;-16738048;-16711936;-26368;-52480;-65536;-65536;-52480;-26368;-16711936;-16738048;-16711936;-26368;-52480;-65536;-65536;-52480;-26368;-16711936;-16738048;-16711936;-26368;-52480;-65536;-16777216;&#xD;
chart.type=1&#xD;
chart.yAxis.ticksVisible=true&#xD;
chart.yAxis.tickLabelsVisible=true&#xD;
chart.antiAlias=true&#xD;
chart.background.color=-1&#xD;
chart.series.limit=0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;&#xD;
chart.title.text=Taille selon Âge&#xD;
chart.title.size=18.0&#xD;
chart.series.sinceWhen=null;null;null;null;null;null;null;null;null;null;null;null;null;null;null;null;null;null;null;null;null;null;null;null;null;null;null;null;null;null;null;null;null;null;null;null;null;&#xD;
chart.xAxis.color=-16750900&#xD;
chart.plot.outline.color=-16777216&#xD;
chart.marker.alpha=0.8&#xD;
chart.showLegend=false&#xD;
chart.plot.background.color=-3355393&#xD;
chart.series.shape=0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;1;</structure>
    <border>false,0,0,0,255</border>
    <background>false,238,238,238,255</background>
    <fontStyle />
    <fontSize>12</fontSize>
    <fontFamily>Dialog</fontFamily>
    <fontColor>true,0,0,0,255</fontColor>
    <hAlign>default</hAlign>
    <vAlign>default</vAlign>
  </component>
  <component xCoord="7" yCoord="4" xSize="1" ySize="1" key="tfWeight" value="0" storeInDB="true" showInHistory="true" historyIndex="2.0" labelPosition="none" labelText="Poids [kg] :">
    <type>lu.tudor.santec.gecamed.formeditor.gui.component.EditableNumericTextField</type>
    <script eventTypeId="13">
      <scriptCode>getBMI();</scriptCode>
    </script>
    <structure />
    <border>false,0,0,0,255</border>
    <background>true,255,255,255,255</background>
    <fontStyle>b</fontStyle>
    <fontSize>12</fontSize>
    <fontFamily>Dialog</fontFamily>
    <fontColor>true,0,0,0,255</fontColor>
    <hAlign>default</hAlign>
    <vAlign>default</vAlign>
  </component>
  <component xCoord="13" yCoord="6" xSize="1" ySize="1" key="datatable" value="" storeInDB="false" showInHistory="false" historyIndex="0.0" labelPosition="none" labelText="">
    <type>lu.tudor.santec.gecamed.formeditor.gui.component.EditableDataTable</type>
    <script eventTypeId="13">
      <scriptCode>convertColumnDateToAge(event.getSource(), 1);</scriptCode>
    </script>
    <structure>#&#xD;
#Fri Mar 16 13:42:05 CET 2012&#xD;
column.ref.3=tfWeight;Poids&#xD;
column.ref.2=tfHeight;Taille&#xD;
column.ref.1=measuringDate;Âge&#xD;
column.width=144;55;56;66;54;&#xD;
column.ref.0=measuringDate;Date de mesure&#xD;
column.ref.4=lblBmi;IMC</structure>
    <border>false,0,0,0,255</border>
    <background>false,255,255,255,255</background>
    <fontStyle>b</fontStyle>
    <fontSize>12</fontSize>
    <fontFamily>Dialog</fontFamily>
    <fontColor>true,0,0,0,255</fontColor>
    <hAlign>default</hAlign>
    <vAlign>default</vAlign>
  </component>
  <initScript>getBMI();
manipulateChart(chart_bmi);
manipulateChart(chart_weight);
manipulateChart(chart_height);
convertColumnDateToAge(datatable, 1);</initScript>
  <function name="convertXValueFromYearsToMonth">
    <scriptCode>/**
 * Converts the x values of the series from years to month.
 * This function just divides the x values through 12.
 * 
 * @param diagram:
 * The diagram containing the series to convert.
 */
function convertXValueFromYearsToMonth (diagram) 
{
	// IMPORTS:
	importPackage(org.jfree.data.xy);
	
	// get the dataset
	var dataset = diagram.getChart().getXYPlot().getDataset();
	var tempList = new LinkedList();
	
	// convert all series of the dataset at the given positions
	for (var seriesIter = dataset.getSeries().iterator(); seriesIter.hasNext(); )
	{
		var series = seriesIter.next();
		
		// clear and fill the template list with the new XYDataItems
		tempList.clear();
		for (var itemIter = series.getItems().iterator(); itemIter.hasNext(); ) 
		{
			var _item = itemIter.next();
			tempList.add(new XYDataItem(_item.getXValue() / 12, _item.getYValue()));
		}
		
		// clear and fill the series with the items of the template list
		series.clear();
		for (var itemIter = tempList.iterator(); itemIter.hasNext(); ) 
		{
			series.add(itemIter.next());
		}
	}
}</scriptCode>
  </function>
  <function name="manipulateChart">
    <scriptCode>/** 
 * Manipulates the given chart. The chart is what you get 
 * by inserting an diagram into the form editor.
 * 
 * 1. Converts the measuring date into the Age of the patient.
 * 2. Centers the diagram on the data series graph.
 * 3. Clears the unnecessary graphs, so there would be shown.
 * 4. The age of the patient will be given in month or years,
 *    depending on the latest measuring date.
 * 
 * NEEDED FUNCTIONS:
 *  - changeGraphDateToPatientAge()
 *  - calculateAge()
 *  - clearSeriesOfDiagram()
 *  - convertXValueFromYearsToMonth
 * 
 * @param diagramToManipulate:
 * The diagram, that shall be manipulated
 * 
 * @param dataGraphIndex:
 * The index of the graph containing the patient&apos;s data
 * 
 * @param graphsToClear:
 * Those graph that shall not be shown
 */
function manipulateChart (diagramToManipulate, dataGraphIndex, graphsToClear) 
{
	var plot = diagramToManipulate.getChart().getXYPlot();
	var dataGraphIndex = plot.getDataset().getSeriesCount() - 1;
	
	// converts the date to the age of the patient at this point of time
	var ranges = changeGraphDateToPatientAge(getBirthdayOfCurrentPatient(), 
			diagramToManipulate, dataGraphIndex);

	if (ranges != null) 
	{
		// centers the diagram on the data series
		plot.getDomainAxis().setRange(ranges[0].getLowerBound() - 0.25, 
				ranges[0].getUpperBound() + 0.25);
		plot.getRangeAxis().setRange(ranges[1].getLowerBound() - 0.25, 
				ranges[1].getUpperBound() + 0.25);
	}
	
	/* Clears the graphs of the boys, if the patient is a girl,
	 * or the graph of the girls, if the patient is a boy.
	 */
	var graphsToClear = new Array(dataGraphIndex / 2);
	var add;
	if ("male".equals(patient.getGender())) 
	{
		add = 0;
	} 
	else 
	{
		add = graphsToClear.length;
	}
	
	for (var i = 0; i &lt; graphsToClear.length; i++) 
	{
		graphsToClear[i] = i + add;
	}
	
	clearSeriesOfDiagram(diagramToManipulate, graphsToClear);
	
	if (ranges != null &amp;&amp; ranges[0].getUpperBound() &lt; 5) 
	{
		/* if the patients age at the latest measuring point is lower 
		 * than 5 years, convert the age from years to month, to give 
		 * a better overview.
		 */
		convertXValueFromYearsToMonth(diagramToManipulate);
		
		// change the description at the x-axis
		plot.getDomainAxis().setLabel(plot.getDomainAxis().
				getLabel().replace("year", "month"));
	} 
	else 
	{
		// change the description at the x-axis
		plot.getDomainAxis().setLabel(plot.getDomainAxis().
				getLabel().replace("month", "year"));
	}
}</scriptCode>
  </function>
  <function name="calculateAge">
    <scriptCode>/**
 * Calculates the age in years at the given point in time 
 * out of a given birthday
 * 
 * @param calendar_birthday
 * @param calendar_ageAtThisDate
 * @return
 */
function calculateAge (calendar_birthday, calendar_ageAtThisDate) 
{
	// IMPORTS
	importPackage(java.util);
	
	var int_yearOfBirth = calendar_birthday.get(Calendar.YEAR);
	var int_dayOfBirth = calendar_birthday.get(Calendar.DAY_OF_YEAR);
	var int_yearOfMeasuring = calendar_ageAtThisDate.get(Calendar.YEAR);
	var int_dayOfMeasuring = calendar_ageAtThisDate.get(Calendar.DAY_OF_YEAR);
	var int_maxDaysOfYear = calendar_ageAtThisDate.getActualMaximum(
			Calendar.DAY_OF_YEAR);
	
	var double_age = int_yearOfMeasuring - int_yearOfBirth;
	if (int_dayOfBirth &lt; int_dayOfMeasuring) 
	{
		double_age += (int_dayOfMeasuring - int_dayOfBirth) / int_maxDaysOfYear;
	} 
	else if (int_dayOfBirth &gt; int_dayOfMeasuring) 
	{
		double_age--;
		double_age += (int_dayOfMeasuring + int_maxDaysOfYear - int_dayOfBirth) / int_maxDaysOfYear;
	}
	
	return double_age;
}</scriptCode>
  </function>
  <function name="convertColumnDateToAge">
    <scriptCode>/** 
 * Converts the measuring date of the second column into the Age
 * of the patient at the measuring day, using the birthday calculated
 * in the function setBirthday.
 * 
 * NEEDED FUNCTIONS:
 * - getBirthdayOfCurrentPatient()
 * - calculateAge()
 * 
 * @param datatable:
 * The table, that shall be manipulated
 * 
 * @param columnToConvert:
 * the index of the column, that shall be converted 
 * from a date to the age at that date (index 0 = first column)
 */
function convertColumnDateToAge (datatable, columnToConvert) 
{
	// IMPORTS
	importPackage(java.util);
	importPackage(java.lang);
	importPackage(java.text);
	//importPackage(java.awt);
	//importPackage(java.awt.font);

	var tableModel = datatable.getModel();

	// get the patients birthday
	var calendar_birthday = getBirthdayOfCurrentPatient();
	var calendar_creationDate = new GregorianCalendar();

	/* a date formater to format a date into a String 
	 * and parse a formated String into a date
	 */
	var formater = DateFormat.getDateInstance(
			DateFormat.SHORT);
			
	// replace the creation date with the patient&apos;s age in every row
	for (var int_row = 0; int_row &lt; tableModel.getRowCount(); int_row++) 
	{
		try 
		{
			// make a Date resp. Calendar out of the formated String
			calendar_creationDate.setTime(
					formater.parse(tableModel.getValueAt(int_row, columnToConvert)));
		} 
		catch (err) 
		{
			// the String couldn&apos;t be parsed
//			println("manipulateTable(): " + err);
			continue;
		}

		// calculate the patient&apos;s age out of the creation date and birthdate
		var int_age = new Integer(calculateAge(calendar_birthday, calendar_creationDate));
		
		// replace the date in the column age with the calculated age
		tableModel.setValueAt(int_age, int_row, columnToConvert);
	}
}</scriptCode>
  </function>
  <function name="getBMI">
    <scriptCode>/* Calculates the BMI out of the given values
 */
function getBMI () 
{
	// IMPORTS
	importPackage(java.awt);
	importPackage(java.lang);
	
	/* Get the patient&apos;s size and weight and 
	 * allocate it to the variables height and weight.
	 */
	var height = new Float(tfHeight.getValue());
	var weight = new Float(tfWeight.getValue());

	/* The patient&apos;s size must be die Größe des Patienten muss &gt; 0 sein,
	 * da sont Division durch 0
	 */
	if (height &lt;= 0) 
	{
		return 0;
	}

	// Convert the patient&apos;s size from cm to m
	height = height / 100;

	// calculate the BMI
	// (rounded on one decimal place)
	var bmi = Math.round(100 * (weight / (height * height))) / 100;

	var color;
	var red = new Color(-39322);
	
	if (bmi &lt; 16) 
	{
		color = red;
	} 
	else if (bmi &lt; 18.5) 
	{
		color = Color.ORANGE;
	} 
	else if (bmi &lt; 25) 
	{
		color = Color.GREEN;
	} 
	else if (bmi &lt; 30) 
	{
		color = Color.ORANGE;
	} 
	else 
	{
		color = red;
	}

	lblBmi.setBackground(color);
	
	// Set the BMI as text of the label
	lblBmi.setText(bmi);

	// print(chart_bmi.getClass()); //paintChart();
}</scriptCode>
  </function>
  <function name="changeGraphDateToPatientAge">
    <scriptCode>/**
 * This function replaces the x-values, given as milliseconds since 1970
 * into the age of the patient in years at that point in time.
 * It returns an array of Range objects, that defines the dimensions
 * of the changed graph. 
 * 
 * NEEDED FUNCTIONS:
 *  - calculateAge
 * 
 * @param patientBirthday: 
 * The patients birthday as a java.util.Calendar
 * 
 * @param diagrammToChange: 
 * The diagram that contains the graph to change 
 * (this is a component created by adding a diagram to the form editor).
 * 
 * @param indexOfGraphToChange
 * The position of the graph in the diagram as int.
 * 
 * @return 
 * An array of org.jfree.data.Range objects, that define the dimensions 
 * of this graph. They&apos;re supposed to be used for centering the chart 
 * view on this graph. The range at position 0 defines the x-axis value, 
 * the range at position 1 defines the y-axis value.
 */
function changeGraphDateToPatientAge (
			patientBirthday, diagramToChange, indexOfGraphToChange) 
{
	// IMPORTS:
	importPackage(java.lang);
	importPackage(java.util);
	importPackage(org.jfree.chart);
	importPackage(org.jfree.data.xy);
	importPackage(org.jfree.data);
	
	
	// prepare the necessary objects
	var plot = diagramToChange.getChart().getXYPlot();
	var dataset = plot.getDataset();
	var series = dataset.getSeries(indexOfGraphToChange);
	var tempList = new LinkedList();
	var creationDate = new GregorianCalendar();
	

	/* to center the view in the diagramm on the patients data, 
	 * we need to get the highest and lowest x- and y-values.
	 */
	var highestX = 0;
	var highestY = 0;
	var lowestX = Integer.MAX_VALUE;
	var lowestY = Integer.MAX_VALUE;
	
	// replace the creation date with the patient&apos;s age in every row
	for (var iter = series.getItems().iterator(); iter.hasNext(); ) 
	{
		var _item = iter.next();
		
		try 
		{
			/* try to make a Date resp. Calendar out of the formated String.
			 * If it fails, ignore this item
			 */
			var long_newXValue = new Double(_item.getXValue()).longValue();
			creationDate.setTimeInMillis(long_newXValue);
		} 
		catch (err) 
		{
			// maybe you want to see want&apos;s happening here
			println("changeGraphDateToPatientAge(): " + err);
			continue;
		}
		
		// get the right values and add them as item to the tempList
		var y = _item.getYValue();
		// calculate the age
		var age = calculateAge(patientBirthday, creationDate);
		tempList.add(new XYDataItem(age, y));
		
		// check, if this value is the lowest or highest x- or y-value
		if (age &lt; lowestX) 
		{
			lowestX = age;
		} 
		if (age &gt; highestX) 
		{
			highestX = age; 
		}
		if (y &lt; lowestY) 
		{
			lowestY = y;
		} 
		if (y &gt; highestY) 
		{
			highestY = y;
		}
	}
	
	// put the changes values from the template list back into the series
	series.clear();
	for (var iter = tempList.iterator(); iter.hasNext(); ) 
	{
		series.add(iter.next());
	}

	if (lowestX &gt; highestX
			|| lowestY &gt; highestY) 
	{
		return null;
	} 
	else 
	{
		return new Array(new Range(lowestX, highestX), new Range(lowestY, highestY));
	}
}</scriptCode>
  </function>
  <function name="clearSeriesOfDiagram">
    <scriptCode>/**
 * Clears the series at the given positions, so the graph won&apos;t 
 * be shown anymore.
 * 
 * @param diagram:
 * The diagram containing the series to clear.
 * 
 * @param clearIndex:
 * The positions of the series that shall be cleared
 */
function clearSeriesOfDiagram (diagram, clearIndex) 
{
	// get the dataset
	var dataset = diagram.getChart().getXYPlot().getDataset();
	
	// clear all series of the dataset at the given positions
	for (var index = 0; index &lt; clearIndex.length; index++) 
	{
		dataset.getSeries(clearIndex[index]).clear();
	}
}</scriptCode>
  </function>
  <function name="getBirthdayOfCurrentPatient">
    <scriptCode>/**
 * Gets the birthday of the current patient and returns it as 
 * a java.util.Calendar.
 * 
 * @return:
 * The birthday of the current patient.
 */
function getBirthdayOfCurrentPatient () 
{
	// IMPORTS
	importPackage(java.util);
	
	var birthday = new GregorianCalendar();
	birthday.setTime(patient.getBirthDate());
	
	return birthday;
}</scriptCode>
  </function>
</form>');





-- ===========================================================================
-- ======				FORM: Carnet de Vaccination V1.0.3 				======
-- ===========================================================================


INSERT INTO formeditor.form_template
(name, version, description, subform_only, xml)
VALUES
(E'Carnet de Vaccination', E'1.0.3', E'This is a vaccination record. The most common vaccinations are listed. Others can be added by free text (supported by autocompletion).', FALSE,
E'<?xml version="1.0" encoding="UTF-8"?>
<form info="Form template of GECAMed 2.00.03 - This file is a template to create forms for GECAMed (GEstion de CAbinet Medicaux)." name="Carnet de Vaccination" version="1.0.3" subFormOnly="false">
  <description>Vaccination record according to Luxemburgish standards.

The most common vaccinations are listed and can be checked. More can be added as free text (supported by autocompletion).

A single form instance represents one vaccination entry. A summary table showing all vaccinations of the patient is displayed, too.</description>
  <layout>
    <colFormat>0px,f:0px:n,f:77px:n,f:71px:n,f:124px:n,f:110px:n,f:110px:n,f:92px:n,f:148px:n,fill:142px:none,fill:160px:none</colFormat>
    <rowFormat>0px,f:10px:n,f:30px:n,f:5px:n,f:50px:n,bottom:80px:n,fill:p:none,fill:30px:none,fill:50px:none,fill:p:none</rowFormat>
    <backgroundImg />
  </layout>
  <component xCoord="6" yCoord="6" xSize="1" ySize="1" key="polio" value="false" storeInDB="true" showInHistory="true" historyIndex="0.0" labelPosition="none" labelText="POLIO">
    <type>lu.tudor.santec.gecamed.formeditor.gui.component.EditableCheckBox</type>
    <structure>&lt;html&gt;&lt;b&gt;POLIO (IPV)&lt;/b&gt;&lt;i&gt;&lt;br&gt;Kinderlähmung</structure>
    <border>false,0,0,0,255</border>
    <background>false,238,238,238,255</background>
    <fontStyle />
    <fontSize>12</fontSize>
    <fontFamily>Dialog</fontFamily>
    <fontColor>true,0,0,0,255</fontColor>
    <hAlign>fill</hAlign>
    <vAlign>top</vAlign>
  </component>
  <component xCoord="3" yCoord="9" xSize="9" ySize="1" key="label_1" value="Vue d''ensemble des vaccinations :" storeInDB="false" showInHistory="false" historyIndex="0.0" labelPosition="none" labelText="">
    <type>lu.tudor.santec.gecamed.formeditor.gui.component.EditableLabel</type>
    <structure />
    <border>false,0,0,0,255</border>
    <background>false,238,238,238,255</background>
    <fontStyle>b</fontStyle>
    <fontSize>36</fontSize>
    <fontFamily>Georgia</fontFamily>
    <fontColor>true,102,102,255,255</fontColor>
    <hAlign>fill</hAlign>
    <vAlign>default</vAlign>
  </component>
  <component xCoord="3" yCoord="5" xSize="9" ySize="1" key="label_2" value="Vaccination :" storeInDB="false" showInHistory="false" historyIndex="0.0" labelPosition="none" labelText="">
    <type>lu.tudor.santec.gecamed.formeditor.gui.component.EditableLabel</type>
    <structure />
    <border>false,0,0,0,255</border>
    <background>false,238,238,238,255</background>
    <fontStyle>b</fontStyle>
    <fontSize>36</fontSize>
    <fontFamily>Georgia</fontFamily>
    <fontColor>true,102,102,255,255</fontColor>
    <hAlign>default</hAlign>
    <vAlign>default</vAlign>
  </component>
  <component xCoord="4" yCoord="6" xSize="1" ySize="1" key="tetanus" value="false" storeInDB="true" showInHistory="true" historyIndex="0.0" labelPosition="none" labelText="TE">
    <type>lu.tudor.santec.gecamed.formeditor.gui.component.EditableCheckBox</type>
    <structure>&lt;html&gt;&lt;b&gt;TE&lt;/b&gt;&lt;i&gt;&lt;br&gt;Tétanos&lt;br&gt;Tetanus</structure>
    <border>false,0,0,0,255</border>
    <background>false,238,238,238,255</background>
    <fontStyle />
    <fontSize>12</fontSize>
    <fontFamily>Dialog</fontFamily>
    <fontColor>true,0,0,0,255</fontColor>
    <hAlign>default</hAlign>
    <vAlign>top</vAlign>
  </component>
  <component xCoord="6" yCoord="3" xSize="2" ySize="1" key="_physician" value="PHYSICIAN" storeInDB="true" showInHistory="false" historyIndex="0.0" labelPosition="none" labelText="">
    <type>lu.tudor.santec.gecamed.formeditor.gui.component.EditableTextField</type>
    <structure />
    <border>false,0,0,0,255</border>
    <background>true,255,255,255,255</background>
    <fontStyle />
    <fontSize>12</fontSize>
    <fontFamily>Dialog</fontFamily>
    <fontColor>true,0,0,0,255</fontColor>
    <hAlign>default</hAlign>
    <vAlign>default</vAlign>
  </component>
  <component xCoord="3" yCoord="3" xSize="3" ySize="1" key="label_3" value="La vaccination effectuée par :" storeInDB="false" showInHistory="false" historyIndex="0.0" labelPosition="none" labelText="">
    <type>lu.tudor.santec.gecamed.formeditor.gui.component.EditableLabel</type>
    <structure />
    <border>false,0,0,0,255</border>
    <background>false,238,238,238,255</background>
    <fontStyle>b</fontStyle>
    <fontSize>16</fontSize>
    <fontFamily>Arial</fontFamily>
    <fontColor>true,0,0,0,255</fontColor>
    <hAlign>default</hAlign>
    <vAlign>default</vAlign>
  </component>
  <component xCoord="3" yCoord="7" xSize="1" ySize="1" key="label_4" value="Plus :" storeInDB="false" showInHistory="false" historyIndex="0.0" labelPosition="none" labelText="">
    <type>lu.tudor.santec.gecamed.formeditor.gui.component.EditableLabel</type>
    <structure />
    <border>false,51,0,0,255</border>
    <background>false,238,238,238,255</background>
    <fontStyle>b</fontStyle>
    <fontSize>12</fontSize>
    <fontFamily>Dialog</fontFamily>
    <fontColor>true,0,0,102,255</fontColor>
    <hAlign>center</hAlign>
    <vAlign>top</vAlign>
  </component>
  <component xCoord="4" yCoord="7" xSize="4" ySize="1" key="misc" value="" storeInDB="true" showInHistory="true" historyIndex="0.0" labelPosition="none" labelText="Plus : ">
    <type>lu.tudor.santec.gecamed.formeditor.gui.component.EditableAutoCompletionTextArea</type>
    <script eventTypeId="11">
      <scriptCode>validateTabbedPane(event);</scriptCode>
    </script>
    <structure>vaccination</structure>
    <border>false,0,0,0,255</border>
    <background>true,255,255,255,255</background>
    <fontStyle />
    <fontSize>12</fontSize>
    <fontFamily>Dialog</fontFamily>
    <fontColor>true,0,0,0,255</fontColor>
    <hAlign>default</hAlign>
    <vAlign>default</vAlign>
  </component>
  <component xCoord="8" yCoord="6" xSize="1" ySize="1" key="hepB" value="false" storeInDB="true" showInHistory="true" historyIndex="0.0" labelPosition="none" labelText="HEPATITE B">
    <type>lu.tudor.santec.gecamed.formeditor.gui.component.EditableCheckBox</type>
    <structure>&lt;html&gt;&lt;b&gt;HEPATITE B&lt;/b&gt;&lt;i&gt;&lt;br&gt;Hepatitis B</structure>
    <border>false,0,0,0,255</border>
    <background>false,238,238,238,255</background>
    <fontStyle />
    <fontSize>12</fontSize>
    <fontFamily>Dialog</fontFamily>
    <fontColor>true,0,0,0,255</fontColor>
    <hAlign>default</hAlign>
    <vAlign>top</vAlign>
  </component>
  <component xCoord="10" yCoord="6" xSize="1" ySize="1" key="meningitis" value="false" storeInDB="true" showInHistory="true" historyIndex="0.0" labelPosition="none" labelText="Méningite">
    <type>lu.tudor.santec.gecamed.formeditor.gui.component.EditableCheckBox</type>
    <structure>&lt;html&gt;&lt;b&gt;Méningite&lt;/b&gt;&lt;i&gt;&lt;br&gt;méningocoques C&lt;br&gt;Hirnhautentzündung</structure>
    <border>false,0,0,0,255</border>
    <background>false,238,238,238,255</background>
    <fontStyle />
    <fontSize>12</fontSize>
    <fontFamily>Dialog</fontFamily>
    <fontColor>true,0,0,0,255</fontColor>
    <hAlign>default</hAlign>
    <vAlign>top</vAlign>
  </component>
  <component xCoord="7" yCoord="6" xSize="1" ySize="1" key="influenzaB" value="false" storeInDB="true" showInHistory="true" historyIndex="0.0" labelPosition="none" labelText="HAEMOPHILUS">
    <type>lu.tudor.santec.gecamed.formeditor.gui.component.EditableCheckBox</type>
    <structure>&lt;html&gt;&lt;b&gt;HAEMOPHILUS&lt;/b&gt;&lt;i&gt;&lt;br&gt;Influenzae B</structure>
    <border>false,0,0,0,255</border>
    <background>false,238,238,238,255</background>
    <fontStyle />
    <fontSize>12</fontSize>
    <fontFamily>Dialog</fontFamily>
    <fontColor>true,0,0,0,255</fontColor>
    <hAlign>default</hAlign>
    <vAlign>top</vAlign>
  </component>
  <component xCoord="11" yCoord="6" xSize="1" ySize="1" key="mmrv" value="false" storeInDB="true" showInHistory="true" historyIndex="0.0" labelPosition="none" labelText="MMRV / RORV">
    <type>lu.tudor.santec.gecamed.formeditor.gui.component.EditableCheckBox</type>
    <structure>&lt;html&gt;&lt;b&gt;MMRV / RORV&lt;/b&gt;&lt;br&gt;  &lt;i&gt;ROUGEOLE / Masern&lt;br&gt;  OREILLONS / &lt;i&gt;Mumps&lt;br&gt;  RUBEOLE / Röteln&lt;br&gt;  VARICELLE / Varizellen</structure>
    <border>false,0,0,0,255</border>
    <background>false,238,238,238,255</background>
    <fontStyle />
    <fontSize>12</fontSize>
    <fontFamily>Dialog</fontFamily>
    <fontColor>true,0,0,0,255</fontColor>
    <hAlign>default</hAlign>
    <vAlign>top</vAlign>
  </component>
  <component xCoord="5" yCoord="6" xSize="1" ySize="1" key="whoopingCough" value="false" storeInDB="true" showInHistory="true" historyIndex="0.0" labelPosition="none" labelText="PER">
    <type>lu.tudor.santec.gecamed.formeditor.gui.component.EditableCheckBox</type>
    <structure>&lt;html&gt;&lt;b&gt;PER&lt;/b&gt;&lt;i&gt;&lt;br&gt;Coqueluche&lt;br&gt;Keuchhusten&lt;br&gt;Whooping cough</structure>
    <border>false,0,0,0,255</border>
    <background>false,238,238,238,255</background>
    <fontStyle />
    <fontSize>12</fontSize>
    <fontFamily>Dialog</fontFamily>
    <fontColor>true,0,0,0,255</fontColor>
    <hAlign>default</hAlign>
    <vAlign>top</vAlign>
  </component>
  <component xCoord="9" yCoord="6" xSize="1" ySize="1" key="infections" value="false" storeInDB="true" showInHistory="true" historyIndex="0.0" labelPosition="none" labelText="Infections">
    <type>lu.tudor.santec.gecamed.formeditor.gui.component.EditableCheckBox</type>
    <structure>&lt;html&gt;&lt;b&gt;Infections invasives à&lt;/b&gt;&lt;i&gt;&lt;br&gt;streptococcus pneumoniaeinvasive infectios</structure>
    <border>false,0,0,0,255</border>
    <background>false,238,238,238,255</background>
    <fontStyle />
    <fontSize>12</fontSize>
    <fontFamily>Dialog</fontFamily>
    <fontColor>true,0,0,0,255</fontColor>
    <hAlign>default</hAlign>
    <vAlign>top</vAlign>
  </component>
  <component xCoord="3" yCoord="10" xSize="9" ySize="1" key="dataTable" value="" storeInDB="false" showInHistory="true" historyIndex="0.0" labelPosition="none" labelText="">
    <type>lu.tudor.santec.gecamed.formeditor.gui.component.EditableDataTable</type>
    <script eventTypeId="13">
      <scriptCode>reloadTable();</scriptCode>
    </script>
    <structure>#&#xD;
#Wed May 28 07:43:01 CEST 2014&#xD;
column.ref.9=misc;Plus&#xD;
column.ref.8=mmrv;MMRV&#xD;
column.ref.7=meningitis;Méningtite&#xD;
column.ref.6=infections;Infections invasives&#xD;
column.ref.5=influenzaB;HAEMOPHILUS&#xD;
column.ref.4=polio;POLIO&#xD;
column.ref.3=whoopingCough;PER&#xD;
column.ref.2=tetanus;TE&#xD;
column.ref.1=diphteria;DI&#xD;
column.ref.0=\\#creationDate;Date de Vaccination&#xD;
column.ref.10=_physician;Vaccination effectuée par&#xD;
column.width=129;46;45;39;50;101;121;73;51;224;153;</structure>
    <border>true,7,38,108,255</border>
    <background>true,255,255,255,255</background>
    <fontStyle>b</fontStyle>
    <fontSize>12</fontSize>
    <fontFamily>Dialog</fontFamily>
    <fontColor>true,0,0,0,255</fontColor>
    <hAlign>fill</hAlign>
    <vAlign>fill</vAlign>
  </component>
  <component xCoord="3" yCoord="6" xSize="1" ySize="1" key="diphteria" value="false" storeInDB="true" showInHistory="true" historyIndex="0.0" labelPosition="none" labelText="DI">
    <type>lu.tudor.santec.gecamed.formeditor.gui.component.EditableCheckBox</type>
    <structure>&lt;html&gt;&lt;b&gt;DI&lt;/b&gt;&lt;i&gt;&lt;br&gt;Diphtérie&lt;br&gt;Diphteria</structure>
    <border>false,0,0,0,255</border>
    <background>false,238,238,238,255</background>
    <fontStyle />
    <fontSize>12</fontSize>
    <fontFamily>Dialog</fontFamily>
    <fontColor>true,0,0,0,255</fontColor>
    <hAlign>default</hAlign>
    <vAlign>top</vAlign>
  </component>
  <initScript>// imports
importClass(javax.swing.SwingConstants);

var iter;
var component;
var componentList 	= components.values();
var renderer 		= dataTable.getDefaultRenderer(new java.lang.String("").getClass());


// reload the table
reloadTable();


// set the text alignment of the checkboxes from centered (default) to top
for (iter = componentList.iterator(); iter.hasNext(); )
{
	component = iter.next();
	if (component instanceof javax.swing.JCheckBox)
	{
		component.setVerticalTextPosition(SwingConstants.TOP);
	}
}


// set the alignment for the columns
renderer.setColumnAlignment(0, SwingConstants.LEFT);
renderer.setColumnAlignment(1, SwingConstants.CENTER);
renderer.setColumnAlignment(2, SwingConstants.CENTER);
renderer.setColumnAlignment(3, SwingConstants.CENTER);
renderer.setColumnAlignment(4, SwingConstants.CENTER);
renderer.setColumnAlignment(5, SwingConstants.CENTER);
renderer.setColumnAlignment(6, SwingConstants.CENTER);
renderer.setColumnAlignment(7, SwingConstants.CENTER);
renderer.setColumnAlignment(8, SwingConstants.CENTER);
renderer.setColumnAlignment(9, SwingConstants.LEFT);
renderer.setColumnAlignment(10,SwingConstants.LEFT);

// set the alignment for the rows
renderer.setRowAlignment(0, SwingConstants.TOP);
renderer.setRowAlignment(1, SwingConstants.TOP);
renderer.setRowAlignment(2, SwingConstants.TOP);
renderer.setRowAlignment(3, SwingConstants.TOP);
renderer.setRowAlignment(4, SwingConstants.TOP);
renderer.setRowAlignment(5, SwingConstants.TOP);
renderer.setRowAlignment(6, SwingConstants.TOP);
renderer.setRowAlignment(7, SwingConstants.TOP);
renderer.setRowAlignment(8, SwingConstants.TOP);
renderer.setRowAlignment(9, SwingConstants.TOP);
renderer.setRowAlignment(10,SwingConstants.TOP);</initScript>
  <function name="validateTabbedPane">
    <scriptCode>/**
 * This is supposed to validate the whole tab, containing the form,
 * everytime The enter-, delete-, or backspace-key was hit.
 * This is to enlarge the misc text area (respectively the row which
 * contains it), as there might be added a new line or an old line removed.
 */
function validateTabbedPane (event) 
{
	var keyCode = event.getKeyCode();
	var tab;
	
	if (keyCode == java.awt.event.KeyEvent.VK_ENTER
			|| keyCode == java.awt.event.KeyEvent.VK_DELETE
			|| keyCode == java.awt.event.KeyEvent.VK_BACK_SPACE)
	{
		tab = formContext.get("tab");
		
		if (tab == null)
		{
			// if this is the first time, tab is not in the context
			tab = mainPanel.getParent();
			while (tab.getParent() != null 
					&amp;&amp; !(tab instanceof javax.swing.JTabbedPane))
			{
				tab = tab.getParent();
			}
			globalContext.put("tab", tab);
		}

		// validate the tab with all its components
		tab.validate();
	}
}</scriptCode>
  </function>
  <function name="reloadTable">
    <scriptCode>/**
 * This function is supposed to configure the data table
 * after is has been loaded / reloaded. 
 * Mainly the "true" and "false" entries in the table are 
 * changed to "X" and empty string.
 */
function reloadTable ()
{
	var column;
	var row;
	var checkboxValue;
	var value;
	
	
	/* 
	 * Define the layout of the table by changing all "true" and "false"-Strings into 
	 * "X" or empty String and center them
	 */
	for (row = 0; row &lt; dataTable.getRowCount(); row++) 
	{
		for (column = 0; column &lt; dataTable.getColumnCount(); column++) 
		{
			value 			= dataTable.getValueAt(row, column);
			checkboxValue 	= false;
			
			if (value == null
					|| column == 0
					|| column == 10) 
				continue;
			
			if (column == 9)
			{
				/* make it a HTML-text and change the linebreaks 
				 * in the text into &lt;br/&gt;
				 */
				value = "&lt;html&gt;" + value.replace("\\n", "&lt;br/&gt;");
				dataTable.setValueAt(value, row, column);
			}
			else if (value.equals("true"))
			{
				// change the text from "true" to "X"
				dataTable.setValueAt("&lt;html&gt;&lt;p align=\\"center\\"&gt;X&lt;/p&gt;", row, column);
				checkboxValue = true;
			}
			else if (value.equals("false"))
			{
				// remove the text, if it is "false"
				dataTable.setValueAt("", row, column);
				checkboxValue = true;
			}
		}
	}
}</scriptCode>
  </function>
</form>');