package lu.tudor.santec.gecamed.formeditor.gui.view.editormenu;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;

import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import lu.tudor.santec.gecamed.core.gui.GECAMedIconNames;
import lu.tudor.santec.gecamed.core.gui.GECAMedModule;
import lu.tudor.santec.gecamed.core.gui.widgets.NamedComponent;
import lu.tudor.santec.gecamed.formeditor.gui.component.CBEListModel;
import lu.tudor.santec.gecamed.formeditor.gui.component.EditableAutoCompletionTextArea;
import lu.tudor.santec.gecamed.formeditor.gui.component.EditableAutoCompletionTextField;
import lu.tudor.santec.gecamed.formeditor.gui.component.EditableButton;
import lu.tudor.santec.gecamed.formeditor.gui.component.EditableChart;
import lu.tudor.santec.gecamed.formeditor.gui.component.EditableCheckBox;
import lu.tudor.santec.gecamed.formeditor.gui.component.EditableComboBox;
import lu.tudor.santec.gecamed.formeditor.gui.component.EditableComponent;
import lu.tudor.santec.gecamed.formeditor.gui.component.EditableDataTable;
import lu.tudor.santec.gecamed.formeditor.gui.component.EditableDateChooser;
import lu.tudor.santec.gecamed.formeditor.gui.component.EditableLabel;
import lu.tudor.santec.gecamed.formeditor.gui.component.EditableNumericTextField;
import lu.tudor.santec.gecamed.formeditor.gui.component.EditableSubForm;
import lu.tudor.santec.gecamed.formeditor.gui.component.EditableTable;
import lu.tudor.santec.gecamed.formeditor.gui.component.EditableTextArea;
import lu.tudor.santec.gecamed.formeditor.gui.component.EditableTextField;
import lu.tudor.santec.gecamed.formeditor.gui.controller.ComponentSettingsController;
import lu.tudor.santec.gecamed.formeditor.gui.model.ComboBoxElement;
import lu.tudor.santec.gecamed.formeditor.gui.model.FormEditorModel;
import lu.tudor.santec.i18n.Translatrix;

import com.jgoodies.forms.layout.FormLayout;

public class DummySettingsPanel extends MenuSettingsPanel
{
	/* ======================================== */
	// 		STATIC MEMBERS
	/* ======================================== */
	
	private static final long serialVersionUID = 1L;
	
	private static final byte LIST_IS_SHOWN		= 0;
	private static final byte COMBOBOX_IS_SHOWN = 1;
	
	private static ComboBoxElement<?>[] ADDABLE_COMPONENTS = new ComboBoxElement<?> [] {
			new ComboBoxElement<String>(
					Translatrix.getTranslationString("formeditor.add_label"),
					EditableLabel.class.getName()),
			new ComboBoxElement<String>(
					Translatrix.getTranslationString("formeditor.add_textfield"),
					EditableTextField.class.getName()),
			new ComboBoxElement<String>(
					Translatrix.getTranslationString("formeditor.add_numeric_textfield"),
					EditableNumericTextField.class.getName()),
			new ComboBoxElement<String>(
					Translatrix.getTranslationString("formeditor.add_textarea"),
					EditableTextArea.class.getName()),
			new ComboBoxElement<String>(
					Translatrix.getTranslationString("formeditor.add_button"),
					EditableButton.class.getName()),
			new ComboBoxElement<String>(
					Translatrix.getTranslationString("formeditor.add_datechooser"),
					EditableDateChooser.class.getName()),
			new ComboBoxElement<String>(
					Translatrix.getTranslationString("formeditor.add_combobox"),
					EditableComboBox.class.getName()),
			new ComboBoxElement<String>(
					Translatrix.getTranslationString("formeditor.add_chart"),
					EditableChart.class.getName()),
			new ComboBoxElement<String>(
					Translatrix.getTranslationString("formeditor.add_checkbox"),
					EditableCheckBox.class.getName()),
			new ComboBoxElement<String>(
					Translatrix.getTranslationString("formeditor.add_table"),
					EditableTable.class.getName()),
			new ComboBoxElement<String>(
					Translatrix.getTranslationString("formeditor.add_data_table"),
					EditableDataTable.class.getName()),
			new ComboBoxElement<String>(
					Translatrix.getTranslationString("formeditor.add_subform"),
					EditableSubForm.class.getName()),
			new ComboBoxElement<String>(
					Translatrix.getTranslationString("formeditor.add_ac_textarea"),
					EditableAutoCompletionTextArea.class.getName()),
			new ComboBoxElement<String>(
					Translatrix.getTranslationString("formeditor.add_ac_textfield"), 
					EditableAutoCompletionTextField.class.getName())
	};
	
	
	/* ======================================== */
	// 		MEMBERS
	/* ======================================== */
	
	private ComponentSettingsController controller;

	private static 	String 	chooseListText 		= Translatrix.getTranslationString("formeditor.select_via_list");
	private static 	String 	chooseBoxText		= Translatrix.getTranslationString("formeditor.select_via_combobox");
	private 		byte 	selectedAddingMode;
	private 		boolean	isModifiing			= false;
	
	
	/* ---------------------------------------- */
	// 		JCOMPONENTS
	/* ---------------------------------------- */
	
	private JButton 	selectionSwitcherButton;
	private JComboBox 	addComponentBox;
	private JList		addComponentList;
	private JButton 	addComponentBtn;
	private JPanel		addComponentBoxPanel;
	private JTextField 	columnTxt;
	private JTextField 	rowTxt;
	private JSpinner	columnWidthSpinner;
	private JSpinner	rowHeightSpinner;
	
	
	
	/* ======================================== */
	// 		CONSTRUCTOR
	/* ======================================== */
	
	public DummySettingsPanel (FormEditorModel model)
	{
		super (model);
	}
	
	
	
	/* ======================================== */
	// 		IMPLEMENTED METHODS
	/* ======================================== */
	
	@Override
	protected void initPanel ()
	{
		selectedAddingMode 	= LIST_IS_SHOWN;
		
		/* **************************************** */
		// 	CREATE THE PANEL ITSELF
		/* **************************************** */
		
		this.setOpaque(false);
		this.setLayout(new FormLayout("5px, f:75px, 5px, f:75px, 0px"));
		
		
		/* **************************************** */
		// 	CREATE THE LABELS TO SHOW CURRENT ROW AND COLUMN
		/* **************************************** */
		
		columnTxt = new JTextField();
		columnTxt.setEnabled(false);
		columnTxt.setBackground(DISABLED_COLOR);
		
		rowTxt = new JTextField();
		rowTxt.setEnabled(false);
		rowTxt.setBackground(DISABLED_COLOR);
		
		appendRow(new NamedComponent(
				Translatrix.getTranslationString("formeditor.column"), 
				columnTxt, true), 2, 1);
		appendRow(new NamedComponent(
				Translatrix.getTranslationString("formeditor.row"), 
				rowTxt, true), 2, 1);
		
		
		/* **************************************** */
		// 	CREATE THE SPINNERS TO DEFINE ROW AND COLUMN SIZE
		/* **************************************** */
		final ComponentSettingsController settingsController = new ComponentSettingsController(model);
		columnWidthSpinner = new JSpinner(new SpinnerNumberModel(1, 1, 1, 1));
		columnWidthSpinner.addChangeListener(new ChangeListener()
		{
			public void stateChanged(ChangeEvent e)
			{
				if (!isModifiing)
					settingsController.spinnerChanged(columnWidthSpinner, 
							ComponentSettingsController.CHECK_COLUMN_WIDTH);
			}
		});
		
		rowHeightSpinner = new JSpinner(new SpinnerNumberModel(1, 1, 1, 1));
		rowHeightSpinner.addChangeListener(new ChangeListener()
		{
			public void stateChanged(ChangeEvent e)
			{
				if (!isModifiing)
					settingsController.spinnerChanged(rowHeightSpinner, 
							ComponentSettingsController.CHECK_ROW_HEIGHT);
			}
		});
		
		this.add(new NamedComponent(
				Translatrix.getTranslationString("formeditor.column_width"),
				columnWidthSpinner, true), CC.xy(4, 1));
		this.add(new NamedComponent(
				Translatrix.getTranslationString("formeditor.row_height"),
				rowHeightSpinner, true), CC.xy(4, 3));
		
		
		/* **************************************** */
		// 	CREATE THE COMBOBOX AND LIST CONTAINING THE EDITABLE COMPONENTS
		/* **************************************** */
		
		Vector<ComboBoxElement<?>> addableComponents = new Vector<ComboBoxElement<?>>(ADDABLE_COMPONENTS.length);
		
		for (ComboBoxElement<?> item : ADDABLE_COMPONENTS)
			addableComponents.add(item);
		
		// sort the vector
		Collections.sort(addableComponents,
				new Comparator<ComboBoxElement<?>>() {
			public int compare(ComboBoxElement<?> e1,
					ComboBoxElement<?> e2) {
				return e1.getTranslation().compareToIgnoreCase(
						e2.getTranslation());
			}
		});
		CBEListModel listModel = new CBEListModel(addableComponents);
		listModel.setSelectedItem(listModel.get(0));
		
		
		// controller that cares about adding
		controller = new ComponentSettingsController(
				model, listModel, 
				(SpinnerNumberModel)columnWidthSpinner.getModel(), 
				(SpinnerNumberModel)rowHeightSpinner.getModel());
		
		// create the combobox
		addComponentBox = new JComboBox(listModel);
		
		// create the button to add the selected component
		addComponentBtn = new JButton(GECAMedModule.getSmallIcon(GECAMedIconNames.ADD));
		addComponentBtn.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent e)
			{
				controller.addComponent(addComponentBox.getSelectedIndex());
			}
		});
		
		// create the selection switcher button
		selectionSwitcherButton = new JButton(new AbstractAction()
		{
			private static final long serialVersionUID = 1L;
			
			public void actionPerformed(ActionEvent e)
			{
				switchButtonCaption();
			}
		});
		
		// create the panel 
		addComponentBoxPanel = new JPanel(new FormLayout("f:126px, 5px, f:24px", "24px"));
		addComponentBoxPanel.add(addComponentBox, CC.xy(1, 1));
		addComponentBoxPanel.add(addComponentBtn, CC.xy(3, 1));
		
		// create the list
		addComponentList = new JList(addableComponents);
		addComponentList.getSelectionModel().setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		
		addComponentList.addMouseListener(new MouseAdapter()
		{
			@Override
			public void mouseClicked(MouseEvent e)
			{
				if (e.getClickCount() >= 2)
					controller.addComponent(addComponentList.getSelectedIndex());
			}
		});
		
		switchButtonCaption();
		
		appendRow(selectionSwitcherButton);
		appendRow(new JLabel(
				Translatrix.getTranslationString("formeditor.add_component") + ":"), 
				2, 3);
		appendRow(addComponentList, 2, 3);
		appendRow(addComponentBoxPanel);
	}
	
	
	@Override
	public void preparePanelForSelectedComponent(
			EditableComponent curSelComp)
	{
		try {
			isModifiing = true;
			
			SpinnerNumberModel spinnerModel;
			
			columnTxt.setText(String.valueOf(curSelComp.getColumn() - 1));
			rowTxt.setText(String.valueOf(curSelComp.getRow() - 1));
			
			curSelComp.setColumnSpinnerModel((SpinnerNumberModel) columnWidthSpinner.getModel());
			curSelComp.setRowSpinnerModel(	 (SpinnerNumberModel) rowHeightSpinner.getModel());
			
			spinnerModel = curSelComp.getColumnSpinnerModel();
			spinnerModel.setValue(1);
			spinnerModel.setMaximum(view.getMaxWidthWithCurrentHeight(curSelComp));
	
			spinnerModel = curSelComp.getRowSpinnerModel();
			spinnerModel.setValue(1);
			spinnerModel.setMaximum(view.getMaxHeightWithCurrentWidth(curSelComp));
			
			// check if the button should be enabled or not
	//		enableAddButton();
		} finally {
			isModifiing = false;
		}
	}
	
	
	
	/* ======================================== */
	// 		HELP METHODS
	/* ======================================== */
	
	private void switchButtonCaption ()
	{
		switch (selectedAddingMode)
		{
		case COMBOBOX_IS_SHOWN:
			selectedAddingMode = LIST_IS_SHOWN;
			selectionSwitcherButton.setText(chooseBoxText);
			selectionSwitcherButton.setToolTipText(chooseBoxText);
			addComponentBoxPanel.setVisible(false);
			addComponentList.setVisible(true);
			break;
			
		case LIST_IS_SHOWN:
			selectedAddingMode = COMBOBOX_IS_SHOWN;
			selectionSwitcherButton.setText(chooseListText);
			selectionSwitcherButton.setToolTipText(chooseListText);
			addComponentBoxPanel.setVisible(true);
			addComponentList.setVisible(false);
			break;
		}
	}
}
