package lu.tudor.santec.gecamed.formeditor.gui.view;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.util.Collection;

import javax.swing.JPanel;

import lu.tudor.santec.gecamed.core.gui.GECAMedColors;
import lu.tudor.santec.gecamed.formeditor.ejb.entity.beans.FormTemplate;
import lu.tudor.santec.gecamed.formeditor.gui.model.ComboBoxElement;
import lu.tudor.santec.gecamed.patient.gui.PatientPanel;
import lu.tudor.santec.gecamed.patient.gui.history.table.HistoryTableModel;
import lu.tudor.santec.gecamed.patient.gui.history.table.HistoryTablePanel;
import lu.tudor.santec.gecamed.patient.gui.history.table.filter.HistoryCodeFilter;
import lu.tudor.santec.gecamed.patient.gui.history.table.filter.HistoryDateFilter;
import lu.tudor.santec.gecamed.patient.gui.history.table.filter.HistoryFulltextFilter;
import lu.tudor.santec.gecamed.patient.gui.history.table.filter.HistoryTypeFilter;
import lu.tudor.santec.gecamed.patient.gui.history.viewtab.HistoryViewTab;
import lu.tudor.santec.i18n.Translatrix;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

public class FormHistoryView extends HistoryViewTab {

	private static final long serialVersionUID = 1L;
	
	public static final String NAME = "FORM_VIEW";
	
	private FormTab formTab;
	
	private HistoryTypeFilter searchFilter;
	
	private HistoryTablePanel tablePanel;
	
	private HistoryTableModel tableModel;
	
	private HistoryCodeFilter codeFilter;
	
	
	public FormHistoryView (PatientPanel patientPanel, FormTab formTab) 
	{
		//Initialisation is done in the parent class
		super(patientPanel,false,"form");


		//	initComponent();
	}

	private void initComponent() 
	{
		JPanel mainPanel = new JPanel(
				new FormLayout("f:100:g", "p, 0px, f:100:g"));
		mainPanel.setOpaque(false);
		
		this.setLayout(new BorderLayout());
		this.add(mainPanel);
		
		this.setBackground(GECAMedColors.c_GECAMedBackground);
		
		CellConstraints cc 	 = new CellConstraints();
		
		mainPanel.add(this.searchPanel, cc.xy(1, 1));
		
		tablePanel.setBorder(null);
		mainPanel.add(this.tablePanel, cc.xy(1, 3));
	}
	
/*
	@Override
	protected void initFilter () 
	{
		searchFilter = new HistoryTypeFilter();
		searchFilter.setFilter(FormTab.NAME);
		
		textFilter = new HistoryFulltextFilter();
		codeFilter = new HistoryCodeFilter();
		dateFilter = new HistoryDateFilter();
		
		/* This is called by the super constructor. 
		 * Therefore this.tableModel & this.tablePanel will be null.
		 * 
		HistoryTablePanel tablePanel = super.formTablePanel;
		HistoryTableModel tableModel = tablePanel.getModel();
//		
		tableModel.installFilter(searchFilter, 2);
		tableModel.installFilter(textFilter, 3);
		tableModel.installFilter(codeFilter, 4);
		tableModel.installFilter(dateFilter, 0);
//		
		tableModel.setFilteringEnabled(true, 2);
		tableModel.setFilteringEnabled(true, 4);
	}
	
*/
	@Override
	public void initTypeBox() 
	{
		if (formTab == null) 
			return;
		
		typeBox.removeAllItems();
		
		Collection<FormTemplate> templates = FormTab.getTemplates();
		
		ComboBoxElement<String> elem = new ComboBoxElement<String>( 
				Translatrix.getTranslationString("core.all"), (String)null);
		typeBox.addItem(elem);
		
		for (FormTemplate template : templates) 
		{
			if (template.isSubFormOnly())
				continue;
			
			elem = new ComboBoxElement<String>(
					template.getName(),
//					"<title>" + template.getName() + "</title>");
					String.valueOf(template.getId()));
//			elem = new ComboBoxElement(template.getName(), template.getName());
			typeBox.addItem(elem);
		}
	}


	/* ======================================== */
	// 		GETTER
	/* ======================================== */
	
	public HistoryTablePanel getHistoryTablePanel() 
	{
		return tablePanel;
	}
	
	@Override
	public String getName() 
	{
		return NAME;
	}
	
	/* ======================================== */
	// 		Overridden events
	/* ======================================== */

	@Override
	public void actionPerformed(ActionEvent e) 
	{
		if (this.typeBox.equals(e.getSource())) 
		{
			ComboBoxElement<?> elem = (ComboBoxElement<?>) typeBox.getSelectedItem();
			
//			if (elem != null && !elem.getValue().equals(""))
			if (elem != null && elem.getValue() != null)  
			{
				codeFilter.setFilter(elem.getValue());
				codeFilter.setFiltering(true);
				tableModel.setFilteringEnabled(true, 4);
			}
			else 
			{
				codeFilter.setFiltering(false);
				tableModel.setFilteringEnabled(false, 4);
			}
		}
		else if (this.clearButton.equals(e.getSource())) 
		{
			this.textField.setText("");
			this.fromDateChooser.setDate(null);
			this.toDateChooser.setDate(  null);
			try 
			{
				this.typeBox.setSelectedIndex(0);
			} 
			catch (Exception ex) {}
		}
		
//		model.update();
		tablePanel.updateTable();
//		tableModel.fireTableDataChanged();
	}
}
