package lu.tudor.santec.gecamed.formeditor.gui.model;

import java.awt.Component;

import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

import lu.tudor.santec.gecamed.core.gui.GECAMedColors;
import lu.tudor.santec.org.fife.ui.autocomplete.CompletionProvider;
import lu.tudor.santec.org.fife.ui.autocomplete.ShorthandCompletion;

public class IconCompletion extends ShorthandCompletion
{
	private static IconCellRenderer renderer = new IconCellRenderer(); 
	
	private Icon icon;
	
	
	public IconCompletion(CompletionProvider provider, String replacementText, String description, Icon icon)
	{
		this(provider, replacementText, replacementText, description, icon);
	}
	
	
	public IconCompletion(CompletionProvider provider, String inputText, String replacementText, String description, Icon icon)
	{
		super(provider, inputText, replacementText, description);
		this.icon = icon;
	}
	
	
	
	public void setIcon (Icon icon)
	{
		this.icon = icon;
	}
	
	
	public Icon getIcon ()
	{
		return this.icon;
	}
	
	
	@Override
	public String toString()
	{
		StringBuffer text = new StringBuffer("<html><b>")
				.append(getInputText())
				.append("</b>");
		if (getShortDescription() != null)
			text.append("</b><i> (")
					.append(getShortDescription())
					.append(")</i>");
		return text.toString();
	}
	
	
	public static ListCellRenderer getRenderer ()
	{
		return renderer;
	}
	
	
	public static ListCellRenderer createRenderer ()
	{
		return new IconCellRenderer();
	}
	
	
	private static class IconCellRenderer implements ListCellRenderer
	{
		public Component getListCellRendererComponent(JList list, Object value,
				int index, boolean isSelected, boolean cellHasFocus)
		{
			JLabel cell = new JLabel(value.toString());
			cell.setOpaque(true);
			
			if (isSelected)
				cell.setBackground(GECAMedColors.c_OddLineSearchBackground);
			else if (index % 2 == 0)
				cell.setBackground(GECAMedColors.c_EvenLineBackground);
			else 
				cell.setBackground(GECAMedColors.c_OddLineBackground);
			
			if (value instanceof IconCompletion)
				cell.setIcon(((IconCompletion) value).getIcon());
			else 
				System.out.println("NOT AN ICON COMPLETION !!!");
			
			return cell;
		}
		
	}
}
