package lu.tudor.santec.gecamed.formeditor.gui.controller.converter;

import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

import lu.tudor.santec.gecamed.core.gui.MainFrame;
import lu.tudor.santec.gecamed.core.gui.controller.ControllerConfig;
import lu.tudor.santec.gecamed.core.gui.controller.document.word.WordController;
import lu.tudor.santec.gecamed.formeditor.gui.model.ComboBoxElement;
import lu.tudor.santec.gecamed.letter.gui.settings.LetterTemplateSettings;
import lu.tudor.santec.i18n.Translatrix;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

public class FormDataConverterChooser extends JPanel
{
	private static final long serialVersionUID = 1L;
	
	/** the logger Object for this class */
	private static Logger logger = Logger.getLogger(FormDataConverterChooser.class.getName());
	
	private JLabel 			label;
	private JComboBox 		box;
	private ActionListener 	optionListener;
	
	
	public FormDataConverterChooser()
	{
		super();
		this.setLayout(new FormLayout("f:p:g, 3dlu, f:p", "f:p"));
		
		this.label 			= new JLabel();
		this.box 			= new JComboBox();
		this.optionListener = new ActionListener()
		{
			public void actionPerformed(ActionEvent e)
			{
				int option = FormDataConverter.NO_HANDLER_OPTION;
				Integer value = getSelectedValue();
				if (value != null)
				{
					option = value.intValue();
					if (option == FormDataConverter.OOWRITER_HANDLER_OPTION
							&& MainFrame.getMachineSetting(ControllerConfig.OO_INSTALLATION) == null
							&& ControllerConfig.getController(LetterTemplateSettings.WRITER, false) == null)
						option = FormDataConverter.NO_HANDLER_OPTION;
				}
				
				FormDataConverter.setHandlerOption(option);
			}
		};
		
		relocalize();
	}
	
	public void relocalize ()
	{
		CellConstraints cc 	= new CellConstraints();
		Integer selected	= this.getSelectedValue();
		Desktop desktop 	= Desktop.getDesktop();
//		String tps 			= null;
//		
//		try {
//			tps 		 	= (String) LetterTemplateModule.getInstance()
//					.getLetterSettings().getValue(LetterTemplateSettings.TPS);
//		}
//		catch (NullPointerException e) { /* TPS is not set -> just leave it */ }
		
		box.removeActionListener(this.optionListener);
		box.addItem(null);
		
		// check the available options ...
		try 
		{
			if (Desktop.isDesktopSupported()
					&& desktop.isSupported(Desktop.Action.EDIT)
					&& desktop.isSupported(Desktop.Action.PRINT))
				// if the Desktop is supported, show the option
				box.addItem(new ComboBoxElement<Integer>(
						Translatrix.getTranslationString("um.formPrinterDesktop"), 
						Integer.valueOf(FormDataConverter.DESKTOP_HANDLER_OPTION)));
		}
		catch (Throwable e) 
		{
			logger.log(Level.WARN, "Couldn't load Desktop API support");
		}
		
//		if (tps != null && tps.equals(LetterTemplateSettings.WORD))
		try
		{
			if (WordController.isWordInstalled())
				// if MS Word is set for the letter module, show the option
				box.addItem(new ComboBoxElement<Integer>(
						Translatrix.getTranslationString("um.formPrinterWord"), 
						Integer.valueOf(FormDataConverter.MSWORD_HANDLER_OPTION)));
		}
		catch (Throwable e) 
		{
			logger.log(Level.WARN, "Couldn't load Word support");
		}
		
//		if (tps != null && tps.equals(LetterTemplateSettings.WRITER))
			// if OO Writer is set for the letter module, show the option
		try
		{
			box.addItem(new ComboBoxElement<Integer>(
					Translatrix.getTranslationString("um.formPrinterWriter"), 
					Integer.valueOf(FormDataConverter.OOWRITER_HANDLER_OPTION)));
		}
		catch (Throwable e) 
		{
			logger.log(Level.WARN, "Couldn't load OOo support");
		}
		
		label.setText("<html>" + Translatrix.getTranslationString("um.formPrinter"));
		
		box.addActionListener(optionListener);
		this.setSelectedValue(selected);
		
		this.removeAll();
		this.add(label, cc.xy(1, 1));
		this.add(box, 	cc.xy(3, 1));
	}
	
	public Integer getSelectedValue()
	{
		ComboBoxElement<?> elem = ((ComboBoxElement<?>)box.getSelectedItem());
		if (elem != null)
			 return (Integer) elem.getValue();
		else return Integer.valueOf(FormDataConverter.NO_HANDLER_OPTION);
	}
	
	public void setSelectedValue(Integer value)
	{
		if (value == null
				|| value.intValue() == FormDataConverter.NO_HANDLER_OPTION)
		{
			box.setSelectedItem(null);
			FormDataConverter.setHandlerOption(FormDataConverter.NO_HANDLER_OPTION);
			return;
		}
		
		int 				intValue = value.intValue();
		Integer 			itemValue;
		ComboBoxElement<?>	item;
		
		for (int index = 0; index < box.getItemCount(); index++)
		{
			item = (ComboBoxElement<?>) box.getItemAt(index);
			if (item == null)
				continue;
			
			itemValue = (Integer) item.getValue();
			if (item != null && itemValue == intValue)
			{
				box.setSelectedItem(item);
				FormDataConverter.setHandlerOption(itemValue);
				return;
			}
		}
		
		
	}
	
	public Integer getValueAt(int index)
	{
		ComboBoxElement<?> elem = ((ComboBoxElement<?>)box.getItemAt(index));
		if (elem != null)
			 return (Integer) elem.getValue();
		else return null;
	}
}
