package lu.tudor.santec.gecamed.formeditor.gui.controller.action;

import java.awt.event.ActionEvent;

import lu.tudor.santec.gecamed.core.gui.GECAMedIconNames;
import lu.tudor.santec.gecamed.core.gui.GECAMedModule;
import lu.tudor.santec.gecamed.core.gui.listener.AEntryAction;
import lu.tudor.santec.gecamed.core.gui.listener.EntryTypeRegister;
import lu.tudor.santec.gecamed.formeditor.gui.view.FormTab;
import lu.tudor.santec.i18n.Translatrix;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class FormEntryDeleteAction extends AEntryAction {

	private static final long serialVersionUID = 1L;
	
	/** the logger Object for this class */
	private static Logger logger = Logger.getLogger(FormEntryDeleteAction.class.getName());
	
	public FormEntryDeleteAction() {
		/* ======================================== */
		super(Translatrix.getTranslationString("formeditor.form.delete"),
				GECAMedModule.getSmallIcon(GECAMedIconNames.CANCEL));
		/* ======================================== */
	}

	public void actionPerformed(ActionEvent e) {
		/* ======================================== */
		try {
			FormTab formTab = (FormTab)EntryTypeRegister.getHandler(FormTab.NAME);
			formTab.delete(entry2work);
		} catch (ClassCastException cce) {
			logger.log(Level.ERROR, cce.getMessage(), cce);
		}
		/* ======================================== */
	}

}
