package lu.tudor.santec.gecamed.formeditor.gui.controller;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;

import lu.tudor.santec.gecamed.core.gui.GECAMedColors;
import lu.tudor.santec.gecamed.core.gui.GECAMedIconNames;
import lu.tudor.santec.gecamed.core.gui.GECAMedModule;
import lu.tudor.santec.gecamed.formeditor.gui.model.FormEditorModel;
import lu.tudor.santec.i18n.Translatrix;

public class FormEditorPopupController implements MouseListener {
	
	private JPopupMenu popupMenu;
	private Component thisComponent;
	private JTabbedPane tabbedPane;
	
	public FormEditorPopupController (FormEditorModel model, 
			JTabbedPane tabbedPane, Component thisComponent) {
		/* ======================================== */
		popupMenu = new JPopupMenu();		
		popupMenu.setBackground(GECAMedColors.c_GECAMedBackground);
		popupMenu.setBorderPainted(true);
		
		MenuPanelController controller = new MenuPanelController(model);
		
		JMenuItem closeMenuItem = new JMenuItem(
				Translatrix.getTranslationString("core.close"),
				GECAMedModule.getMiniIcon(GECAMedIconNames.CLOSE));		
		closeMenuItem.setActionCommand(
				MenuPanelController.CLOSE_PREVIEW_BUTTON);
		
		closeMenuItem.addActionListener(controller);
		closeMenuItem.addActionListener(new ActionListener() {
			
			/* -------------------------------------------------- */
			public void actionPerformed(ActionEvent e) {
				popupMenu.setVisible(false);
			}
			/* -------------------------------------------------- */
		});
		
		popupMenu.add(closeMenuItem);
		
		JMenuItem closeAllMenuItem = new JMenuItem(
				Translatrix.getTranslationString("core.closeAll"),
				GECAMedModule.getMiniIcon(GECAMedIconNames.CLOSE));		
		closeAllMenuItem.setActionCommand(
				MenuPanelController.CLOSE_ALL_PREVIEWS_BUTTON);
		
		closeAllMenuItem.addActionListener(controller);
		closeAllMenuItem.addActionListener(new ActionListener() {
			
			/* -------------------------------------------------- */
			public void actionPerformed(ActionEvent e) {
				popupMenu.setVisible(false);
			}
			/* -------------------------------------------------- */
		});
		
		popupMenu.add(closeAllMenuItem);
		
		this.tabbedPane = tabbedPane;
		this.thisComponent = thisComponent;
		/* ======================================== */
	}
	
	private void showPopup (MouseEvent e)
	{
		if (e.isPopupTrigger())
		{
			popupMenu.show((Component)e.getSource(), e.getX(), e.getY());
		}
	}

	public void mouseClicked(MouseEvent e) {
		/* ======================================== */
		showPopup(e);
		/* ======================================== */
	}
	
	public void mousePressed(MouseEvent e) { 
		/* ======================================== */
		tabbedPane.setSelectedComponent(thisComponent);
		showPopup(e);
		/* ======================================== */
	}
	
	public void mouseReleased(MouseEvent e) { 
		showPopup(e);
	}
	
	public void mouseEntered(MouseEvent e) { }
	public void mouseExited(MouseEvent e) { }
}
