package lu.tudor.santec.gecamed.formeditor.gui.controller;

import java.awt.Component;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;

import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;

import lu.tudor.santec.gecamed.core.gui.GECAMedModule;
import lu.tudor.santec.gecamed.core.gui.GECAMedTab;

public class EditableScrollingListener implements MouseWheelListener
{
	public void mouseWheelMoved(MouseWheelEvent e)
	{
		Component 	c = (JComponent) e.getSource();
		JScrollPane pane;
		JScrollBar 	bar;
		int 		value;
		
		while (c != null
				&& !(c instanceof GECAMedTab)
				&& !(c instanceof GECAMedModule))
		{
			if (c instanceof JScrollPane)
			{
				pane = ((JScrollPane)c);
				if (pane.getVerticalScrollBar().isVisible()
						|| pane.getHorizontalScrollBar().isVisible())
				{
					if (pane.getVerticalScrollBar().isVisible())
						 bar = pane.getVerticalScrollBar();
					else bar = pane.getHorizontalScrollBar();
					
					value = bar.getValue();
					if (e.getScrollType() == MouseWheelEvent.WHEEL_UNIT_SCROLL)
						 value += e.getUnitsToScroll() * bar.getUnitIncrement();
					else value += e.getUnitsToScroll() * bar.getBlockIncrement();
					
					bar.setValue(value);
					
					return;
				}
			}
			
			c = c.getParent();
		}
	}
}
