package lu.tudor.santec.gecamed.formeditor.gui.controller;

import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;

import lu.tudor.santec.gecamed.formeditor.gui.component.EditableComponent;
import lu.tudor.santec.gecamed.formeditor.gui.model.FormEditorModel;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class DnDController implements DropTargetListener {
	
	/**
	 * @author Jens Ferring
	 * 
	 * This Controller enables the DnD-ability for the EditableComponents.
	 */
	
	/** the logger Object for this class */
	private static Logger logger = Logger.getLogger(DnDController.class.getName());
	
	private FormEditorModel model;
	private EditableComponent component;
	
	public DnDController (FormEditorModel formeditorModule, EditableComponent editableComponent) {
		model = formeditorModule;
		component = editableComponent;
	}

	/**
	 * makes the component be a drop target (only dummy-components are drop-targets)
	 */
	public void drop(DropTargetDropEvent dtde) 
	{
		try {
			if (!model.getCurrentlySelectedComponent().getName().equals(component.getName())) 
			{
				if (model.moveComponent(model.getCurrentlySelectedComponent(), component))
					model.getView().setModified(true);
			}
		} 
		catch (NullPointerException e) 
		{ 
			//The target was dropped to a wrong location
			logger.log(Level.INFO, "Invalid droptarget ...");
		}
	}
	
	// =====  UNUSED LISTENER-METHODS  =====
	public void dragEnter(DropTargetDragEvent dtde) {}
	public void dragExit(DropTargetEvent dte) {}
	public void dragOver(DropTargetDragEvent dtde) {}
	public void dropActionChanged(DropTargetDragEvent dtde) {}
}
