package lu.tudor.santec.gecamed.formeditor.gui.component;

import java.lang.reflect.Array;


public class ScriptHelper
{
	/* ======================================== */
	// 	ARRAY OPERATIONS
	/* ======================================== */
	
	public static Object createArray (int length)
	{
		return createArray(Object.class, length);
	}
	
	
	public static Object createArray (int ... dimensions)
	{
		return createArray(dimensions);
	}
	
	
	public static Object createArray (Class<?> clazz, int length)
	{
		return Array.newInstance(clazz, length);
	}
	
	
	public static Object createArray (Class<?> clazz, int ... dimensions)
	{
		return Array.newInstance(clazz, dimensions);
	}
	
	
	public static byte[] createByteArray (int length)
	{
		return new byte[length];
	}
	
	
	public static short[] createShortArray (int length)
	{
		return new short[length];
	}
	
	
	public static int[] createIntArray (int length)
	{
		return new int[length];
	}
	
	
	public static long[] createLongArray (int length)
	{
		return new long[length];
	}
	
	
	public static float[] createFloatArray (int length)
	{
		return new float[length];
	}
	
	
	public static double[] createDoubleArray (int length)
	{
		return new double[length];
	}
	
	
	public static boolean[] createBooleanArray (int length)
	{
		return new boolean[length];
	}
	
	
	public static char[] createCharArray (int length)
	{
		return new char[length];
	}
	
	
	
	/* ======================================== */
	// 	INSTANCE OF
	/* ======================================== */
	
	public static boolean instanceOf (Object o, Class<?> clazz)
	{
		Class<?> objectClazz 	= o.getClass();
		Class<?> compareClass 	= clazz;
		
		while (!objectClazz.equals(Object.class))
		{
			if (objectClazz.equals(compareClass))
				return true;
			else
				objectClazz 	= objectClazz.getSuperclass();
		}
		
		if (compareClass.equals(Object.class))
			 return true;
		else return false;
	}
	
	
	
	/* ======================================== */
	// 	MAIN (for testing)
	/* ======================================== */
	
	public static void main(String[] args)
	{
		// test here ...
		
	}
}
