package lu.tudor.santec.gecamed.formeditor.gui.component;

import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;

import lu.tudor.santec.gecamed.formeditor.gui.FormEditorModule;
import lu.tudor.santec.i18n.Translatrix;

public class FormEditorButton extends JButton {
	
	private static final long serialVersionUID = 1L;
	
	public FormEditorButton () {}
	
	public FormEditorButton (Action a) { super(a); }
	
	public FormEditorButton (Icon icon) { super(icon); }
	
	public FormEditorButton (String text) { super(text); }
	
	public FormEditorButton (String text, Icon icon) { super(text, icon); }
	
	
	
	@Override
	public void setEnabled (boolean enable) {
		if (FormEditorModule.isJavaVersionOK()) {
			super.setEnabled(enable);
		} else {
			super.setEnabled(false);
		}
	}
	
	@Override
	public void setToolTipText (String text) {
		if (!FormEditorModule.isJavaVersionOK())
			super.setToolTipText(
					Translatrix.getTranslationString("formeditor.wrongJavaVersion_tooltipp"));
		else 
			super.setToolTipText(text);
	}
	
	@Override
	public void setMnemonic (int mnemonic) {
		if (FormEditorModule.isJavaVersionOK())
			super.setMnemonic(mnemonic);
	}
	
	@Override
	public void setMnemonic (char mnemonic) {
		if (FormEditorModule.isJavaVersionOK())
			super.setMnemonic(mnemonic);
	}
}
