package lu.tudor.santec.gecamed.formeditor.gui.component;

import java.awt.BorderLayout;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;

import lu.tudor.santec.gecamed.formeditor.gui.controller.FormController;
import lu.tudor.santec.gecamed.formeditor.gui.model.FormEditorModel;
import lu.tudor.santec.gecamed.formeditor.gui.model.FormModel;
import lu.tudor.santec.i18n.Translatrix;

import org.apache.log4j.Level;
import org.jdom.Element;

import com.jgoodies.forms.layout.CellConstraints;

public class EditableTextArea extends EditableComponent {	
	/**
	 * @author Jens Ferring
	 * 
	 * This represents a JTextArea as EditableComponent.
	 */
	private static final long serialVersionUID = 1L;
	
	public static final int LISTENER_METHOD_SIZE = 1;
	public static final int CARET_UPDATED = SUPER_LISTENER_METHOD_SIZE;

	public EditableTextArea () {
		super();
		component = new JTextArea();
//		component.setEnabled(false);
	}
	
	@Override
	public void init (CellConstraints constraints, FormEditorModel formModel, byte formModelType) {
		super.init(constraints, formModel, formModelType);
		this.remove(component);
		JScrollPane sp = new JScrollPane(component);
		sp.getVerticalScrollBar().setUnitIncrement(16);
		sp.setOpaque(false);
		sp.getViewport().setOpaque(false);
		this.add(sp, BorderLayout.CENTER);
	}
	
	@Override
	protected void initType()
	{
		// the key-listener is add to synchronize the TextField in the settings panel with this TextArea
		component.addKeyListener(new KeyListener() 
		{
			public void keyTyped(KeyEvent e) {}
			public void keyPressed(KeyEvent e) {}
			
			public void keyReleased(KeyEvent e) 
			{
				((JTextComponent)optionPanel.getCaptionText()).setText(getText());
			}
		});
		
		super.initType();
	}
	
	@Override
	public String getText() {
		return ((JTextArea)component).getText();
	}

	@Override
	public void setText(String text) {
		((JTextArea)component).setText(text);
	}
	
	@Override
	public JPanel getAddablePanel(JComponent c) {
		/* ======================================== */
		JScrollPane sp = new JScrollPane(c);
		sp.getVerticalScrollBar().setUnitIncrement(16);
		sp.setOpaque(false);
		sp.getViewport().setOpaque(false);
		return super.getAddablePanel(sp);
		/* ======================================== */
	}
	
	@Override
	public String getComponentType () {
		return "textarea";
	}
	
	@Override
	public JComponent copyComponent (FormModel model) 
	{
		JTextComponent ta = (JTextComponent) this.component;
		
		FormController controller = new FormController(model);
		ta.addCaretListener(controller);
		controller.setCodeAt(FormController.CARET_UPDATED, getScriptAt(CARET_UPDATED));
		super.addDefaultListener(ta, controller);
		
		return ta;
	}

	@Override
	protected void addListenerMethodNames() {
		listenerMethodNames[CARET_UPDATED] = "caretUpdated";
	}

	@Override
	public int getListenerMethodSize() {
		return LISTENER_METHOD_SIZE;
	}

	@Override
	public String getStructure() {
		return "";
	}

	@Override
	public void setStructure(String text) { }
	
	@Override
	public String getTypeTranslation () {
		/* ======================================== */
		return Translatrix.getTranslationString("formeditor.add_textarea");
		/* ======================================== */
	}

	@Override
	protected JComponent createCaptionText () {
		return new JTextArea();
	}
	
//	@Override
//	protected DefaultOptionPanel createOptionPanel () {
//		/* ======================================== */
//		DefaultOptionPanel p = super.createOptionPanel();
//		
//		/* enlarge the captionText, cause in this case
//		 * it is not a text field, but a text area
//		 */
//		((FormLayout)p.getLayout()).setRowSpec(1, RowSpec.decode("f:75px"));
//		
//		return p;
//		/* ======================================== */
//	}

	@Override
	public Boolean isComponentTypeStoredInDBByDefault () {
		return true;
	}
	
	@Override
	public Element getDataAsXML()
	{
		Element 	data 		= new Element(getKey());
		JTextArea 	textArea 	= (JTextArea) getComponent();
		
		fillWithXMLData(data, textArea);
		addDefaultProperties(data);
		
		return data;
	}
	
	
	public static Element fillWithXMLData (Element data, JTextArea textArea)
	{
//		Element data = new Element(getKey());
		Element text = new Element(XML_ELEMENT_TEXT);
		Element lines = new Element("lines");
		Element line;
		
//		JTextArea ta = (JTextArea) getComponent();
		String 	textLine;
		int 	lineCount = textArea.getLineCount();
		int 	lineStartOffset;
		int 	lineEndOffset;
		
		
		for (int lineIndex = 0; lineIndex < lineCount; lineIndex++)
		{
			try
			{
				lineStartOffset = textArea.getLineStartOffset(lineIndex);
				lineEndOffset 	= textArea.getLineEndOffset(lineIndex);
				textLine 		= textArea.getText(lineStartOffset, (lineEndOffset - lineStartOffset));
				
			} 
			catch (BadLocationException e)
			{
				logger.log(Level.ERROR, e.getMessage(), e);
				textLine 		= " ## MISSING LINE !!! ## ";
			}
			line = new Element("line");
			line.setText(textLine);
			lines.addContent(line);
		}
		data.addContent(lines);
		
		text.setText(textArea.getText());
		data.addContent(text);
		
//		addDefaultProperties(data);
		return data;
	}
}
