package lu.tudor.santec.gecamed.formeditor.gui.component;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Properties;

import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.border.BevelBorder;

import lu.tudor.santec.gecamed.formeditor.gui.controller.FormController;
import lu.tudor.santec.gecamed.formeditor.gui.model.FormEditorModel;
import lu.tudor.santec.gecamed.formeditor.gui.model.FormModel;
import lu.tudor.santec.i18n.Translatrix;

import org.apache.log4j.Level;

import com.jgoodies.forms.layout.CellConstraints;

public class EditableLabel extends EditableComponent {
	
	/**
	 * @author Jens Ferring
	 * 
	 * A EditableComponent that represents a JLabel, when add. EditableLabels are used for dummies and border-bar-elements.
	 */	
	private static final long serialVersionUID = 1L;
	private final int LISTENER_METHOD_SIZE = 0;
	
	public EditableLabel () {
		super();
		component = new JLabel();
//		{
//			private static final long	serialVersionUID	= 1L;
//
//			protected void paintComponent(Graphics g) 
//			{
//				super.paintComponent(g);
////				if (getKey().equals("pic"))
////					System.out.print("_");
////				if (icon != null)
////					paintImage(g, getHorizontalAlignment(), getVerticalAlignment());
//			}
//		};
	}
	
	/**
	 * needs to override the init-method, to format the border and dummy-elements and give 
	 * every label an own default layout.
	 */
	@Override
	public void init(CellConstraints constraints, FormEditorModel model, byte formModelType) {
		super.init(constraints, model, formModelType);
		component.setOpaque(false);
//		getPropertyPanel().setBackgroundColor(component.getBackground());
		this.setBorder(BorderFactory.createBevelBorder(BevelBorder.RAISED));
		
		iconEnabled = true;
	}
	
	
	@Override
	public String getText() {
		return ((JLabel)component).getText();
	}
	
	
	@Override
	public void setText(String text) 
	{
		if (type == FormModel.TYPE_EDITOR && isRealComponent())
		{
			if (getIcon() == null && (text == null || "".equals(text)))
				setIcon(EMPTY_ICON);
			else if (EMPTY_ICON.equals(getIcon()) && text != null && !"".equals(text))
				setIcon(null);
		}
		else if (EMPTY_ICON.equals(getIcon()))
			setIcon(null);
		
		((JLabel)component).setText(text);
	}
	
	
	@Override
	public String getComponentType () {
		return "label";
	}
	
	
	@Override
	public javax.swing.JLabel copyComponent (FormModel model) 
	{
		JLabel l = (JLabel) this.component;
		
		l.setOpaque(false);
		
		addDefaultListener(l, new FormController(model));
		
		return l;
	}
	
	@Override
	public int getListenerMethodSize() {
		return LISTENER_METHOD_SIZE;
	}
	
	@Override
	protected void addListenerMethodNames() {
		// There are no listeners to add to a JLabel, that you cannot add to a JComponent
	}

	@Override
	public String getStructure() {
		/* ======================================== */
		if (imgData == null) {
			/* ---------------------------------------- */
			return "";
			/* ---------------------------------------- */
		}
		
		// create and fill the properties
		Properties structure = new Properties(); 
		writeImage(structure);
		
		// return the properties String
		StringWriter writer = new StringWriter();
		try {
			structure.store(writer, "");
		} catch (IOException e) {
			logger.log(Level.ERROR, e.getMessage(), e);
			return "";
		}
		
		new JLabel().setVerticalAlignment(javax.swing.SwingConstants.TOP);
		
		
		return writer.toString();
		/* ======================================== */
	}

	@Override
	public void setStructure(String text) {
		/* ======================================== */
		if (text.length() == 0) {
			/* ---------------------------------------- */
			return;
			/* ---------------------------------------- */
		}
		
		// create and fill the properties
		StringReader reader = new StringReader(text);
		Properties structure = new Properties();
		try {
			structure.load(reader);
		} catch (IOException e) {
			logger.log(Level.ERROR, e.getMessage(), e);
		}
		
		// create and scale the image
		readImage(structure);
		/* ======================================== */
	}
	
	@Override
	public void setIcon (Icon newIcon) 
	{
		((JLabel)component).setIcon(newIcon);
	}
	
	@Override
	public Icon getIcon () 
	{
		return ((JLabel)component).getIcon();
	}
	
	@Override
	public String getTypeTranslation () {
		/* ======================================== */
		return Translatrix.getTranslationString("formeditor.add_label");
		/* ======================================== */
	}
	
	@Override
	public String getComponentSimpleName()
	{
		return JLabel.class.getSimpleName();
	}
	
//	public class JLabel extends javax.swing.JLabel 
//	{
//		private static final long serialVersionUID = 1L;
//		
//		public JLabel ()
//		{
//			super();
//		}
//		
//		public JLabel (String text)
//		{
//			super(text);
//		}
//
//		protected void paintComponent(Graphics g) 
//		{
//			super.paintComponent(g);
////			if (getKey().equals("pic"))
////				System.out.print("_");
////			if (icon != null)
////				paintImage(g, getHorizontalAlignment(), getVerticalAlignment());
//		}
//	}
}