package lu.tudor.santec.gecamed.formeditor.gui.component;

import javax.swing.JComponent;
import javax.swing.JTextArea;

import lu.tudor.santec.gecamed.core.gui.widgets.autocompletion.GECAMedAutoCompletionTextComponent;
import lu.tudor.santec.i18n.Translatrix;

import org.jdom.Element;

public class EditableAutoCompletionTextArea extends EditableAutoCompletionTextField
{
	private static final long serialVersionUID = 1L;
	
	
	
	/* ======================================== */
	// 		CONSTRUCTOR
	/* ======================================== */
	
	public EditableAutoCompletionTextArea()
	{
		super(new GECAMedAutoCompletionTextComponent(new JTextArea(), null));
	}
	
	
	
	/* ======================================== */
	// 		OVERRIDDEN METHODS
	/* ======================================== */
	
//	@Override
//	public JComponent copyComponent(FormModel model)
//	{
//		return super.copyComponent(model, 
//				model.preview()
//				? new GECAMedAutoCompletionTextComponent(new JTextArea(), null)
//				: null);
//	}
	
	@Override
	public String getComponentType()
	{
		return "acTextarea";
	}
	
	
	@Override
	public String getTypeTranslation()
	{
		return Translatrix.getTranslationString("formeditor.add_ac_textarea");
	}
	
	
	@Override
	protected JComponent createCaptionText()
	{
		return new JTextArea();
	}
	
	
	@Override
	public Element getDataAsXML()
	{
		Element 	data 		= new Element(getKey());
		JTextArea 	textArea 	= (JTextArea) getTextComponent();
		
		EditableTextArea.fillWithXMLData(data, textArea);
		addDefaultProperties(data);
		
		return data;
	}
}