package lu.tudor.santec.gecamed.formeditor.gui.component;

import java.awt.dnd.DropTarget;

import lu.tudor.santec.gecamed.formeditor.gui.controller.DnDController;
import lu.tudor.santec.gecamed.formeditor.gui.model.FormEditorModel;
import lu.tudor.santec.gecamed.formeditor.gui.model.FormModel;

import com.jgoodies.forms.layout.CellConstraints;

public class DummyComponent extends EditableLabel
{
	private static final long serialVersionUID = 1L;
	
	@Override
	public void init(CellConstraints constraints, FormEditorModel model, byte formModelType)
	{
		super.init(constraints, model, FormModel.TYPE_EDITOR);
		
		component.setOpaque(true);
		formatDummy();
	}
	
	@Override
	protected void initType()
	{
		// only dummy-elements are drop targets this is a dummy
		DropTarget dt = new DropTarget(this, new DnDController(
				model, this));
		this.setDropTarget(dt);
		this.setComponentOpaq(false);
	}

	@Override
	public int getType()
	{
		return DUMMY_COMPONENT;
	}
	
	/**
	 * gives a dummy the default background
	 */
	private void formatDummy () {
//		this.setText(getColumn()+":"+getRow());
//		component.setFont(component.getFont().deriveFont(0, 10));
		component.setBackground(DEFAULT_BACKGROUND);
		this.setBackground(DEFAULT_BACKGROUND);
	}
}
