package lu.tudor.santec.gecamed.formeditor.gui.component;

import java.awt.Color;

import javax.swing.JLabel;

import lu.tudor.santec.gecamed.formeditor.gui.model.FormEditorModel;
import lu.tudor.santec.gecamed.formeditor.gui.model.FormModel;

import com.jgoodies.forms.layout.CellConstraints;

public class BorderComponent extends EditableLabel
{
	private static final long serialVersionUID = 1L;
	
	
	@Override
	public void init(CellConstraints constraints, FormEditorModel model, byte formModelType)
	{
		super.init(constraints, model, FormModel.TYPE_EDITOR);

		component.setOpaque(true);
		formatBorder();
	}
	
	
	@Override
	protected void initType()
	{
		hoverColor = HOVER_COLOR_BORDER;
	}
	
	
	@Override
	public int getType()
	{
		return BORDER_COMPONENT;
	}
	
	
	/**
	 * Gives a border-element its format and text
	 */
	private void formatBorder () {
		if (getColumn() == 1 || getRow() == 1) {
			if (getColumn() == 1 && getRow() != 1) {
				setText((getRow()-1)+"");
			} else if (getRow() == 1 && getColumn() != 1){
				setText((getColumn()-1)+"");
			}
			((JLabel)component).setVerticalAlignment(JLabel.CENTER);
			this.setAlignmentX(CENTER_ALIGNMENT);
			((JLabel)component).setHorizontalAlignment(JLabel.CENTER);
			this.setAlignmentY(CENTER_ALIGNMENT);
			component.setFont(component.getFont().deriveFont(1, 16));
		} 
		component.setBackground(Color.LIGHT_GRAY);
		this.setBackground(Color.LIGHT_GRAY);
	}
}
