package lu.tudor.santec.gecamed.formeditor.ejb.session.interfaces;

import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Vector;

import lu.tudor.santec.gecamed.formeditor.ejb.entity.beans.Form;
import lu.tudor.santec.gecamed.formeditor.ejb.entity.beans.FormTemplate;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.Patient;

public interface FormManager {
	

	/* ======================================== */
	//			FormTemplate
	/* ======================================== */
	public FormTemplate saveTemplateWithoutIReport (FormTemplate template);
	public void deleteTemplate (FormTemplate template);
	public void deleteTemplate (Integer templateId);
	public FormTemplate getTemplate (Integer templateId);
	
	/**
	 * @return all templates that are stored in the DB
	 */
	public Collection<FormTemplate> getAllTemplates ();
	
	public Collection<FormTemplate> getAllTemplatesExceptSubformOnly ();
	
	/**
	 * @param name 
	 * the name under which the template can be found in the DB
	 * 
	 * @param version
	 * the version number of the template. Can be null, to return all templates with this name.
	 * 
	 * @return the templates stored in the DB under the specified name and, if not null version number
	 */
	public Collection<FormTemplate> getTemplatesByName(String name, String version);
	
	
	

	/* ======================================== */
	//			Form
	/* ======================================== */
	
	public Form saveForm (Form form);
	public void deleteForm (Form form);
	public Form getForm (Integer formId);
	
	/**
	 * Returns all patients that have forms created out of the 
	 * FormTemplate with the given templateId.
	 * 
	 * @param templateId
	 * @return a list of patients
	 */
	public List<Patient> getPatientsWithFormsOfTemplate (Integer templateId);
	
	/**
	 * @param patientId
	 * specifies whose forms shell be returned 
	 * 
	 * @return all forms for the specified patient
	 */
	public Collection<Form> getFormsOfPatient (Integer patientId);
	
	/**
	 * @param entryId
	 * the incident entry under which the form is stored.
	 * 
	 * @return the form for the specified incident entry
	 */
	public Form getFormByIncidentEntry (Integer entryId);
	
	/**
	 * @param formId
	 * the form that contains the sub forms
	 * 
	 * @return all sub forms of the specified form
	 */
	public Collection<Form> getSubformsOfForm (Integer formId);

	/**
	 * @param formId
	 * the form all sub forms shell be deleted
	 */
	public void deleteSubformsOfForm (Integer formId);
	
	
	/* ======================================== */
	//			FormValue
	/* ======================================== */
	
	
	/**
	 * @param sinceWhen
	 * @param limit
	 * @param templateId
	 * @param patientId
	 * @param keyRefs
	 * 
	 * @return the values of the components referenced in the keyRefs-array from the patient with 
	 * the given patient name, from the forms constructed of the template with the given template id
	 * from the specified date.
	 * The creation date of the form is entered in the first column of the array in the result collection,
	 * the others will be the values of the referenced components in the order given in the keyRefs-array.
	 */
	public Vector<Object[]> getValuesOfComponent (Calendar sinceWhen, 
			Integer limit, Integer templateId, Integer patientId, String ... keyRefs);
}
