package lu.tudor.santec.gecamed.formeditor.ejb.entity.beans;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.IncidentEntry;

@Entity
@Table(name="form", schema="formeditor")
@NamedQueries ({
//	@NamedQuery(name=Form.GET_FORM_BY_TEMPLATE_AND_VISIT_ID, query="SELECT OBJECT(o) 
//			FROM Form o WHERE o.templateId = :templateId AND o.visitId = :visitId"),
	@NamedQuery(name=Form.GET_FORM_BY_IENTRY_ID, 
			query = "SELECT OBJECT(o) FROM Form o " +
					"WHERE o.incidentEntry.id = :entryId"),
	@NamedQuery(name=Form.GET_FORMS_OF_PATIENT, 
			query = "SELECT OBJECT(o) FROM Form o " +
					"WHERE o.patientId = :patientId " +
					"ORDER BY o.dateCreated"),
	@NamedQuery(name=Form.GET_PATIENTS_OF_TEMPLATE, 
			query = "SELECT DISTINCT OBJECT(p) FROM Patient p, Form f " +
					"WHERE f.patientId = p.id " +
					"AND f.templateId = :templateId " +
					"ORDER BY p.surName, p.firstName"),
	@NamedQuery(name=Form.GET_SUBFORMS_OF_FORM,
			query = "SELECT OBJECT(o) FROM Form o " +
					"WHERE o.subForm = :formId " +
					"ORDER BY o.dateCreated")
})

public class Form extends GECAMedEntityBean implements Serializable {	
	private static final long serialVersionUID = 1L;
	
	/**
	 * the names of the NamedQueries
	 */
//	public static final String GET_FORM_BY_TEMPLATE_AND_VISIT_ID = "getFormByTemplateIdAndVisitId";
	public static final String GET_FORM_BY_IENTRY_ID 	= "getFormByIEntryId";
	public static final String GET_FORMS_OF_PATIENT 	= "getFormsOfPatient";
	public static final String GET_PATIENTS_OF_TEMPLATE = "getPatientsOfTemplate";
	public static final String GET_SUBFORMS_OF_FORM		= "getSubformsOfForm";
	public static final String DELETE_SUBFORMS_OF_FORM	= "deleteSubformsOfForm";
	
	
	/**
	 * a reference to the template, which contains the structure of the form
	 */
	private Integer templateId;
	
	/**
	 * the entry of the current incident for this form 
	 */
	private IncidentEntry incidentEntry;
	
	/**
	 * the reference to the current patient, this form belongs to
	 */
	private Integer patientId;
	
	/**
	 * the date and time when this form was created
	 */
	private Date dateCreated;
	
	/**
	 * the date and time when this form was changed at last
	 */
	private Date dateLastChanged;
	
	/**
	 * Defines, if this form is used as sub form. If this is 
	 * a sub form, it won't be shown in the history.
	 */
	private Integer subFormOf;
	
	/**
	 * the reference to the values that contain the text of the components of this form
	 */
	private Collection<FormValue> values;
		
	public Form () {
		dateCreated = new Timestamp((new GregorianCalendar().getTimeInMillis()));
	}
	
	@Column(name="template_id")
	public Integer getTemplateId() {
		return templateId;
	}
	public void setTemplateId(Integer templateId) {
		this.templateId = templateId;
	}
	
	@Column(name="patient_id")
	public Integer getPatientId() {
		return patientId;
	}
	public void setPatientId(Integer patientId) {
		this.patientId = patientId;
	}
	

	@Column(name="date_created")
	public Date getDateCreated() {
		return dateCreated;
	}
	public void setDateCreated(Date dateCreated) {
		this.dateCreated = dateCreated;
	}
	
	@Column(name="date_last_changed")
	public Date getDateLastChanged() {
		return dateLastChanged;
	}
	public void setDateLastChanged(Date dateLastChanged) {
		this.dateLastChanged = dateLastChanged;
	}
	
	@Column(name="subform_of")
	public Integer getSubForm() {
		return subFormOf;
	}
	public void setSubForm(Integer formId) {
		this.subFormOf = formId;
	}
	
	
	@ManyToOne(cascade = javax.persistence.CascadeType.ALL, fetch = javax.persistence.FetchType.EAGER)
	@JoinColumn(name = "incident_entry_id")
	public IncidentEntry getIncidentEntry() {
		return incidentEntry;
	}
	public void setIncidentEntry(IncidentEntry incidentEntry) {
		this.incidentEntry = incidentEntry;
	}
	
	@OneToMany(cascade = javax.persistence.CascadeType.ALL, fetch = javax.persistence.FetchType.EAGER)
	@JoinColumn(name = "form_id")
	public Collection<FormValue> getValues() {
		return values;
	}
	public void setValues(Collection<FormValue> values) {
		this.values = values;
	}

	
//	/**
//	 * Creates a new IncidentEntry from the current incident and adds it to form.
//	 */
//	@Transient
//	public void setEntryForCurrentIncident () 
//	{
//		Incident inc = PatientManagerModule.getInstance()
//    			.getPatientPanel().getCurrentIncident();
//		IncidentManager incidentManager = (IncidentManager) ManagerFactory
//				.getRemote(IncidentManagerBean.class);
//		
//		IncidentEntry ie = new IncidentEntry();
//		ie.setIncident(inc);
//		ie = incidentManager.saveEntry(ie, FormTab.NAME);
//		this.setIncidentEntry(ie);
//	}
	
	
	
	@Transient
	private String historyText;
	
	@Transient
	public void setHistoryText (String historyText) {
		this.historyText = historyText;
	}
	
	@Transient
	public String getHistoryText () {
		return this.historyText;
	}
}
