package lu.tudor.santec.gecamed.esante.gui.webservice;

/**
 * @author jens.ferring(at)tudor.lu
 * 
 * @version
 * <br>$Log: WebserviceConstants.java,v $
 * <br>Revision 1.27  2014-02-12 12:17:02  ferring
 * <br>short and long eHealth IDs introduced
 * <br>
 * <br>Revision 1.26  2014-02-11 12:48:31  ferring
 * <br>pictures removed from available formats
 * <br>
 * <br>Revision 1.25  2014-02-05 10:02:16  ferring
 * <br>Uploaded documents can now be blocked and normal, restricted or private
 * <br>
 * <br>Revision 1.24  2014-01-31 16:29:43  donak
 * <br>Added error dialog when document cannot be uploaded due to invalid access privileges
 * <br>Fixed bug that prevented saml assertions from being renewed after they exceeded in cache
 * <br>Fixed bug that prevented documents from being uploaded (gecamed id has not been written to template due to renaming of placeholder)
 * <br>SMART UPLOAD (TM) feature: Upload option is added to context menu dependent on dsp access permissions and upload success probability calculations
 * <br>Upload support for images added
 * <br>
 * <br>Revision 1.23  2014-01-30 18:14:12  donak
 * <br>upload option will only be offered, if the user possesses the appropriate mandate and access rights to the dsp.
 * <br>
 * <br>Revision 1.22  2014-01-29 16:57:50  donak
 * <br>Renamed references to HPD to eHealth in respect to the request of the eHealth Agency
 * <br>Removed template DSP-11-12 as it is not needed and was created only for internal testing purposes
 * <br>
 * <br>Revision 1.21  2014-01-28 14:10:32  ferring
 * <br>App name and version taken from system properties
 * <br>
 * <br>Revision 1.20  2014-01-27 13:13:47  donak
 * <br>* Properties are now saved in db in respect to the following contexts:
 * <br>  - specific to a GECAMed user
 * <br>  - specific to a GECAMed physician
 * <br>  - specific to an eSanté plattform user
 * <br>  - general (independend of GECAMed user, physician, eSanté platform user)
 * <br>* Improved authentication handling. A signed authentication request is now only done for user authentication. for dsp authentication requests the provided saml assertion is used. (authentication speed up). ATTENTION: This fix is currently disabled till a bug in the eSanté platform has been fixed.
 * <br>* Naming of message loggings had been adapted to the naming in the connection kit (e.g. DSP-10, DSP-22)
 * <br>* Changed behavior for handling of dsps for which physician has insufficient access permissions. If physician does not want to provide presence password, a DSP-11 is sent instead of a DSP-12 to allow the physician to at least access the documents he is author of.
 * <br>
 * <br>Revision 1.19  2014-01-23 15:03:38  ferring
 * <br>option added to query by DSP ID
 * <br>
 * <br>Revision 1.18  2014-01-16 12:28:44  ferring
 * <br>Changes on eSanté platform applied and logging added
 * <br>
 * <br>Revision 1.17  2014-01-09 16:44:33  ferring
 * <br>Error handling for SAML assertions changed
 * <br>
 * <br>Revision 1.16  2014-01-02 15:07:58  donak
 * <br>Implemented authentication workflow: user-saml request --> check ehr access permissions --> dsp saml request --> actual webservice request
 * <br>All saml assertions independent of type are cached.
 * <br>
 * <br>Revision 1.15  2013-12-31 17:07:38  donak
 * <br>Fixed bug of eSanté Connection Kit specification
 * <br>Added mechanism to request mandate before final saml assertion is requested. DOES NOT WORK COMPLETELY, YET.
 * <br>
 * <br>Revision 1.14  2013-12-30 10:03:00  donak
 * <br>Removed unneeded templates that have accidently been committed after cleaning up imports in the sources.
 * <br>Changed the names of authentication templates to clarify a little more, which authentication method is used.
 * <br>
 * <br>Revision 1.13  2013-12-17 13:22:21  ferring
 * <br>replacing improved
 * <br>
 * <br>Revision 1.12  2013-12-13 16:17:08  donak
 * <br>LuxTrust authentication completed
 * <br>
 * <br>Revision 1.11  2013-12-13 13:17:24  donak
 * <br>Integratoin of LuxTrust authentication - so far it is disabled
 * <br>
 * <br>Revision 1.10  2013-12-10 11:59:27  ferring
 * <br>webservice error handling improved
 * <br>
 * <br>Revision 1.9  2013-12-09 17:15:37  donak
 * <br>Bug-fixing for upload to eSanté platform
 * <br>
 * <br>Revision 1.8  2013-12-08 22:14:40  donak
 * <br>Upload for CDA documents to eSanté platform finished. However upload is still not working as required codes do not seem to be implemented at the platform repository
 * <br>
 * <br>Revision 1.7  2013-11-29 09:10:52  ferring
 * <br>first changes for eSanté test platform
 * <br>
 * <br>Revision 1.6  2013-11-12 12:48:22  donak
 * <br>Document upload:
 * <br>* conversion to pdf/a using open office has been moved to the server. OpenOffice 4 has to be located in the jboss work directory. ATTENTION: it still has to be evaluated if the license agreement dialog occurs when instance is started the first time on the server.
 * <br>* If document contains a description, the first forty characters of the description followed by three dots will be used as title instead of the filename
 * <br>* Upload of incident type letters has been fixed
 * <br>* upload for docx files has been added
 * <br>
 * <br>Upload parameters:
 * <br>* database does now support storage of user dependent properties
 * <br>* The system will automatically remember the last chosen values for confidentiality, facility type, and speciality and propose them as default when the next document will be uploaded.
 * <br>
 * <br>Inactivity Monitor:
 * <br>* the event mouse wheel scrolling is now taken into account for resetting the logoff timer
 * <br>* the logoff delay is now stored in the database. If the database does not contain this parameter, it will be created
 * <br>
 * <br>General:
 * <br>* Optimized incident entry bean handling. Caching will now avoid copying the binary content and the generated pdf content of an incident entry as these elements should only be loaded when needed. Now it should be save to re-implement a proper getBinaryContent() handling.
 * <br>
 * <br>Revision 1.5  2013-10-08 08:57:36  ferring
 * <br>commit comments utf8 correction
 * <br>
 * <br>Revision 1.4  2013-09-30 13:27:45  donak
 * <br>Adaption of document upload template (ITI-41)
 * <br>
 * <br>Revision 1.3  2013-09-30 11:44:09  donak
 * <br>eSanté upload integration
 * <br>
 * <br>Revision 1.2  2013-09-19 12:24:43  ferring
 * <br>eSante bugs fixed and documents stored in database
 * <br>
 * <br>Revision 1.1  2013-06-10 08:21:58  ferring
 * <br>eSante POC
 * <br>
 */

public interface WebserviceConstants
{
	/* ---------------------------------------- */
	// TEMPLATES
	/* ---------------------------------------- */
	
	/**
	 * Authentication request template.<br>
	 * Used to get a new SAML assertion. This includes user saml assertions as well as dsp saml assertions (with and without presence password)
	 */
	public static final String	TEMPLATE_DSP_10_11_12			= "DSP-10-11-12-AuthnRequest-Template.xml";
	
	/**
	 * DSP-22 check access rights EHR<br>
	 * Requests the access permissions for a patient dsp on the eSanté platform. Here especially the mandate is of importance.
	 * If the mandate id is not 1, 2, or 13, a presence password has to be provided when requesting a saml assertion for the dsp
	 */
	public static final String	TEMPLATE_DSP_22				= "DSP-22-CheckAccessRightsEHR-Template.xml";

	/**
	 * Security header for a dsp assertion request using an existing user saml assertion
	 */
	public static final String	TEMPLATE_SECURITY_HEADER_ASSERTION	= "SecurityHeader-assertion-Template.xml";
	/**
	 * Security header for an assertion request using an X509 certificate (smartcard)
	 */
	public static final String	TEMPLATE_SECURITY_HEADER_X509		= "SecurityHeader-X509_signed-Template.xml";
	/**
	 * Security header for an assertion request using login and password
	 */
	public static final String	TEMPLATE_SECURITY_HEADER_LP			= "SecurityHeader-LoginPassword_signed-Template.xml";

	/**
	 * INF-12 get patient template.<br>
	 * Used to request a list of possible patients in order to get the IPID for a patient.
	 */
	public static final String	TEMPLATE_INF_12				= "INF-12-GetPatient-Template.xml";
	/** Template for the ATNA syslog message (DICOM format) that will be sent when GECAMed is started */
	public static final String	ATNA_START_APP					= "ATNA-StartApplication-Template.xml";
	/** Template for the ATNA syslog message (DICOM format) that will be sent when GECAMed is ended */
	public static final String	ATNA_STOP_APP					= "ATNA-StopApplication-Template.xml";
	
	/**
	 * Registry stored query request template.<br/>
	 * Used to request a list of CDA documents for a patient.
	 */
	public static final String	TEMPLATE_ITI_18_FIND_DOCUMENTS	= "ITI-18-RsqFindDocuments-Template.xml";

	/** Registry stored query request template.<br/>
    Used to find all versions of a specific document.<br/><br/><b><i>(This one is used to determine the latest version of a document.)</b></i>*/
    public static final String	TEMPLATE_ITI_18_GET_RELATED_DOCUMENTS	= "ITI-18-RsqGetRelatedDocuments-Template.xml";

    /**
	 * Registry stored query request template.<br/>
	 * Used to find the metadata of a specific document.<br/>
	 * <br/>
	 * <b><i>(This one is used to determine the metadata of a document.)</b></i>
	 */
	public static final String TEMPLATE_ITI_18_GET_DOCUMENTS = "ITI-18-RsqGetDocuments-Template.xml";
	
	/** Template for the ATNA syslog message (DICOM format) that will be sent for ITI 18 */
	public static final String	ATNA_ITI_18					= "ATNA-ITI-18-RegistryStoredQuery-Template.xml";
	
	/**
	 * Publish and register document template.<br>
	 * Used to upload a new CDA document.
	 */
	public static final String	TEMPLATE_ITI_41_UPLOAD_DOCUMENT	= "ITI-41-ProvideAndRegisterDocument-Template.xml";
	/**
	 * Replace document template.<br>
	 * Used to replace an existing CDA document by another.
	 */
	public static final String	TEMPLATE_ITI_41_REPLACE_DOCUMENT	= "ITI-41-ReplaceDocument-Template.xml";
	
	/** Template for the ATNA syslog message (DICOM format) that will be sent for ITI 41 */
	public static final String	ATNA_ITI_41					= "ATNA-ITI-41-ProvideAndRegisterDocument-Template.xml";
	
	/**
	 * Retrieve document set template.<br>
	 * Used to get the content of a CDA document.
	 */
	public static final String	TEMPLATE_ITI_43				= "ITI-43-RetrieveDocumentSet-Template.xml";
	/** Template for the ATNA syslog message (DICOM format) that will be sent for ITI 43 */
	public static final String	ATNA_ITI_43					= "ATNA-ITI-43-RetrieveDocumentSet-Template.xml";
	
	/**
	 * This is a template to create a new CDA document.
	 */
	public static final String	TEMPLATE_CDA_DOCUMENT		= "CDA-Document-Template.xml";
	
	
	public static final String[] TEMPLATE_NAMES				= new String[]
	{
		TEMPLATE_DSP_10_11_12, TEMPLATE_DSP_22, TEMPLATE_SECURITY_HEADER_ASSERTION, TEMPLATE_SECURITY_HEADER_X509, TEMPLATE_SECURITY_HEADER_LP, 
		TEMPLATE_INF_12, TEMPLATE_ITI_18_FIND_DOCUMENTS, TEMPLATE_ITI_18_GET_RELATED_DOCUMENTS, TEMPLATE_ITI_41_UPLOAD_DOCUMENT, TEMPLATE_ITI_43, TEMPLATE_CDA_DOCUMENT, ATNA_START_APP, ATNA_STOP_APP, ATNA_ITI_18, 
		ATNA_ITI_41, ATNA_ITI_43
	};
	
    public static final String	ATNA_PROCESS_ID							= "37857229034";
    
    /**
     * GENERAL_PRACTICE_IDENTIFIER used as PREFIX for the PROP_PRACTICE_EHEALTH_ID
     */
    public static final String GENERAL_PRACTICE_IDENTIFIER 				= "10000508.";
    
    /**
     * Defines the upload mode when a document is transferred to the EHR of the patient.
     * This comes into account for an update of the document metadata, the replacement of the document itself or both.
     * In case of an initial upload of a document to the EHR, the metadata and the document itself will be transferred.
     * This will be detected by checking unique id of the document. If this id is non-existent, the system assumes that no version of the document had been uploaded so far.
     */
    /** update the document meta data */
	public static final int UPLOAD_UPDATE_METADATA = 1;
	/** replace the document by a new version */
	public static final int UPLOAD_REPLACE_DOCUMENT = 2;
	/** The document has never been uploaded, thus initiate and initial upload to the dsp */
	public static final int UPLOAD_INITIALE_UPLOAD = 3;
	
	
	/* ------------------------------------------- */
	// TEMPLATE PLACEHOLDERS in alphabetical order
	/* ------------------------------------------- */
	
	public static final String	PLACEHOLDER_APP_ID						= "INF_APP_ID";
	public static final String	PLACEHOLDER_APP_NAME					= "INF_APP_NAME";
	public static final String	PLACEHOLDER_APP_VERSION					= "INF_APP_VERSION";
	public static final String	PLACEHOLDER_AUTHENTICATION				= "INF_AUTHENTICATION";
	public static final String	PLACEHOLDER_AUTHN_CONTEXT_CLASS_REF		= "INF_AUTHN_CONTEXT_CLASS_REF";
	public static final String	PLACEHOLDER_AUTHNREQUEST_DIGEST 		= "INF_AUTHNREQUEST_DIGEST";
	public static final String  PLACEHOLDER_AUTHOR_ID					= "INF_AUTHOR_ID";
	public static final String  PLACEHOLDER_AUTHOR_FIRST_NAME			= "INF_AUTHOR_FIRST_NAME";
	public static final String	PLACEHOLDER_AUTHOR_PERSON				= "INF_AUTHOR_PERSON";
	public static final String	PLACEHOLDER_AUTHOR_ROLE					= "INF_AUTHOR_ROLE";
	public static final String	PLACEHOLDER_AUTHOR_SPECIALITY			= "INF_AUTHOR_SPECIALTY";
	public static final String  PLACEHOLDER_AUTHOR_SURNAME				= "INF_AUTHOR_NAME";
	public static final String  PLACEHOLDER_AUTHOR_TITLE				= "INF_AUTHOR_TITLE";
	public static final String	PLACEHOLDER_AUTHOR_TYPE					= "INF_AUTHOR_TYPE";
	public static final String	PLACEHOLDER_ATTACHMENT_CID				= "INF_ATTACHMENT_CID";
	public static final String  PLACEHOLDER_ATTACHMENT_TEMPLATE			= "INF_ATTACHMENT_TEMPLATE";
	public static final String  PLACEHOLDER_BASE64_CONTENT				= "INF_B64_CONTENT";
	public static final String	PLACEHOLDER_BIRTHDATE		 			= "INF_BIRTHDATE";
	public static final String  PLACEHOLDER_CERT_AS_BASE64 				= "INF_CERT_AS_BASE64";
	public static final String  PLACEHOLDER_CERTIFICATE_DIGEST			= "INF_CERTIFICATE_DIGEST";
	public static final String	PLACEHOLDER_CLASSCODE					= "INF_CLASSCODE_CODE";
	public static final String	PLACEHOLDER_CLASSCODE_NAME				= "INF_CLASSCODE_NAME";
	public static final String	PLACEHOLDER_CLASSCODE_OID				= "INF_CLASSCODE_OID";
	public static final String	PLACEHOLDER_CONFIDENTIALITY				= "INF_CONFIDENTIALITYCODE_CODE";
	public static final String	PLACEHOLDER_CONFIDENTIALITY_BLOCK_CODE	= "INF_CONFIDENTIALITYCODE_BLOCK_CODE";
	public static final String	PLACEHOLDER_CONFIDENTIALITY_BLOCK_NAME	= "INF_CONFIDENTIALITYCODE_BLOCK_NAME";
	public static final String	PLACEHOLDER_CONFIDENTIALITY_NAME		= "INF_CONFIDENTIALITYCODE_NAME";
	public static final String	PLACEHOLDER_CONFIDENTIALITY_OID			= "INF_CONFIDENTIALITYCODE_OID";
	public static final String	PLACEHOLDER_CONSUMER_SERVICE			= "INF_CONSUMER_SERVICE";
	public static final String  PLACEHOLDER_CREATED						= "INF_CREATED";
	public static final String  PLACEHOLDER_CREATION_TIME				= "INF_CREATION_TIME";
	public static final String  PLACEHOLDER_CUSTODIAN 					= "INF_CUSTODIAN";
	public static final String	PLACEHOLDER_DESTINATION					= "INF_DESTINATION";
	public static final String	PLACEHOLDER_DESTINATION_DNS_NAME		= "INF_DESTINATION_DNS_NAME";
	public static final String	PLACEHOLDER_DOC_NAME					= "INF_DOC_NAME";
	public static final String	PLACEHOLDER_DOC_REPOSITORY_UID			= "INF_DOC_REPOSITORY_UNIQUE_ID";
	public static final String	PLACEHOLDER_DOC_TITLE					= "INF_DOC_TITLE";
	public static final String	PLACEHOLDER_DOC_UID						= "INF_DOC_UNIQUE_ID";	
	public static final String	PLACEHOLDER_EFFECTIVE_TIME				= "INF_EFFECTIVE_TIME";
	public static final String	PLACEHOLDER_FIRSTNAME					= "INF_FIRSTNAME";
	public static final String	PLACEHOLDER_FORMAT_CODE					= "INF_FORMATCODE_CODE";
	public static final String	PLACEHOLDER_FORMAT_CODE_NAME			= "INF_FORMATCODE_NAME";
	public static final String	PLACEHOLDER_FORMAT_CODE_OID				= "INF_FORMATCODE_OID";
	public static final String	PLACEHOLDER_GECAMED_PATIENT_ID			= "INF_GECAMED_PATIENT_ID";
	public static final String  PLACEHOLDER_HCF_TYPE					= "INF_HEALTHCARE_FACILITY_TYPECODE_CODE";
	public static final String  PLACEHOLDER_HCF_TYPE_NAME				= "INF_HEALTHCARE_FACILITY_TYPECODE_NAME";
	public static final String  PLACEHOLDER_HCF_TYPE_OID				= "INF_HEALTHCARE_FACILITY_TYPECODE_OID";
	public static final String  PLACEHOLDER_HOME_COMMUNITY_ID 			= "INF_HOME_COMMUNITY_ID";
	public static final String  PLACEHOLDER_INTENDED_RECIPIENT			= "INF_INTENDED_RECIPIENT";
	public static final String	PLACEHOLDER_LANGUAGE					= "INF_LANGUAGE";
	public static final String	PLACEHOLDER_LOGIN						= "INF_LOGIN";
	public static final String	PLACEHOLDER_MIME_TYPE					= "INF_MIME_TYPE";
	public static final String	PLACEHOLDER_MSG_UUID					= "INF_MSG_UUID";
	public static final String	PLACEHOLDER_NAME						= "INF_NAME";
	public static final String	PLACEHOLDER_NONCE						= "INF_NONCE";
	public static final String	PLACEHOLDER_NOT_AFTER					= "INF_NOT_AFTER";
	public static final String	PLACEHOLDER_NOT_BEFORE					= "INF_NOT_BEFORE";
	public static final String	PLACEHOLDER_OLD_DOC_OID					= "INF_OLD_DOC_OBJECT_ID";
	public static final String	PLACEHOLDER_PASSWORD					= "INF_PASSWORD";
	public static final String  PLACEHOLDER_PATIENT_BIRTHDATE			= "INF_PAT_BIRTHDATE";
	public static final String  PLACEHOLDER_PATIENT_CITY				= "INF_PATIENT_CITY";
	public static final String  PLACEHOLDER_PATIENT_COUNTRY				= "INF_PATIENT_COUNTRY";
	public static final String  PLACEHOLDER_PATIENT_COUNTRY_CODE		= "INF_PATIENT_COUNTRY_CODE";
	public static final String  PLACEHOLDER_PATIENT_FIRST_NAME			= "INF_PAT_FIRSTNAME";
	public static final String  PLACEHOLDER_PATIENT_GENDER_CODE			= "INF_GENDER_CODE";
	public static final String  PLACEHOLDER_PATIENT_GENDER_NAME			= "INF_GENDER_NAME";
	public static final String  PLACEHOLDER_PATIENT_ID					= "INF_PATIENT_ID";
	public static final String  PLACEHOLDER_PATIENT_MATRICULE			= "INF_PATIENT_MATRICULE";	
	public static final String  PLACEHOLDER_PRACTICE_SETTING			= "INF_PRACTICE_SETTINGCODE_CODE";
	public static final String  PLACEHOLDER_PRACTICE_SETTING_NAME		= "INF_PRACTICE_SETTINGCODE_NAME";
	public static final String  PLACEHOLDER_PRACTICE_SETTING_OID		= "INF_PRACTICE_SETTINGCODE_OID";
	public static final String  PLACEHOLDER_PATIENT_SURNAME				= "INF_PAT_NAME";
	public static final String  PLACEHOLDER_PATIENT_STREET				= "INF_PATIENT_STREET";
	public static final String  PLACEHOLDER_PATIENT_ZIP_CODE			= "INF_PATIENT_ZIP_CODE";
	public static final String	PLACEHOLDER_PRACTICE_EHEALTH_ID_LONG	= "INF_PRACTICE_EHEALTH_ID_LONG";
	public static final String	PLACEHOLDER_PRACTICE_EHEALTH_ID_SHORT	= "INF_PRACTICE_EHEALTH_ID_SHORT";
	public static final String	PLACEHOLDER_PRESENCE_PASSWORD			= "INF_PRESENCE_PASSWORD";
	public static final String	PLACEHOLDER_PROCESS_ID					= "INF_PROCESS_ID";
	public static final String	PLACEHOLDER_QUERY_BASE64				= "INF_QUERY_BASE64";

	public static final String	PLACEHOLDER_PRACTICE_NAME				= "INF_PRACTICE_NAME";
	public static final String	PLACEHOLDER_SAML_ASSERTION				= "INF_SAML_ASSERTION";
	public static final String	PLACEHOLDER_SECURITY_HEADER				= "INF_SECURITY_HEADER";
	public static final String	PLACEHOLDER_SENDER_IP					= "INF_SENDER_IP";
	public static final String  PLACEHOLDER_SIGNATURE					= "INF_SIGNATURE";
	public static final String  PLACEHOLDER_SOURCE_ID					= "INF_SOURCE_ID";
	public static final String  PLACEHOLDER_SOURCE_PATIENT_ID			= "INF_SOURCE_PATIENT_ID";
	public static final String	PLACEHOLDER_SUBMISSION_TIME				= "INF_SUBMISSION_TIME";
	public static final String	PLACEHOLDER_TIME_FROM					= "INF_TIME_FROM";
	public static final String  PLACEHOLDER_TIMESTAMP_TAG_DIGEST		= "INF_TIMESTAMP_TAG_DIGEST";
	public static final String  PLACEHOLDER_TYPE						= "INF_TYPECODE_CODE";	
	public static final String  PLACEHOLDER_TYPE_NAME					= "INF_TYPECODE_NAME";
	public static final String  PLACEHOLDER_TYPE_OID					= "INF_TYPECODE_OID";
	public static final String  PLACEHOLDER_TYPE_SYSTEM					= "INF_TYPECODE_SYSTEM";
	public static final String	PLACEHOLDER_USER_CERT_INFO				= "INF_USER_CERT_INFO";
	public static final String	PLACEHOLDER_USER_CERT_NAME				= "INF_USER_CERT_NAME";
	public static final String	PLACEHOLDER_USER_CERT_FIRSTNAME			= "INF_USER_CERT_FIRSTNAME";
	public static final String	PLACEHOLDER_USER_ID						= "INF_USER_ID";
	public static final String	PLACEHOLDER_USER_EHEALTH_ID_LONG		= "INF_USER_EHEALTH_ID_LONG";
	public static final String	PLACEHOLDER_USER_EHEALTH_ID_SHORT		= "INF_USER_EHEALTH_ID_SHORT";
	public static final String	PLACEHOLDER_PDQ_PARAMETER				= "INF_PDQ_PARAMETER";
	   
	public static final String	XML_NULL							= "xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:nil=\"true\"";
	
	public static final int	MANDATE_NOT_AUTHORIZED					= -1;
	public static final int	MANDATE_CONSULTATION					= 1;
	public static final int	MANDATE_CIRCLE_OF_TRUST					= 2;
	public static final int	MANDATE_AUTHOR							= 5;
	public static final int	MANDATE_REFERING_DOCTOR					= 13;
	
	/** Indicates that the whole request message and, in case of an upload, the extracted cda-document, the extracted payload (currently a pdf/a document), and atna messages are logged */
	public static final int	MESSAGE_LOGLEVEL_FULL					= 3;
	/** Indicates that the  request message and atna messages are logged */
	public static final int	MESSAGE_LOGLEVEL_MESSAGE				= 2;
	/** Indicates that the  atna messages are logged */
	public static final int	MESSAGE_LOGLEVEL_ATNA					= 1;
	/** Indicates that no message is logged */
	public static final int	MESSAGE_LOGLEVEL_NONE					= 0;
	/** Indicates that the message logging has not yet been specified */
	public static final int	MESSAGE_LOGLEVEL_NOT_SET				= -1;
	

	/** Indicates the reference to the authentication class X509 meaning that a smartcard has been used for authenticating */
	public static final String AUTHENTICATION_CLASS_X509			= "X509";
	/** Indicates the reference to the authentication class Password meaning that a username/password has been used for authenticating */
	public static final String AUTHENTICATION_CLASS_LP				= "Password";
	
	/** Specifies a list of filename extensions for files that are supported to be uploaded to the eSanté platform*/
	public static final String UPLOAD_DOCUMENT_TYPES = "pdf, doc, docx, odt, xls, xlsx, ods, txt, html, htm, ppt, pptx, rtf, swf, swt, swc, flv, fla";
	
	
	/* ---------------------------------------- */
	// TEMPLATE PLACEHOLDERS TEMPLATE VALUES
	/* ---------------------------------------- */
    
    public static final String	PH_TEMP_PRESENCE_PASSWORD			= "<saml2:Attribute Name=\"presence-password\" xmlns:saml2=\"urn:oasis:names:tc:SAML:2.0:assertion\"><saml2:AttributeValue>$0</saml2:AttributeValue></saml2:Attribute>";
    /** The patient id attribute is only needed when a saml assertion for accessing a specific pastient DSP on the eSanté platform is requested. For general access (e.g. patient query) this attribut is omitted */
    public static final String	PH_TEMP_PATIENT_ID					= "<saml2:Attribute Name=\"urn:oasis:names:tc:xacml:2.0:resource:resource-id\" xmlns:saml2=\"urn:oasis:names:tc:SAML:2.0:assertion\"><saml2:AttributeValue>$0</saml2:AttributeValue></saml2:Attribute>";
    /** Home community attribute for XCA profile */
    public static final String	PH_TEMP_HOME_COMMUNITY_ID			= "<HomeCommunityId>$0</HomeCommunityId>";
    public static final String	PH_TEMP_ATNA_HOME_COMMUNITY_ID		= "<ParticipantObjectDetail type=\"ihe:homeCommunityID\" value=\"$0\"/>";
    public static final String	PH_TEMP_SSN							= "<entry><key>id</key><value>$0^^^&amp;1.3.182.4.4&amp;ISO</value></entry>";
    public static final String	PH_TEMP_DSP_ID						= "<entry><key>id</key><value>$0^^^&amp;1.3.182.2.4.2&amp;ISO</value></entry>";
//    public static final String	PH_TEMP_

}
