package lu.tudor.santec.gecamed.esante.gui.tab;

import java.util.ArrayList;
import java.util.Collection;

import javax.swing.table.AbstractTableModel;

import lu.tudor.santec.gecamed.esante.ejb.entity.beans.Dsp;

/**
 * @author jens.ferring(at)tudor.lu
 * 
 * @version
 * <br>$Log: DspListModel.java,v $
 * <br>Revision 1.2  2014-01-23 15:02:11  ferring
 * <br>DSP last names changed
 * <br>
 * <br>Revision 1.1  2013-11-05 09:47:56  ferring
 * <br>ESantePatient changed to Dsp. The Dsp object will be stored in the database, if a patient is linked with eSanté.
 * <br>
 * <br>Revision 1.7  2013-10-29 13:42:43  ferring
 * <br>bug fixes when showing patient DSPs to link to
 * <br>
 * <br>Revision 1.6  2013-10-28 16:54:12  ferring
 * <br>eSante and GECAMed patient compare dialog added and a lot of bug fixes
 * <br>
 * <br>Revision 1.5  2013-09-10 06:16:28  ferring
 * <br>eSante improvements
 * <br>
 * <br>Revision 1.4  2013-07-15 06:18:37  ferring
 * <br>logging changed
 * <br>
 * <br>Revision 1.3  2013-07-03 13:06:20  ferring
 * <br>eSante module handling changed
 * <br>
 * <br>Revision 1.2  2013-06-27 14:12:39  ferring
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.1  2013-06-26 11:19:37  ferring
 * <br>migrating eSante view from dialogs to eSante patient tab
 * <br>
 * <br>Revision 1.1  2013-06-10 08:21:54  ferring
 * <br>eSante POC
 * <br>
 */

public class DspListModel extends AbstractTableModel
{
	/* ======================================== */
	// CONSTANTS
	/* ======================================== */
	
	private static final long	serialVersionUID	= -4886650795285505515L;
	
	public static final int	IPID		= 0;
//	public static final int	ID			= 1;
	public static final int	MATCH		= 1;
	public static final int	FIRST_NAME	= 2;
	public static final int	FAMILY_NAME	= 3;
	public static final int	COMMON_NAME	= 4;
	public static final int	BIRTH_DATE	= 5;
	public static final int	GENDER		= 6;
//	public static final int	STATE		= 8;
	public static final int	ADDRESS		= 7;
	
	public static final int COLUMN_COUNT = 8;
	
	
	
	/* ======================================== */
	// MEMBERS
	/* ======================================== */
	
	private ArrayList<Dsp> patients	= new ArrayList<Dsp>();
	
	
	
	/* ======================================== */
	// CONSTRUCTORS
	/* ======================================== */
	
	public DspListModel () {}
	
	
	
	/* ======================================== */
	// CLASS BODY
	/* ======================================== */
	
	public void setValues (Collection<Dsp> patients)
	{
		int size = 0;
		
		
		if (this.patients != null)
			size = getRowCount();
		
		if (patients instanceof ArrayList)
		{
			this.patients	= (ArrayList<Dsp>) patients;
		}
		else
		{
			this.patients.clear();
			if (patients != null)
			{
				this.patients.addAll(patients);
			}
		}
		
		fireTableRowsDeleted(0, size);
		fireTableRowsInserted(0, patients != null ? patients.size() : 0);
	}
	
	
	public int getRowCount ()
	{
		if (patients == null)
			return 0;
		else
			return patients.size();
	}
	
	
	public int getColumnCount ()
	{
		return COLUMN_COUNT;
	}
	
	
	public Object getValueAt (int rowIndex, int columnIndex)
	{
		Dsp	p	= patients.get(rowIndex);
		String			value;
		
		
		switch (columnIndex)
		{
			case IPID:
				value = p.getShortDspOid();
				break;
				
//			case ID:
//				value = p.getDspOid();
//				break;
				
			case MATCH:
				value = p.getMatchRateString();
				break;
				
			case BIRTH_DATE:
				value = p.getBirthDateString(Dsp.INTER_DATE_FROMAT);
				break;
				
			case FIRST_NAME:
				value = p.getGivenName();
				break;
				
			case FAMILY_NAME:
				value = p.getFamilyName();
				break;
				
			case COMMON_NAME:
				value = p.getCommonName();
				break;
				
			case GENDER:
				value = p.getSex();
				break;
				
//			case STATE:
//				value = p.getEhrStatus();
//				break;
				
			case ADDRESS:
				value = p.getAddressesString();
				break;
				
			default:
				return null;
		}
		
		return value;
	}
	
	
	public Dsp getDspAtRow (int row)
	{
		if (row < 0 || row > patients.size() - 1)
			return null;
		else
			return patients.get(row);
	}
}
