package lu.tudor.santec.gecamed.esante.gui.tab;

import lu.tudor.santec.gecamed.esante.ejb.entity.beans.Dsp;

/**
 * @author jens.ferring(at)tudor.lu
 * 
 * @version
 * <br>$Log: DspListListener.java,v $
 * <br>Revision 1.1  2013-11-05 09:47:56  ferring
 * <br>ESantePatient changed to Dsp. The Dsp object will be stored in the database, if a patient is linked with eSanté.
 * <br>
 * <br>Revision 1.4  2013-09-10 06:16:28  ferring
 * <br>eSante improvements
 * <br>
 * <br>Revision 1.3  2013-07-15 06:18:37  ferring
 * <br>logging changed
 * <br>
 * <br>Revision 1.2  2013-07-05 06:08:02  ferring
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.1  2013-06-26 11:19:37  ferring
 * <br>migrating eSante view from dialogs to eSante patient tab
 * <br>
 */

public interface DspListListener
{
	/**
	 * Called at start and when ever a new patient is selected.
	 * 
	 * @param dsp The selected patient
	 */
	public void dspSelected (Dsp dsp);
	
	/**
	 * Called when a patient was double clicked.
	 * 
	 * @param dsp The selected patient
	 */
	public void dspChosen (Dsp dsp);
	
//	/**
//	 * Called when a patient row is clicked with a popup trigger.
//	 * 
//	 * @param patient The clicked patient
//	 * @param e The triggered mouse event
//	 */
//	public void patientPopupTriggerTriggered (ESantePatient patient, MouseEvent e);
}
