package lu.tudor.santec.gecamed.esante.gui.tab;

import java.util.List;

import lu.tudor.santec.gecamed.esante.ejb.entity.beans.CdaDocument;

/**
 * @author jens.ferring(at)tudor.lu
 * 
 * @version
 * <br>$Log: CdaDocumentListListener.java,v $
 * <br>Revision 1.1  2013-11-11 11:44:22  ferring
 * <br>Download documents option added
 * <br>
 * <br>Revision 1.2  2013-10-08 08:54:14  ferring
 * <br>class name refactoring and tree view implementation (first steps)
 * <br>
 * <br>Revision 1.1  2013-09-13 14:18:56  ferring
 * <br>eSante bugs fixed and database implementation started
 * <br>
 */

public interface CdaDocumentListListener
{
	/**
	 * Called when the list selection changed.
	 * 
	 * @param documents A list with the selected documents.
	 */
	public void documentSelectionChanged (List<CdaDocument> documents);
	
	/**
	 * Called when documents are to be opened.
	 * 
	 * @param documents A list of the documents that shall be opened.
	 */
	public void openDocuments (List<CdaDocument> documents);
	
	/**
	 * Called when CdaDocuments are to be downloaded.
	 * 
	 * @param documents A list of the documents to download.
	 */
	public void downloadDocuments (List<CdaDocument> documents);
	
	/**
	 * Called when documents are to be integrated into GECAMed.
	 * 
	 * @param documents A list of the documents that shall be integrated.
	 */
	public void integrateDocuments (List<CdaDocument> documents);
}
