package lu.tudor.santec.gecamed.esante.gui.history;

import java.awt.Component;

import javax.swing.JLabel;
import javax.swing.JTable;

import lu.tudor.santec.gecamed.core.gui.utils.LineColorCellRenderer;
import lu.tudor.santec.gecamed.esante.gui.utils.ESanteGuiUtils;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.IncidentEntry;

/**
 * @author jens.ferring(at)tudor.lu
 * 
 * @version
 * <br>$Log: CdaHistoryRenderer.java,v $
 * <br>Revision 1.2  2013-11-26 09:24:59  ferring
 * <br>CDA history shortcut changed from 'cda' to 'CDA'
 * <br>
 * <br>Revision 1.1  2013-10-08 08:54:13  ferring
 * <br>class name refactoring and tree view implementation (first steps)
 * <br>
 * <br>Revision 1.1  2013-09-30 10:56:27  ferring
 * <br>eSante integration in GECAMed and synchronise funktion added
 * <br>
 * <br>Revision 1.1  2013-09-19 12:24:43  ferring
 * <br>eSante bugs fixed and documents stored in database
 * <br>
 */
public class CdaHistoryRenderer extends LineColorCellRenderer
{
	/* ======================================== */
	// CONSTANTS
	/* ======================================== */
	
	private static final long	serialVersionUID	= 1L;
	
	private static final String CDA_HISTORY_SHORTCUT = "CDA";
	
	
	
	/* ======================================== */
	// CLASS BODY
	/* ======================================== */
	
	public Component getTableCellRendererComponent (JTable table, Object value, 
			boolean isSelected, boolean hasFocus, int row, int column)
	{
		switch (column)
		{
			case 2:
				
				return getShortcutCell(table, value, isSelected, hasFocus, row, column);
			
			case 3:
				
				return getContentCell(table, value, isSelected, hasFocus, row, column);
				
			default:
				
				return new JLabel();
		}
	}
	
	
	
	/* ======================================== */
	// HELP METHODS
	/* ======================================== */
	
	private Component getContentCell (JTable table, Object value, 
			boolean isSelected, boolean hasFocus, int row, int column)
	{
		JLabel cell = (JLabel) super.getTableCellRendererComponent(
				table, ((IncidentEntry)value).getTextContent(), isSelected, hasFocus, row, column);
		cell.setIcon(ESanteGuiUtils.getESanteIcon(42));
		
		return cell;
	}
	
	
	private Component getShortcutCell (JTable table, Object value, 
			boolean isSelected, boolean hasFocus, int row, int column)
	{
		JLabel cell = (JLabel)super.getTableCellRendererComponent(table, CDA_HISTORY_SHORTCUT, isSelected, hasFocus, row, column);
		cell.setIcon(null);
		
		return cell;
	}
}
