package lu.tudor.santec.gecamed.esante.gui.dialogs;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import lu.tudor.santec.gecamed.esante.ejb.entity.beans.CdaCode;
import lu.tudor.santec.gecamed.esante.gui.webservice.XDS;

import org.apache.log4j.Logger;

/**
 * Action listener for ComboBoxes with values (CDA codes) on which another
 * ComboBox depends.
 * 
 * @author donak
 * 
 * @version <br>
 *          $Log: UploadComboBoxActionListener.java,v $
 *          Revision 1.3  2013-12-27 18:09:26  donak
 *          Cleanup of imports
 *
 *          Revision 1.2  2013-10-08 08:57:36  ferring
 *          commit comments utf8 correction
 *
 *          Revision 1.1  2013-10-04 17:22:43  donak
 *          eSanté upload dialog and integration of selected values
 *
 */
public class UploadComboBoxActionListener implements ActionListener {

	private static Logger logger = Logger.getLogger(XDS.class.getName());

	private MetaDataComboBox dependentCB = null;

	/**
	 * Creates a new listener that populate another ComboBox dependent on the
	 * 
	 * @param dependendCB
	 */
	public UploadComboBoxActionListener(MetaDataComboBox dependendCB) {
		this.dependentCB = dependendCB;
	}

	/**
	 * Triggers repopulation of the dependent combobox in respect to the
	 * selected value in the cb triggering this event
	 */
	public void actionPerformed(ActionEvent e) {
		// get reference to the combo-box this action listener is tied to
		MetaDataComboBox parent = (MetaDataComboBox) e.getSource();
		CdaCode selectedCode = (CdaCode) parent.getSelectedItem();
		try {
			ESanteUploadDialog.populateCB(this.dependentCB, selectedCode.getId());
		} catch (Exception e1) {
			logger.error("Unable to repopulate combobox for cda category \""
					+ this.dependentCB.getCategory() + "\"", e1);
		}
	}
}
