package lu.tudor.santec.gecamed.esante.gui.dialogs;

import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

import lu.tudor.santec.gecamed.core.gui.GECAMedIconNames;
import lu.tudor.santec.gecamed.core.gui.GECAMedModule;
import lu.tudor.santec.gecamed.core.gui.MainFrame;
import lu.tudor.santec.gecamed.esante.ejb.entity.beans.Dsp;
import lu.tudor.santec.gecamed.esante.gui.tab.DspListListener;
import lu.tudor.santec.gecamed.esante.gui.tab.DspListPanel;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.Patient;
import lu.tudor.santec.i18n.Translatrix;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

/**
 * @author jens.ferring(at)tudor.lu
 * 
 * @version
 * <br>$Log: ESantePatientListDialog.java,v $
 * <br>Revision 1.19  2014-03-05 13:08:10  ferring
 * <br>eSante bug fixed, where user was asked several times, to link with DSP when compare dialog was shown automatically, because there was only one DSP for choice
 * <br>
 * <br>Revision 1.18  2014-01-22 14:42:06  ferring
 * <br>SSN search implemented
 * <br>
 * <br>Revision 1.17  2014-01-13 07:38:53  ferring
 * <br>Label used for PDQ warnings instead of dialog
 * <br>
 * <br>Revision 1.16  2014-01-06 13:13:48  ferring
 * <br>title translated
 * <br>
 * <br>Revision 1.15  2013-12-27 18:09:26  donak
 * <br>Cleanup of imports
 * <br>
 * <br>Revision 1.14  2013-12-13 12:31:31  ferring
 * <br>Exception handling changed
 * <br>
 * <br>Revision 1.13  2013-11-15 16:08:02  ferring
 * <br>tidied up the unneeded methods
 * <br>
 * <br>Revision 1.12  2013-11-15 10:43:25  ferring
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.11  2013-11-14 16:52:18  ferring
 * <br>Auto resizing of table columns
 * <br>
 * <br>Revision 1.10  2013-11-05 09:47:56  ferring
 * <br>ESantePatient changed to Dsp. The Dsp object will be stored in the database, if a patient is linked with eSanté.
 * <br>
 * <br>Revision 1.9  2013-10-29 13:44:15  ferring
 * <br>getInstance will not always create a new dialog
 * <br>
 * <br>Revision 1.8  2013-10-29 13:42:43  ferring
 * <br>bug fixes when showing patient DSPs to link to
 * <br>
 * <br>Revision 1.7  2013-10-28 16:54:12  ferring
 * <br>eSante and GECAMed patient compare dialog added and a lot of bug fixes
 * <br>
 * <br>Revision 1.6  2013-10-21 08:17:34  ferring
 * <br>linking and unlinking patient changed
 * <br>
 * <br>Revision 1.5  2013-09-10 06:16:28  ferring
 * <br>eSante improvements
 * <br>
 * <br>Revision 1.4  2013-07-15 06:18:37  ferring
 * <br>logging changed
 * <br>
 * <br>Revision 1.3  2013-07-05 06:08:03  ferring
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.2  2013-07-03 13:06:24  ferring
 * <br>eSante module handling changed
 * <br>
 * <br>Revision 1.1  2013-06-26 11:19:37  ferring
 * <br>migrating eSante view from dialogs to eSante patient tab
 * <br>
 * <br>Revision 1.1  2013-06-10 08:21:50  ferring
 * <br>eSante POC
 * <br>
 */

public class ESantePatientListDialog extends ESanteDialog implements WindowListener, DspListListener
{
	/* ======================================== */
	// CONSTANTS
	/* ======================================== */
	
	private static final long	serialVersionUID	= 301088046700295733L;
	
	
	
	/* ======================================== */
	// MEMBERS
	/* ======================================== */
	
	private static ESantePatientListDialog	instance;
	
	
	private DspListPanel	patientPanel;
	
	private String			warning;
	
	private Dsp				selectedDsp;
	
	private Patient			gecamedPatient;
	
	
	
	/* ======================================== */
	// CONSTRUCTORS
	/* ======================================== */
	
	public ESantePatientListDialog ()
	{
		super(MainFrame.getInstance(), 
				Translatrix.getTranslationString("esante.DspList.dialogTitle"), 
				OK_CANCEL_BUTTON_MODE);
		
		patientPanel	= new DspListPanel(true);
		patientPanel.addPatientListListener(this);
		
		mainPanel.setLayout(new FormLayout("f:p:g", "f:p:g"));
		mainPanel.add(patientPanel, new CellConstraints(1, 1));
		setResizingOptions(RESIZING_NONE);
		addWindowListener(this);
		setResizingOptions(RESIZING_SIZE);
	}
	
	
	
	/* ======================================== */
	// CLASS BODY
	/* ======================================== */
	
	public Dsp linkPatient (Patient patient)
	{
//		Dsp esantePatient = new Dsp(patient);
		// reset the button option to be able to check it, bevor the dialog opens
		buttonOption = CLOSED_OPTION;
		
		gecamedPatient = patient;
		patientPanel.setAlreadyLoaded(false);
		patientPanel.writePatientDataIntoFields(patient);
//		patientPanel.activateReload(true);
		Boolean querySuccessfull = patientPanel.queryPatients();
		
		if (buttonOption == OK_OPTION)
		{
			// do not show the dialog, as the DSP was already chosen
			return selectedDsp;
		}
		if (!Boolean.TRUE.equals(querySuccessfull))
		{
			// query for DSPs wasn't successful
			return null;
		}
		
		pack();
		setSize(800, 480);
		showCenteredDialog();
		
//		patientPanel.activateReload(false);
		
		if (buttonOption == OK_OPTION)
		{
			return selectedDsp;
		}
		
		return null;
	}
	
	
	@Override
	public void okActionCalled ()
	{
		if (ComparePatientDataDialog.getInstance().compareData(gecamedPatient, selectedDsp))
			super.okActionCalled();
	}
	
	
	public static ESantePatientListDialog getInstance ()
	{
		if (instance == null)
			instance = new ESantePatientListDialog();
		
		return instance;
	}
	
	
	/* ---------------------------------------- */
	// WINDOW LISTENER METHODS
	/* ---------------------------------------- */
	
	public void windowOpened (WindowEvent e)
	{
		if (warning != null)
		{
			showMessageDialog(this, 
					Translatrix.getTranslationString("Warning while loading patients"), 
					warning, 
					OK_BUTTON_MODE, 
					GECAMedModule.getBigIcon(GECAMedIconNames.WARNING));
		}
	}
	
	
	public void windowClosing (WindowEvent e) {}
	public void windowClosed (WindowEvent e) {}
	public void windowIconified (WindowEvent e) {}
	public void windowDeiconified (WindowEvent e) {}
	public void windowActivated (WindowEvent e) {}
	public void windowDeactivated (WindowEvent e) {}
	
	
	/* ---------------------------------------- */
	// PATIENT LIST LISTENER METHODS
	/* ---------------------------------------- */
	
	public void dspSelected (Dsp dsp)
	{
		getOKButton().setEnabled(dsp != null);
		selectedDsp = dsp;
	}
	
	
	public void dspChosen (Dsp dsp)
	{
		if (!ComparePatientDataDialog.getInstance().compareData(gecamedPatient, dsp))
			return;
		
		selectedDsp = dsp;
		super.okActionCalled();
	}
}
