package lu.tudor.santec.gecamed.esante.gui.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.font.TextAttribute;

import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ScrollPaneConstants;

import lu.tudor.santec.gecamed.core.gui.GECAMedColors;
import lu.tudor.santec.gecamed.core.gui.utils.GECAMedGuiUtils;
import lu.tudor.santec.gecamed.core.gui.widgets.GECAMedBaseDialogImpl;
import lu.tudor.santec.gecamed.esante.gui.utils.ESanteGuiUtils;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

/**
 * @author jens.ferring(at)tudor.lu
 * 
 * @version
 * <br>$Log: ESanteDialog.java,v $
 * <br>Revision 1.6  2014-01-27 13:13:47  donak
 * <br>* Properties are now saved in db in respect to the following contexts:
 * <br>  - specific to a GECAMed user
 * <br>  - specific to a GECAMed physician
 * <br>  - specific to an eSanté plattform user
 * <br>  - general (independend of GECAMed user, physician, eSanté platform user)
 * <br>* Improved authentication handling. A signed authentication request is now only done for user authentication. for dsp authentication requests the provided saml assertion is used. (authentication speed up). ATTENTION: This fix is currently disabled till a bug in the eSanté platform has been fixed.
 * <br>* Naming of message loggings had been adapted to the naming in the connection kit (e.g. DSP-10, DSP-22)
 * <br>* Changed behavior for handling of dsps for which physician has insufficient access permissions. If physician does not want to provide presence password, a DSP-11 is sent instead of a DSP-12 to allow the physician to at least access the documents he is author of.
 * <br>
 * <br>Revision 1.5  2013-12-19 12:37:07  ferring
 * <br>static message dialog option added
 * <br>
 * <br>Revision 1.4  2013-12-17 16:48:33  ferring
 * <br>font size of input dialog enlarged
 * <br>
 * <br>Revision 1.3  2013-10-10 13:31:50  ferring
 * <br>new picture fitted
 * <br>
 * <br>Revision 1.2  2013-07-03 13:06:23  ferring
 * <br>eSante module handling changed
 * <br>
 * <br>Revision 1.1  2013-06-10 08:21:49  ferring
 * <br>eSante POC
 * <br>
 */

public class ESanteDialog extends GECAMedBaseDialogImpl
{
	/* ======================================== */
	// CONSTANTS
	/* ======================================== */
	
	private static final long	serialVersionUID	= 2178390107151765738L;
	
//	private static final ImageIcon ESANTE_LOGO = ESanteUtils.getESanteIcon(64);
	
	
	
	/* ======================================== */
	// CONSTRUCTORS
	/* ======================================== */
	
	public ESanteDialog (JDialog parent, String title, int buttonMode, JPanel mainPanel)
	{
		super(parent, title, buttonMode, mainPanel);
		init();
	}
	
	
	public ESanteDialog (JFrame parent, String title, int buttonMode, JPanel mainPanel)
	{
		super(parent, title, buttonMode, mainPanel);
		init();
	}
	
	
	public ESanteDialog (JDialog parent, String title, int buttonMode)
	{
		this(parent, title, buttonMode, new JPanel());
	}
	
	
	public ESanteDialog (JFrame parent, String title, int buttonMode)
	{
		this(parent, title, buttonMode, new JPanel());
	}
	
	
	
	/* ======================================== */
	// CLASS BODY
	/* ======================================== */
	
	private void init ()
	{
		JLabel logo = new JLabel(ESanteGuiUtils.getESanteIcon(48));
		logo.setMaximumSize(new Dimension(64, 24));
		logo.setPreferredSize(new Dimension(64, 24));
		
		logo.setOpaque(false);
		actionPanel.add(logo);
	}
	
	/**
	 * Displays a dialog that requests a user input
	 * 
	 * @param parentComponent
	 *            The component this dialog should be attached to
	 * @param title
	 *            The title of the dialog window
	 * @param message
	 *            The message that will be displayed in the dialog
	 * @param startText
	 *            A default value that will be displayed in the input field
	 * @return If the ok button was pressed, the user input is returned, if the cancel button was pressed, null is returned
	 */
	public static String showInputMessageDialog (Component parentComponent, String title, String message, String startText)
	{
		JLabel 		label 		= new JLabel(message);
		JTextField 	textField 	= new JTextField(startText != null ? startText : "");
		FormLayout 	layout 		= new FormLayout("5px, f:p:g, 5px", "5px, f:p:g, 10px, f:p, 5px");
		JPanel 		mainPanel 	= new JPanel(layout);
		CellConstraints cc 		= new CellConstraints();
		
		GECAMedGuiUtils.changeFont(textField, TextAttribute.SIZE, 18);
		
		mainPanel.add(label, 		cc.xy(2, 2));
		mainPanel.add(textField, 	cc.xy(2, 4));
		
		ESanteDialog dialog;
		Window owner = getParentWindow(parentComponent);
		if (owner instanceof JDialog)
			dialog = new ESanteDialog((JDialog) owner, title, OK_CANCEL_BUTTON_MODE, mainPanel);
		else
			dialog = new ESanteDialog((JFrame) owner, title, OK_CANCEL_BUTTON_MODE, mainPanel);
		
		dialog.pack();
		dialog.setLocationRelativeTo(owner);
		dialog.setVisible(true);
		
		String inputText;
		if (dialog.buttonOption == OK_OPTION)
			inputText = textField.getText();
		else
			inputText = null;
		
		return inputText;
	}
	
	
	public static int showMessageDialog (Component parentComponent, 
			String title, String message, int buttonMode, Icon icon)
	{
		JLabel 				label;
		JScrollPane 		scroller;
		JPanel 				mainPanel 	= new JPanel();
		CellConstraints		cc 			= new CellConstraints();
		Window				parent		= getParentWindow(parentComponent);
		ESanteDialog		dialog;
		
		// define the panel and add the message
		mainPanel.setBackground(GECAMedColors.c_GECAMedBackground);
		mainPanel.setLayout(new FormLayout(
				"10px, f:p, 5px, f:p:g, 10px",
				"10px, f:min(p; 400px):g, 10px"));
		
		label = new JLabel(message);
		label.setOpaque(false);
		GECAMedGuiUtils.changeFont(label, TextAttribute.WEIGHT, TextAttribute.WEIGHT_REGULAR);
//		attributes = (Map<TextAttribute, Object>) label.getFont().getAttributes();
//		attributes.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_REGULAR);
//		label.setFont(new Font(attributes));
		scroller = new JScrollPane(label);
		scroller.setOpaque(false);
		scroller.setHorizontalScrollBarPolicy(ScrollPaneConstants.HORIZONTAL_SCROLLBAR_AS_NEEDED);
		scroller.setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_AS_NEEDED);
		scroller.getViewport().setOpaque(false);
		scroller.setBorder(BorderFactory.createEmptyBorder());
		
		if (icon == null)
		{
			mainPanel.add(scroller, cc.xyw(2, 2, 3));
		} 
		else
		{
			mainPanel.add(scroller, cc.xy(4, 2));
			
			label = new JLabel(icon);
			label.setOpaque(false);
			mainPanel.add(label, cc.xy(2, 2));
		}
		
		if (parent instanceof JDialog)
			dialog	= new ESanteDialog((JDialog)parent, title, buttonMode, mainPanel);
		else 
			dialog	= new ESanteDialog((JFrame)parent, title, buttonMode, mainPanel);
		
		
		// show the dialog
		dialog.setResizingOptions(RESIZING_NONE);
		dialog.pack();
		dialog.showCenteredDialog();
		
		return dialog.getButtonOption();
	}
}
