package lu.tudor.santec.gecamed.esante.gui.dialogs;

import java.awt.Color;
import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

import lu.tudor.santec.gecamed.address.ejb.entity.beans.GECAMedAddressBean;
import lu.tudor.santec.gecamed.core.ejb.entity.beans.Gender;
import lu.tudor.santec.gecamed.core.gui.GECAMedIconNames;
import lu.tudor.santec.gecamed.core.gui.GECAMedModule;
import lu.tudor.santec.gecamed.core.gui.MainFrame;
import lu.tudor.santec.gecamed.core.gui.utils.GECAMedGuiUtils;
import lu.tudor.santec.gecamed.core.gui.widgets.GECAMedBaseDialogImpl;
import lu.tudor.santec.gecamed.core.utils.GECAMedUtils;
import lu.tudor.santec.gecamed.esante.ejb.entity.beans.Dsp;
import lu.tudor.santec.gecamed.esante.gui.IconNames;
import lu.tudor.santec.gecamed.esante.gui.utils.ESanteGuiUtils;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.Patient;
import lu.tudor.santec.gecamed.patient.gui.PatientManagerModule;
import lu.tudor.santec.i18n.Translatrix;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.toedter.calendar.JDateChooser;

/**
 * @author jens.ferring(at)tudor.lu
 * 
 * @version
 * <br>$Log: ComparePatientDataDialog.java,v $
 * <br>Revision 1.16  2014-01-27 10:09:04  ferring
 * <br>colons added
 * <br>
 * <br>Revision 1.15  2014-01-23 15:01:32  ferring
 * <br>DSP last names changed
 * <br>
 * <br>Revision 1.14  2014-01-10 13:16:43  ferring
 * <br>GECAMed data gender translated
 * <br>
 * <br>Revision 1.13  2014-01-10 08:26:20  ferring
 * <br>tranlsations added
 * <br>
 * <br>Revision 1.12  2014-01-06 12:34:28  ferring
 * <br>download site constants moved
 * <br>
 * <br>Revision 1.11  2013-12-19 12:37:53  ferring
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.10  2013-12-17 08:14:52  ferring
 * <br>Correct button mode set
 * <br>
 * <br>Revision 1.9  2013-12-16 13:02:44  ferring
 * <br>Connection to DSP without ID no longer possible
 * <br>
 * <br>Revision 1.8  2013-12-16 12:05:12  ferring
 * <br>logging eSanté actions
 * <br>
 * <br>Revision 1.7  2013-11-28 10:38:21  ferring
 * <br>GECAMedUtils split into utils and GUI utils classes
 * <br>
 * <br>Revision 1.6  2013-11-26 10:30:24  ferring
 * <br>translated
 * <br>
 * <br>Revision 1.5  2013-11-12 09:33:37  ferring
 * <br>show compare dialog when unlinking patient
 * <br>
 * <br>Revision 1.4  2013-11-05 09:47:56  ferring
 * <br>ESantePatient changed to Dsp. The Dsp object will be stored in the database, if a patient is linked with eSanté.
 * <br>
 * <br>Revision 1.3  2013-10-29 13:44:15  ferring
 * <br>getInstance will not always create a new dialog
 * <br>
 * <br>Revision 1.2  2013-10-29 13:42:43  ferring
 * <br>bug fixes when showing patient DSPs to link to
 * <br>
 * <br>Revision 1.1  2013-10-28 16:54:12  ferring
 * <br>eSante and GECAMed patient compare dialog added and a lot of bug fixes
 * <br>
 */

public class ComparePatientDataDialog extends ESanteDialog
{
	/* ======================================== */
	// CONSTANTS
	/* ======================================== */
	
	private static final long	serialVersionUID	= 1L;
	
	private static final String[] GENDERS	= new String[] 
	{
		Translatrix.getTranslationString("esante.ComparePatientData.gender." + Gender.MALE),
		Translatrix.getTranslationString("esante.ComparePatientData.gender." + Gender.FEMALE),
		Translatrix.getTranslationString("esante.ComparePatientData.gender." + Gender.UNKNOWN)
	};
	
	
	
	/* ======================================== */
	// MEMBERS
	/* ======================================== */

	private static ComparePatientDataDialog instance;
	
	
	private String			linkTitle;
	
	private String			unlinkTitle;
	
	private String			linkDescription;
	
	private String			unlinkDescription;
	
	private JLabel			descriptionLabel;
	
	private JLabel			dspHeadlineLabel;
	
	private JTextField		gecamedFirstNameField;
	
	private JTextField		gecamedSurNameField;
	
	private JTextField		gecamedMaidenNameField;
	
	private JDateChooser	gecamedBirthdayChooser;
	
	private JComboBox		gecamedGenderBox;
	
	private JTextArea		gecamedAddressArea;
	
	private JTextField		esanteFirstNameField;
	
	private JTextField		esanteFamilyNameField;
	
	private JTextField		esanteCommonNameField;
	
	private JTextField		esanteBirthdayField;
	
	private JTextField		esanteGenderField;
	
	private JTextArea		esanteAddressArea;
	
	private JButton			takeOverDataButton;
	
	
	
	/* ======================================== */
	// CONSTRUCTOR
	/* ======================================== */
	
	public ComparePatientDataDialog ()
	{
		super(MainFrame.getInstance(),
				"", 
				YES_NO_BUTTON_MODE);
		
		linkTitle	= Translatrix.getTranslationString("esante.ComparePatientData.linkTitle");
		unlinkTitle	= Translatrix.getTranslationString("esante.ComparePatientData.unlinkTitle");
		initialize();
	}
	
	
	
	/* ======================================== */
	// CLASS BODY
	/* ======================================== */
	
	public boolean compareData (Patient gecamedData, Dsp dspData)
	{
		if (GECAMedUtils.isEmpty(gecamedData.getIdLuxembourg())
				&& GECAMedUtils.isEmpty(dspData.getDspOid()))
		{
			ESanteDialog.showMessageDialog(MainFrame.getInstance(), 
					Translatrix.getTranslationString("esante.DspList.warning.noDspIdSetTitle"), 
					Translatrix.getTranslationString("esante.DspList.warning.noDspIdSetMsg"), 
					GECAMedBaseDialogImpl.OK_BUTTON_MODE, 
					GECAMedModule.getBigIcon(GECAMedIconNames.INFO));
			return false;
		}
		
		String esanteGender		= dspData.getSex();
		String gecamedGender	= gecamedData.getGender();
		
		if (esanteGender == null)
		{
			esanteGender = Translatrix.getTranslationString("esante.ComparePatientData.gender." + Gender.UNKNOWN);
		}
		else
		{
			esanteGender = esanteGender.toUpperCase();
			esanteGender = Translatrix.getTranslationString("esante.ComparePatientData.gender." + 
					( esanteGender.equalsIgnoreCase(Dsp.GENDER_MALE) 
					? Gender.MALE
					: esanteGender.equalsIgnoreCase(Dsp.GENDER_FEMALE) 
					? Gender.FEMALE
					: Gender.UNKNOWN));
		}
		
		if (gecamedGender == null)
		{
			gecamedGender = Translatrix.getTranslationString("esante.ComparePatientData.gender." + Gender.UNKNOWN);
		}
		else
		{
			gecamedGender = gecamedGender.toUpperCase();
			gecamedGender = Translatrix.getTranslationString("esante.ComparePatientData.gender." + 
					( gecamedGender.equalsIgnoreCase(Gender.MALE) 
					? Gender.MALE
					: gecamedGender.equalsIgnoreCase(Gender.FEMALE) 
					? Gender.FEMALE
					: Gender.UNKNOWN));
		}
		
		dspHeadlineLabel.setToolTipText(dspData.getDspOid());
		gecamedFirstNameField.setText(gecamedData.getFirstName());
		gecamedSurNameField.setText(gecamedData.getSurName());
		gecamedMaidenNameField.setText(gecamedData.getMaidenName());
		gecamedBirthdayChooser.setDate(gecamedData.getBirthDate());
		gecamedGenderBox.setSelectedItem(gecamedGender);
		gecamedAddressArea.setText(GECAMedAddressBean.printAddresses(gecamedData.getAddress(), false));
		esanteFirstNameField.setText(dspData.getGivenName());
		esanteFamilyNameField.setText(dspData.getFamilyName());
		esanteCommonNameField.setText(dspData.getCommonName());
		esanteBirthdayField.setText(GECAMedGuiUtils.getDateFormat(false).format(dspData.getBirthDate()));
		// TODO translate
		esanteGenderField.setText(esanteGender);
		esanteAddressArea.setText(dspData.getAddressesString());
		
		if (gecamedData.getIdLuxembourg() == null)
		{
			// ask to LINK the patient with the DSP
			setTitle(linkTitle);
			descriptionLabel.setText(linkDescription);
			descriptionLabel.setIcon(null);
			takeOverDataButton.setVisible(true);
		}
		else
		{
			// ask to UNLINK the patient with the DSP
			setTitle(unlinkTitle);
			descriptionLabel.setText(unlinkDescription);
			descriptionLabel.setIcon(GECAMedModule.getBigIcon(GECAMedIconNames.WARNING));
			takeOverDataButton.setVisible(false);
		}
		
		pack();
		centerWindowOnOwner();
		setVisible(true);
		
		if (buttonOption == YES_OPTION)
		{
			ESanteGuiUtils.trace("DSP", 
					new StringBuilder("Patient ")
							.append(gecamedData.toShortString())
							.append("(ID = ")
							.append(gecamedData.getId())
							.append(") ")
							.append(gecamedData.getIdLuxembourg() == null
									? "LINKED"
									: "UNLINKED")
							.append(" with DSP ")
							.append(dspData.getDspOid())
							.toString());
			
			return true;
		}
		else 
		{
			return false;
		}
	}
	
	
	@Override
	public void okActionCalled ()
	{
		savePatientData();
		
		super.okActionCalled();
	}
	
	
	public static ComparePatientDataDialog getInstance ()
	{
		if (instance == null)
			instance = new ComparePatientDataDialog();
		
		return instance;
	}
	
	
	
	/* ======================================== */
	// HELP METHODS
	/* ======================================== */
	
	private void initialize ()
	{
		String				patientSurName;
		String				patientMaidenName;
		
		
		if (PatientManagerModule.isMaidenConfig()) 
		{
			patientSurName		= Translatrix.getTranslationString("pm.maidenName")+":";
			patientMaidenName	= Translatrix.getTranslationString("pm.familyName")+":";
    	} 
		else 
		{
    		patientSurName		= Translatrix.getTranslationString("pm.lastName")+":";
    		patientMaidenName	= Translatrix.getTranslationString("pm.maidenName")+":";
    	}
		// define the description
		descriptionLabel	= new JLabel();
		descriptionLabel.setOpaque(false);
		
		linkDescription		= Translatrix.getTranslationString("esante.ComparePatientData.linkDescription");
		unlinkDescription	= Translatrix.getTranslationString("esante.ComparePatientData.unlinkDescription");
		
		JLabel gecamedHeadlineLabel	= new JLabel(Translatrix.getTranslationString(
				"esante.ComparePatientData.gecamedHeadline"));
		gecamedHeadlineLabel.setOpaque(false);
		
		dspHeadlineLabel		= new JLabel(Translatrix.getTranslationString(
				"esante.ComparePatientData.dspHeadline"));
		dspHeadlineLabel.setOpaque(false);
		
		JLabel gecamedFirstName		= new JLabel(Translatrix.getTranslationString("pm.firstName")+":");
		JLabel gecamedSurName		= new JLabel(patientSurName);
		JLabel gecamedMaidenName	= new JLabel(patientMaidenName);
		JLabel gecamedBirthday		= new JLabel(Translatrix.getTranslationString("pm.dayOfBirth")+":");
		JLabel gecamedGender		= new JLabel(Translatrix.getTranslationString("pm.gender")+":");
		JLabel gecamedAddress		= new JLabel(Translatrix.getTranslationString("esante.ComparePatientData.addresses"));

		JLabel esanteFirstName		= new JLabel(Translatrix.getTranslationString("pm.firstName")+":");
		JLabel esanteFamilyName		= new JLabel(Translatrix.getTranslationString("esante.ComparePatientData.familyName"));
		JLabel esanteCommonName		= new JLabel(Translatrix.getTranslationString("esante.ComparePatientData.commonName"));
		JLabel esanteBirthday		= new JLabel(Translatrix.getTranslationString("pm.dayOfBirth")+":");
		JLabel esanteGender			= new JLabel(Translatrix.getTranslationString("pm.gender")+":");
		JLabel esanteAddress		= new JLabel(Translatrix.getTranslationString("esante.ComparePatientData.addresses"));
		
		gecamedFirstNameField	= new JTextField();
		gecamedFirstNameField.setEnabled(false);
		gecamedSurNameField		= new JTextField();
		gecamedSurNameField.setEnabled(false);
		gecamedMaidenNameField	= new JTextField();
		gecamedMaidenNameField.setEnabled(false);
		gecamedBirthdayChooser	= GECAMedGuiUtils.getDateChooser(false);
		gecamedBirthdayChooser.setEnabled(false);
		gecamedGenderBox		= new JComboBox(GENDERS);
		gecamedGenderBox.setEnabled(false);
		gecamedAddressArea		= new JTextArea();
		gecamedAddressArea.setEnabled(false);
		gecamedAddressArea.setDisabledTextColor(Color.BLACK);
		JScrollPane gecamedAddressScroller	= new JScrollPane(gecamedAddressArea);
		gecamedAddressScroller.setOpaque(false);
		gecamedAddressScroller.getViewport().setOpaque(false);
		esanteFirstNameField	= new JTextField();
		esanteFirstNameField.setEnabled(false);
		esanteFamilyNameField		= new JTextField();
		esanteFamilyNameField.setEnabled(false);
		esanteCommonNameField	= new JTextField();
		esanteCommonNameField.setEnabled(false);
		esanteBirthdayField		= new JTextField();
		esanteBirthdayField.setEnabled(false);
		esanteGenderField		= new JTextField();
		esanteGenderField.setEnabled(false);
		esanteAddressArea		= new JTextArea();
		esanteAddressArea.setEnabled(false);
		esanteAddressArea.setDisabledTextColor(Color.BLACK);
		JScrollPane esanteAddressScroller	= new JScrollPane(esanteAddressArea);
		esanteAddressScroller.setOpaque(false);
		esanteAddressScroller.getViewport().setOpaque(false);
		
		takeOverDataButton			= new JButton(new AbstractAction(
				Translatrix.getTranslationString("esante.ComparePatientData.transferDspData"),
				ESanteGuiUtils.getIcon(IconNames.LEFT_ARROWS, 16))
		{
			private static final long	serialVersionUID	= 1L;
			
			public void actionPerformed (ActionEvent e)
			{
				takeOverData();
			}
		});
		
		CellConstraints cc	= new CellConstraints();
		int row				= 0;
		int	gecamedLabelCol	= 2;
		int gecamedDataCol	= 4;
		int	esanteLabelCol	= 6;
		int esanteDataCol	= 8;
		
		mainPanel.setLayout(new FormLayout(
				"10px, f:p, 5px, f:250px:g, 10px, f:p, 5px, f:250px:g, 10px", 
				  "10px,f:p,"	// description
				+ "20px,f:p,"	// headline
				+ " 5px,f:p,"	// first name
				+ " 5px,f:p,"	// surname
				+ " 5px,f:p,"	// birth name
				+ " 5px,f:p,"	// gender
				+ " 5px,f:p,"	// birthday
				+ " 5px,t:p,"	// address
				+ "10px,f:p,"	// take over data
				+ "10px"));
		
		row += 2;
		mainPanel.add(descriptionLabel,			cc.xyw(2, row, 7));
		row += 2;
		mainPanel.add(gecamedHeadlineLabel,		cc.xyw(2, row, 3));
		mainPanel.add(dspHeadlineLabel,			cc.xyw(6, row, 3));
		row += 2;
		mainPanel.add(gecamedFirstName,			cc.xy(gecamedLabelCol, row));
		mainPanel.add(gecamedFirstNameField,	cc.xy(gecamedDataCol, row));
		mainPanel.add(esanteFirstName,			cc.xy(esanteLabelCol, row));
		mainPanel.add(esanteFirstNameField,		cc.xy(esanteDataCol,  row));
		row += 2;
		mainPanel.add(gecamedSurName,			cc.xy(gecamedLabelCol, row));
		mainPanel.add(gecamedSurNameField,		cc.xy(gecamedDataCol, row));
		mainPanel.add(esanteFamilyName,			cc.xy(esanteLabelCol, row));
		mainPanel.add(esanteFamilyNameField,	cc.xy(esanteDataCol,  row));
		row += 2;
		mainPanel.add(gecamedMaidenName,		cc.xy(gecamedLabelCol, row));
		mainPanel.add(gecamedMaidenNameField,	cc.xy(gecamedDataCol, row));
		mainPanel.add(esanteCommonName,			cc.xy(esanteLabelCol, row));
		mainPanel.add(esanteCommonNameField,	cc.xy(esanteDataCol,  row));
		row += 2;
		mainPanel.add(gecamedBirthday,			cc.xy(gecamedLabelCol, row));
		mainPanel.add(gecamedBirthdayChooser.getDateEditor().getUiComponent(),
												cc.xy(gecamedDataCol, row));
		mainPanel.add(esanteBirthday,			cc.xy(esanteLabelCol, row));
		mainPanel.add(esanteBirthdayField,		cc.xy(esanteDataCol,  row));
		row += 2;
		mainPanel.add(gecamedGender,			cc.xy(gecamedLabelCol, row));
		mainPanel.add(gecamedGenderBox,			cc.xy(gecamedDataCol, row));
		mainPanel.add(esanteGender,				cc.xy(esanteLabelCol, row));
		mainPanel.add(esanteGenderField,		cc.xy(esanteDataCol,  row));
		row += 2;
		mainPanel.add(gecamedAddress,			cc.xy(gecamedLabelCol, row));
		mainPanel.add(gecamedAddressScroller,	cc.xy(gecamedDataCol, row));
		mainPanel.add(esanteAddress,			cc.xy(esanteLabelCol, row));
		mainPanel.add(esanteAddressScroller,	cc.xy(esanteDataCol,  row));
		row += 2;
//		mainPanel.add(takeOverDataButton,		cc.xyw(4, row, 5, CellConstraints.CENTER, CellConstraints.TOP));
	}
	
	
	private void takeOverData ()
	{
		// TODO
	}
	
	
	private void savePatientData ()
	{
		// TODO
	}
}
