package lu.tudor.santec.gecamed.esante.gui.dialogs;

import java.awt.event.ActionEvent;
import java.awt.font.TextAttribute;

import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JRadioButton;

import lu.tudor.santec.gecamed.core.gui.MainFrame;
import lu.tudor.santec.gecamed.core.gui.utils.GECAMedGuiUtils;
import lu.tudor.santec.gecamed.esante.ejb.entity.beans.ESanteProperty;
import lu.tudor.santec.gecamed.esante.ejb.session.beans.ESanteConfigManagerBean;
import lu.tudor.santec.gecamed.esante.utils.ESanteUtils;
import lu.tudor.santec.i18n.Translatrix;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

/**
 * @author jens.ferring(at)tudor.lu
 * 
 * @version
 * <br>$Log: CdaDownloadSiteDialog.java,v $
 * <br>Revision 1.3  2014-01-21 14:32:05  ferring
 * <br>myDSP configuration can be changed and reloaded.
 * <br>The clean CDA files on server function was added
 * <br>
 * <br>Revision 1.2  2014-01-09 14:32:20  ferring
 * <br>Clear CDA documents on server function prepared, but not yet done
 * <br>
 * <br>Revision 1.1  2014-01-06 13:14:05  ferring
 * <br>Option added to select the download site
 * <br>
 */

public class CdaDownloadSiteDialog extends ESanteDialog
{
	/* ======================================== */
	// CONSTANTS
	/* ======================================== */
	
	private static final long	serialVersionUID	= 1L;
	
	
	
	/* ======================================== */
	// MEMBERS
	/* ======================================== */
	
	private static CdaDownloadSiteDialog instance;
	
	
	private JRadioButton	serverSiteButton;
	
	private JRadioButton	clientSiteButton;
	
	private JButton			clearDocumentsButton;
	
	
	
	/* ======================================== */
	// CONSTRUCTORS
	/* ======================================== */
	
	public CdaDownloadSiteDialog ()
	{
		super(MainFrame.getInstance(), Translatrix.getTranslationString(
						"esante.managementPanel.preferencesPanel.cdaDownloadSiteDialog"),
				OK_CANCEL_BUTTON_MODE);
		initDialog();
	}
	
	
	
	/* ======================================== */
	// CLASS BODY
	/* ======================================== */
	
	public void chooseCdaDownloadSite ()
	{
		if (ESanteUtils.getCdaDownloadSite() == ESanteUtils.CDA_DOWNLOAD_SITE_CLIENT)
			clientSiteButton.setSelected(true);
		else
			serverSiteButton.setSelected(true);
		
		pack();
		showCenteredDialog();
		
		if (buttonOption == OK_OPTION)
		{
			// TODO: check if option has changed
			ESanteConfigManagerBean.getInstance().setESanteProperty(ESanteProperty.PROP_CDA_DOWNLOAD_SITE, 
					clientSiteButton.isSelected() ? ESanteProperty.DOWNLOAD_SITE_CLIENT : ESanteProperty.DOWNLOAD_SITE_SERVER);
			ESanteUtils.resetCdaDownloadSite();
		}
	}
	
	
	public static CdaDownloadSiteDialog getInstance ()
	{
		if (instance == null)
			instance = new CdaDownloadSiteDialog();
		
		return instance;
	}
	
	
	
	/* ======================================== */
	// HELP METHODS
	/* ======================================== */
	
	private void initDialog ()
	{
		CellConstraints	cc	= new CellConstraints();
		ButtonGroup		bg	= new ButtonGroup();
		JLabel			descriptionLabel;
		int				row;
		
		
		mainPanel.setLayout(new FormLayout(
				"5px, f:p:g, 5px", 
				" 5px,f:p," +	// description 
				"15px,f:p," +	// client option
				"10px,f:p," +	// server option
				"15px,f:p," +	// clear button
				" 5px"));
		
		
		descriptionLabel	= new JLabel(Translatrix.getTranslationString(
				"esante.managementPanel.preferencesPanel.setDownloadSiteDescription"));
		descriptionLabel.setOpaque(false);
		
		clientSiteButton	= new JRadioButton(Translatrix.getTranslationString(
				"esante.managementPanel.preferencesPanel.setDownloadSiteClient"));
		clientSiteButton.setOpaque(false);
		GECAMedGuiUtils.changeFont(clientSiteButton, TextAttribute.WEIGHT, TextAttribute.WEIGHT_REGULAR);
		bg.add(clientSiteButton);
		
		serverSiteButton	= new JRadioButton(Translatrix.getTranslationString(
				"esante.managementPanel.preferencesPanel.setDownloadSiteServer"));
		serverSiteButton.setOpaque(false);
		GECAMedGuiUtils.changeFont(serverSiteButton, TextAttribute.WEIGHT, TextAttribute.WEIGHT_REGULAR);
		bg.add(serverSiteButton);
		
		
		clearDocumentsButton= new JButton(new AbstractAction(
				Translatrix.getTranslationString("esante.managementPanel.preferencesPanel.clearDownloads"))
		{
			private static final long	serialVersionUID	= 1L;
			
			public void actionPerformed (ActionEvent e)
			{
				clearDocuments();
			}
		});
		clearDocumentsButton.setToolTipText(Translatrix.getTranslationString(
				"esante.managementPanel.preferencesPanel.clearDownloadsToolTip"));
		
		row	= 0;
		mainPanel.add(descriptionLabel,		cc.xy(2, row+=2));
		mainPanel.add(clientSiteButton,		cc.xy(2, row+=2));
		mainPanel.add(serverSiteButton,		cc.xy(2, row+=2));
		// TODO in comment, when it function works
		mainPanel.add(clearDocumentsButton,	cc.xy(2, row+=2));
	}
	
	
	private void clearDocuments ()
	{
		ClearCdaDocumentsDialog.showDialog(this);
	}
}
