package lu.tudor.santec.gecamed.esante.gui.data;


/**
 * @author jens.ferring(at)tudor.lu
 * 
 * @version
 * <br>$Log: FixSizeQueue.java,v $
 * <br>Revision 1.1  2014-01-16 12:28:44  ferring
 * <br>Changes on eSanté platform applied and logging added
 * <br>
 */

public class FixSizeQueue<E>
{
	private Object[]	data;
	
	private int			index;
	
	
	public FixSizeQueue (int capacity)
	{
		if (capacity <= 0)
			throw new RuntimeException("The capacity is "+capacity+", but must be greater than 0.");
		
		data	= new Object[capacity];
		index	= 0;
	}
	
	
	/**
	 * Adds a new item and returns the replaced one. If there hasn't been 
	 * @param newItem
	 * @return
	 */
	public E push (E newItem)
	{
		@SuppressWarnings("unchecked")
		E	removedItem	= (E) data[index];
		data[index]		= newItem;
		
		// increase the index
		index++;
		if (index >= data.length)
			index = 0;
		
		return removedItem;
	}
}
