package lu.tudor.santec.gecamed.esante.gui.actions;

import java.awt.event.ActionEvent;

import javax.swing.ImageIcon;

import lu.tudor.santec.gecamed.core.gui.listener.AEntryAction;
import lu.tudor.santec.gecamed.core.gui.utils.GECAMedGuiUtils;
import lu.tudor.santec.gecamed.esante.ejb.entity.beans.Dsp;
import lu.tudor.santec.gecamed.esante.ejb.session.beans.CDAManagerBean;
import lu.tudor.santec.gecamed.esante.gui.IconNames;
import lu.tudor.santec.gecamed.esante.gui.dialogs.ComparePatientDataDialog;
import lu.tudor.santec.gecamed.esante.gui.tab.ESanteTab;
import lu.tudor.santec.gecamed.esante.gui.utils.ESanteGuiUtils;
import lu.tudor.santec.gecamed.esante.gui.webservice.SOAPUtilities;
import lu.tudor.santec.gecamed.esante.utils.exceptions.SendingStoppedException;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.Patient;
import lu.tudor.santec.gecamed.patient.gui.PatientListModule;
import lu.tudor.santec.i18n.Translatrix;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;

/**
 * @author jens.ferring(at)tudor.lu
 * 
 * @version
 * <br>$Log: RemoveESanteIdAction.java,v $
 * <br>Revision 1.14  2014-02-18 13:17:33  ferring
 * <br>Patients with Luxembourg ID, but without DSP, are now connected to their DSP or Luxembourg ID is removed, if no DSP was found.
 * <br>If only one DSP was found in search, the compare DSP and patient dialog is shown directly.
 * <br>
 * <br>Revision 1.13  2013-12-16 12:05:25  ferring
 * <br>logging eSanté actions
 * <br>
 * <br>Revision 1.12  2013-12-10 11:48:37  ferring
 * <br>link and unlink functions translated
 * <br>
 * <br>Revision 1.11  2013-11-12 09:33:37  ferring
 * <br>show compare dialog when unlinking patient
 * <br>
 * <br>Revision 1.10  2013-11-05 09:47:57  ferring
 * <br>ESantePatient changed to Dsp. The Dsp object will be stored in the database, if a patient is linked with eSanté.
 * <br>
 * <br>Revision 1.9  2013-10-28 16:54:12  ferring
 * <br>eSante and GECAMed patient compare dialog added and a lot of bug fixes
 * <br>
 * <br>Revision 1.8  2013-10-23 07:32:32  ferring
 * <br>icon names changed to constants
 * <br>
 * <br>Revision 1.7  2013-10-22 05:57:17  ferring
 * <br>get eSante tabs with ID of patient instead with patient object
 * <br>
 * <br>Revision 1.6  2013-10-21 08:16:44  ferring
 * <br>linking and unlinking patient changed
 * <br>
 * <br>Revision 1.5  2013-10-09 13:36:36  ferring
 * <br>eSanté icon changed and tree view initialised
 * <br>
 * <br>Revision 1.4  2013-07-15 06:18:36  ferring
 * <br>logging changed
 * <br>
 * <br>Revision 1.3  2013-07-03 13:06:39  ferring
 * <br>eSante module handling changed
 * <br>
 * <br>Revision 1.2  2013-06-26 11:19:37  ferring
 * <br>migrating eSante view from dialogs to eSante patient tab
 * <br>
 * <br>Revision 1.1  2013-06-10 08:22:14  ferring
 * <br>eSante POC
 * <br>
 */

public class RemoveESanteIdAction extends AEntryAction
{
	/* ======================================== */
	// CONSTANTS
	/* ======================================== */
	
	private static final long	serialVersionUID	= -6240419972293784427L;
	
	
	
	/* ======================================== */
	// MEMBERS
	/* ======================================== */
	
	/** the logger Object for this class */
	private static Logger logger = Logger.getLogger(RemoveESanteIdAction.class.getName());
	
	
	private PatientProvider pProvider;
	
	
	
	/* ======================================== */
	// CONSTRUCTORS
	/* ======================================== */
	
	public RemoveESanteIdAction (PatientProvider provider)
	{
		this(provider,
				Translatrix.getTranslationString("esante.actions.removeLink2Dsp"), 
				GECAMedGuiUtils.createGrayImage(ESanteGuiUtils.getIcon(
						IconNames.ESANTE_LOGO_SQUARE, ESanteGuiUtils.SMALLPIX)));
	}
	
	
	public RemoveESanteIdAction (PatientProvider provider, String text, ImageIcon icon)
	{
		super(text, icon);
		
		this.pProvider = provider;
	}
	
	
	
	/* ======================================== */
	// CLASS BODY
	/* ======================================== */
	
	public void actionPerformed (ActionEvent e)
	{
		removeESanteId(pProvider.getPatientToQuery());
	}
	
	
	public static void removeESanteId (Patient patient)
	{
		if (patient.getIdLuxembourg() == null)
			return;
		
		ESanteTab eSanteTab = ESanteTab.getESanteTab(patient.getId());
		if (eSanteTab != null)
		{
			// the patient is opened, let the eSanteTab handle this
			eSanteTab.unlinkCurrentPatient();
		}
		else
		{
			// the patient is not opened, you need to handle it here
//			Dsp linkedDsp = CDAManagerBean.getInstance().getLinkedDsp(patient.getId());
			Dsp linkedDsp;
			try
			{
				linkedDsp = SOAPUtilities.getValidDsp(patient, true);
			}
			catch (SendingStoppedException e)
			{
				return;
			}
			
			if (linkedDsp == null)
				return;
			
			if (ComparePatientDataDialog.getInstance().compareData(patient, linkedDsp))
			{
				try
				{
					patient.setIdLuxembourg(null);
					CDAManagerBean.getInstance().unlinkDsp(patient.getId());
					PatientListModule.getInstance().research();
				}
				catch (Exception e)
				{
					logger.log(Level.ERROR, e.getMessage(), e);
				}
			}
		}
	}
}
