package lu.tudor.santec.gecamed.esante.gui.actions;

import java.awt.event.ActionEvent;

import javax.swing.ImageIcon;

import lu.tudor.santec.gecamed.core.gui.IconFetcher;
import lu.tudor.santec.gecamed.core.gui.listener.AEntryAction;
import lu.tudor.santec.gecamed.esante.ejb.entity.beans.Dsp;
import lu.tudor.santec.gecamed.esante.ejb.session.beans.CDAManagerBean;
import lu.tudor.santec.gecamed.esante.gui.IconNames;
import lu.tudor.santec.gecamed.esante.gui.dialogs.ESantePatientListDialog;
import lu.tudor.santec.gecamed.esante.gui.tab.ESanteTab;
import lu.tudor.santec.gecamed.esante.gui.utils.ESanteGuiUtils;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.Patient;
import lu.tudor.santec.gecamed.patient.gui.PatientListModule;
import lu.tudor.santec.i18n.Translatrix;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;

/**
 * @author jens.ferring(at)tudor.lu
 * 
 * @version
 * <br>$Log: PdqAction.java,v $
 * <br>Revision 1.9  2013-12-10 11:48:37  ferring
 * <br>link and unlink functions translated
 * <br>
 * <br>Revision 1.8  2013-11-05 09:47:57  ferring
 * <br>ESantePatient changed to Dsp. The Dsp object will be stored in the database, if a patient is linked with eSanté.
 * <br>
 * <br>Revision 1.7  2013-10-28 16:54:12  ferring
 * <br>eSante and GECAMed patient compare dialog added and a lot of bug fixes
 * <br>
 * <br>Revision 1.6  2013-10-23 07:32:32  ferring
 * <br>icon names changed to constants
 * <br>
 * <br>Revision 1.5  2013-10-22 05:57:17  ferring
 * <br>get eSante tabs with ID of patient instead with patient object
 * <br>
 * <br>Revision 1.4  2013-10-21 08:16:31  ferring
 * <br>linking and unlinking patient changed
 * <br>
 * <br>Revision 1.3  2013-10-16 13:03:47  ferring
 * <br>some small esante bugfixes
 * <br>
 * <br>Revision 1.2  2013-10-09 13:36:36  ferring
 * <br>eSanté icon changed and tree view initialised
 * <br>
 * <br>Revision 1.1  2013-10-08 08:54:14  ferring
 * <br>class name refactoring and tree view implementation (first steps)
 * <br>
 * <br>Revision 1.5  2013-07-15 06:18:37  ferring
 * <br>logging changed
 * <br>
 * <br>Revision 1.4  2013-07-03 13:06:38  ferring
 * <br>eSante module handling changed
 * <br>
 * <br>Revision 1.3  2013-06-26 11:19:37  ferring
 * <br>migrating eSante view from dialogs to eSante patient tab
 * <br>
 * <br>Revision 1.2  2013-06-10 13:00:14  ferring
 * <br>typo in package name corrected
 * <br>
 * <br>Revision 1.1  2013-06-10 08:22:14  ferring
 * <br>eSante POC
 * <br>
 */

public class PdqAction extends AEntryAction
{
	/* ======================================== */
	// CONSTANTS
	/* ======================================== */
	
	private static final long	serialVersionUID	= 9000266372530529406L;
	
	
	
	/* ======================================== */
	// MEMBERS
	/* ======================================== */
	
	/** the logger Object for this class */
	private static Logger logger = Logger.getLogger(PdqAction.class.getName());
	
	
	private PatientProvider pProvider;
	
	
	
	/* ======================================== */
	// CONSTRUCTORS
	/* ======================================== */
	
	public PdqAction (PatientProvider patientProvider)
	{
		this(patientProvider,
				Translatrix.getTranslationString("esante.actions.link2Dsp"), 
				ESanteGuiUtils.getIcon(IconNames.ESANTE_LOGO_SQUARE, IconFetcher.SMALLPIX));
	}
	
	
	public PdqAction (PatientProvider patientProvider, String title, ImageIcon icon)
	{
		super(title, icon);
		
		this.pProvider = patientProvider;
	}
	
	
	
	/* ======================================== */
	// CLASS BODY
	/* ======================================== */
	
	public void actionPerformed (ActionEvent e)
	{
		setESanteIdForPatient(pProvider.getPatientToQuery());
	}
	
	
	public static void setESanteIdForPatient (Patient patient)
	{
		if (patient == null)
			return;
		
		try
		{
			Dsp dsp	= ESantePatientListDialog.getInstance().linkPatient(patient);
			
			if (dsp == null 
					|| dsp.getDspOid() == null 
					|| dsp.getDspOid().equals(patient.getIdLuxembourg()))
				// no new link chosen or action was cancelled
				return;
			
			ESanteTab eSanteTab = ESanteTab.getESanteTab(patient.getId());
			if (eSanteTab != null)
			{
				// The patient is opened let the eSanteTab handle this
				eSanteTab.dspChosen(dsp, true);
			}
			else
			{
				// set the eSante ID for the selected patient
				patient.setIdLuxembourg(dsp.getDspOid());
				
				dsp.setPatient(patient);
				// save the link in the DB
				CDAManagerBean.getInstance().linkDsp(dsp);
				PatientListModule.getInstance().research();
			}
			
		}
		catch (Exception e)
		{
			logger.log(Level.ERROR, e.getMessage(), e);
		}
	}
}
