package lu.tudor.santec.gecamed.esante.ejb.entity.beans;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;

/**
 * @author jens.ferring(at)tudor.lu
 * 
 * @version <br>
 *          $Log: ESanteProperty.java,v $
 *          Revision 1.22  2014-01-29 16:57:51  donak
 *          Renamed references to HPD to eHealth in respect to the request of the eHealth Agency
 *          Removed template DSP-11-12 as it is not needed and was created only for internal testing purposes
 *
 *          Revision 1.21  2014-01-28 17:53:15  donak
 *          Practice eHealth id is now set automatically
 *          Document format is now determined automatically
 *          Text of eHealth id input dialog has been changed DSP id --> eHealth ID
 *          eHealth id support link is now obtained from db
 *
 *          Revision 1.20  2014-01-28 16:02:44  ferring
 *          eHealth ID management implemented
 *
 *          Revision 1.19  2014-01-28 09:22:46  ferring
 *          *** empty log message ***
 *
 *          Revision 1.18  2014-01-27 13:13:47  donak
 *          * Properties are now saved in db in respect to the following contexts:
 *            - specific to a GECAMed user
 *            - specific to a GECAMed physician
 *            - specific to an eSanté plattform user
 *            - general (independend of GECAMed user, physician, eSanté platform user)
 *          * Improved authentication handling. A signed authentication request is now only done for user authentication. for dsp authentication requests the provided saml assertion is used. (authentication speed up). ATTENTION: This fix is currently disabled till a bug in the eSanté platform has been fixed.
 *          * Naming of message loggings had been adapted to the naming in the connection kit (e.g. DSP-10, DSP-22)
 *          * Changed behavior for handling of dsps for which physician has insufficient access permissions. If physician does not want to provide presence password, a DSP-11 is sent instead of a DSP-12 to allow the physician to at least access the documents he is author of.
 *
 *          Revision 1.15  2014-01-16 12:28:44  ferring
 *          Changes on eSanté platform applied and logging added
 *
 *          Revision 1.14  2014-01-06 12:34:28  ferring
 *          download site constants moved
 *
 *          Revision 1.13  2014-01-02 15:08:08  donak
 *          Implemented authentication workflow: user-saml request --> check ehr access permissions --> dsp saml request --> actual webservice request
 *          All saml assertions independent of type are cached.
 *
 *          Revision 1.12  2013-12-31 17:07:38  donak
 *          Fixed bug of eSanté Connection Kit specification
 *          Added mechanism to request mandate before final saml assertion is requested. DOES NOT WORK COMPLETELY, YET.
 *
 *          Revision 1.11  2013-12-13 16:17:08  donak
 *          LuxTrust authentication completed
 *
 *          Revision 1.10  2013-12-11 13:17:43  ferring
 *          *** empty log message ***
 *
 *          Revision 1.9  2013-12-08 22:14:40  donak
 *          Upload for CDA documents to eSanté platform finished. However upload is still not working as required codes do not seem to be implemented at the platform repository
 *
 *          Revision 1.8  2013-12-05 15:19:25  donak
 *          Partial upload support for the eSanté platform, not yet functional
 *
 *          Revision 1.5  2013-12-04 13:15:18  troth
 *          Add EPSOS button to patient view to open the epsos website.
 *
 *          Revision 1.4  2013-11-26 08:16:23  ferring
 *          Option added for temporary downloads of CDA documents
 *          Property names changed
 *
 *          Revision 1.3  2013-11-12 12:48:23  donak
 *          Document upload:
 *          * conversion to pdf/a using open office has been moved to the server. OpenOffice 4 has to be located in the jboss work directory. ATTENTION: it still has to be evaluated if the license agreement dialog occurs when instance is started the first time on the server.
 *          * If document contains a description, the first forty characters of the description followed by three dots will be used as title instead of the filename
 *          * Upload of incident type letters has been fixed
 *          * upload for docx files has been added
 *
 *          Upload parameters:
 *          * database does now support storage of user dependent properties
 *          * The system will automatically remember the last chosen values for confidentiality, facility type, and speciality and propose them as default when the next document will be uploaded.
 *
 *          Inactivity Monitor:
 *          * the event mouse wheel scrolling is now taken into account for resetting the logoff timer
 *          * the logoff delay is now stored in the database. If the database does not contain this parameter, it will be created
 *
 *          General:
 *          * Optimized incident entry bean handling. Caching will now avoid copying the binary content and the generated pdf content of an incident entry as these elements should only be loaded when needed. Now it should be save to re-implement a proper getBinaryContent() handling.
 * <br>
 *          Revision 1.2 2013-11-04 14:06:03 donak <br>
 *          Added constants for obtaining webservice urls <br>
 * <br>
 *          Revision 1.1 2013-09-19 12:24:43 ferring <br>
 *          eSante bugs fixed and documents stored in database <br>
 */
		@NamedQueries({ @NamedQuery(name = ESanteProperty.GET_PROPERTY_VALUE,
				query	= "SELECT o.value FROM ESanteProperty o " 
						+ "WHERE name = :name "
						+ "AND esanteUserId IS NULL "
						+ "AND physicianId IS NULL "
						+ "AND userId IS NULL"),
		@NamedQuery(name = ESanteProperty.GET_PROPERTY, 
				query	= "SELECT OBJECT(o) FROM ESanteProperty o " 
						+ "WHERE name = :name"),
		@NamedQuery(name = ESanteProperty.GET_USER_PROPERTY_VALUE, 
				query	= "SELECT o.value FROM ESanteProperty o " 
						+ "WHERE name = :name " 
						+ "AND userId = :userId"),
		@NamedQuery(name = ESanteProperty.GET_PHYSICIAN_PROPERTY_VALUE, 
				query	= "SELECT o.value FROM ESanteProperty o " 
						+ "WHERE name = :name " 
						+ "AND physicianId = :physicianId"),
		@NamedQuery(name = ESanteProperty.GET_ESANTE_USER_PROPERTY_VALUE, 
				query	= "SELECT o.value FROM ESanteProperty o " 
						+ "WHERE name = :name " 
						+ "AND esanteUserId = :esanteUserId"),			
		@NamedQuery(name = ESanteProperty.GET_USER_PROPERTY, 
				query	= "SELECT OBJECT(o) FROM ESanteProperty o " 
						+ "WHERE name = :name " 
						+ "AND userId = :userId"),
		@NamedQuery(name = ESanteProperty.GET_PHYSICIAN_PROPERTY, 
				query	= "SELECT OBJECT(o) FROM ESanteProperty o " 
						+ "WHERE name = :name " 
						+ "AND physicianId = :physicianId"),
		@NamedQuery(name = ESanteProperty.GET_ESANTE_USER_PROPERTY, 
				query	= "SELECT OBJECT(o) FROM ESanteProperty o " 
						+ "WHERE name = :name " 
						+ "AND esanteUserId = :esanteUserId"),
		@NamedQuery(name = ESanteProperty.GET_ESANTE_USER_PROPERTIES,
				query	= "SELECT OBJECT(o) FROM ESanteProperty o "
						+ "WHERE o.name = :name "
						+ "AND esanteUserId IS NOT NULL"),
		@NamedQuery(name = ESanteProperty.GET_PROPERTIES, 
				query	= "SELECT OBJECT(o) FROM ESanteProperty o "
						+ "WHERE esanteUserId IS NULL "
						+ "AND physicianId IS NULL "
						+ "AND userId IS NULL"), 
		@NamedQuery(name = ESanteProperty.GET_PROPERTIES_LIKE_NAME,
				query	= "SELECT OBJECT(o) FROM ESanteProperty o "
						+ "WHERE userId IS NULL "
						+ "AND name LIKE :name"),
		@NamedQuery(name = ESanteProperty.GET_PROPERTIES_BY_NAME,
				query	= "SELECT OBJECT(o) FROM ESanteProperty o "
						+ "WHERE userId IS NULL "
						+ "AND name IN (:nameList)"),
		@NamedQuery(name = ESanteProperty.GET_ESANTE_USER_PROPERTYS_BY_ESANTEUSERID, 
				query	= "SELECT OBJECT(o) FROM ESanteProperty o " 
						+ "WHERE esanteUserId = :esanteUserId"),
		})
@Entity
@Table(schema = "esante", name = "property")
public class ESanteProperty extends GECAMedEntityBean {
	/* ======================================== */
	// CONSTANTS
	/* ======================================== */

	private static final long serialVersionUID = 1L;

	public static final String GET_PROPERTY_VALUE = "getESantePropertyValue";
	public static final String GET_PROPERTY = "getESanteProperty";
	public static final String GET_PROPERTIES = "getESanteProperties";
	public static final String GET_PROPERTIES_LIKE_NAME	= "getPropertiesLikeName";
	public static final String GET_PROPERTIES_BY_NAME = "getPropertiesByName";
	public static final String GET_USER_PROPERTY_VALUE = "getUserPropertyValue";
	public static final String GET_PHYSICIAN_PROPERTY_VALUE = "getPhysicianPropertyValue";
	public static final String GET_ESANTE_USER_PROPERTY_VALUE = "getESanteUserPropertyValue";
	public static final String GET_USER_PROPERTY = "getUserProperty";		
	public static final String GET_PHYSICIAN_PROPERTY = "getPhysicianProperty";	
	public static final String GET_ESANTE_USER_PROPERTY = "getESanteUserProperty";
	public static final String GET_ESANTE_USER_PROPERTIES = "getESanteUserProperties";
	public static final String GET_ESANTE_USER_PROPERTYS_BY_ESANTEUSERID = "GET_ESANTE_USER_PROPERTYS_BY_ESANTEUSERID";
	
	/** The name that will be used to identify a user saml assertion (DSP-10), that is not specific to a certain dsp, in the cache */
	public static final String USER_ASSERTION_NAME = "UserAssertion";
	
	public static final int		MIN_INACTIVITY_TIMEOUT	= 5;
	public static final int		MAX_INACTIVITY_TIMEOUT	= 30;
	
	/* ---------------------------------------- */
	// PROPERTIE NAMES
	/* ---------------------------------------- */
	
	// Connection urls for eSanté web-services
//	public static final String PROP_WSDL_URL_SAML					= "WSDL_URL_SAML";
//	public static final String PROP_WSDL_URL_SAML_X509				= "WSDL_URL_SAML_X509";
//	public static final String PROP_WSDL_URL_SAML_USER_X509			= "WSDL_URL_SAML_USER_X509";
//	public static final String PROP_WSDL_URL_SAML_USER				= "WSDL_URL_SAML_USER";
//	public static final String PROP_WSDL_URL_PDQ					= "WSDL_URL_PDQ";
//	public static final String PROP_WSDL_URL_REGISTRY				= "WSDL_URL_REGISTRY";
//	public static final String PROP_WSDL_URL_RETRIEVE				= "WSDL_URL_RETRIEVE";
//	public static final String PROP_WSDL_URL_PROVIDE				= "WSDL_URL_PROVIDE";
//	public static final String PROP_WSDL_URL_EHR_ACCESS_RIGHTS		= "WSDL_URL_EHR_ACCESS_RIGHTS";
//	public static final String PROP_WSDL_URL_ASSERTION_SAML_SERVICE	= "WSDL_URL_ASSERTION_SAML_SERVICE";	
	
	// Service urls for IHE webservices 
	/** DSP-10 User Authentication via username and password */
	public static final String PROP_SERVICE_DSP_10_LP	= "WSDL_DSP-10:User Authentication LP";	
	/** DSP-10 User Authentication via X.509 certificate */
	public static final String PROP_SERVICE_DSP_10_X509	= "WSDL_DSP-10:User Authentication X509";	
	/** DSP-11 and 12 DSP access with and without presence code */
	public static final String PROP_SERVICE_DSP_11_12	= "WSDL_DSP-11-12:DSP Access";	
	/** DSP-20 Search a patient through his demographic data */
	public static final String PROP_SERVICE_ITI_21		= "WSDL_ITI-21:Patient Demographics Query";	
	/** DSP-22 Check access rights for EHR */
	public static final String PROP_SERVICE_DSP_22		= "WSDL_DSP-22:Check Access Rights EHR";	
	/** ITI-18 Stored Query */
	public static final String PROP_SERVICE_ITI_18		= "WSDL_ITI-18:Stored Query:sq.b";	
	/** ITI-40 Provide X-User Assertion */
	public static final String PROP_SERVICE_ITI_40		= "WSDL_ITI-40:Provide X-User Assertion";	
	/** ITI-41 Provide and Register Document Set-b */
	public static final String PROP_SERVICE_ITI_41		= "WSDL_ITI-41:Provide and Register.b:pr.b";	
	/** ITI-43 Retrieve Document Set */
	public static final String PROP_SERVICE_ITI_43		= "WSDL_ITI-43:Retrieve.b:ret.b";	
	/** ATNA service with DICOM format and TLS authentication and channel encryption */
	public static final String PROP_SERVICE_ATNA		= "WSDL_ATNA_SERVER";

	/**
	 * The support link that will be displayed in the dialog where the user can enter his eHealth id
	 */
	public static final String PROP_EHEALTH_ID_SUPPORT_LINK = "EHEALTH_ID_SUPPORT_LINK";
	/**
	 * The name of the property for the timeout in minutes till the user is automatically logged of due to inactivity
	 */
	public static final String PROP_INACTIVITY_TIMEOUT 		= "INACTIVITY_TIMEOUT";

	// Document metadata properties that are set when user uploads a document to a dsp. The last choice of the user will be remembered 
	public static final String PROP_METADATA_LANGUAGE 			= "METADATA_LANGUAGE";
	public static final String PROP_METADATA_CONFIDENTIALITY 	= "METADATA_CONFIDENTIALITY";
	public static final String PROP_METADATA_EXPERTISE_AREA 	= "METADATA_EXPERTISE_AREA";
	public static final String PROP_METADATA_HC_FACILITY_TYPE 	= "METADATA_HC_FACILITY_TYPE";
	public static final String PROP_METADATA_AUTHOR_ROLE 		= "METADATA_AUTHOR_ROLE";
	public static final String PROP_METADATA_AUTHOR_SPECIALTY 	= "METADATA_AUTHOR_SPECIALTY";
	
	// Properties that are needed for building valid OIDs
	public static final String PROP_USER_EHEALTH_ID 		= "USER_EHEALTH_ID";
	public static final String PROP_ESANTE_USER_INFO 		= "ESANTE_USER_INFO";
	public static final String PROP_PRACTICE_EHEALTH_ID 	= "PRACTICE_EHEALTH_ID";
	public static final String PROP_GECAMED_APPLICATION_ID 	= "GECAMED_APPLICATION_ID";
	public static final String PROP_PHYSICIAN_LOGIN_DATA 	= "PHYSICIAN_LOGIN_DATA";

	public static final String PROP_MESSAGE_LOGLEVEL 		= "MESSAGE_LOG_LEVEL";	
	
	/**
	 * Defines to which location the CDAs shall be downloaded.<br>
	 * The options are:
	 * <ul>
	 * <li>"CLIENT" <i>(<b>default</b>)</i></li>
	 * <li>"SERVER"</li>
	 * </ul>
	 */
	public static final String PROP_CDA_DOWNLOAD_SITE	= "CDA_DOWNLOAD_SITE";
	
	/**
	 * Defines, the name of the property for the URL of the EPSOS website.
	 */
	public static final String PROP_EPSOS_URL			= "EPSOS_URL";
	
	public static final String PROP_SHOW_EPSOS_BUTTON	= "SHOW_EPSOS_BUTTON";
	
	
	/* ---------------------------------------- */
	// PROPERTY VALUES
	/* ---------------------------------------- */
	
	public static final String DOWNLOAD_SITE_SERVER	= "server";
	public static final String DOWNLOAD_SITE_CLIENT	= "client";
	
	
	
	/* ======================================== */
	// MEMBERS
	/* ======================================== */

	private String name;

	private String value;

	private Integer userId;
	
	private Integer physicianId;
	
	private String esanteUserId;

	private Date created;

	private Date modified;

	/* ======================================== */
	// GETTER & SETTER
	/* ======================================== */

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getValue() {
		return value;
	}

	public void setValue(String value) {
		this.value = value;
	}
	
	@Column (name="user_id")
	public Integer getUserId() {
		return userId;
	}

	public void setUserId(Integer userId) {
		this.userId = userId;
	}
	
	@Column (name="physician_id")
	public Integer getPhysicianId() {
		return physicianId;
	}

	public void setPhysicianId(Integer physicianId) {
		this.physicianId = physicianId;
	}

	@Column (name="esante_user_id")
	public String getEsanteUserId() {
		return esanteUserId;
	}

	public void setEsanteUserId(String esanteUserId) {
		this.esanteUserId = esanteUserId;
	}

	public Date getCreated() {
		return created;
	}

	public void setCreated(Date created) {
		this.created = created;
	}

	public Date getModified() {
		return modified;
	}

	public void setModified(Date modified) {
		this.modified = modified;
	}
}
