package lu.tudor.santec.gecamed.esante.ejb.entity.beans;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Transient;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;

/**
 * @author Ortwin Donak
 * 
 * @version <br>
 *          $Log: CdaCodeDescription.java,v $
 *          Revision 1.2  2013-12-04 13:11:10  ferring
 *          CdaCodeDescription added
 *
 *          Revision 1.1  2013-12-03 17:56:38  donak
 *          Entity bean for the the new table esante.code_description
 *
 */
@NamedQueries({ 
	@NamedQuery(name = CdaCodeDescription.GET_CODE_DESCRIPTION_BY_CODE_ID_AND_LANGUAGE,	
			query="SELECT OBJECT(o) FROM CdaCodeDescription o "
				+ "WHERE codeId = :codeId "
				+ "AND language = :language"),
	@NamedQuery(name = CdaCodeDescription.GET_CODE_DESCRIPTION_LIST_BY_CODE_ID_AND_LANGUAGE, 
			query="SELECT OBJECT(o) FROM CdaCodeDescription o "
				+ "WHERE language = :language "
				+ "AND codeId IN (:codeIdList) "),
	@NamedQuery(name = CdaCodeDescription.GET_CODE_DESCRIPTION_LIST_OF_CATEGORY, 
			query="SELECT OBJECT(d) FROM CdaCodeDescription d, CdaCode c "
				+ "WHERE d.language = :language "
				+ "AND d.codeId = c.id "
				+ "AND c.codeCategoryId = :categoryId")
})
@Entity
@Table(schema = "esante", name = "code_description")
public class CdaCodeDescription extends GECAMedEntityBean
{
	/* ======================================== */
	// CONSTANTS
	/* ======================================== */
	
	public static final String	GET_CODE_DESCRIPTION_BY_CODE_ID_AND_LANGUAGE		= "getCdaCodeDescriptionByCodeIdAndLanguage";
	public static final String	GET_CODE_DESCRIPTION_LIST_BY_CODE_ID_AND_LANGUAGE	= "getCdaCodeDescriptionListByCodeIdAndLanguage";
	public static final String	GET_CODE_DESCRIPTION_LIST_OF_CATEGORY				= "getCdaCodeDescriptionListForCategoryAndLanguage";
	
	public static final String	LANGUAGE_GERMAN  = "de";
	public static final String	LANGUAGE_FRENCH	 = "fr";
	public static final String	LANGUAGE_ENGLISH = "en";
	
	
	private static final long	serialVersionUID		= 1L;
	
	/* ======================================== */
	// MEMBERS
	/* ======================================== */
	
	private Integer codeId = null;

	private String language = null;

	private String displayName = null;

	private String description = null;
	
	/* ======================================== */
	// CONSTRUCTORS
	/* ======================================== */
	
	/**
	 * The default constructor for Hibernate
	 */
	public CdaCodeDescription () {}
	
	
	public CdaCodeDescription (Integer codeId, String displayName, String description, String language)
	{
		this.codeId			= codeId;
		this.displayName	= displayName;
		this.description	= description;
		this.language		= language;
	}
	
	/* ======================================== */
	// GETTER & SETTER
	/* ======================================== */
	
	/**
	 * Provides the ID of the code to which the description belongs
	 * @param codeId The id of the corresponding code
	 */
	@Column(name = "code_id")
	public Integer getCodeId() {
		return codeId;
	}

	/**
	 * Sets the ID of the code to which the description belongs
	 * @param codeId The id of the corresponding code
	 */
	public void setCodeId(Integer codeId) {
		this.codeId = codeId;
	}

	/**
	 *  Provides the language of the code description 
	 * @return Language of code description (abbreviation)
	 */
	@Column(name = "language")
	public String getLanguage() {
		return language;
	}

	/**
	 * Sets the language of the code description 
	 * @param language Language of code description (abbreviation e.g. 'en' for English)
	 */
	public void setLanguage(String language) {
		this.language = language;
	}

	/**
	 * Provides the localized display name of the code
	 * @return Localized display name
	 */
	@Column(name = "display_name")
	public String getDisplayName() {
		return displayName;
	}

	/**
	 * Sets the localized display name of the code
	 * @param displayName Localized display name
	 */
	public void setDisplayName(String displayName) {
		this.displayName = displayName;
	}

	/**
	 * Provides the description of the code in the chosen language
	 * @return Description of the code (might be null)
	 */
	@Column(name = "description")
	public String getDescription() {
		return description;
	}

	/**
	 * Sets the description of the code in the chosen language
	 * @param description The description of the code
	 */
	public void setDescription(String description) {
		this.description = description;
	}
	
	@Transient
	@Override
	public String toString ()
	{
		return displayName != null ? displayName : codeId.toString();
	}
}
