package lu.tudor.santec.gecamed.esante.ejb.entity.beans;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Transient;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;

/**
 * @author jens.ferring(at)tudor.lu
 * 
 * @version <br>
 *          $Log: CdaCode.java,v $
 *          Revision 1.10  2013-12-09 17:15:37  donak
 *          Bug-fixing for upload to eSanté platform
 *
 *          Revision 1.9  2013-12-04 15:22:25  ferring
 *          CdaCodeDescription added
 *
 *          Revision 1.8  2013-12-04 13:11:10  ferring
 *          CdaCodeDescription added
 *
 *          Revision 1.7  2013-12-03 17:59:28  donak
 *          removed display name - this will probably prevent Jenkins from building GECAMed but cannot be avoided temporarily.
 *
 *          Revision 1.6  2013-10-21 08:15:30  ferring
 *          loading CdaCodes if there not loaded and creating not existing, if they don't exist in the DB
 *
 *          Revision 1.5  2013-10-08 08:57:36  ferring
 *          commit comments utf8 correction
 *
 *          Revision 1.4  2013-10-08 08:54:14  ferring
 *          class name refactoring and tree view implementation (first steps)
 *
 *          Revision 1.3  2013-10-04 08:50:53  donak
 *          removed conflict with parent class
 *
 *          Revision 1.2  2013-10-03 16:32:37  donak
 *          eSanté integration CDA document upload metadata configuration dialog - there is a problem w/ the entity beans (CdaCodeCategory is not found), which needs to be addressed
 *
 *          Revision 1.1  2013-10-03 11:17:21  donak
 *          eSanté integration CDA document upload metadata configuration dialog
 * <br>
 *          Revision 1.1 2013-10-01 10:03:11 ferring <br>
 *          enhancement in code fetching <br>
 * <br>
 *          Revision 1.1 2013-10-01 07:04:37 ferring <br>
 *          CDA codes introduced <br>
 */
@NamedQueries({ 
	@NamedQuery(name = CdaCode.GET_CDA_CODE_CHILDREN,				query = "SELECT OBJECT(o) FROM CdaCode o " + 
																			"WHERE parentId = :parentId"),
	@NamedQuery(name = CdaCode.GET_CODE_BY_CATEGORY_AND_CODE_ID,	query = "SELECT OBJECT(o) FROM CdaCode o " + 
																			"WHERE codeId = :codeId " + 
																			"AND codeCategoryId = :categoryId")
})
@Entity
@Table(schema = "esante", name = "code")
public class CdaCode extends GECAMedEntityBean
{
	/* ======================================== */
	// CONSTANTS
	/* ======================================== */
	
	public static final String	GET_CDA_CODE_CHILDREN	= "getCdaCodeChildren";
	public static final String	GET_CODE_BY_CATEGORY_AND_CODE_ID	= "getCdaCodeByCodeId";
	
	
	private static final long	serialVersionUID		= 1L;
	
	/* ======================================== */
	// MEMBERS
	/* ======================================== */
	
	private Integer				codeCategoryId			= null;
	
	private String				codeId					= null;

	private String				codeOid					= null;

	private Integer				parentId				= null;
	
	private CdaCodeDescription	description;
	
	
	
	
	/* ======================================== */
	// GETTER & SETTER
	/* ======================================== */
	
	/**
	 * Provides the ID of the category to which the cda code belongs
	 * 
	 * @return The ID of the corresponding code category
	 */
	@Column(name = "code_type_id")
	public Integer getCodeCategoryId ()
	{
		return this.codeCategoryId;
	}
	
	
	/**
	 * Sets the ID of the category to which the cda code belongs
	 * 
	 * @param codeTypeId
	 *            The ID of the corresponding code category
	 */
	public void setCodeCategoryId (Integer codeCategoryId)
	{
		this.codeCategoryId = codeCategoryId;
	}
	
	
	/**
	 * Provides the id of the cda code
	 * @return The id of the cda code
	 */
	@Column(name = "code")
	public String getCodeId ()
	{
		return this.codeId;
	}
	
	
	/**
	 * Sets the id of the cda code
	 * @param code The id of the cda code
	 */
	public void setCodeId (String codeId)
	{
		this.codeId = codeId;
	}
	

	/**
	 * Provides the oid of the cda code
	 * @return The oid of the cda code
	 */
	@Column(name = "code_oid")
	public String getCodeOid ()
	{
		return this.codeOid;
	}
	
	
	/**
	 * Sets the id of the cda code
	 * @param code The oid of the cda code
	 */
	public void setCodeOid (String codeOid)
	{
		this.codeOid = codeOid;
	}
	
	/**
	 * The code might be a more detailed classification of another code. In this case the other code is considered as the parent of the current code.
	 * The code id of this parent is provided by this method.
	 * 
	 * @return The row id of the parent cda code in the db or null if this cda code does not have a parent cda code
	 */
	@Column(name = "parent_id")
	public Integer getParentId ()
	{
		return this.parentId;
	}
	
	
	/**
	 * Sets the id of the parent CDA code this code is a child of. Please be aware that this function requires the id and not the code id.
	 * @param parentId The code id of the parent CDA code
	 */
	public void setParentId (Integer parentId)
	{
		this.parentId = parentId;
	}
	
	
	@Transient
	public CdaCodeDescription getDescription ()
	{
		return description;
	}
	
	
	@Transient
	public void setDescription (CdaCodeDescription description)
	{
		this.description = description;
	}
	
	
	@Transient
	@Override
	public String toString ()
	{
		if (getDescription() != null && getDescription().getDisplayName() != null)
			return getDescription().getDisplayName();
		else
			return codeId;
	}
}
