/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.dicom.ejb.entity.beans;

import java.io.Serializable;
import java.util.Date;
import java.util.Vector;

import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;

/**
 * Entity bean that represents an DCM Image in the database
 * 
 *
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 *
 * @version
 * <br>$Log: DCMImage.java,v $
 * <br>Revision 1.5  2008-09-25 09:43:08  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.4  2008-04-08 13:15:32  hermen
 * <br>added dicom entry to medical history
 * <br>
 * <br>Revision 1.3  2008-03-05 07:27:39  hermen
 * <br>a lot of improvements and bugfixes
 * <br>
 *
 */
@javax.persistence.NamedQueries({

    @javax.persistence.NamedQuery(name=DCMImage.findAllDCMImage,
        query="SELECT OBJECT(o) FROM DCMImage o"),
    @javax.persistence.NamedQuery(name=DCMImage.findAllDCMImageBySeriesID,
        query="SELECT OBJECT(o) FROM DCMImage o WHERE o.seriesID = :seriesID ORDER BY o.date"),
    @javax.persistence.NamedQuery(name=DCMImage.findDCMImageByInstanceUID,
        query="SELECT OBJECT(o) FROM DCMImage o WHERE o.instanceUID = :instanceUID")
})


@Entity
@Table(schema="dicom", name="image")
public class DCMImage extends GECAMedEntityBean implements Serializable, DCMEntry {

	private static final long serialVersionUID = 1L;
	
	public static final String findAllDCMImage = "findAllDCMImage";
	public static final String findAllDCMImageBySeriesID = "findAllDCMImageBySeriesID";
	public static final String findDCMImageByInstanceUID = "findDCMImageByInstanceUID";

	/**
	 * reference to DCMSeries
	 */
	private Integer seriesID;

	/**
	 * reference to Patient
	 */
	private Integer patientID;
	
	/**
	 * dcm tag 0008,0018 SOP Instance UID
	 */
	private String instanceUID;
	
	
	/**
	 * dcm tag  0020,0013 Image Nr
	 */
	private Integer number;
	
	/**
	 * dcm tag 0020,4000 Image Comments
	 */
	private String description;
	
	/**
	 * dcm tag  0008,0060 Modality
	 */
	private String modality;
	
	/**
	 * dcm tag 0008,0008 Image Type
	 */
	private String type;
	
	/**
	 * dcm tags 0008,0023+0008,0033 Image Date/Time
	 */
	private Date 	date;
	
	/**
	 * jpg preview of the image
	 */
	private byte[] preview;
	
	/**
	 * filesize in byte
	 */
	private Long size;
	
	/**
	 * rows of image
	 */
	private Integer cols;
	
	
	/**
	 * cols of image 
	 */
	private Integer rows;
	
	
	
	/**
	 * @return the patientID
	 */
	@javax.persistence.Column(name = "modality")
	public java.lang.String getModality() {
		return modality;
	}

	/**
	 * @param patientID the patientID to set
	 */
	public void setModality(String patientID) {
		this.modality = patientID;
	}

	/**
	 * @return the date
	 */
	@javax.persistence.Column(name = "date")
	public Date getDate() {
		return date;
	}

	/**
	 * @param date the date to set
	 */
	public void setDate(Date date) {
		this.date = date;
	}

	/**
	 * @return the description
	 */
	@javax.persistence.Column(name = "description")
	public String getDescription() {
		return description;
	}

	/**
	 * @param description the description to set
	 */
	public void setDescription(String description) {
		this.description = description;
	}

	/**
	 * @return the instanceUID
	 */
	@javax.persistence.Column(name = "instance_uid")
	public String getInstanceUID() {
		return instanceUID;
	}

	/**
	 * @param instanceUID the instanceUID to set
	 */
	public void setInstanceUID(String instanceUID) {
		this.instanceUID = instanceUID;
	}

	/**
	 * @return the institution
	 */
	@javax.persistence.Column(name = "number")
	public Integer getNumber() {
		return number;
	}

	/**
	 * @param number the number to set
	 */
	public void setNumber(Integer institution) {
		this.number = institution;
	}

	/**
	 * @return the studyID
	 */
	@javax.persistence.Column(name = "series_id")
	public Integer getSeriesID() {
		return seriesID;
	}

	/**
	 * @param seriesID the seriesID to set
	 */
	public void setSeriesID(Integer seriesID) {
		this.seriesID = seriesID;
	}

	/**
	 * @return the preview
	 */
	@javax.persistence.Column(name = "preview")
	public byte[] getPreview() {
		return preview;
	}

	/**
	 * @param preview the preview to set
	 */
	public void setPreview(byte[] preview) {
		this.preview = preview;
	}

	/**
	 * @return the type
	 */
	@javax.persistence.Column(name = "type")
	public String getType() {
		return type;
	}

	/**
	 * @param type the type to set
	 */
	public void setType(String type) {
		this.type = type;
	}

	/**
	 * @return the cols
	 */
	@javax.persistence.Column(name = "cols")
	public Integer getCols() {
		return cols;
	}

	/**
	 * @param cols the cols to set
	 */
	public void setCols(Integer cols) {
		this.cols = cols;
	}

	/**
	 * @return the rows
	 */
	@javax.persistence.Column(name = "rows")
	public Integer getRows() {
		return rows;
	}

	/**
	 * @param rows the rows to set
	 */
	public void setRows(Integer rows) {
		this.rows = rows;
	}

	/**
	 * @return the size
	 */
	@javax.persistence.Column(name = "size")
	public Long getSize() {
		return size;
	}

	/**
	 * @param size the size to set
	 */
	public void setSize(Long size) {
		this.size = size;
	}
	
	/**
	 * @return the patientID
	 */
	@javax.persistence.Column(name = "patient_id")
	public Integer getPatientID() {
		return patientID;
	}

	/**
	 * @param patientID the patientID to set
	 */
	public void setPatientID(Integer patientID) {
		this.patientID = patientID;
	}

	/* (non-Javadoc)
	 * @see lu.tudor.santec.gecamed.dicom.ejb.entity.beans.DCMEntry#getEntryType()
	 */
	@Transient
	public int getEntryType() {
		return IMAGE;
	}

	/* (non-Javadoc)
	 * @see lu.tudor.santec.gecamed.dicom.ejb.entity.beans.DCMEntry#getChildCount()
	 */
	@Transient
	public int getChildCount() {
		return 0;
	}

	/* (non-Javadoc)
	 * @see lu.tudor.santec.gecamed.dicom.ejb.entity.beans.DCMEntry#getChilds()
	 */
	@Transient
	public Vector<DCMEntry> getChilds() {
		return null;
	}

	/* (non-Javadoc)
	 * @see lu.tudor.santec.gecamed.dicom.ejb.entity.beans.DCMEntry#setChilds(java.util.Vector)
	 */
	@Transient
	public void setChilds(Vector<DCMEntry> childs) {
	}

	@Transient
	public Integer getIncidentEntryID() {
	    return null;
	}
    
    
}
