/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.dicom.ejb.entity.beans;

import java.text.DateFormat;
import java.util.Date;
import java.util.Vector;

/**
 * general interface for DCM Study, Series and Image
 * 
 *
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 *
 * @version
 * <br>$Log: DCMEntry.java,v $
 * <br>Revision 1.5  2008-09-25 09:43:08  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.4  2008-04-08 13:15:32  hermen
 * <br>added dicom entry to medical history
 * <br>
 * <br>Revision 1.3  2008-03-05 07:27:39  hermen
 * <br>a lot of improvements and bugfixes
 * <br>
 *
 */
public interface DCMEntry {
	
	public static final int STUDY =0;
	public static final int SERIES = 1;
	public static final int IMAGE = 2;
	
	public static final String DCM_ENTRY_TYPE = "dicom";
	
	public DateFormat df = DateFormat.getDateInstance(DateFormat.SHORT );
	
	public Date getDate();
	
	/**
	 * returns the type of entry (study/series/image
	 * @return
	 */
	public int getEntryType();

	/**
	 * returns of childs
	 * @return
	 */
	public Vector<DCMEntry>getChilds();
	
	/**
	 * sets the childs
	 * @param childs
	 */
	public void setChilds( Vector<DCMEntry> childs);
	
	
	/**
	 * returns the number of childs
	 * @return
	 */
	public int getChildCount();
	
	
	public Integer getIncidentEntryID();
	
}
