/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.core.utils.querybuilder;

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

/**
 *  The HibernateSubSelect class does not immediately extend a generic query object 
 *  but is intended to be used as a value of a HibernateCondition object. It will 
 *  normally be used in conjunction with the IN and NOT IN Operator. The HibernateSubSelect 
 *  class has four properties, namely Property, Bean, Entity and WhereClause.
 */

public class HibernateSubSelect extends TreeNode 
	{
	private static final long serialVersionUID = 1L;

	private String			m_Property;	
	private String			m_Bean;
	private String			m_Entity;
	private WhereClause		m_WhereClause;
	
//***************************************************************************
//* Class Constants                                                         *
//***************************************************************************
	
	private static final String c_DefaultEntity = "o";

//---------------------------------------------------------------------------
//***************************************************************************
//* Constructors                                       						*
//***************************************************************************
//---------------------------------------------------------------------------

public HibernateSubSelect ()
	{
	m_Property = "";
	m_Bean     = "";
	m_Entity   = c_DefaultEntity;
	m_WhereClause = new WhereClause ();
	}
		
//---------------------------------------------------------------------------

public HibernateSubSelect (String p_Property, String p_Bean, WhereClause p_WhereClause)
	{
	this.setProperty (p_Property);
	this.setBean	 (p_Bean);
	this.setWhereClause(p_WhereClause);
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body		                                                        *
//***************************************************************************
//---------------------------------------------------------------------------

public String getProperty ()
	{
	return m_Property;
	}

//---------------------------------------------------------------------------

public void setProperty (String p_Property)
	{
	m_Property = p_Property;
	}

//---------------------------------------------------------------------------

public String getBean ()
	{
	return m_Bean;
	}

//---------------------------------------------------------------------------

public void setBean (String p_Bean)
	{
	m_Bean = p_Bean;
	}

//---------------------------------------------------------------------------

public void setEntity (String p_Entity)
	{
	m_Entity = p_Entity;
	}

//---------------------------------------------------------------------------

public String getEntity ()
	{
	return m_Entity;
	}

//---------------------------------------------------------------------------

public WhereClause getWhereClause ()
	{
	return m_WhereClause;
	}

//---------------------------------------------------------------------------

public void setWhereClause (WhereClause p_WhereClause)
	{
	m_WhereClause = p_WhereClause;
	}

//---------------------------------------------------------------------------
/**
 * Renders the hibernate specific representation of this sub select
 * @return Hibernate specific representation of this sub select
 */
//---------------------------------------------------------------------------

public String toString ()
	{
	StringBuffer	l_SubSelect;

	l_SubSelect = new StringBuffer ();
	
	if (m_Entity == null) m_Entity = c_DefaultEntity;
	
	l_SubSelect.append ("( SELECT ");
	l_SubSelect.append(m_Entity).append('.').append(this.getProperty());
	l_SubSelect.append (" FROM ").append(m_Bean).append(' ').append(m_Entity);
	l_SubSelect.append (" WHERE ").append (m_WhereClause.toString()).append (')');
	
	return l_SubSelect.toString();
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* End Of Class                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
}
