/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.core.utils.querybuilder;

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

/**
 *  The HibernateProperty class does not immediately extend a generic query object 
 *  but is intended to be used as a value of a HibernateCondition object. It will 
 *  normally be used in conjunction with a join over multiple tables. The HibernateProperty 
 *  class has two properties, namely Entity and Property.
 */

public class HibernateProperty extends TreeNode 
	{
	private static final long serialVersionUID = 1L;

	private String			m_Property;	
	private String			m_Entity;
	
//***************************************************************************
//* Class Constants                                                         *
//***************************************************************************
	
	private static final String c_DefaultEntity = "o";

//---------------------------------------------------------------------------
//***************************************************************************
//* Constructors                                       						*
//***************************************************************************
//---------------------------------------------------------------------------

public HibernateProperty ()
	{
	m_Property = "";
	m_Entity   = c_DefaultEntity;
	}
		
//---------------------------------------------------------------------------

public HibernateProperty (String p_Property)
	{
	this.setEntity   (c_DefaultEntity);
	this.setProperty (p_Property);
	}

//---------------------------------------------------------------------------

public HibernateProperty (String p_Entity, String p_Property)
	{
	this.setEntity   (p_Entity);
	this.setProperty (p_Property);
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body		                                                        *
//***************************************************************************
//---------------------------------------------------------------------------

public String getProperty ()
	{
	return m_Property;
	}

//---------------------------------------------------------------------------

public void setProperty (String p_Property)
	{
	m_Property = p_Property;
	}

//---------------------------------------------------------------------------

public void setEntity (String p_Entity)
	{
	m_Entity = p_Entity;
	}

//---------------------------------------------------------------------------

public String getEntity ()
	{
	return m_Entity;
	}


//---------------------------------------------------------------------------
/**
 * Renders the hibernate specific representation of this property
 * @return Hibernate specific representation of this property
 */
//---------------------------------------------------------------------------

public String toString ()
	{
	StringBuffer	l_SubSelect;

	l_SubSelect = new StringBuffer ();
	
	if (m_Entity == null) m_Entity = c_DefaultEntity;
	
	l_SubSelect.append(m_Entity).append('.').append(this.getProperty());
	
	return l_SubSelect.toString();
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* End Of Class                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
}
