/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.core.utils.controller.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

//A general utility class for Stream reading an writing
public class FileUtils {
	public static byte[] readFile(File file) throws IOException {
		byte[] buffer = new byte[(int) file.length()];
		InputStream istream = new FileInputStream(file);
		istream.read(buffer);
		istream.close();
		return buffer;
	}
	
	public static  File createFile(byte[] buffer, File file_tmp) throws IOException {
		OutputStream ostream = new FileOutputStream(file_tmp);
		ostream.write(buffer);
		ostream.close();
		return file_tmp;
	}

	public static String adeptFilePath(String path){
		if(path.startsWith("/")){
			path = path.substring(1);
		}
		if(File.separator.equals("\\")){
			String new_path = path.replace(File.separator + "", "/");
			return new_path;
		}
		return path;
	}
	
	public static String adeptInstallPath(String path){
		if(File.separator.equals("\\")){
			String new_path = path.replace(File.separator + "", "/");
			return new_path;
		}
		return path;
	}
}
