/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
/*
 * UCMCodeField.java
 *
 * Created on May 26, 2005, 10:41 AM
 */

package lu.tudor.santec.gecamed.core.utils;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.text.ParseException;

import javax.swing.text.MaskFormatter;

/**
 * The SSNFormatter eases the input of SSNs (Social Security Numbers). Luxembourgs
 * SSN are in the format YYYY MM DD XXC, YYYY standing for the year of birth,
 * MM for the month and DD for the Day. XX is a running number which is even for
 * females and odd for males. The last digit C is a check digit.
 */

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

public class SSNFormatter extends MaskFormatter implements Serializable, PropertyChangeListener
    {
    private static final long serialVersionUID = 1L;
    
//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************

public SSNFormatter () 
    {
	try {
		this.setMask("#### ## ## ### **");
		}
    catch (ParseException p_Exception) 
        {
    		//Can be safely ignored here.
        }
    
    this.setAllowsInvalid(false);
    this.setValidCharacters("0123456789 ");
    this.setPlaceholderCharacter('0');
    this.setOverwriteMode(true);
    this.setValueContainsLiteralCharacters(true);
    this.setCommitsOnValidEdit(false);
    }
    
//***************************************************************************
//* Class Primitives                                                        *
//***************************************************************************

//---------------------------------------------------------------------------
	
	public Object stringToValue (String ssn)
	{
		return SSNChecker.getCompactSSN(ssn);
	}

//---------------------------------------------------------------------------
	
	public String valueToString (Object p_Value)
	{
		String ssn = SSNChecker.getFormattedSSN((String) p_Value, true);
		setEditValid(SSNChecker.isValidSSN(ssn));
		
		return ssn;
	}
	
	
	public void propertyChange (PropertyChangeEvent evt)
	{
		if ("value".equals(evt.getPropertyName()))
		{
			setEditValid(SSNChecker.isValidSSN((String) evt.getNewValue()));
		}
	}

//***************************************************************************
//* End of Class                                                            *
//***************************************************************************

}
