package lu.tudor.santec.gecamed.core.utils;

import java.io.Serializable;

/**
 * @author jens.ferring(at)tudor.lu
 * 
 * Used mainly from the LetterPlaceholders (resp. the DatabaseManager)
 * to transfer name parameters.
 * 
 * @version
 * <br>$Log: NamedParameterBean.java,v $
 * <br>Revision 1.1  2012-12-17 13:20:22  ferring
 * <br>Methods improved to get DB access from scripts in letter placeholders
 * <br>
 */
public class NamedParameterBean implements Serializable
{
	/* ======================================== */
	// 		CONSTANTS
	/* ======================================== */
	
	private static final long	serialVersionUID	= 1L;
	
	
	
	/* ======================================== */
	// 		MEMBERS
	/* ======================================== */
	
	private String name;
	
	private Object value;
	
	
	
	/* ======================================== */
	// 		CONSTRUCTORS
	/* ======================================== */
	
	public NamedParameterBean() {}
	
	
	public NamedParameterBean(String name, Object value)
	{
		this.name = name;
		this.value = value;
	}
	
	
	
	/* ======================================== */
	// 		GETTER & SETTER
	/* ======================================== */
	
	public String getName()
	{
		return name;
	}
	
	
	public void setName(String name)
	{
		this.name = name;
	}
	
	
	public Object getValue()
	{
		return value;
	}
	
	
	public void setValue(Object value)
	{
		this.value = value;
	}
}
