package lu.tudor.santec.gecamed.core.utils;

import java.io.Serializable;
import java.util.HashMap;

import net.sf.jasperreports.engine.JasperReport;

/**
 * @author jens.ferring(at)tudor.lu
 * 
 * @version
 * <br>$Log: JasperTemplateBean.java,v $
 * <br>Revision 1.2  2014-02-11 12:49:06  ferring
 * <br>Template loading modified
 * <br>
 * <br>Revision 1.1  2013-01-22 14:21:38  ferring
 * <br>iReport templates will now be compiled only once until the server is stopped
 * <br>
 */

public class JasperTemplateBean implements Serializable
{
	/* ======================================== */
	// 		CONSTANTS
	/* ======================================== */
	
	private static final long	serialVersionUID	= 1L;
	
	private static final String	DEFAULT_RESOURCE_PATH	= "/lu/tudor/santec/gecamed/MODULE/templates/";
	
	
	public static final String TYPE_INVOICE						= "invoice";
	public static final String TYPE_PRESCRIPTION				= "prescription";
	public static final String TYPE_FIRST_NOTICE				= "first_notice";
	public static final String TYPE_SECOND_NOTICE				= "second_notice";
	public static final String TYPE_PAYMENT_ORDER				= "payment_order";
	
	public static final String TYPE_PAYMENT_ORDER_DIEKIRCH		= "payment_order_diekirch";
	public static final String TYPE_PAYMENT_ORDER_ESCH			= "payment_order_esch";
	public static final String TYPE_PAYMENT_ORDER_LUXEMBOURG	= "payment_order_luxembourg";
	
	public static final String TYPE_CERT_MORNING				= "cert_morning";
	public static final String TYPE_CERT_AFTERNOON				= "cert_afternoon";
	public static final String TYPE_3RD_PARTY_STMNT				= "3rd_party_stmnt";
	public static final String TYPE_FORM_TEMPLATE				= "form_template_def";
	public static final String TYPE_AGENDA_PATIENT				= "agenda_template_pat";
	public static final String TYPE_AGENDA_PHYSICIAN			= "agenda_template_phy";
	
	// Agenda
	public static final String AGENDA_PATIENT_APPOINTMENTS		= "AgendaPatientAppointmentPrintTemplate";
	public static final String AGENDA_PHYSICIAN_APPOINTMENTS	= "AgendaPhysicianAppointmentPrintTemplate";
	// Billing
	public static final String BILLING_ACTIVITIES				= "activity_list";
	public static final String BILLING_FIRST_REMINDER			= "first_reminder";
	public static final String BILLING_INVOICES					= "invoice_list";
	public static final String BILLING_INVOICE					= "invoice_single_doctor";
	public static final String BILLING_ISSUED_INVOICES			= "issued_invoice_list";
	public static final String BILLING_PAYMENT_ORDER			= "payment_order";
		
	public static final String BILLING_REMINDERS				= "reminder_list";
	public static final String BILLING_SECOND_REMINDER			= "second_reminder";
	public static final String BILLING_STATEMENT_COVER			= "statement_cover";
	public static final String BILLING_STATEMENTS				= "statement_list";
	public static final String BILLING_TRANSACTIONS				= "transaction_list";
	// Patient
	public static final String CERTIFICATE_AFTERNOON			= "cert_afternoon";
	public static final String CERTIFICATE_MORNING				= "cert_morning";
	public static final String PATIENT_INCIDENTS				= "patient_incident_list";
	// Prescription
	public static final String PRESCRIPTION						= "OrdonnanceMedicale";
	// Form-Editor
	public static final String FORM_EDITOR						= "FormPrintTemplate";	
	
	public static final String[] TYPES = new String[]
			{
				TYPE_CERT_MORNING,
				TYPE_CERT_AFTERNOON,
				TYPE_PRESCRIPTION,
				TYPE_INVOICE,
				TYPE_FIRST_NOTICE,
				TYPE_SECOND_NOTICE,
				TYPE_PAYMENT_ORDER,
				TYPE_PAYMENT_ORDER_DIEKIRCH,
				TYPE_PAYMENT_ORDER_ESCH,
				TYPE_PAYMENT_ORDER_LUXEMBOURG,
				TYPE_3RD_PARTY_STMNT,
				TYPE_AGENDA_PATIENT,
				TYPE_AGENDA_PHYSICIAN,
				TYPE_FORM_TEMPLATE
			};

	/* ======================================== */
	// 		MEMBERS
	/* ======================================== */
	
	private static HashMap<String, String>				type2NameMap;
	
	private static HashMap<String, JasperTemplateBean>	templates;
	
	
	private String			name;

	private String			resourcePath;
	
	private String			resourceName;
	
	private String			type;
	
	private JasperReport	report;
	
	
	
	/* ======================================== */
	// 		GETTER & SETTER
	/* ======================================== */
	
	public String getName()
	{
		return name;
	}
	
	
	private void setName(String name)
	{
		this.name = name;
	}
	
	
	public String getResourceName()
	{
		return resourceName;
	}
	
	
	private void setResourceName (String resourceName)
	{
		this.resourceName = resourceName;
	}
	
	
	public String getResourceFolder()
	{
		return resourcePath;
	}
	
	
	private void setResourceFolder(String resourcePath)
	{
		this.resourcePath = resourcePath;
	}
	
	
	public String getResourcePath ()
	{
		return resourcePath + resourceName;
	}
	
	
	public String getType()
	{
		return type;
	}
	
	
	private void setType(String type)
	{
		this.type = type;
	}
	
	
	public JasperReport getReport()
	{
		return report;
	}
	
	
	public void setReport(JasperReport report)
	{
		this.report = report;
	}
	
	
	/**
	 * THIS METHOD SHOULD ONLY BE CALLED FROM SERVER SITE, in order to get the JasperReport object.
	 * 
	 * @param name The name of the template to return
	 * @return The JasperTemplateBean with the given name
	 */
	public static JasperTemplateBean getTemplateBean (String name)
	{
		return getTemplateBean(name, true);
	}
	
	
	/**
	 * THIS METHOD SHOULD ONLY BE CALLED FROM SERVER SITE, in order to get the JasperReport object.
	 * 
	 * @param key The name or the type of the template, depending on the byName flag.
	 * @param byName If <code>true</code> key is the name of the template, else key is the type 
	 * 	of the template
	 * @return The JasperTemplateBean, with the given name or type.
	 */
	public static JasperTemplateBean getTemplateBean (String key, boolean byName)
	{
		if (templates == null)
		{
			// create the list with all its entries 
			JasperTemplateBean t;
			templates		= new HashMap<String, JasperTemplateBean>();
			type2NameMap	= new HashMap<String, String>();
			
			t = new JasperTemplateBean();
			t.setName(AGENDA_PATIENT_APPOINTMENTS);
			t.setResourceFolder(DEFAULT_RESOURCE_PATH.replace("MODULE", "agenda"));
			t.setResourceName(t.getName()+".jrxml");
			t.setType(TYPE_AGENDA_PATIENT);
			type2NameMap.put(t.getType(), t.getName());
			templates.put(t.getName(), t);
			
			t = new JasperTemplateBean();
			t.setName(AGENDA_PHYSICIAN_APPOINTMENTS);
			t.setResourceFolder(DEFAULT_RESOURCE_PATH.replace("MODULE", "agenda"));
			t.setResourceName(t.getName()+".jrxml");
			t.setType(TYPE_AGENDA_PHYSICIAN);
			type2NameMap.put(t.getType(), t.getName());
			templates.put(t.getName(), t);
			
			t = new JasperTemplateBean();
			t.setName(BILLING_ACTIVITIES);
			t.setResourceFolder(DEFAULT_RESOURCE_PATH.replace("MODULE", "billing"));
			t.setResourceName(t.getName()+".jrxml");
			templates.put(t.getName(), t);
			
			t = new JasperTemplateBean();
			t.setName(BILLING_FIRST_REMINDER);
			t.setResourceFolder(DEFAULT_RESOURCE_PATH.replace("MODULE", "billing"));
			t.setResourceName(t.getName()+".jrxml");
			t.setType(TYPE_FIRST_NOTICE);
			type2NameMap.put(t.getType(), t.getName());
			templates.put(t.getName(), t);
			
			t = new JasperTemplateBean();
			t.setName(BILLING_INVOICE);
			t.setResourceFolder(DEFAULT_RESOURCE_PATH.replace("MODULE", "billing"));
			t.setResourceName(t.getName()+".jrxml");
			t.setType(TYPE_INVOICE);
			type2NameMap.put(t.getType(), t.getName());
			templates.put(t.getName(), t);
			
			t = new JasperTemplateBean();
			t.setName(BILLING_INVOICES);
			t.setResourceFolder(DEFAULT_RESOURCE_PATH.replace("MODULE", "billing"));
			t.setResourceName(t.getName()+".jrxml");
			templates.put(t.getName(), t);
			
			t = new JasperTemplateBean();
			t.setName(BILLING_ISSUED_INVOICES);
			t.setResourceFolder(DEFAULT_RESOURCE_PATH.replace("MODULE", "billing"));
			t.setResourceName(t.getName()+".jrxml");
			templates.put(t.getName(), t);
			
			t = new JasperTemplateBean();
			t.setName(BILLING_PAYMENT_ORDER);
			t.setResourceFolder(DEFAULT_RESOURCE_PATH.replace("MODULE", "billing"));
			t.setResourceName(t.getName()+".jrxml");
			t.setType(TYPE_PAYMENT_ORDER);
			type2NameMap.put(t.getType(), t.getName());
			templates.put(t.getName(), t);
			
			t = new JasperTemplateBean();
			t.setName(TYPE_PAYMENT_ORDER_DIEKIRCH);
			t.setResourceFolder(DEFAULT_RESOURCE_PATH.replace("MODULE", "billing"));
			t.setResourceName(t.getName()+".jrxml");
			t.setType(TYPE_PAYMENT_ORDER_DIEKIRCH);
			type2NameMap.put(t.getType(), t.getName());
			templates.put(t.getName(), t);
			
			t = new JasperTemplateBean();
			t.setName(TYPE_PAYMENT_ORDER_ESCH);
			t.setResourceFolder(DEFAULT_RESOURCE_PATH.replace("MODULE", "billing"));
			t.setResourceName(t.getName()+".jrxml");
			t.setType(TYPE_PAYMENT_ORDER_ESCH);
			type2NameMap.put(t.getType(), t.getName());
			templates.put(t.getName(), t);
			
			t = new JasperTemplateBean();
			t.setName(TYPE_PAYMENT_ORDER_LUXEMBOURG);
			t.setResourceFolder(DEFAULT_RESOURCE_PATH.replace("MODULE", "billing"));
			t.setResourceName(t.getName()+".jrxml");
			t.setType(TYPE_PAYMENT_ORDER_LUXEMBOURG);
			type2NameMap.put(t.getType(), t.getName());
			templates.put(t.getName(), t);
			
			t = new JasperTemplateBean();
			t.setName(BILLING_PAYMENT_ORDER);
			t.setResourceFolder(DEFAULT_RESOURCE_PATH.replace("MODULE", "billing"));
			t.setResourceName(t.getName()+".jrxml");
			t.setType(TYPE_PAYMENT_ORDER);
			type2NameMap.put(t.getType(), t.getName());
			templates.put(t.getName(), t);
			
			t = new JasperTemplateBean();
			t.setName(BILLING_REMINDERS);
			t.setResourceFolder(DEFAULT_RESOURCE_PATH.replace("MODULE", "billing"));
			t.setResourceName(t.getName()+".jrxml");
			templates.put(t.getName(), t);
			
			t = new JasperTemplateBean();
			t.setName(BILLING_SECOND_REMINDER);
			t.setResourceFolder(DEFAULT_RESOURCE_PATH.replace("MODULE", "billing"));
			t.setResourceName(t.getName()+".jrxml");
			t.setType(TYPE_SECOND_NOTICE);
			type2NameMap.put(t.getType(), t.getName());
			templates.put(t.getName(), t);
			
			t = new JasperTemplateBean();
			t.setName(BILLING_STATEMENT_COVER);
			t.setResourceFolder(DEFAULT_RESOURCE_PATH.replace("MODULE", "billing"));
			t.setResourceName(t.getName()+".jrxml");
			t.setType(TYPE_3RD_PARTY_STMNT);
			type2NameMap.put(t.getType(), t.getName());
			templates.put(t.getName(), t);
			
			t = new JasperTemplateBean();
			t.setName(BILLING_STATEMENTS);
			t.setResourceFolder(DEFAULT_RESOURCE_PATH.replace("MODULE", "billing"));
			t.setResourceName(t.getName()+".jrxml");
			templates.put(t.getName(), t);
			
			t = new JasperTemplateBean();
			t.setName(BILLING_TRANSACTIONS);
			t.setResourceFolder(DEFAULT_RESOURCE_PATH.replace("MODULE", "billing"));
			t.setResourceName(t.getName()+".jrxml");
			templates.put(t.getName(), t);
			
			t = new JasperTemplateBean();
			t.setName(FORM_EDITOR);
			t.setResourceFolder(DEFAULT_RESOURCE_PATH.replace("MODULE", "formeditor"));
			t.setResourceName(t.getName()+".jrxml");
			t.setType(TYPE_FORM_TEMPLATE);
			type2NameMap.put(t.getType(), t.getName());
			templates.put(t.getName(), t);
			
			t = new JasperTemplateBean();
			t.setName(CERTIFICATE_AFTERNOON);
			t.setResourceFolder(DEFAULT_RESOURCE_PATH.replace("MODULE", "patient"));
			t.setResourceName(t.getName()+".jrxml");
			t.setType(TYPE_CERT_AFTERNOON);
			type2NameMap.put(t.getType(), t.getName());
			templates.put(t.getName(), t);
			
			t = new JasperTemplateBean();
			t.setName(CERTIFICATE_MORNING);
			t.setResourceFolder(DEFAULT_RESOURCE_PATH.replace("MODULE", "patient"));
			t.setResourceName(t.getName()+".jrxml");
			t.setType(TYPE_CERT_MORNING);
			type2NameMap.put(t.getType(), t.getName());
			templates.put(t.getName(), t);
			
			t = new JasperTemplateBean();
			t.setName(PATIENT_INCIDENTS);
			t.setResourceFolder(DEFAULT_RESOURCE_PATH.replace("MODULE", "patient"));
			t.setResourceName(t.getName()+".jrxml");
			templates.put(t.getName(), t);
			
			t = new JasperTemplateBean();
			t.setName(PRESCRIPTION);
			t.setResourceFolder(DEFAULT_RESOURCE_PATH.replace("MODULE", "prescription"));
			t.setResourceName(t.getName()+".jrxml");
			t.setType(TYPE_PRESCRIPTION);
			type2NameMap.put(t.getType(), t.getName());
			templates.put(t.getName(), t);
		}
		
		return templates.get(byName ? key : type2NameMap.get(key));
	}
}
