/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
/**
 * @author Martin Heinemann martin.heinemann@tudor.lu
 *
 *
 *
 * @version
 * <br>$Log: TestSystemInfo.java,v $
 * <br>Revision 1.3  2013-12-27 18:09:26  donak
 * <br>Cleanup of imports
 * <br>
 * <br>Revision 1.2  2008-09-25 09:43:07  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.1  2007-12-17 14:59:59  heinemann
 * <br>plugins and file store and open
 * <br>
 *   
 */
package lu.tudor.santec.gecamed.core.test;

import static org.junit.Assert.assertEquals;
import lu.tudor.santec.gecamed.core.gui.utils.SystemInfo;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

/**
 * @author martin.heinemann@tudor.lu
 * 12.12.2007
 * 09:20:06
 *
 *
 * @version
 * <br>$Log: TestSystemInfo.java,v $
 * <br>Revision 1.3  2013-12-27 18:09:26  donak
 * <br>Cleanup of imports
 * <br>
 * <br>Revision 1.2  2008-09-25 09:43:07  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.1  2007-12-17 14:59:59  heinemann
 * <br>plugins and file store and open
 * <br>
 *   
 */
public class TestSystemInfo {

	/**
	 * @throws java.lang.Exception
	 */
	@Before
	public void setUp() throws Exception {
	}

	/**
	 * @throws java.lang.Exception
	 */
	@After
	public void tearDown() throws Exception {
	}

	/**
	 * Test method for {@link lu.tudor.santec.gecamed.core.gui.utils.SystemInfo#getOperatingSystem()}.
	 */
	@Test
	public final void testGetOperatingSystem() {
		/* ================================================== */
		assertEquals("System not Linux", SystemInfo.getOperatingSystem(), SystemInfo.SYSTEM_LINUX);
		/* ================================================== */
	}

}
