/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.core.gui.widgets.searchtableheader;

import java.beans.PropertyChangeListener;

//***************************************************************************
//* Interface Definition and Members                                        *
//***************************************************************************

/**
 * The SearchableTable interface extends the PropertyChangeListener and defines
 * a reset method to reset search criteria when necessary.
 * @author nico.mack@tudor.lu
 */

public interface SearchableTable extends PropertyChangeListener
	{

//---------------------------------------------------------------------------
/**
 * Tables implementing the SearchableTable interface should use the resetSearch
 * method to update their view as a result of search criteria being reset.
 */
//---------------------------------------------------------------------------
	
	public void resetSearch ();

//---------------------------------------------------------------------------
//***************************************************************************
//* End Of Interface                                                        *
//***************************************************************************
//---------------------------------------------------------------------------
	}
