/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008-2009
 *******************************************************************************/

package lu.tudor.santec.gecamed.core.gui.widgets.progress;

import lu.tudor.santec.gecamed.core.gui.utils.SwingWorker;

public class ProgressExecutor 
	{
	ProgressWorker	m_Worker;
	SwingWorker		m_WorkerThread;
	boolean			m_Aborted;
	
//---------------------------------------------------------------------------
//***************************************************************************
//* Constants	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//***************************************************************************
//* Constructor	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//***************************************************************************
//* Primitives	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

public void setWorker (ProgressWorker p_Worker)	
	{
	m_Worker = p_Worker;
	}

//---------------------------------------------------------------------------

public void startExecution ()
	{
	m_WorkerThread = new SwingWorker() 
	{
	public Object construct() 
		{
		return (m_Worker != null)?m_Worker.work():"";
		}
	public void start ()
		{
		m_Aborted = false;
		if (m_Worker != null) m_Worker.start();
		super.start();
		}
	public void finished ()
		{
		if (m_Worker != null) m_Worker.done ();
		}
	public void interrupt ()
		{
		m_Aborted = true;
		if (m_Worker != null) m_Worker.abort();
		super.interrupt();
		}
	};

	m_WorkerThread.start ();  	
	}

//---------------------------------------------------------------------------

public void abortExecution ()
	{
	m_Aborted = true;
	if (m_WorkerThread != null) m_WorkerThread.interrupt();
	}

//---------------------------------------------------------------------------

public void suspendExecution ()
	{
	if (m_Worker != null) m_Worker.suspend();
	}

//---------------------------------------------------------------------------

public void resumeExecution ()
	{
	if (m_Worker != null) m_Worker.resume();
	}

//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
//***************************************************************************
//* End of Class                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
}
