/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.core.gui.widgets.progress;

//***************************************************************************
//* Class Definition		                                            	*
//***************************************************************************

/**
 * The ProgressEvent encapsulates data about progress of lenghty task.
 * ProgressEvents are dispatched by classes implementing the
 * ProgressEventSource interface and are received by corresponding
 * Listeneres.
 * @autor nico.mack@tudor.lu
 */

public class ProgressEvent 
	{
	private	Object		m_Source;
	private int			m_Type;
	private int			m_Progress;
	
//***************************************************************************
//* Constants	                                                            *
//***************************************************************************
	
	public static final int c_None			= 0;
	public static final int c_Started		= 1;
	public static final int c_Progressed	= 2;
	public static final int c_Aborted		= 3;
	public static final int c_Completed		= 4;
	
//---------------------------------------------------------------------------
//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************
//---------------------------------------------------------------------------
/**
 * Creates an unititialized instance of the ProgressEvent class.
 */
//---------------------------------------------------------------------------

public 	ProgressEvent ()
	{
	m_Source   		= null;
	m_Type			= c_None;
	m_Progress		= 0;
	}
	
//---------------------------------------------------------------------------
/**
 * Creates an instance of the ProgressEvent class of the specified type and
 * originating from the specified source.
 * @param p_Source specifies the originating class of this event.
 * @param p_Type specifies the type of progress this event represents.
 */
//---------------------------------------------------------------------------

public ProgressEvent (Object p_Source, int p_Type)
	{
	this.setSource(p_Source);
	this.setType (p_Type);
	m_Progress = 0;
	}

//---------------------------------------------------------------------------
/**
 * Creates an instance of the ProgressEvent class of the specified type and
 * originating from the specified source with the specified progress.
 * @param p_Source specifies the originating class of this event.
 * @param p_Progress specifies the progress represented by this event
 */
//---------------------------------------------------------------------------

public ProgressEvent (Object p_Source, int p_Type, int p_Progress)
	{
	this.setSource(p_Source);
	this.setType (p_Type);
	m_Progress = p_Progress;
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
/**
 * Returns the source of this event, i.e. the instance that posted it.
 * @return the event source.
 */
//---------------------------------------------------------------------------

public Object getSource ()
	{
	return m_Source;
	}

//---------------------------------------------------------------------------
/**
 * Sets the source of this event
 * @param p_Source specifies the source of this event.
 */
//---------------------------------------------------------------------------

public void setSource (Object p_Source)
	{
	m_Source = p_Source;
	}

//---------------------------------------------------------------------------
/**
 * Returns the type of this event.
 * @return the event type. Possible values are:
 * 	- c_None
 *  - c_Started
 *  - c_Progressed
 *  - c_Aborted
 *  - c_Completed
 */
//---------------------------------------------------------------------------

public int getType ()
	{
	return m_Type;
	}

//---------------------------------------------------------------------------
/**
 * Sets the type of the event.
 * @param p_Type specifies the new event type.
 */
//---------------------------------------------------------------------------

public void setType (int p_Type)
	{
	if ((p_Type >= c_None) && (p_Type <= c_Completed))
		m_Type = p_Type;
	}

//---------------------------------------------------------------------------
/**
 * Returns the progress property of this event
 * @return the current value of the progress property
 */
//---------------------------------------------------------------------------

public int getProgress ()
	{
	return m_Progress;
	}

//---------------------------------------------------------------------------
/**
 * Sets the current value of the progress property for this event
 * @param the new value of the progress property
 */
//---------------------------------------------------------------------------

public void setProgress (int p_Progress)
	{
	if ((p_Progress >= c_None) && (p_Progress <= c_Completed))
		m_Progress = p_Progress;
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* End of Class															*
//***************************************************************************
//---------------------------------------------------------------------------
}


