package lu.tudor.santec.gecamed.core.gui.widgets.incidentfileoverview;

import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.font.TextAttribute;
import java.text.DateFormat;
import java.util.Date;
import java.util.Map;

import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingConstants;
import javax.swing.table.TableCellRenderer;

import lu.tudor.santec.gecamed.core.gui.GECAMedColors;
import lu.tudor.santec.gecamed.core.gui.GECAMedModule;
import lu.tudor.santec.gecamed.core.utils.IncidentFileInfo;
import lu.tudor.santec.gecamed.office.ejb.entity.beans.Physician;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.Incident;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.IncidentEntry;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.Patient;
import lu.tudor.santec.gecamed.patient.gui.history.FileHandler;
import lu.tudor.santec.gecamed.usermanagement.ejb.entity.beans.GecamedUser;
import lu.tudor.santec.i18n.Translatrix;

import org.apache.log4j.Logger;

public class IncidentFileOverviewRenderer /* extends DefaultCellEditor */ implements TableCellRenderer
{
	/* ======================================== */
	// 		MEMBERS
	/* ======================================== */
	
	/** the logger Object for this class */
	private static Logger logger = Logger.getLogger(IncidentFileOverviewRenderer.class.getName());
	
	private static DateFormat	dateFormatter	= DateFormat.getDateInstance(DateFormat.SHORT, Translatrix.getLocale());
	
	private static GecamedUser	currentUser		= GECAMedModule.getCurrentUser();
	
	
	private IncidentFileOverviewModel	model;
	
	
	
	/* ======================================== */
	// 		CONSTRUCTORS
	/* ======================================== */
	
	public IncidentFileOverviewRenderer(IncidentFileOverviewModel model)
	{
		this.model	= model;
	}
	
	
	
	/* ======================================== */
	// 		DERIVED METHODS
	/* ======================================== */
	
	public Component getTableCellRendererComponent(JTable table, Object value, 
			boolean isSelected, boolean hasFocus, int row, int column)
	{
		IncidentFileInfo	fileInfo	= (IncidentFileInfo) value;
		JComponent			cell;
		Patient				patient;
		Physician			physician;
		GecamedUser			user;
		IncidentEntry		entry;
		Incident			incident;
		Date				entryDate;
		
		
		switch (column)
		{
			case IncidentFileOverviewModel.DATE_COLUMN:
				entry		= fileInfo.getEntry();
				incident	= entry.getIncident();
				entryDate	= incident.getIncidentDate();
				cell		= new JLabel(dateFormatter.format(entryDate));
				break;
				
			case IncidentFileOverviewModel.PHYSICAN_COLUMN:
				physician	= fileInfo.getPhysician();
				cell		= new JLabel(physician.getMnemonic());
				break;

			case IncidentFileOverviewModel.PATIENT_COLUMN:
				patient		= fileInfo.getPatient();
				cell		= new JLabel(patient.toString());
				break;

			case IncidentFileOverviewModel.FILE_COLLUMN:
				cell		= createFileLabel(fileInfo, 
						table.getColumnModel().getColumn(column).getWidth());
				break;

			case IncidentFileOverviewModel.USER_COLUMN:
				user		= fileInfo.getUser();
				if (user == null)
					cell	= createApproveButton(fileInfo);
				else if (user.equals(currentUser))
					cell	= createDisapproveButton(fileInfo);
				else 
					cell	= new JLabel(user.getLogin(), SwingConstants.CENTER);
				model.putUserColumnComponent(Integer.valueOf(row), cell);
				break;
				
			default:
				cell		= new JLabel();
				break;
		}
		
		// define the background color
		if (!(cell instanceof JButton))
		{
			cell.setOpaque(true);
			if (isSelected)
				cell.setBackground(GECAMedColors.c_TabSelection);
			else if (row % 2 == 0)
				cell.setBackground(GECAMedColors.c_EvenLineBackground);
			else
				cell.setBackground(GECAMedColors.c_OddLineBackground);
		}
		
		cell.setSize(cell.getPreferredSize());
		// set the row height
		if (table.getRowHeight(row) < cell.getPreferredSize().height) 
			table.setRowHeight(row, cell.getPreferredSize().height);
		
		return cell;
	}
	
	
	
	/* ======================================== */
	// 		HELP METHODS
	/* ======================================== */
	
	@SuppressWarnings("unchecked")
	private JComponent createFileLabel (IncidentFileInfo fileInfo, int columnWidth)
	{
		Map<TextAttribute, Object>	attributes;
		IncidentEntry	entry	= fileInfo.getEntry();
		String			content	= entry.getTextContent();
		ImageIcon		icon	= FileHandler.getImage(entry.getFileName());
		JLabel			cell;
		StringBuilder	text;
		
		text	= new StringBuilder("<html><span style=\"width:"+columnWidth+";\">")
				.append("<b>")
				.append(entry.getOriginalFilename())
				.append("</b>");
		
		if (content != null && content.trim().length() > 0)
		{
			text.append("<br><i>")
					.append(content)
					.append("</i>");
		}
		text.append("</span></html>");
		
		cell		= new JLabel(text.toString(), icon, SwingConstants.LEFT);
		attributes	= (Map<TextAttribute, Object>) cell.getFont().getAttributes();
		attributes.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_REGULAR);
		cell.setFont(new Font(attributes));
		
		return cell;
	}
	
	
	private JComponent createDisapproveButton(final IncidentFileInfo fileInfo)
	{
		GecamedUser	user	= fileInfo.getUser();
		
		return new JButton(new AbstractAction(
				"<html><font color=red>" + user.getLogin() + "</font></html>")
		{
			private static final long	serialVersionUID	= 1L;

			public void actionPerformed(ActionEvent e)
			{
//				System.out.println("DISAPPROVED!");
				model.disapprove(fileInfo);
			}
		});
	}
	
	
	private JComponent createApproveButton (final IncidentFileInfo fileInfo)
	{
		return new JButton(new AbstractAction(
				Translatrix.getTranslationString("core.incidentFileOverview.approve"))
		{
			private static final long	serialVersionUID	= 1L;

			public void actionPerformed(ActionEvent e)
			{
//				System.out.println("APPROVED!");
				model.approve(fileInfo);
			}
		});
	}
}
