package lu.tudor.santec.gecamed.core.gui.widgets.incidentfileoverview;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

import lu.tudor.santec.gecamed.core.gui.GECAMedIconNames;
import lu.tudor.santec.gecamed.core.gui.GECAMedModule;
import lu.tudor.santec.gecamed.core.gui.MainFrame;
import lu.tudor.santec.gecamed.core.gui.listener.EntryTypeRegister;
import lu.tudor.santec.gecamed.core.gui.widgets.GECAMedBaseDialogImpl;
import lu.tudor.santec.gecamed.core.utils.IncidentFileInfo;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.IncidentEntry;
import lu.tudor.santec.i18n.Translatrix;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

public class IncidentFileOverviewDialog extends GECAMedBaseDialogImpl implements ActionListener, MouseListener
{
	/* ======================================== */
	// 		CONSTANTS
	/* ======================================== */
	
	private static final long	serialVersionUID	= 1L;
	
	
	
	/* ======================================== */
	// 		MEMBERS
	/* ======================================== */
	
	private static IncidentFileOverviewDialog	instance;
	
	
	private IncidentFileOverviewModel	model;
	
	private JTable						fileTable;

	private JScrollPane					scroller;
	
	private JCheckBox					showApprovedBox;
	
	private JCheckBox					showAllPhysiciansBox;
	
	private JButton						reloadButton;
	
	
	
	/* ======================================== */
	// 		CONSTRUCTORS
	/* ======================================== */
	
	public IncidentFileOverviewDialog()
	{
		super(MainFrame.getInstance(), 
				Translatrix.getTranslationString("core.incidentFileOverview.title"), 
				GECAMedBaseDialogImpl.OK_BUTTON_MODE);
		
		buildPanel();
	}
	
	
	private void buildPanel()
	{
		TableColumnModel	columnModel;
		TableColumn			column;
		TableCellRenderer	columnRenderer;
		CellConstraints		cc	= new CellConstraints();
		
		mainPanel.setLayout(new FormLayout("5px,f:p:g,5px", 
				"5px,f:p:g," +	// table
				"5px,f:p," +	// show approved box
				"5px,f:p," +	// show all physicians box
				"5px"));
		
		model			= new IncidentFileOverviewModel();
		
		fileTable		= new JTable(model);
		fileTable.setModel(model);
		fileTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		fileTable.setColumnSelectionAllowed(false);
		fileTable.setRowSelectionAllowed(true);
		fileTable.getTableHeader().setReorderingAllowed(false);
		fileTable.addMouseListener(this);
		
		columnModel		= fileTable.getColumnModel();
		columnRenderer	= new IncidentFileOverviewRenderer(model);
		for (int index = 0; index < columnModel.getColumnCount(); index++)
		{
			column		= columnModel.getColumn(index);
			column.setCellRenderer(columnRenderer);
			column.setMinWidth(65);
			column.setMaxWidth(400);
		}
//		columnModel.getColumn(IncidentFileOverviewModel.USER_COLUMN)
//				.setCellEditor((TableCellEditor) columnRenderer);
		
		scroller		= new JScrollPane(fileTable);
		scroller.setOpaque(false);
		scroller.getViewport().setOpaque(false);
		scroller.getHorizontalScrollBar().setUnitIncrement(16);
		scroller.getVerticalScrollBar().setUnitIncrement(16);
		mainPanel.add(scroller,				cc.xy(2, 2));
		
		showApprovedBox	= new JCheckBox(
				Translatrix.getTranslationString("core.incidentFileOverview.showApprovedFiles"));
		showApprovedBox.setOpaque(false);
		showApprovedBox.addActionListener(this);
		mainPanel.add(showApprovedBox,		cc.xy(2, 4));
		
		showAllPhysiciansBox = new JCheckBox(
				Translatrix.getTranslationString("core.incidentFileOverview.showOtherPhysicianFiles"));
		showAllPhysiciansBox.setOpaque(false);
		showAllPhysiciansBox.addActionListener(this);
		mainPanel.add(showAllPhysiciansBox,	cc.xy(2, 6));
		
		reloadButton	= new JButton(GECAMedModule.getSmallIcon(GECAMedIconNames.RELOAD));
		reloadButton.setToolTipText(Translatrix.getTranslationString("pm.reload"));
		reloadButton.addActionListener(this);
		addButton(reloadButton);
	}
	
	
	
	/* ======================================== */
	// 		CLASS BODY
	/* ======================================== */

	public static void showDialog ()
	{
//		if (instance == null)
			instance	= new IncidentFileOverviewDialog();
		instance.init();
	}
	
	
	public void init ()
	{
		model.reload(showApprovedBox.isSelected(),
				showAllPhysiciansBox.isSelected());
		setSize(getOwner().getWidth()	/ 3 * 2, 
					 getOwner().getHeight()	/ 3 * 2);
		setLocationRelativeTo(getOwner());
		AutofitTableColumns.autoResizeTable(fileTable, true);
		setVisible(true);
	}


	public void actionPerformed(ActionEvent e)
	{
		model.reload(showApprovedBox.isSelected(),
				showAllPhysiciansBox.isSelected());
		AutofitTableColumns.autoResizeTable(fileTable, true);
	}
	
	
	
	/* ======================================== */
	// 		IMPLEMENTED METHODS
	/* ======================================== */
	
	public void mouseClicked(MouseEvent e) 
	{
		IncidentFileInfo	fileInfo;
		IncidentEntry		entry;
		Point				clickedPoint;
		Object				source	= e.getSource();
		int					clickedColumn;
		int					clickedRow;
		JComponent 			cell;
		
		
		if (source == fileTable)
		{
			clickedPoint	= e.getPoint();
			clickedColumn	= fileTable.columnAtPoint(clickedPoint);
			if (clickedColumn == IncidentFileOverviewModel.FILE_COLLUMN)
			{
				// handle click on file column
				if (e.getClickCount() >= 2)
				{
					clickedRow	= fileTable.rowAtPoint(clickedPoint);
					fileInfo	= model.getValueAt(clickedRow, clickedColumn);
					entry		= fileInfo.getEntry();
					// open the file
					EntryTypeRegister.getHandler(entry.getEntryType().getName()).openEntry(entry);
				}
			}
			else if (clickedColumn == IncidentFileOverviewModel.USER_COLUMN)
			{
				// handle click on user column
				clickedRow	= fileTable.rowAtPoint(clickedPoint);
				cell		= model.getUserColumnComponent(Integer.valueOf(clickedRow));
				if (cell instanceof JButton)
					((JButton)cell).doClick();
			}
		}
	}
	
	
	public void mousePressed(MouseEvent e) { forwardMouseEvent(e); }
	public void mouseReleased(MouseEvent e) { forwardMouseEvent(e); }
	public void mouseEntered(MouseEvent e) { forwardMouseEvent(e); }
	public void mouseExited(MouseEvent e) { /*forwardMouseEvent(e);*/ }
	
	
	private void forwardMouseEvent (MouseEvent e)
	{
		Object		source	= e.getSource();
		Point		point;
		int			column;
		int			row;
		JComponent 	cell;
		MouseEvent	newEvent;
		
		if (source == fileTable)
		{
			point	= e.getPoint();
			column	= fileTable.columnAtPoint(point);
			if (column == IncidentFileOverviewModel.USER_COLUMN)
			{
				// handle click on user column
				row			= fileTable.rowAtPoint(point);
				cell		= model.getUserColumnComponent(Integer.valueOf(row));
				if (cell != null)
				{
					newEvent	= (MouseEvent) SwingUtilities.convertMouseEvent(fileTable, e, cell);
					cell.dispatchEvent(newEvent);
				}
			}
		}
	}
}
